/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sniffer;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sniffer.SnifferAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;

public class Sniffer
extends EntityAnimal {
    private static final int bO = 1700;
    private static final int bP = 6000;
    private static final int bQ = 30;
    private static final int bR = 120;
    private static final int bS = 48000;
    private static final float bT = 0.4f;
    private static final EntitySize bU = EntitySize.b(EntityTypes.bk.l(), EntityTypes.bk.m() - 0.4f).b(0.81f);
    private static final DataWatcherObject<State> bV = DataWatcher.a(Sniffer.class, DataWatcherRegistry.G);
    private static final DataWatcherObject<Integer> bW = DataWatcher.a(Sniffer.class, DataWatcherRegistry.b);
    public final AnimationState bI = new AnimationState();
    public final AnimationState bJ = new AnimationState();
    public final AnimationState bK = new AnimationState();
    public final AnimationState bM = new AnimationState();
    public final AnimationState bN = new AnimationState();

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gz().a(GenericAttributes.v, 0.1f).a(GenericAttributes.s, 14.0);
    }

    public Sniffer(EntityTypes<? extends EntityAnimal> entitytypes, World world) {
        super(entitytypes, world);
        this.N().a(true);
        this.a(PathType.j, -1.0f);
        this.a(PathType.g, -1.0f);
        this.a(PathType.y, -1.0f);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(bV, State.a);
        datawatcher_a.a(bW, 0);
    }

    @Override
    public void F() {
        super.F();
        if (this.bX() || this.bi()) {
            this.a(PathType.j, 0.0f);
        }
    }

    @Override
    public void G() {
        this.a(PathType.j, -1.0f);
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return this.gH() == State.f ? bU.a(this.ek()) : super.e(entitypose);
    }

    public boolean p() {
        return this.gH() == State.e;
    }

    public boolean u() {
        return this.bs.c(MemoryModuleType.S).orElse(false);
    }

    public boolean gu() {
        return !this.u() && !this.gr() && !this.bi() && !this.gE() && this.aH() && !this.bY() && !this.Q_();
    }

    public boolean gv() {
        return this.gH() == State.f || this.gH() == State.e;
    }

    private BlockPosition gy() {
        Vec3D vec3d = this.gG();
        return BlockPosition.a(vec3d.a(), this.dC() + (double)0.2f, vec3d.c());
    }

    private Vec3D gG() {
        return this.dt().e(this.bU().c(2.25));
    }

    public State gH() {
        return this.al.a(bV);
    }

    private Sniffer b(State sniffer_state) {
        this.al.a(bV, sniffer_state);
        return this;
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (bV.equals(datawatcherobject)) {
            State sniffer_state = this.gH();
            this.gI();
            switch (sniffer_state.ordinal()) {
                case 1: {
                    this.bI.b(this.af);
                    break;
                }
                case 2: {
                    this.bJ.b(this.af);
                    break;
                }
                case 3: {
                    this.bK.b(this.af);
                }
                default: {
                    break;
                }
                case 5: {
                    this.bM.b(this.af);
                    break;
                }
                case 6: {
                    this.bN.b(this.af);
                }
            }
            this.h_();
        }
        super.a(datawatcherobject);
    }

    private void gI() {
        this.bM.a();
        this.bK.a();
        this.bN.a();
        this.bI.a();
        this.bJ.a();
    }

    public Sniffer a(State sniffer_state) {
        switch (sniffer_state.ordinal()) {
            case 0: {
                this.b(State.a);
                break;
            }
            case 1: {
                this.a(SoundEffects.zA, 1.0f, 1.0f);
                this.b(State.b);
                break;
            }
            case 2: {
                this.b(State.c).gJ();
                break;
            }
            case 3: {
                this.a(SoundEffects.zw, 1.0f, 1.0f);
                this.b(State.d);
                break;
            }
            case 4: {
                this.b(State.e);
                break;
            }
            case 5: {
                this.b(State.f).gK();
                break;
            }
            case 6: {
                this.a(SoundEffects.zz, 1.0f, 1.0f);
                this.b(State.g);
            }
        }
        return this;
    }

    private Sniffer gJ() {
        this.a(SoundEffects.zv, 1.0f, this.e_() ? 1.3f : 1.0f);
        return this;
    }

    private Sniffer gK() {
        this.al.a(bW, this.af + 120);
        this.dV().a((Entity)this, (byte)63);
        return this;
    }

    public Sniffer w(boolean flag) {
        if (flag) {
            this.i(this.aQ());
        }
        return this;
    }

    public Optional<BlockPosition> gw() {
        return IntStream.range(0, 5).mapToObj(i2 -> LandRandomPos.a(this, 10 + 2 * i2, 3)).filter(Objects::nonNull).map(BlockPosition::a).filter(blockposition -> this.dV().E_().a((BlockPosition)blockposition)).map(BlockPosition::e).filter(this::h).findFirst();
    }

    public boolean gx() {
        return !this.gr() && !this.u() && !this.e_() && !this.bi() && this.aH() && !this.bY() && this.h(this.gy().e());
    }

    private boolean h(BlockPosition blockposition) {
        return this.dV().a_(blockposition).a(TagsBlock.cy) && this.gM().noneMatch(globalpos -> GlobalPos.a(this.dV().aj(), blockposition).equals(globalpos)) && Optional.ofNullable(this.N().a(blockposition, 1)).map(PathEntity::j).orElse(false) != false;
    }

    private void gL() {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.al.a(bW) == this.af) {
                BlockPosition blockposition = this.gy();
                this.a(worldserver, LootTables.aG, (WorldServer worldserver1, ItemStack itemstack) -> {
                    EntityItem entityitem = new EntityItem(this.dV(), blockposition.u(), blockposition.v(), blockposition.w(), (ItemStack)itemstack);
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                    entityitem.i();
                    worldserver1.b(entityitem);
                });
                this.a(SoundEffects.zu, 1.0f, 1.0f);
                return;
            }
        }
    }

    private Sniffer a(AnimationState animationstate) {
        boolean flag;
        boolean bl = flag = animationstate.a((float)this.af) > 1700L && animationstate.a((float)this.af) < 6000L;
        if (flag) {
            BlockPosition blockposition = this.gy();
            IBlockData iblockdata = this.dV().a_(blockposition.e());
            if (iblockdata.o() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    Vec3D vec3d = Vec3D.b(blockposition).b(0.0, -0.65f, 0.0);
                    this.dV().a(new ParticleParamBlock(Particles.b, iblockdata), vec3d.d, vec3d.e, vec3d.f, 0.0, 0.0, 0.0);
                }
                if (this.af % 10 == 0) {
                    this.dV().a(this.dA(), this.dC(), this.dG(), iblockdata.A().f(), this.dm(), 0.5f, 0.5f, false);
                }
            }
        }
        if (this.af % 10 == 0) {
            this.dV().a(GameEvent.u, this.gy(), GameEvent.a.a(this));
        }
        return this;
    }

    public Sniffer i(BlockPosition blockposition) {
        List list = this.gM().limit(20L).collect(Collectors.toList());
        list.add(0, GlobalPos.a(this.dV().aj(), blockposition));
        this.ec().a(MemoryModuleType.aR, list);
        return this;
    }

    public Stream<GlobalPos> gM() {
        return this.ec().c(MemoryModuleType.aR).stream().flatMap(Collection::stream);
    }

    @Override
    public void r() {
        double d1;
        super.r();
        double d0 = this.bC.c();
        if (d0 > 0.0 && (d1 = this.dy().j()) < 0.01) {
            this.a(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
    }

    @Override
    public void a(WorldServer worldserver, EntityAnimal entityanimal) {
        ItemStack itemstack = new ItemStack(Items.kU);
        EntityItem entityitem = new EntityItem(worldserver, this.dt().a(), this.dt().b(), this.dt().c(), itemstack);
        entityitem.i();
        this.a(worldserver, entityanimal, (EntityAgeable)null);
        this.a(SoundEffects.zB, 1.0f, (this.ae.i() - this.ae.i()) * 0.2f + 0.5f);
        worldserver.b(entityitem);
    }

    @Override
    public void a(DamageSource damagesource) {
        this.a(State.a);
        super.a(damagesource);
    }

    @Override
    public void g() {
        switch (this.gH().ordinal()) {
            case 4: {
                this.gN();
                break;
            }
            case 5: {
                this.a(this.bM).gL();
            }
        }
        super.g();
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        boolean flag = this.i(itemstack);
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (enuminteractionresult.a() && flag) {
            this.gA();
        }
        return enuminteractionresult;
    }

    @Override
    protected void gA() {
        this.dV().a((Entity)null, this, SoundEffects.zq, SoundCategory.g, 1.0f, MathHelper.b(this.dV().A, 0.8f, 1.2f));
    }

    private void gN() {
        if (this.dV().A_() && this.af % 20 == 0) {
            this.dV().a(this.dA(), this.dC(), this.dG(), SoundEffects.zx, this.dm(), 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.zp, 0.15f, 1.0f);
    }

    @Override
    protected SoundEffect s() {
        return Set.of(State.f, State.e).contains((Object)this.gH()) ? null : SoundEffects.zr;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.zs;
    }

    @Override
    protected SoundEffect j_() {
        return SoundEffects.zt;
    }

    @Override
    public int ae() {
        return 50;
    }

    @Override
    public void a(boolean flag) {
        this.c_(flag ? -48000 : 0);
    }

    @Override
    public EntityAgeable a(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.bk.a(worldserver, EntitySpawnReason.e);
    }

    @Override
    public boolean a(EntityAnimal entityanimal) {
        if (!(entityanimal instanceof Sniffer)) {
            return false;
        }
        Sniffer sniffer = (Sniffer)entityanimal;
        Set<State> set = Set.of(State.a, State.c, State.b);
        return set.contains((Object)this.gH()) && set.contains((Object)sniffer.gH()) && super.a(entityanimal);
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return itemstack.a(TagsItem.ac);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return SnifferAi.a(this.ed().a(dynamic));
    }

    public BehaviorController<Sniffer> ec() {
        return super.ec();
    }

    protected BehaviorController.b<Sniffer> ed() {
        return BehaviorController.a(SnifferAi.b, SnifferAi.a);
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("snifferBrain");
        this.ec().a(worldserver, this);
        gameprofilerfiller.b("snifferActivityUpdate");
        SnifferAi.a(this);
        gameprofilerfiller.c();
        super.a(worldserver);
    }

    @Override
    protected void ab() {
        super.ab();
        PacketDebug.a(this);
    }

    public static enum State {
        a(0),
        b(1),
        c(2),
        d(3),
        e(4),
        f(5),
        g(6);

        public static final IntFunction<State> h;
        public static final StreamCodec<ByteBuf, State> i;
        private final int j;

        private State(int i2) {
            this.j = i2;
        }

        public int a() {
            return this.j;
        }

        static {
            h = ByIdMap.a(State::a, State.values(), ByIdMap.a.a);
            i = ByteBufCodecs.a(h, State::a);
        }
    }
}

