/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.wolf;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBeg;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariants;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariants;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityWolf
extends EntityTameableAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> bO = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> bP = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bQ = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Holder<WolfVariant>> bR = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.A);
    private static final DataWatcherObject<Holder<WolfSoundVariant>> bS = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.B);
    public static final PathfinderTargetCondition.a bM = (entityliving, worldserver) -> {
        EntityTypes<?> entitytypes = entityliving.an();
        return entitytypes == EntityTypes.bc || entitytypes == EntityTypes.aZ || entitytypes == EntityTypes.ab;
    };
    private static final float bT = 8.0f;
    private static final float bU = 40.0f;
    private static final float bV = 0.125f;
    public static final float bN = 0.62831855f;
    private static final EnumColor bW = EnumColor.o;
    private float bX;
    private float bY;
    public boolean bZ;
    private boolean ca;
    private float cb;
    private float cc;
    private static final UniformInt cd = TimeRange.a(20, 39);
    @Nullable
    private UUID ce;

    public EntityWolf(EntityTypes<? extends EntityWolf> entitytypes, World world) {
        super((EntityTypes<? extends EntityTameableAnimal>)entitytypes, world);
        this.a(false, false);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    @Override
    protected void C() {
        this.bF.a(1, new PathfinderGoalFloat(this));
        this.bF.a(1, new EntityTameableAnimal.a(1.5, DamageTypeTags.G));
        this.bF.a(2, new PathfinderGoalSit(this));
        this.bF.a(3, new a(this, EntityLlama.class, 24.0f, 1.5, 1.5));
        this.bF.a(4, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bF.a(5, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bF.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.bF.a(7, new PathfinderGoalBreed(this, 1.0));
        this.bF.a(8, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bF.a(9, new PathfinderGoalBeg(this, 8.0f));
        this.bF.a(10, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bF.a(10, new PathfinderGoalRandomLookaround(this));
        this.bG.a(1, new PathfinderGoalOwnerHurtByTarget(this));
        this.bG.a(2, new PathfinderGoalOwnerHurtTarget(this));
        this.bG.a(3, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.bG.a(4, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.bG.a(5, new PathfinderGoalRandomTargetNonTamed<EntityAnimal>(this, EntityAnimal.class, false, bM));
        this.bG.a(6, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.bI));
        this.bG.a(7, new PathfinderGoalNearestAttackableTarget<EntitySkeletonAbstract>((EntityInsentient)this, EntitySkeletonAbstract.class, false));
        this.bG.a(8, new PathfinderGoalUniversalAngerReset<EntityWolf>(this, true));
    }

    public MinecraftKey gG() {
        WolfVariant wolfvariant = this.gL().a();
        return this.m() ? wolfvariant.b().b().b() : (this.ac_() ? wolfvariant.b().c().b() : wolfvariant.b().a().b());
    }

    public Holder<WolfVariant> gL() {
        return this.al.a(bR);
    }

    public void j(Holder<WolfVariant> holder) {
        this.al.a(bR, holder);
    }

    private Holder<WolfSoundVariant> gM() {
        return this.al.a(bS);
    }

    private void k(Holder<WolfSoundVariant> holder) {
        this.al.a(bS, holder);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aw ? EntityWolf.c(datacomponenttype, this.gL()) : (datacomponenttype == DataComponents.ax ? EntityWolf.c(datacomponenttype, this.gM()) : (datacomponenttype == DataComponents.ay ? EntityWolf.c(datacomponenttype, this.gJ()) : super.a(datacomponenttype)));
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aw);
        this.a(datacomponentgetter, DataComponents.ax);
        this.a(datacomponentgetter, DataComponents.ay);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aw) {
            this.j(EntityWolf.c(DataComponents.aw, t0));
            return true;
        }
        if (datacomponenttype == DataComponents.ax) {
            this.k(EntityWolf.c(DataComponents.ax, t0));
            return true;
        }
        if (datacomponenttype == DataComponents.ay) {
            this.a(EntityWolf.c(DataComponents.ay, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    public static AttributeProvider.Builder gH() {
        return EntityAnimal.gz().a(GenericAttributes.v, 0.3f).a(GenericAttributes.s, 8.0).a(GenericAttributes.c, 4.0);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        IRegistry<WolfSoundVariant> iregistry = this.dX().f(Registries.bn);
        datawatcher_a.a(bR, VariantUtils.a(this.dX(), WolfVariants.j));
        DataWatcherObject<Holder<WolfSoundVariant>> datawatcherobject = bS;
        Optional optional = iregistry.a(WolfSoundVariants.a);
        Objects.requireNonNull(iregistry);
        datawatcher_a.a(datawatcherobject, (Holder)optional.or(iregistry::a).orElseThrow());
        datawatcher_a.a(bO, false);
        datawatcher_a.a(bP, bW.a());
        datawatcher_a.a(bQ, 0);
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.DR, 0.15f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("CollarColor", EnumColor.s, this.gJ());
        VariantUtils.a(nbttagcompound, this.gL());
        this.a_(nbttagcompound);
        this.gM().e().ifPresent(resourcekey -> nbttagcompound.a("sound_variant", ResourceKey.a(Registries.bn), resourcekey));
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        VariantUtils.a(nbttagcompound, this.dX(), Registries.bm).ifPresent(this::j);
        this.a(nbttagcompound.a("CollarColor", EnumColor.s).orElse(bW));
        this.a(this.dV(), nbttagcompound);
        nbttagcompound.a("sound_variant", ResourceKey.a(Registries.bn)).flatMap(resourcekey -> this.dX().f(Registries.bn).a((ResourceKey)resourcekey)).ifPresent(this::k);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        if (groupdataentity instanceof b) {
            b entitywolf_b = (b)groupdataentity;
            this.j(entitywolf_b.a);
        } else {
            Optional<? extends Holder<WolfVariant>> optional = WolfVariants.a(this.ae, this.dX(), SpawnContext.a(worldaccess, this.dv()));
            if (optional.isPresent()) {
                this.j(optional.get());
                groupdataentity = new b(optional.get());
            }
        }
        this.k(WolfSoundVariants.a(this.dX(), this.ae));
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    protected SoundEffect s() {
        return this.ac_() ? this.gM().a().c().a() : (this.ae.a(3) == 0 ? (this.m() && this.eG() < 20.0f ? this.gM().a().f().a() : this.gM().a().e().a()) : this.gM().a().a().a());
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return this.i(damagesource) ? SoundEffects.DO : this.gM().a().d().a();
    }

    @Override
    protected SoundEffect j_() {
        return this.gM().a().b().a();
    }

    @Override
    protected float fe() {
        return 0.4f;
    }

    @Override
    public void d_() {
        super.d_();
        if (!this.dV().C && this.bZ && !this.ca && !this.gq() && this.aH()) {
            this.ca = true;
            this.cb = 0.0f;
            this.cc = 0.0f;
            this.dV().a((Entity)this, (byte)8);
        }
        if (!this.dV().C) {
            this.a((WorldServer)this.dV(), true);
        }
    }

    @Override
    public void g() {
        super.g();
        if (this.bJ()) {
            this.bY = this.bX;
            this.bX = this.gK() ? (this.bX += (1.0f - this.bX) * 0.4f) : (this.bX += (0.0f - this.bX) * 0.4f);
            if (this.bk()) {
                this.bZ = true;
                if (this.ca && !this.dV().C) {
                    this.dV().a((Entity)this, (byte)56);
                    this.gN();
                }
            } else if ((this.bZ || this.ca) && this.ca) {
                if (this.cb == 0.0f) {
                    this.a(SoundEffects.DQ, this.fe(), (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
                    ((Entity)this).a(GameEvent.u);
                }
                this.cc = this.cb;
                this.cb += 0.05f;
                if (this.cc >= 2.0f) {
                    this.bZ = false;
                    this.ca = false;
                    this.cc = 0.0f;
                    this.cb = 0.0f;
                }
                if (this.cb > 0.4f) {
                    float f2 = (float)this.dC();
                    int i2 = (int)(MathHelper.a((this.cb - 0.4f) * (float)Math.PI) * 7.0f);
                    Vec3D vec3d = this.dy();
                    for (int j2 = 0; j2 < i2; ++j2) {
                        float f1 = (this.ae.i() * 2.0f - 1.0f) * this.dq() * 0.5f;
                        float f22 = (this.ae.i() * 2.0f - 1.0f) * this.dq() * 0.5f;
                        this.dV().a(Particles.ap, this.dA() + (double)f1, (double)(f2 + 0.8f), this.dG() + (double)f22, vec3d.d, vec3d.e, vec3d.f);
                    }
                }
            }
        }
    }

    private void gN() {
        this.ca = false;
        this.cb = 0.0f;
        this.cc = 0.0f;
    }

    @Override
    public void a(DamageSource damagesource) {
        this.bZ = false;
        this.ca = false;
        this.cc = 0.0f;
        this.cb = 0.0f;
        super.a(damagesource);
    }

    public float J(float f2) {
        return !this.bZ ? 1.0f : Math.min(0.75f + MathHelper.h(f2, this.cc, this.cb) / 2.0f * 0.25f, 1.0f);
    }

    public float K(float f2) {
        return MathHelper.h(f2, this.cc, this.cb);
    }

    public float L(float f2) {
        return MathHelper.h(f2, this.bY, this.bX) * 0.15f * (float)Math.PI;
    }

    @Override
    public int ac() {
        return this.u() ? 20 : super.ac();
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        boolean result = super.a(worldserver, damagesource, f2);
        if (!result) {
            return result;
        }
        this.y(false);
        return result;
    }

    @Override
    public boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        if (!this.i(damagesource)) {
            return super.actuallyHurt(worldserver, damagesource, f2, event);
        }
        if (event.isCancelled()) {
            return false;
        }
        ItemStack itemstack = this.fY();
        int i2 = itemstack.o();
        int j2 = itemstack.p();
        itemstack.a(MathHelper.f(f2), (EntityLiving)this, EnumItemSlot.g);
        if (Crackiness.b.a(i2, j2) != Crackiness.b.a(this.fY())) {
            this.a(SoundEffects.DN);
            worldserver.a(new ParticleParamItem(Particles.U, Items.pe.m()), this.dA(), this.dC() + 1.0, this.dG(), 20, 0.2, 0.1, 0.2, 0.1);
        }
        return false;
    }

    private boolean i(DamageSource damagesource) {
        return this.fY().a(Items.pf) && !damagesource.a(DamageTypeTags.C);
    }

    @Override
    protected void p() {
        if (this.m()) {
            this.g(GenericAttributes.s).a(40.0);
            this.d(this.eU());
        } else {
            this.g(GenericAttributes.s).a(8.0);
        }
    }

    @Override
    protected void c(DamageSource damagesource, float f2) {
        this.a(damagesource, f2, EnumItemSlot.g);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        Item item = itemstack.h();
        if (this.m()) {
            if (this.i(itemstack) && this.eG() < this.eU()) {
                this.a(entityhuman, enumhand, itemstack);
                FoodInfo foodinfo = itemstack.a(DataComponents.v);
                float f2 = foodinfo != null ? (float)foodinfo.a() : 1.0f;
                this.heal(2.0f * f2, EntityRegainHealthEvent.RegainReason.EATING);
                return EnumInteractionResult.a;
            }
            if (item instanceof ItemDye) {
                ItemDye itemdye = (ItemDye)item;
                if (this.j(entityhuman)) {
                    EnumColor enumcolor = itemdye.a();
                    if (enumcolor != this.gJ()) {
                        this.a(enumcolor);
                        itemstack.a(1, (EntityLiving)entityhuman);
                        return EnumInteractionResult.a;
                    }
                    return super.b(entityhuman, enumhand);
                }
            }
            if (this.a(itemstack, EnumItemSlot.g) && !this.ga() && this.j(entityhuman) && !this.e_()) {
                this.h(itemstack.c(1));
                itemstack.a(1, (EntityLiving)entityhuman);
                return EnumInteractionResult.a;
            }
            if (!itemstack.a(Items.td) || !this.j(entityhuman) || !this.ga() || EnchantmentManager.a(this.fY(), EnchantmentEffectComponents.E) && !entityhuman.gz()) {
                if (this.u() && this.ga() && this.j(entityhuman) && this.fY().n() && this.fY().c(itemstack)) {
                    itemstack.h(1);
                    this.a(SoundEffects.DP);
                    ItemStack itemstack1 = this.fY();
                    int i2 = (int)((float)itemstack1.p() * 0.125f);
                    itemstack1.b(Math.max(0, itemstack1.o() - i2));
                    return EnumInteractionResult.a;
                }
                EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
                if (!enuminteractionresult.a() && this.j(entityhuman)) {
                    this.y(!this.gu());
                    this.bf = false;
                    this.bE.m();
                    this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET, true);
                    return EnumInteractionResult.a.b();
                }
                return enuminteractionresult;
            }
            itemstack.a(1, (EntityLiving)entityhuman, EntityWolf.d(enumhand));
            this.a(SoundEffects.az);
            ItemStack itemstack2 = this.fY();
            this.h(ItemStack.l);
            World world = this.dV();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                this.forceDrops = true;
                this.a(worldserver, itemstack2);
                this.forceDrops = false;
            }
            return EnumInteractionResult.a;
        }
        if (!this.dV().C && itemstack.a(Items.sH) && !this.ac_()) {
            itemstack.a(1, (EntityLiving)entityhuman);
            this.f(entityhuman);
            return EnumInteractionResult.b;
        }
        return super.b(entityhuman, enumhand);
    }

    private void f(EntityHuman entityhuman) {
        if (this.ae.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, entityhuman).isCancelled()) {
            this.a(entityhuman);
            this.bE.m();
            this.g((EntityLiving)null);
            this.y(true);
            this.dV().a((Entity)this, (byte)7);
        } else {
            this.dV().a((Entity)this, (byte)6);
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 8) {
            this.ca = true;
            this.cb = 0.0f;
            this.cc = 0.0f;
        } else if (b0 == 56) {
            this.gN();
        } else {
            super.b(b0);
        }
    }

    public float gI() {
        if (this.ac_()) {
            return 1.5393804f;
        }
        if (this.m()) {
            float f2 = this.eU();
            float f1 = (f2 - this.eG()) / f2;
            return (0.55f - f1 * 0.4f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return itemstack.a(TagsItem.ai);
    }

    @Override
    public int fX() {
        return 8;
    }

    @Override
    public int a() {
        return this.al.a(bQ);
    }

    @Override
    public void a(int i2) {
        this.al.a(bQ, i2);
    }

    @Override
    public void c() {
        this.a(cd.a(this.ae));
    }

    @Override
    @Nullable
    public UUID b() {
        return this.ce;
    }

    @Override
    public void a(@Nullable UUID uuid) {
        this.ce = uuid;
    }

    public EnumColor gJ() {
        return EnumColor.a(this.al.a(bP));
    }

    public void a(EnumColor enumcolor) {
        this.al.a(bP, enumcolor.a());
    }

    @Nullable
    public EntityWolf b(WorldServer worldserver, EntityAgeable entityageable) {
        EntityWolf entitywolf = EntityTypes.bN.a(worldserver, EntitySpawnReason.e);
        if (entitywolf != null && entityageable instanceof EntityWolf) {
            EntityWolf entitywolf1 = (EntityWolf)entityageable;
            if (this.ae.h()) {
                entitywolf.j(this.gL());
            } else {
                entitywolf.j(entitywolf1.gL());
            }
            if (this.m()) {
                ((EntityTameableAnimal)entitywolf).a(this.d());
                entitywolf.a(true, true);
                EnumColor enumcolor = this.gJ();
                EnumColor enumcolor1 = entitywolf1.gJ();
                entitywolf.a(EnumColor.a(worldserver, enumcolor, enumcolor1));
            }
            entitywolf.k(WolfSoundVariants.a(this.dX(), this.ae));
        }
        return entitywolf;
    }

    public void z(boolean flag) {
        this.al.a(bO, flag);
    }

    @Override
    public boolean a(EntityAnimal entityanimal) {
        if (entityanimal == this) {
            return false;
        }
        if (!this.m()) {
            return false;
        }
        if (!(entityanimal instanceof EntityWolf)) {
            return false;
        }
        EntityWolf entitywolf = (EntityWolf)entityanimal;
        return !entitywolf.m() ? false : (entitywolf.u() ? false : this.gE() && entitywolf.gE());
    }

    public boolean gK() {
        return this.al.a(bO);
    }

    @Override
    public boolean a(EntityLiving entityliving, EntityLiving entityliving1) {
        if (!(entityliving instanceof EntityCreeper || entityliving instanceof EntityGhast || entityliving instanceof EntityArmorStand)) {
            EntityTameableAnimal entitytameableanimal;
            EntityHorseAbstract entityhorseabstract;
            if (entityliving instanceof EntityWolf) {
                EntityWolf entitywolf = (EntityWolf)entityliving;
                return !entitywolf.m() || entitywolf.T_() != entityliving1;
            }
            if (entityliving instanceof EntityHuman) {
                EntityHuman entityhuman1;
                EntityHuman entityhuman = (EntityHuman)entityliving;
                if (entityliving1 instanceof EntityHuman && !(entityhuman1 = (EntityHuman)entityliving1).a(entityhuman)) {
                    return false;
                }
            }
            if (entityliving instanceof EntityHorseAbstract && (entityhorseabstract = (EntityHorseAbstract)entityliving).gL()) {
                return false;
            }
            if (entityliving instanceof EntityTameableAnimal && (entitytameableanimal = (EntityTameableAnimal)entityliving).m()) {
                boolean flag = false;
                return flag;
            }
            boolean flag = true;
            return flag;
        }
        return false;
    }

    @Override
    public boolean w() {
        return !this.ac_();
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.6f * this.cS(), this.dq() * 0.4f);
    }

    public static boolean c(EntityTypes<EntityWolf> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.cj) && EntityWolf.a(generatoraccess, blockposition);
    }

    private class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityWolf j;

        public a(EntityWolf entitywolf, Class oclass, float f2, double d0, double d1) {
            super(entitywolf, oclass, f2, d0, d1);
            this.j = entitywolf;
        }

        @Override
        public boolean b() {
            return super.b() && this.b instanceof EntityLlama ? !this.j.m() && this.a((EntityLlama)this.b) : false;
        }

        private boolean a(EntityLlama entityllama) {
            return entityllama.gy() >= EntityWolf.this.ae.a(5);
        }

        @Override
        public void d() {
            EntityWolf.this.g((EntityLiving)null);
            super.d();
        }

        @Override
        public void a() {
            EntityWolf.this.g((EntityLiving)null);
            super.a();
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Holder<WolfVariant> a;

        public b(Holder<WolfVariant> holder) {
            super(false);
            this.a = holder;
        }
    }
}

