/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.DragonFlightHistory;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerManager;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityEnderDragon
extends EntityInsentient
implements IMonster {
    private static final Logger bK = LogUtils.getLogger();
    public static final DataWatcherObject<Integer> a = DataWatcher.a(EntityEnderDragon.class, DataWatcherRegistry.b);
    private static final PathfinderTargetCondition bL = PathfinderTargetCondition.a().a(64.0);
    private static final int bM = 200;
    private static final int bN = 400;
    private static final float bO = 0.25f;
    private static final String bP = "DragonDeathTime";
    private static final String bQ = "DragonPhase";
    private static final int bR = 0;
    public final DragonFlightHistory b = new DragonFlightHistory();
    public final EntityComplexPart[] bS;
    public final EntityComplexPart c;
    private final EntityComplexPart bT;
    private final EntityComplexPart bU;
    private final EntityComplexPart bV;
    private final EntityComplexPart bW;
    private final EntityComplexPart bX;
    private final EntityComplexPart bY;
    private final EntityComplexPart bZ;
    public float d;
    public float e;
    public boolean f;
    public int bH = 0;
    public float bI;
    @Nullable
    public EntityEnderCrystal bJ;
    @Nullable
    private EnderDragonBattle ca;
    private BlockPosition cb = BlockPosition.c;
    private final DragonControllerManager cc;
    private int cd = 100;
    private float ce;
    private final PathPoint[] cf = new PathPoint[24];
    private final int[] cg = new int[24];
    private final Path ch = new Path();
    private final Explosion explosionSource;

    public EntityEnderDragon(EntityTypes<? extends EntityEnderDragon> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.Q, world);
        this.c = new EntityComplexPart(this, "head", 1.0f, 1.0f);
        this.bT = new EntityComplexPart(this, "neck", 3.0f, 3.0f);
        this.bU = new EntityComplexPart(this, "body", 5.0f, 3.0f);
        this.bV = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.bW = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.bX = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.bY = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.bZ = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.bS = new EntityComplexPart[]{this.c, this.bT, this.bU, this.bV, this.bW, this.bX, this.bY, this.bZ};
        this.d(this.eU());
        this.ad = true;
        this.cc = new DragonControllerManager(this);
        this.explosionSource = new ServerExplosion(world.getMinecraftWorld(), this, null, null, new Vec3D(Double.NaN, Double.NaN, Double.NaN), Float.NaN, true, Explosion.Effect.b);
    }

    public void a(EnderDragonBattle enderdragonbattle) {
        this.ca = enderdragonbattle;
    }

    public void c(BlockPosition blockposition) {
        this.cb = blockposition;
    }

    public BlockPosition m() {
        return this.cb;
    }

    public static AttributeProvider.Builder p() {
        return EntityInsentient.D().a(GenericAttributes.s, 200.0);
    }

    @Override
    public boolean aZ() {
        float f2 = MathHelper.b(this.e * ((float)Math.PI * 2));
        float f1 = MathHelper.b(this.d * ((float)Math.PI * 2));
        return f1 <= -0.3f && f2 >= -0.3f;
    }

    @Override
    public void aY() {
        if (this.dV().C && !this.ba()) {
            this.dV().a(this.dA(), this.dC(), this.dG(), SoundEffects.iB, this.dm(), 5.0f, 0.8f + this.ae.i() * 0.3f, false);
        }
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, DragonControllerPhase.k.b());
    }

    @Override
    public void d_() {
        WorldServer worldserver;
        EnderDragonBattle enderdragonbattle;
        World world;
        this.aN();
        if (this.dV().C) {
            this.d(this.eG());
            if (!this.ba() && !this.cc.a().a() && --this.cd < 0) {
                this.dV().a(this.dA(), this.dC(), this.dG(), SoundEffects.iC, this.dm(), 2.5f, 0.8f + this.ae.i() * 0.3f, false);
                this.cd = 200 + this.ae.a(200);
            }
        }
        if (this.ca == null && (world = this.dV()) instanceof WorldServer && (enderdragonbattle = (worldserver = (WorldServer)world).F()) != null && this.cG().equals(enderdragonbattle.i())) {
            this.ca = enderdragonbattle;
        }
        this.d = this.e;
        if (this.eH()) {
            float f2 = (this.ae.i() - 0.5f) * 8.0f;
            float f1 = (this.ae.i() - 0.5f) * 4.0f;
            float f22 = (this.ae.i() - 0.5f) * 8.0f;
            this.dV().a(Particles.w, this.dA() + (double)f2, this.dC() + 2.0 + (double)f1, this.dG() + (double)f22, 0.0, 0.0, 0.0);
        } else {
            this.gu();
            Vec3D vec3d = this.dy();
            float f3 = 0.2f / ((float)vec3d.i() * 10.0f + 1.0f);
            this.e = this.cc.a().a() ? (this.e += 0.1f) : (this.f ? (this.e += f3 * 0.5f) : (this.e += (f3 *= (float)Math.pow(2.0, vec3d.e))));
            this.w(MathHelper.h(this.dL()));
            if (this.gj()) {
                this.e = 0.5f;
            } else {
                this.b.a(this.dC(), this.dL());
                World world1 = this.dV();
                if (world1 instanceof WorldServer) {
                    Vec3D vec3d1;
                    WorldServer worldserver1 = (WorldServer)world1;
                    IDragonController idragoncontroller = this.cc.a();
                    idragoncontroller.a(worldserver1);
                    if (this.cc.a() != idragoncontroller) {
                        idragoncontroller = this.cc.a();
                        idragoncontroller.a(worldserver1);
                    }
                    if ((vec3d1 = idragoncontroller.f()) != null && idragoncontroller.h() != DragonControllerPhase.k) {
                        double d0 = vec3d1.d - this.dA();
                        double d1 = vec3d1.e - this.dC();
                        double d2 = vec3d1.f - this.dG();
                        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                        float f4 = idragoncontroller.e();
                        double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (d4 > 0.0) {
                            d1 = MathHelper.a(d1 / d4, (double)(-f4), (double)f4);
                        }
                        this.i(this.dy().b(0.0, d1 * 0.01, 0.0));
                        this.w(MathHelper.h(this.dL()));
                        Vec3D vec3d2 = vec3d1.a(this.dA(), this.dC(), this.dG()).d();
                        Vec3D vec3d3 = new Vec3D(MathHelper.a(this.dL() * ((float)Math.PI / 180)), this.dy().e, -MathHelper.b(this.dL() * ((float)Math.PI / 180))).d();
                        float f5 = Math.max(((float)vec3d3.b(vec3d2) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d0) > (double)1.0E-5f || Math.abs(d2) > (double)1.0E-5f) {
                            float f6 = MathHelper.a(MathHelper.h(180.0f - (float)MathHelper.d(d0, d2) * 57.295776f - this.dL()), -50.0f, 50.0f);
                            this.bI *= 0.8f;
                            this.bI += f6 * idragoncontroller.g();
                            this.w(this.dL() + this.bI * 0.1f);
                        }
                        float f7 = (float)(2.0 / (d3 + 1.0));
                        float f8 = 0.06f;
                        this.a(0.06f * (f5 * f7 + (1.0f - f7)), new Vec3D(0.0, 0.0, -1.0));
                        if (this.f) {
                            this.a(EnumMoveType.a, this.dy().c((double)0.8f));
                        } else {
                            this.a(EnumMoveType.a, this.dy());
                        }
                        Vec3D vec3d4 = this.dy().d();
                        double d5 = 0.8 + 0.15 * (vec3d4.b(vec3d3) + 1.0) / 2.0;
                        this.i(this.dy().d(d5, 0.91f, d5));
                    }
                } else {
                    this.bj.e();
                    this.cc.a().b();
                }
                if (!this.dV().A_()) {
                    this.aI();
                }
                this.aV = this.dL();
                Vec3D[] avec3d = new Vec3D[this.bS.length];
                for (int i2 = 0; i2 < this.bS.length; ++i2) {
                    avec3d[i2] = new Vec3D(this.bS[i2].dA(), this.bS[i2].dC(), this.bS[i2].dG());
                }
                float f9 = (float)(this.b.a(5).a() - this.b.a(10).a()) * 10.0f * ((float)Math.PI / 180);
                float f10 = MathHelper.b(f9);
                float f11 = MathHelper.a(f9);
                float f12 = this.dL() * ((float)Math.PI / 180);
                float f13 = MathHelper.a(f12);
                float f14 = MathHelper.b(f12);
                this.a(this.bU, (double)(f13 * 0.5f), 0.0, (double)(-f14 * 0.5f));
                this.a(this.bY, (double)(f14 * 4.5f), 2.0, (double)(f13 * 4.5f));
                this.a(this.bZ, (double)(f14 * -4.5f), 2.0, (double)(f13 * -4.5f));
                World world2 = this.dV();
                if (world2 instanceof WorldServer) {
                    WorldServer worldserver2 = (WorldServer)world2;
                    if (this.aN == 0) {
                        this.a(worldserver2, worldserver2.a((Entity)this, this.bY.cR().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        this.a(worldserver2, worldserver2.a((Entity)this, this.bZ.cR().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        this.b(worldserver2, worldserver2.a((Entity)this, this.c.cR().g(1.0), IEntitySelector.e));
                        this.b(worldserver2, worldserver2.a((Entity)this, this.bT.cR().g(1.0), IEntitySelector.e));
                    }
                }
                float f15 = MathHelper.a(this.dL() * ((float)Math.PI / 180) - this.bI * 0.01f);
                float f16 = MathHelper.b(this.dL() * ((float)Math.PI / 180) - this.bI * 0.01f);
                float f17 = this.gt();
                this.a(this.c, (double)(f15 * 6.5f * f10), (double)(f17 + f11 * 6.5f), (double)(-f16 * 6.5f * f10));
                this.a(this.bT, (double)(f15 * 5.5f * f10), (double)(f17 + f11 * 5.5f), (double)(-f16 * 5.5f * f10));
                DragonFlightHistory.a dragonflighthistory_a = this.b.a(5);
                for (int j2 = 0; j2 < 3; ++j2) {
                    EntityComplexPart entitycomplexpart = null;
                    if (j2 == 0) {
                        entitycomplexpart = this.bV;
                    }
                    if (j2 == 1) {
                        entitycomplexpart = this.bW;
                    }
                    if (j2 == 2) {
                        entitycomplexpart = this.bX;
                    }
                    DragonFlightHistory.a dragonflighthistory_a1 = this.b.a(12 + j2 * 2);
                    float f18 = this.dL() * ((float)Math.PI / 180) + this.i((double)(dragonflighthistory_a1.b() - dragonflighthistory_a.b())) * ((float)Math.PI / 180);
                    float f19 = MathHelper.a(f18);
                    float f20 = MathHelper.b(f18);
                    float f21 = 1.5f;
                    float f22 = (float)(j2 + 1) * 2.0f;
                    this.a(entitycomplexpart, (double)(-(f13 * 1.5f + f19 * f22) * f10), dragonflighthistory_a1.a() - dragonflighthistory_a.a() - (double)((f22 + 1.5f) * f11) + 1.5, (double)((f14 * 1.5f + f20 * f22) * f10));
                }
                World world3 = this.dV();
                if (world3 instanceof WorldServer) {
                    WorldServer worldserver3 = (WorldServer)world3;
                    this.f = this.a(worldserver3, this.c.cR()) | this.a(worldserver3, this.bT.cR()) | this.a(worldserver3, this.bU.cR());
                    if (this.ca != null) {
                        this.ca.b(this);
                    }
                }
                for (int k2 = 0; k2 < this.bS.length; ++k2) {
                    this.bS[k2].K = avec3d[k2].d;
                    this.bS[k2].L = avec3d[k2].e;
                    this.bS[k2].M = avec3d[k2].f;
                    this.bS[k2].aa = avec3d[k2].d;
                    this.bS[k2].ab = avec3d[k2].e;
                    this.bS[k2].ac = avec3d[k2].f;
                }
            }
        }
    }

    private void a(EntityComplexPart entitycomplexpart, double d0, double d1, double d2) {
        entitycomplexpart.a_(this.dA() + d0, this.dC() + d1, this.dG() + d2);
    }

    private float gt() {
        if (this.cc.a().a()) {
            return -1.0f;
        }
        DragonFlightHistory.a dragonflighthistory_a = this.b.a(5);
        DragonFlightHistory.a dragonflighthistory_a1 = this.b.a(0);
        return (float)(dragonflighthistory_a.a() - dragonflighthistory_a1.a());
    }

    private void gu() {
        if (this.bJ != null) {
            if (this.bJ.dQ()) {
                this.bJ = null;
            } else if (this.af % 10 == 0 && this.eG() < this.eU()) {
                EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0, EntityRegainHealthEvent.RegainReason.ENDER_CRYSTAL);
                this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.d((float)((double)this.eG() + event.getAmount()));
                }
            }
        }
        if (this.ae.a(10) == 0) {
            List<EntityEnderCrystal> list = this.dV().a(EntityEnderCrystal.class, this.cR().g(32.0));
            EntityEnderCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EntityEnderCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.g(this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
            }
            this.bJ = entityendercrystal;
        }
    }

    private void a(WorldServer worldserver, List<Entity> list) {
        double d0 = (this.bU.cR().a + this.bU.cR().d) / 2.0;
        double d1 = (this.bU.cR().c + this.bU.cR().f) / 2.0;
        for (Entity entity : list) {
            if (!(entity instanceof EntityLiving)) continue;
            EntityLiving entityliving = (EntityLiving)entity;
            double d2 = entity.dA() - d0;
            double d3 = entity.dG() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.i(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0);
            if (this.cc.a().a() || entityliving.et() >= entity.af - 2) continue;
            DamageSource damagesource = this.dW().b(this);
            entity.a(worldserver, damagesource, 5.0f);
            EnchantmentManager.a(worldserver, entity, damagesource);
        }
    }

    private void b(WorldServer worldserver, List<Entity> list) {
        for (Entity entity : list) {
            if (!(entity instanceof EntityLiving)) continue;
            DamageSource damagesource = this.dW().b(this);
            entity.a(worldserver, damagesource, 10.0f);
            EnchantmentManager.a(worldserver, entity, damagesource);
        }
    }

    private float i(double d0) {
        return (float)MathHelper.d(d0);
    }

    private boolean a(WorldServer worldserver, AxisAlignedBB axisalignedbb) {
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.a(axisalignedbb.b);
        int k2 = MathHelper.a(axisalignedbb.c);
        int l2 = MathHelper.a(axisalignedbb.d);
        int i1 = MathHelper.a(axisalignedbb.e);
        int j1 = MathHelper.a(axisalignedbb.f);
        boolean flag = false;
        boolean flag1 = false;
        ArrayList<org.bukkit.block.Block> destroyedBlocks = new ArrayList<org.bukkit.block.Block>();
        for (int k1 = i2; k1 <= l2; ++k1) {
            for (int l1 = j2; l1 <= i1; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    BlockPosition blockposition = new BlockPosition(k1, l1, i22);
                    IBlockData iblockdata = worldserver.a_(blockposition);
                    if (iblockdata.l() || iblockdata.a(TagsBlock.aG)) continue;
                    if (worldserver.O().c(GameRules.d) && !iblockdata.a(TagsBlock.aF)) {
                        flag1 = true;
                        destroyedBlocks.add(CraftBlock.at(worldserver, blockposition));
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (!flag1) {
            return flag;
        }
        EntityExplodeEvent event = CraftEventFactory.callEntityExplodeEvent(this, destroyedBlocks, 0.0f, this.explosionSource.b());
        if (event.isCancelled()) {
            return flag;
        }
        if (event.getYield() == 0.0f) {
            for (org.bukkit.block.Block block : event.blockList()) {
                this.dV().a(new BlockPosition(block.getX(), block.getY(), block.getZ()), false);
            }
        } else {
            for (org.bukkit.block.Block block : event.blockList()) {
                Material blockId = block.getType();
                if (blockId.isAir()) continue;
                CraftBlock craftBlock = (CraftBlock)block;
                BlockPosition blockposition = craftBlock.getPosition();
                Block nmsBlock = craftBlock.getNMS().b();
                if (nmsBlock.a(this.explosionSource)) {
                    TileEntity tileentity = craftBlock.getNMS().x() ? this.dV().c_(blockposition) : null;
                    LootParams.a loottableinfo_builder = new LootParams.a((WorldServer)this.dV()).a(LootContextParameters.f, Vec3D.b(blockposition)).a(LootContextParameters.i, ItemStack.l).a(LootContextParameters.j, Float.valueOf(1.0f / event.getYield())).b(LootContextParameters.h, tileentity);
                    craftBlock.getNMS().a(loottableinfo_builder).forEach(itemstack -> Block.a(this.dV(), blockposition, itemstack));
                    craftBlock.getNMS().a((WorldServer)this.dV(), blockposition, ItemStack.l, false);
                }
                nmsBlock.a((WorldServer)this.dV(), blockposition, this.explosionSource);
                this.dV().a(blockposition, false);
            }
        }
        if (flag1) {
            BlockPosition blockposition1 = new BlockPosition(i2 + this.ae.a(l2 - i2 + 1), j2 + this.ae.a(i1 - j2 + 1), k2 + this.ae.a(j1 - k2 + 1));
            worldserver.c(2008, blockposition1, 0);
        }
        return flag;
    }

    public boolean a(WorldServer worldserver, EntityComplexPart entitycomplexpart, DamageSource damagesource, float f2) {
        if (this.cc.a().h() == DragonControllerPhase.j) {
            return false;
        }
        f2 = this.cc.a().a(damagesource, f2);
        if (entitycomplexpart != this.c) {
            f2 = f2 / 4.0f + Math.min(f2, 1.0f);
        }
        if (f2 < 0.01f) {
            return false;
        }
        if (damagesource.d() instanceof EntityHuman || damagesource.a(DamageTypeTags.y)) {
            float f1 = this.eG();
            this.d(worldserver, damagesource, f2);
            if (this.eH() && !this.cc.a().a()) {
                this.d(1.0f);
                this.cc.a(DragonControllerPhase.j);
            }
            if (this.cc.a().a()) {
                this.ce = this.ce + f1 - this.eG();
                if (this.ce > 0.25f * this.eU()) {
                    this.ce = 0.0f;
                    this.cc.a(DragonControllerPhase.e);
                }
            }
        }
        return true;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        return this.a(worldserver, this.bU, damagesource, f2);
    }

    protected void d(WorldServer worldserver, DamageSource damagesource, float f2) {
        super.a(worldserver, damagesource, f2);
    }

    @Override
    public void c(WorldServer worldserver) {
        this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        ((Entity)this).a(GameEvent.p);
        if (this.ca != null) {
            this.ca.b(this);
            this.ca.a(this);
        }
    }

    @Override
    public int getExpReward(WorldServer worldserver, Entity entity) {
        boolean flag = worldserver.O().c(GameRules.g);
        int short0 = 500;
        if (this.ca != null && !this.ca.f()) {
            short0 = 12000;
        }
        return flag ? short0 : 0;
    }

    @Override
    protected void en() {
        World world1;
        if (this.ca != null) {
            this.ca.b(this);
        }
        ++this.bH;
        if (this.bH >= 180 && this.bH <= 200) {
            float f2 = (this.ae.i() - 0.5f) * 8.0f;
            float f1 = (this.ae.i() - 0.5f) * 4.0f;
            float f22 = (this.ae.i() - 0.5f) * 8.0f;
            this.dV().a(Particles.v, this.dA() + (double)f2, this.dC() + 2.0 + (double)f1, this.dG() + (double)f22, 0.0, 0.0, 0.0);
        }
        int i2 = this.expToDrop;
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.bH > 150 && this.bH % 5 == 0) {
                EntityExperienceOrb.a(worldserver, this.dt(), MathHelper.d((float)i2 * 0.08f));
            }
            if (this.bH == 1 && !this.ba()) {
                int viewDistance = worldserver.getCraftServer().getViewDistance() * 16;
                for (EntityPlayer player : worldserver.p().ag().l) {
                    double deltaX = this.dA() - player.dA();
                    double deltaZ = this.dG() - player.dG();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    if (worldserver.spigotConfig.dragonDeathSoundRadius > 0 && distanceSquared > (double)(worldserver.spigotConfig.dragonDeathSoundRadius * worldserver.spigotConfig.dragonDeathSoundRadius)) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.dA() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.dG() + deltaZ / deltaLength * (double)viewDistance;
                        player.f.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)relativeX, (int)this.dC(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.f.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)this.dA(), (int)this.dC(), (int)this.dG()), 0, true));
                }
            }
        }
        Vec3D vec3d = new Vec3D(0.0, 0.1f, 0.0);
        this.a(EnumMoveType.a, vec3d);
        for (EntityComplexPart entitycomplexpart : this.bS) {
            entitycomplexpart.bx();
            entitycomplexpart.b(entitycomplexpart.dt().e(vec3d));
        }
        if (this.bH == 200 && (world1 = this.dV()) instanceof WorldServer) {
            WorldServer worldserver1 = (WorldServer)world1;
            EntityExperienceOrb.a(worldserver1, this.dt(), MathHelper.d((float)i2 * 0.2f));
            if (this.ca != null) {
                this.ca.a(this);
            }
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
            ((Entity)this).a(GameEvent.p);
        }
    }

    public int u() {
        if (this.cf[0] == null) {
            for (int i2 = 0; i2 < 24; ++i2) {
                int l2;
                int k2;
                int j2 = 5;
                if (i2 < 12) {
                    k2 = MathHelper.d(60.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                    l2 = MathHelper.d(60.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                } else if (i2 < 20) {
                    int i1 = i2 - 12;
                    k2 = MathHelper.d(40.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    l2 = MathHelper.d(40.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    j2 += 10;
                } else {
                    int j1 = i2 - 20;
                    k2 = MathHelper.d(20.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)j1)));
                    l2 = MathHelper.d(20.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)j1)));
                }
                int k1 = Math.max(73, this.dV().a(HeightMap.Type.f, new BlockPosition(k2, 0, l2)).v() + j2);
                this.cf[i2] = new PathPoint(k2, k1, l2);
            }
            this.cg[0] = 6146;
            this.cg[1] = 8197;
            this.cg[2] = 8202;
            this.cg[3] = 16404;
            this.cg[4] = 32808;
            this.cg[5] = 32848;
            this.cg[6] = 65696;
            this.cg[7] = 131392;
            this.cg[8] = 131712;
            this.cg[9] = 263424;
            this.cg[10] = 526848;
            this.cg[11] = 525313;
            this.cg[12] = 1581057;
            this.cg[13] = 3166214;
            this.cg[14] = 2138120;
            this.cg[15] = 6373424;
            this.cg[16] = 4358208;
            this.cg[17] = 12910976;
            this.cg[18] = 9044480;
            this.cg[19] = 9706496;
            this.cg[20] = 15216640;
            this.cg[21] = 0xD0E000;
            this.cg[22] = 11763712;
            this.cg[23] = 0x7E0000;
        }
        return this.q(this.dA(), this.dC(), this.dG());
    }

    public int q(double d0, double d1, double d2) {
        float f2 = 10000.0f;
        int i2 = 0;
        PathPoint pathpoint = new PathPoint(MathHelper.a(d0), MathHelper.a(d1), MathHelper.a(d2));
        int j2 = 0;
        if (this.ca == null || this.ca.e() == 0) {
            j2 = 12;
        }
        for (int k2 = j2; k2 < 24; ++k2) {
            float f1;
            if (this.cf[k2] == null || !((f1 = this.cf[k2].c(pathpoint)) < f2)) continue;
            f2 = f1;
            i2 = k2;
        }
        return i2;
    }

    @Nullable
    public PathEntity a(int i2, int j2, @Nullable PathPoint pathpoint) {
        for (int k2 = 0; k2 < 24; ++k2) {
            PathPoint pathpoint1 = this.cf[k2];
            pathpoint1.i = false;
            pathpoint1.g = 0.0f;
            pathpoint1.e = 0.0f;
            pathpoint1.f = 0.0f;
            pathpoint1.h = null;
            pathpoint1.d = -1;
        }
        PathPoint pathpoint2 = this.cf[i2];
        PathPoint pathpoint3 = this.cf[j2];
        pathpoint2.e = 0.0f;
        pathpoint2.g = pathpoint2.f = pathpoint2.a(pathpoint3);
        this.ch.a();
        this.ch.a(pathpoint2);
        PathPoint pathpoint4 = pathpoint2;
        int l2 = 0;
        if (this.ca == null || this.ca.e() == 0) {
            l2 = 12;
        }
        while (!this.ch.e()) {
            PathPoint pathpoint5 = this.ch.c();
            if (pathpoint5.equals(pathpoint3)) {
                if (pathpoint != null) {
                    pathpoint.h = pathpoint3;
                    pathpoint3 = pathpoint;
                }
                return this.a(pathpoint2, pathpoint3);
            }
            if (pathpoint5.a(pathpoint3) < pathpoint4.a(pathpoint3)) {
                pathpoint4 = pathpoint5;
            }
            pathpoint5.i = true;
            int i1 = 0;
            for (int j1 = 0; j1 < 24; ++j1) {
                if (this.cf[j1] != pathpoint5) continue;
                i1 = j1;
                break;
            }
            for (int k1 = l2; k1 < 24; ++k1) {
                if ((this.cg[i1] & 1 << k1) <= 0) continue;
                PathPoint pathpoint6 = this.cf[k1];
                if (pathpoint6.i) continue;
                float f2 = pathpoint5.e + pathpoint5.a(pathpoint6);
                if (pathpoint6.c() && !(f2 < pathpoint6.e)) continue;
                pathpoint6.h = pathpoint5;
                pathpoint6.e = f2;
                pathpoint6.f = pathpoint6.a(pathpoint3);
                if (pathpoint6.c()) {
                    this.ch.a(pathpoint6, pathpoint6.e + pathpoint6.f);
                    continue;
                }
                pathpoint6.g = pathpoint6.e + pathpoint6.f;
                this.ch.a(pathpoint6);
            }
        }
        if (pathpoint4 == pathpoint2) {
            return null;
        }
        bK.debug("Failed to find path from {} to {}", (Object)i2, (Object)j2);
        if (pathpoint != null) {
            pathpoint.h = pathpoint4;
            pathpoint4 = pathpoint;
        }
        return this.a(pathpoint2, pathpoint4);
    }

    private PathEntity a(PathPoint pathpoint, PathPoint pathpoint1) {
        ArrayList list = Lists.newArrayList();
        PathPoint pathpoint2 = pathpoint1;
        list.add(0, pathpoint1);
        while (pathpoint2.h != null) {
            pathpoint2 = pathpoint2.h;
            list.add(0, pathpoint2);
        }
        return new PathEntity(list, new BlockPosition(pathpoint1.a, pathpoint1.b, pathpoint1.c), true);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a(bQ, this.cc.a().h().b());
        nbttagcompound.a(bP, this.bH);
        nbttagcompound.a("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        nbttagcompound.e(bQ).ifPresent(integer -> this.cc.a(DragonControllerPhase.a(integer)));
        this.bH = nbttagcompound.b(bP, 0);
        this.expToDrop = nbttagcompound.b("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    public void dH() {
    }

    public EntityComplexPart[] gq() {
        return this.bS;
    }

    @Override
    public boolean bF() {
        return false;
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.iy;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.iD;
    }

    @Override
    protected float fe() {
        return 5.0f;
    }

    public Vec3D J(float f2) {
        Vec3D vec3d;
        IDragonController idragoncontroller = this.cc.a();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.h();
        if (dragoncontrollerphase != DragonControllerPhase.d && dragoncontrollerphase != DragonControllerPhase.e) {
            if (idragoncontroller.a()) {
                float f1 = this.dN();
                float f22 = 1.5f;
                this.x(-45.0f);
                vec3d = this.h(f2);
                this.x(f1);
            } else {
                vec3d = this.h(f2);
            }
        } else {
            BlockPosition blockposition = this.dV().a(HeightMap.Type.f, WorldGenEndTrophy.a(this.cb));
            float f3 = Math.max((float)Math.sqrt(blockposition.b(this.dt())) / 4.0f, 1.0f);
            float f4 = 6.0f / f3;
            float f5 = this.dN();
            float f6 = 1.5f;
            this.x(-f4 * 1.5f * 5.0f);
            vec3d = this.h(f2);
            this.x(f5);
        }
        return vec3d;
    }

    public void a(WorldServer worldserver, EntityEnderCrystal entityendercrystal, BlockPosition blockposition, DamageSource damagesource) {
        EntityHuman entityhuman1;
        Entity entity = damagesource.d();
        EntityHuman entityhuman = entity instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entity) : worldserver.a(bL, (double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w());
        if (entityendercrystal == this.bJ) {
            this.a(worldserver, this.c, this.dW().d(entityendercrystal, entityhuman), 10.0f);
        }
        this.cc.a().a(entityendercrystal, blockposition, damagesource, entityhuman);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (a.equals(datawatcherobject) && this.dV().C) {
            this.cc.a(DragonControllerPhase.a(this.ar().a(a)));
        }
        super.a(datawatcherobject);
    }

    public DragonControllerManager gr() {
        return this.cc;
    }

    @Nullable
    public EnderDragonBattle gs() {
        return this.ca;
    }

    @Override
    public boolean b(MobEffect mobeffect, @Nullable Entity entity) {
        return false;
    }

    @Override
    protected boolean o(Entity entity) {
        return false;
    }

    @Override
    public boolean n(boolean flag) {
        return false;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        EntityComplexPart[] aentitycomplexpart = this.gq();
        for (int i2 = 0; i2 < aentitycomplexpart.length; ++i2) {
            aentitycomplexpart[i2].e(i2 + packetplayoutspawnentity.b() + 1);
        }
    }

    @Override
    public boolean c(EntityLiving entityliving) {
        return entityliving.ez();
    }

    @Override
    protected float b(float f2) {
        return 1.0f;
    }
}

