/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityPainting
extends EntityHanging {
    private static final DataWatcherObject<Holder<PaintingVariant>> e = DataWatcher.a(EntityPainting.class, DataWatcherRegistry.E);
    public static final float d = 0.0625f;

    public EntityPainting(EntityTypes<? extends EntityPainting> entitytypes, World world) {
        super((EntityTypes<? extends EntityHanging>)entitytypes, world);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(e, VariantUtils.b(this.dX(), Registries.aZ));
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (e.equals(datawatcherobject)) {
            this.e();
        }
    }

    public void b(Holder<PaintingVariant> holder) {
        this.al.a(e, holder);
    }

    public Holder<PaintingVariant> l() {
        return this.al.a(e);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aM ? EntityPainting.c(datacomponenttype, this.l()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aM);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aM) {
            this.b(EntityPainting.c(DataComponents.aM, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    public static Optional<EntityPainting> a(World world, BlockPosition blockposition, EnumDirection enumdirection) {
        EntityPainting entitypainting = new EntityPainting(world, blockposition);
        ArrayList<Holder> list = new ArrayList<Holder>();
        Iterable<Holder<PaintingVariant>> iterable = world.J_().f(Registries.aZ).c(PaintingVariantTags.a);
        Objects.requireNonNull(list);
        iterable.forEach(list::add);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        entitypainting.a(enumdirection);
        list.removeIf(holder -> {
            entitypainting.b((Holder<PaintingVariant>)holder);
            return !entitypainting.f();
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int i2 = list.stream().mapToInt(EntityPainting::c).max().orElse(0);
        list.removeIf(holder -> EntityPainting.c(holder) < i2);
        Optional optional = SystemUtils.b(list, entitypainting.ae);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        entitypainting.b((Holder)optional.get());
        entitypainting.a(enumdirection);
        return Optional.of(entitypainting);
    }

    private static int c(Holder<PaintingVariant> holder) {
        return holder.a().a();
    }

    private EntityPainting(World world, BlockPosition blockposition) {
        super((EntityTypes<? extends EntityHanging>)EntityTypes.aL, world, blockposition);
    }

    public EntityPainting(World world, BlockPosition blockposition, EnumDirection enumdirection, Holder<PaintingVariant> holder) {
        this(world, blockposition);
        this.b(holder);
        this.a(enumdirection);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        nbttagcompound.a("facing", EnumDirection.l, this.c);
        super.b(nbttagcompound);
        VariantUtils.a(nbttagcompound, this.l());
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        this.c = nbttagcompound.a("facing", EnumDirection.l).orElse(EnumDirection.d);
        super.a(nbttagcompound);
        this.a(this.c);
        VariantUtils.a(nbttagcompound, this.dX(), Registries.aZ).ifPresent(this::b);
    }

    @Override
    protected AxisAlignedBB a(BlockPosition blockposition, EnumDirection enumdirection) {
        PaintingVariant paintingvariant = this.l().a();
        return EntityPainting.calculateBoundingBoxStatic(blockposition, enumdirection, paintingvariant.b(), paintingvariant.c());
    }

    public static AxisAlignedBB calculateBoundingBoxStatic(BlockPosition blockposition, EnumDirection enumdirection, int width, int height) {
        float f2 = 0.46875f;
        Vec3D vec3d = Vec3D.b(blockposition).a(enumdirection, -0.46875);
        double d0 = EntityPainting.b(width);
        double d1 = EntityPainting.b(height);
        EnumDirection enumdirection1 = enumdirection.i();
        Vec3D vec3d1 = vec3d.a(enumdirection1, d0).a(EnumDirection.b, d1);
        EnumDirection.EnumAxis enumdirection_enumaxis = enumdirection.o();
        double d2 = enumdirection_enumaxis == EnumDirection.EnumAxis.a ? 0.0625 : (double)width;
        double d3 = height;
        double d4 = enumdirection_enumaxis == EnumDirection.EnumAxis.c ? 0.0625 : (double)width;
        return AxisAlignedBB.a(vec3d1, d2, d3, d4);
    }

    private static double b(int i2) {
        return i2 % 2 == 0 ? 0.5 : 0.0;
    }

    @Override
    public void a(WorldServer worldserver, @Nullable Entity entity) {
        if (worldserver.O().c(GameRules.j)) {
            EntityHuman entityhuman;
            this.a(SoundEffects.te, 1.0f, 1.0f);
            if (entity instanceof EntityHuman && (entityhuman = (EntityHuman)entity).fV()) {
                return;
            }
            this.a(worldserver, Items.qN);
        }
    }

    @Override
    public void u() {
        this.a(SoundEffects.tf, 1.0f, 1.0f);
    }

    @Override
    public void b(double d0, double d1, double d2, float f2, float f1) {
        this.a_(d0, d1, d2);
    }

    @Override
    public Vec3D du() {
        return Vec3D.a(this.a);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntity((Entity)this, this.c.d(), this.i());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        this.a(EnumDirection.a(packetplayoutspawnentity.p()));
    }

    @Override
    public ItemStack dI() {
        return new ItemStack(Items.qN);
    }
}

