/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class EntityItem
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<ItemStack> c = DataWatcher.a(EntityItem.class, DataWatcherRegistry.h);
    private static final float d = 0.1f;
    public static final float a = 0.2125f;
    private static final int e = 6000;
    private static final int f = Short.MAX_VALUE;
    private static final int g = Short.MIN_VALUE;
    private static final int h = 5;
    private static final short i = 0;
    private static final short j = 0;
    public int k = 0;
    public int l = 0;
    private int m = 5;
    @Nullable
    public UUID n;
    @Nullable
    private Entity o;
    @Nullable
    public UUID p;
    public final float b;
    private int lastTick = MinecraftServer.currentTick - 1;

    public EntityItem(EntityTypes<? extends EntityItem> entitytypes, World world) {
        super(entitytypes, world);
        this.b = this.ae.i() * (float)Math.PI * 2.0f;
        this.w(this.ae.i() * 360.0f);
    }

    public EntityItem(World world, double d0, double d1, double d2, ItemStack itemstack) {
        this(world, d0, d1, d2, itemstack, world.A.j() * 0.2 - 0.1, 0.2, world.A.j() * 0.2 - 0.1);
    }

    public EntityItem(World world, double d0, double d1, double d2, ItemStack itemstack, double d3, double d4, double d5) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ar, world);
        this.a_(d0, d1, d2);
        this.n(d3, d4, d5);
        this.a(itemstack);
    }

    private EntityItem(EntityItem entityitem) {
        super(entityitem.an(), entityitem.dV());
        this.a(entityitem.e().v());
        this.w(entityitem);
        this.k = entityitem.k;
        this.b = entityitem.b;
    }

    @Override
    public boolean bg() {
        return this.e().a(TagsItem.bt);
    }

    @Override
    @Nullable
    public Entity p() {
        World world;
        if (this.o != null && !this.o.dQ()) {
            return this.o;
        }
        if (this.n != null && (world = this.dV()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.o = worldserver.b(this.n);
            return this.o;
        }
        return null;
    }

    @Override
    public void x(Entity entity) {
        super.x(entity);
        if (entity instanceof EntityItem) {
            EntityItem entityitem = (EntityItem)entity;
            this.o = entityitem.o;
        }
    }

    @Override
    protected Entity.MovementEmission bf() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(c, ItemStack.l);
    }

    @Override
    protected double bc() {
        return 0.04;
    }

    @Override
    public void g() {
        if (this.e().f()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            double d0;
            int i2;
            super.g();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            if (this.l != Short.MAX_VALUE) {
                this.l -= elapsedTicks;
            }
            if (this.k != Short.MIN_VALUE) {
                this.k += elapsedTicks;
            }
            this.lastTick = MinecraftServer.currentTick;
            this.K = this.dA();
            this.L = this.dC();
            this.M = this.dG();
            Vec3D vec3d = this.dy();
            if (this.bi() && this.b(TagsFluid.a) > (double)0.1f) {
                this.v();
            } else if (this.bv() && this.b(TagsFluid.b) > (double)0.1f) {
                this.w();
            } else {
                this.be();
            }
            if (this.dV().C) {
                this.ad = false;
            } else {
                boolean bl = this.ad = !this.dV().a((Entity)this, this.cR().h(1.0E-7));
                if (this.ad) {
                    this.l(this.dA(), (this.cR().b + this.cR().e) / 2.0, this.dG());
                }
            }
            if (!this.aH() || this.dy().j() > (double)1.0E-5f || (this.af + this.ao()) % 4 == 0) {
                this.a(EnumMoveType.a, this.dy());
                this.aI();
                float f2 = 0.98f;
                if (this.aH()) {
                    f2 = this.dV().a_(this.aP()).b().g() * 0.98f;
                }
                this.i(this.dy().d(f2, 0.98, f2));
                if (this.aH()) {
                    Vec3D vec3d1 = this.dy();
                    if (vec3d1.e < 0.0) {
                        this.i(vec3d1.d(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = MathHelper.a(this.K) != MathHelper.a(this.dA()) || MathHelper.a(this.L) != MathHelper.a(this.dC()) || MathHelper.a(this.M) != MathHelper.a(this.dG());
            int n2 = i2 = flag ? 2 : 40;
            if (this.af % i2 == 0 && !this.dV().C && this.y()) {
                this.x();
            }
            this.ar |= this.bo();
            if (!this.dV().C && (d0 = this.dy().d(vec3d).h()) > 0.01) {
                this.ar = true;
            }
            if (!this.dV().C && this.k >= this.dV().spigotConfig.itemDespawnRate) {
                if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                    this.k = 0;
                    return;
                }
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            }
        }
    }

    @Override
    public void inactiveTick() {
        int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
        if (this.l != Short.MAX_VALUE) {
            this.l -= elapsedTicks;
        }
        if (this.k != Short.MIN_VALUE) {
            this.k += elapsedTicks;
        }
        this.lastTick = MinecraftServer.currentTick;
        if (!this.dV().C && this.k >= this.dV().spigotConfig.itemDespawnRate) {
            if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                this.k = 0;
                return;
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public BlockPosition aP() {
        return this.f(0.999999f);
    }

    private void v() {
        this.h((double)0.99f);
    }

    private void w() {
        this.h((double)0.95f);
    }

    private void h(double d0) {
        Vec3D vec3d = this.dy();
        this.n(vec3d.d * d0, vec3d.e + (double)(vec3d.e < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.f * d0);
    }

    private void x() {
        if (this.y()) {
            double radius = this.dV().spigotConfig.itemMerge;
            for (EntityItem entityitem : this.dV().a(EntityItem.class, this.cR().c(radius, radius - 0.5, radius), (? super T entityitem1) -> entityitem1 != this && entityitem1.y())) {
                if (!entityitem.y()) continue;
                this.a(entityitem);
                if (!this.dQ()) continue;
                break;
            }
        }
    }

    private boolean y() {
        ItemStack itemstack = this.e();
        return this.bJ() && this.l != Short.MAX_VALUE && this.k != Short.MIN_VALUE && this.k < 6000 && itemstack.M() < itemstack.k();
    }

    private void a(EntityItem entityitem) {
        ItemStack itemstack = this.e();
        ItemStack itemstack1 = entityitem.e();
        if (Objects.equals(this.p, entityitem.p) && EntityItem.a(itemstack, itemstack1)) {
            EntityItem.a(this, itemstack, entityitem, itemstack1);
        }
    }

    public static boolean a(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack1.M() + itemstack.M() > itemstack1.k() ? false : ItemStack.c(itemstack, itemstack1);
    }

    public static ItemStack a(ItemStack itemstack, ItemStack itemstack1, int i2) {
        int j2 = Math.min(Math.min(itemstack.k(), i2) - itemstack.M(), itemstack1.M());
        ItemStack itemstack2 = itemstack.c(itemstack.M() + j2);
        itemstack1.h(j2);
        return itemstack2;
    }

    private static void a(EntityItem entityitem, ItemStack itemstack, ItemStack itemstack1) {
        ItemStack itemstack2 = EntityItem.a(itemstack, itemstack1, 64);
        entityitem.a(itemstack2);
    }

    private static void a(EntityItem entityitem, ItemStack itemstack, EntityItem entityitem1, ItemStack itemstack1) {
        if (!CraftEventFactory.callItemMergeEvent(entityitem1, entityitem)) {
            return;
        }
        EntityItem.a(entityitem, itemstack, itemstack1);
        entityitem.l = Math.max(entityitem.l, entityitem1.l);
        entityitem.k = Math.min(entityitem.k, entityitem1.k);
        if (itemstack1.f()) {
            entityitem1.discard(EntityRemoveEvent.Cause.MERGE);
        }
    }

    @Override
    public boolean bh() {
        return !this.e().a(this.dW().a()) || super.bh();
    }

    @Override
    protected boolean aD() {
        return this.m <= 0 ? true : this.af % 10 == 0;
    }

    @Override
    public final boolean b(DamageSource damagesource) {
        return this.d(damagesource) ? false : this.e().a(damagesource);
    }

    @Override
    public final boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (this.d(damagesource)) {
            return false;
        }
        if (!worldserver.O().c(GameRules.d) && damagesource.d() instanceof EntityInsentient) {
            return false;
        }
        if (!this.e().a(damagesource)) {
            return false;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f2)) {
            return false;
        }
        this.bB();
        this.m = (int)((float)this.m - f2);
        this.a(GameEvent.o, damagesource.d());
        if (this.m <= 0) {
            this.e().a(this);
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public boolean a(Explosion explosion) {
        return explosion.h() ? super.a(explosion) : true;
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        nbttagcompound.a("Health", (short)this.m);
        nbttagcompound.a("Age", (short)this.k);
        nbttagcompound.a("PickupDelay", (short)this.l);
        nbttagcompound.b("Thrower", UUIDUtil.a, this.n);
        nbttagcompound.b("Owner", UUIDUtil.a, this.p);
        if (!this.e().f()) {
            RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
            nbttagcompound.a("Item", ItemStack.b, registryops, this.e());
        }
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        this.m = nbttagcompound.b("Health", (short)5);
        this.k = nbttagcompound.b("Age", (short)0);
        this.l = nbttagcompound.b("PickupDelay", (short)0);
        this.p = nbttagcompound.a("Owner", UUIDUtil.a).orElse(null);
        this.n = nbttagcompound.a("Thrower", UUIDUtil.a).orElse(null);
        this.o = null;
        RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
        this.a(nbttagcompound.a("Item", ItemStack.b, (DynamicOps<NBTBase>)registryops).orElse(ItemStack.l));
        if (this.e().f()) {
            this.discard(null);
        }
    }

    @Override
    public void a_(EntityHuman entityhuman) {
        if (!this.dV().C) {
            ItemStack itemstack = this.e();
            Item item = itemstack.h();
            int i2 = itemstack.M();
            int canHold = entityhuman.gj().canHold(itemstack);
            int remaining = i2 - canHold;
            if (this.l <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                itemstack.e(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.dV().getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                if (playerEvent.isCancelled()) {
                    itemstack.e(i2);
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)((Player)entityhuman.getBukkitEntity()), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.dV().getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    itemstack.e(i2);
                    return;
                }
                ItemStack current = this.e();
                if (!itemstack.equals(current)) {
                    itemstack = current;
                } else {
                    itemstack.e(canHold + remaining);
                }
                this.l = 0;
            } else if (this.l == 0) {
                this.l = -1;
            }
            if (this.l == 0 && (this.p == null || this.p.equals(entityhuman.cG())) && entityhuman.gj().g(itemstack)) {
                entityhuman.a((Entity)this, i2);
                if (itemstack.f()) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                    itemstack.e(i2);
                }
                entityhuman.a(StatisticList.e.b(item), i2);
                entityhuman.a(this);
            }
        }
    }

    @Override
    public IChatBaseComponent ah() {
        IChatBaseComponent ichatbasecomponent = this.aj();
        return ichatbasecomponent != null ? ichatbasecomponent : this.e().A();
    }

    @Override
    public boolean cB() {
        return false;
    }

    @Override
    @Nullable
    public Entity b(TeleportTransition teleporttransition) {
        Entity entity = super.b(teleporttransition);
        if (!this.dV().C && entity instanceof EntityItem) {
            EntityItem entityitem = (EntityItem)entity;
            entityitem.x();
        }
        return entity;
    }

    public ItemStack e() {
        return this.ar().a(c);
    }

    public void a(ItemStack itemstack) {
        this.ar().a(c, itemstack);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        super.a(datawatcherobject);
        if (c.equals(datawatcherobject)) {
            this.e().a((Entity)this);
        }
    }

    public void b(@Nullable UUID uuid) {
        this.p = uuid;
    }

    public void b(Entity entity) {
        this.n = entity.cG();
        this.o = entity;
    }

    public int f() {
        return this.k;
    }

    public void i() {
        this.l = 10;
    }

    public void l() {
        this.l = 0;
    }

    public void m() {
        this.l = Short.MAX_VALUE;
    }

    public void b(int i2) {
        this.l = i2;
    }

    public boolean n() {
        return this.l > 0;
    }

    public void r() {
        this.k = Short.MIN_VALUE;
    }

    public void s() {
        this.k = -6000;
    }

    public void t() {
        this.m();
        this.k = this.dV().spigotConfig.itemDespawnRate - 1;
    }

    public static float f(float f2, float f1) {
        return f2 / 20.0f + f1;
    }

    public EntityItem u() {
        return new EntityItem(this);
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.i;
    }

    @Override
    public float dM() {
        return 180.0f - EntityItem.f((float)this.f() + 0.5f, this.b) / ((float)Math.PI * 2) * 360.0f;
    }

    @Override
    public SlotAccess a_(int i2) {
        return i2 == 0 ? SlotAccess.a(this::e, this::a) : super.a_(i2);
    }
}

