/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSwell;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityCreeper
extends EntityMonster {
    private static final DataWatcherObject<Integer> a = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> b = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private static final boolean d = false;
    private static final boolean e = false;
    private static final short f = 30;
    private static final byte bI = 3;
    private int bJ;
    public int bK;
    public int bL = 30;
    public int bM = 3;
    private int bN;
    public Entity entityIgniter;

    public EntityCreeper(EntityTypes<? extends EntityCreeper> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
    }

    @Override
    protected void C() {
        this.bF.a(1, new PathfinderGoalFloat(this));
        this.bF.a(2, new PathfinderGoalSwell(this));
        this.bF.a(3, new PathfinderGoalAvoidTarget<EntityOcelot>(this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.bF.a(3, new PathfinderGoalAvoidTarget<EntityCat>(this, EntityCat.class, 6.0f, 1.0, 1.2));
        this.bF.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bF.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.bF.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bF.a(6, new PathfinderGoalRandomLookaround(this));
        this.bG.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bG.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gA().a(GenericAttributes.v, 0.25);
    }

    @Override
    public int cE() {
        return this.e() == null ? this.y(0.0f) : this.y(this.eG() - 1.0f);
    }

    @Override
    public boolean a(double d0, float f2, DamageSource damagesource) {
        boolean flag = super.a(d0, f2, damagesource);
        this.bK += (int)(d0 * 1.5);
        if (this.bK > this.bL - 5) {
            this.bK = this.bL - 5;
        }
        return flag;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, -1);
        datawatcher_a.a(b, false);
        datawatcher_a.a(c, false);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("powered", this.p());
        nbttagcompound.a("Fuse", (short)this.bL);
        nbttagcompound.a("ExplosionRadius", (byte)this.bM);
        nbttagcompound.a("ignited", this.gu());
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.al.a(b, nbttagcompound.b("powered", false));
        this.bL = nbttagcompound.b("Fuse", (short)30);
        this.bM = nbttagcompound.b("ExplosionRadius", (byte)3);
        if (nbttagcompound.b("ignited", false)) {
            this.gv();
        }
    }

    @Override
    public void g() {
        if (this.bJ()) {
            int i2;
            this.bJ = this.bK;
            if (this.gu()) {
                this.b(1);
            }
            if ((i2 = this.u()) > 0 && this.bK == 0) {
                this.a(SoundEffects.gH, 1.0f, 0.5f);
                ((Entity)this).a(GameEvent.I);
            }
            this.bK += i2;
            if (this.bK < 0) {
                this.bK = 0;
            }
            if (this.bK >= this.bL) {
                this.bK = this.bL;
                this.gy();
            }
        }
        super.g();
    }

    @Override
    public void g(@Nullable EntityLiving entityliving) {
        if (!(entityliving instanceof Goat)) {
            super.g(entityliving);
        }
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.gG;
    }

    @Override
    protected SoundEffect j_() {
        return SoundEffects.gF;
    }

    @Override
    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        EntityCreeper entitycreeper;
        super.a(worldserver, damagesource, flag);
        Entity entity = damagesource.d();
        if (entity != this && entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).gw()) {
            entitycreeper.gx();
            this.a(worldserver, Items.vz);
        }
    }

    @Override
    public boolean c(WorldServer worldserver, Entity entity) {
        return true;
    }

    public boolean p() {
        return this.al.a(b);
    }

    public float J(float f2) {
        return MathHelper.h(f2, this.bJ, this.bK) / (float)(this.bL - 2);
    }

    public int u() {
        return this.al.a(a);
    }

    public void b(int i2) {
        this.al.a(a, i2);
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        super.a(worldserver, entitylightning);
        if (CraftEventFactory.callCreeperPowerEvent(this, entitylightning, CreeperPowerEvent.PowerCause.LIGHTNING).isCancelled()) {
            return;
        }
        this.al.a(b, true);
    }

    public void setPowered(boolean powered) {
        this.al.a(b, powered);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(TagsItem.bx)) {
            SoundEffect soundeffect = itemstack.a(Items.vg) ? SoundEffects.jn : SoundEffects.jD;
            this.dV().a((Entity)entityhuman, this.dA(), this.dC(), this.dG(), soundeffect, this.dm(), 1.0f, this.ae.i() * 0.4f + 0.8f);
            if (!this.dV().C) {
                this.entityIgniter = entityhuman;
                this.gv();
                if (itemstack.p() == 0) {
                    itemstack.h(1);
                } else {
                    itemstack.a(1, (EntityLiving)entityhuman, EntityCreeper.d(enumhand));
                }
            }
            return EnumInteractionResult.a;
        }
        return super.b(entityhuman, enumhand);
    }

    public void gy() {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            float f2 = this.p() ? 2.0f : 1.0f;
            ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, (float)this.bM * f2, false);
            if (!event.isCancelled()) {
                this.bc = true;
                worldserver.a((Entity)this, Explosion.a(this.dV(), this).customCausingEntityDamager(this.entityIgniter), null, this.dA(), this.dC(), this.dG(), event.getRadius(), event.getFire(), World.a.c);
                this.gB();
                this.a(worldserver, Entity.RemovalReason.a);
                this.discard(EntityRemoveEvent.Cause.EXPLODE);
            } else {
                this.bK = 0;
            }
        }
    }

    private void gB() {
        Collection<MobEffect> collection = this.eD();
        if (!collection.isEmpty()) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.dV(), this.dA(), this.dC(), this.dG());
            entityareaeffectcloud.a(this);
            entityareaeffectcloud.a(2.5f);
            entityareaeffectcloud.c(-0.5f);
            entityareaeffectcloud.c(10);
            entityareaeffectcloud.a(300);
            entityareaeffectcloud.b(0.25f);
            entityareaeffectcloud.d(-entityareaeffectcloud.c() / (float)entityareaeffectcloud.h());
            for (MobEffect mobeffect : collection) {
                entityareaeffectcloud.a(new MobEffect(mobeffect));
            }
            this.dV().addFreshEntity(entityareaeffectcloud, CreatureSpawnEvent.SpawnReason.EXPLOSION);
        }
    }

    public boolean gu() {
        return this.al.a(c);
    }

    public void gv() {
        this.al.a(c, true);
    }

    public boolean gw() {
        return this.p() && this.bN < 1;
    }

    public void gx() {
        ++this.bN;
    }
}

