/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityEnderman
extends EntityMonster
implements IEntityAngerable {
    private static final MinecraftKey c = MinecraftKey.b("attacking");
    private static final AttributeModifier d = new AttributeModifier(c, 0.15f, AttributeModifier.Operation.a);
    private static final int e = 400;
    private static final int f = 600;
    private static final DataWatcherObject<Optional<IBlockData>> bI = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.j);
    private static final DataWatcherObject<Boolean> bJ = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bK = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private int bL = Integer.MIN_VALUE;
    private int bM;
    private static final UniformInt bN = TimeRange.a(20, 39);
    private int bO;
    @Nullable
    private UUID bP;

    public EntityEnderman(EntityTypes<? extends EntityEnderman> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.a(PathType.j, -1.0f);
    }

    @Override
    protected void C() {
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(1, new a(this));
        this.bF.a(2, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bF.a(7, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 0.0f));
        this.bF.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bF.a(8, new PathfinderGoalRandomLookaround(this));
        this.bF.a(10, new PathfinderGoalEndermanPlaceBlock(this));
        this.bF.a(11, new PathfinderGoalEndermanPickupBlock(this));
        this.bG.a(1, new PathfinderGoalPlayerWhoLookedAtTarget(this, this::a));
        this.bG.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bG.a(3, new PathfinderGoalNearestAttackableTarget<EntityEndermite>((EntityInsentient)this, EntityEndermite.class, true, false));
        this.bG.a(4, new PathfinderGoalUniversalAngerReset<EntityEnderman>(this, false));
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gA().a(GenericAttributes.s, 40.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.c, 7.0).a(GenericAttributes.m, 64.0).a(GenericAttributes.B, 1.0);
    }

    @Override
    public void g(@Nullable EntityLiving entityliving) {
        this.setTarget(entityliving, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    @Override
    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (!super.setTarget(entityliving, reason, fireEvent)) {
            return false;
        }
        entityliving = this.e();
        AttributeModifiable attributemodifiable = this.g(GenericAttributes.v);
        if (entityliving == null) {
            this.bM = 0;
            this.al.a(bJ, false);
            this.al.a(bK, false);
            attributemodifiable.c(c);
        } else {
            this.bM = this.af;
            this.al.a(bJ, true);
            if (!attributemodifiable.b(c)) {
                attributemodifiable.b(d);
            }
        }
        return true;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(bI, Optional.empty());
        datawatcher_a.a(bJ, false);
        datawatcher_a.a(bK, false);
    }

    @Override
    public void c() {
        this.a(bN.a(this.ae));
    }

    @Override
    public void a(int i2) {
        this.bO = i2;
    }

    @Override
    public int a() {
        return this.bO;
    }

    @Override
    public void a(@Nullable UUID uuid) {
        this.bP = uuid;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.bP;
    }

    public void p() {
        if (this.af >= this.bL + 400) {
            this.bL = this.af;
            if (!this.ba()) {
                this.dV().a(this.dA(), this.dE(), this.dG(), SoundEffects.iL, this.dm(), 2.5f, 1.0f, false);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (bJ.equals(datawatcherobject) && this.gw() && this.dV().C) {
            this.p();
        }
        super.a(datawatcherobject);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        IBlockData iblockdata = this.gu();
        if (iblockdata != null) {
            RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
            nbttagcompound.a("carriedBlockState", IBlockData.a, registryops, iblockdata);
        }
        this.a_(nbttagcompound);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
        this.c((IBlockData)nbttagcompound.a("carriedBlockState", IBlockData.a, (DynamicOps<NBTBase>)registryops).filter(iblockdata -> !iblockdata.l()).orElse(null));
        this.a(this.dV(), nbttagcompound);
    }

    boolean a(EntityHuman entityhuman) {
        return !EntityLiving.aH.test(entityhuman) ? false : this.a(entityhuman, 0.025, true, false, this.dE());
    }

    @Override
    public void d_() {
        if (this.dV().C) {
            for (int i2 = 0; i2 < 2; ++i2) {
                this.dV().a(Particles.af, this.d(0.5), this.dD() - 0.25, this.g(0.5), (this.ae.j() - 0.5) * 2.0, -this.ae.j(), (this.ae.j() - 0.5) * 2.0);
            }
        }
        this.bf = false;
        if (!this.dV().C) {
            this.a((WorldServer)this.dV(), true);
        }
        super.d_();
    }

    @Override
    public boolean fr() {
        return true;
    }

    @Override
    protected void a(WorldServer worldserver) {
        float f2;
        if (worldserver.V() && this.af >= this.bM + 600 && (f2 = this.bw()) > 0.5f && worldserver.h(this.dv()) && this.ae.i() * 30.0f < (f2 - 0.4f) * 2.0f) {
            this.g((EntityLiving)null);
            this.u();
        }
        super.a(worldserver);
    }

    public boolean u() {
        if (!this.dV().A_() && this.bJ()) {
            double d0 = this.dA() + (this.ae.j() - 0.5) * 64.0;
            double d1 = this.dC() + (double)(this.ae.a(64) - 32);
            double d2 = this.dG() + (this.ae.j() - 0.5) * 64.0;
            return this.q(d0, d1, d2);
        }
        return false;
    }

    public boolean b(Entity entity) {
        Vec3D vec3d = new Vec3D(this.dA() - entity.dA(), this.e(0.5) - entity.dE(), this.dG() - entity.dG());
        vec3d = vec3d.d();
        double d0 = 16.0;
        double d1 = this.dA() + (this.ae.j() - 0.5) * 8.0 - vec3d.d * 16.0;
        double d2 = this.dC() + (double)(this.ae.a(16) - 8) - vec3d.e * 16.0;
        double d3 = this.dG() + (this.ae.j() - 0.5) * 8.0 - vec3d.f * 16.0;
        return this.q(d1, d2, d3);
    }

    private boolean q(double d0, double d1, double d2) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(d0, d1, d2);
        while (blockposition_mutableblockposition.v() > this.dV().K_() && !this.dV().a_(blockposition_mutableblockposition).d()) {
            blockposition_mutableblockposition.c(EnumDirection.a);
        }
        IBlockData iblockdata = this.dV().a_(blockposition_mutableblockposition);
        boolean flag = iblockdata.d();
        boolean flag1 = iblockdata.y().a(TagsFluid.a);
        if (flag && !flag1) {
            Vec3D vec3d = this.dt();
            boolean flag2 = this.b(d0, d1, d2, true);
            if (flag2) {
                this.dV().a(GameEvent.R, vec3d, GameEvent.a.a(this));
                if (!this.ba()) {
                    this.dV().a((Entity)null, this.K, this.L, this.M, SoundEffects.iM, this.dm(), 1.0f, 1.0f);
                    this.a(SoundEffects.iM, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    @Override
    protected SoundEffect s() {
        return this.gv() ? SoundEffects.iK : SoundEffects.iH;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.iJ;
    }

    @Override
    protected SoundEffect j_() {
        return SoundEffects.iI;
    }

    @Override
    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        super.a(worldserver, damagesource, flag);
        IBlockData iblockdata = this.gu();
        if (iblockdata != null) {
            ItemStack itemstack = new ItemStack(Items.pX);
            EnchantmentManager.a(itemstack, worldserver.J_(), VanillaEnchantmentProviders.g, worldserver.d_(this.dv()), this.dY());
            LootParams.a lootparams_a = new LootParams.a((WorldServer)this.dV()).a(LootContextParameters.f, this.dt()).a(LootContextParameters.i, itemstack).b(LootContextParameters.a, this);
            for (ItemStack itemstack1 : iblockdata.a(lootparams_a)) {
                this.a(worldserver, itemstack1);
            }
        }
    }

    public void c(@Nullable IBlockData iblockdata) {
        this.al.a(bI, Optional.ofNullable(iblockdata));
    }

    @Nullable
    public IBlockData gu() {
        return this.al.a(bI).orElse(null);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        EntityPotion entitypotion1;
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        Entity entity = damagesource.c();
        EntityPotion entitypotion = entity instanceof EntityPotion ? (entitypotion1 = (EntityPotion)entity) : null;
        EntityPotion entitypotion2 = entitypotion;
        if (!damagesource.a(DamageTypeTags.j) && entitypotion2 == null) {
            boolean flag = super.a(worldserver, damagesource, f2);
            if (!(damagesource.d() instanceof EntityLiving) && this.ae.a(10) != 0) {
                this.u();
            }
            return flag;
        }
        boolean flag1 = entitypotion2 != null && this.a(worldserver, damagesource, entitypotion2, f2);
        for (int i2 = 0; i2 < 64; ++i2) {
            if (!this.u()) continue;
            return true;
        }
        return flag1;
    }

    private boolean a(WorldServer worldserver, DamageSource damagesource, EntityPotion entitypotion, float f2) {
        ItemStack itemstack = entitypotion.e();
        PotionContents potioncontents = itemstack.a(DataComponents.R, PotionContents.a);
        return potioncontents.a(Potions.a) ? super.a(worldserver, damagesource, f2) : false;
    }

    public boolean gv() {
        return this.al.a(bJ);
    }

    public boolean gw() {
        return this.al.a(bK);
    }

    public void gx() {
        this.al.a(bK, true);
    }

    @Override
    public boolean Y() {
        return super.Y() || this.gu() != null;
    }

    private static class a
    extends PathfinderGoal {
        private final EntityEnderman a;
        @Nullable
        private EntityLiving b;

        public a(EntityEnderman entityenderman) {
            this.a = entityenderman;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            this.b = this.a.e();
            EntityLiving entityliving = this.b;
            if (entityliving instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)entityliving;
                double d0 = this.b.g(this.a);
                return d0 > 256.0 ? false : this.a.a(entityhuman);
            }
            return false;
        }

        @Override
        public void d() {
            this.a.N().m();
        }

        @Override
        public void a() {
            this.a.I().a(this.b.dA(), this.b.dE(), this.b.dG());
        }
    }

    private static class PathfinderGoalEndermanPlaceBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPlaceBlock(EntityEnderman entityenderman) {
            this.a = entityenderman;
        }

        @Override
        public boolean b() {
            return this.a.gu() == null ? false : (!PathfinderGoalEndermanPlaceBlock.a(this.a).O().c(GameRules.d) ? false : this.a.dY().a(PathfinderGoalEndermanPlaceBlock.b(2000)) == 0);
        }

        @Override
        public void a() {
            RandomSource randomsource = this.a.dY();
            World world = this.a.dV();
            int i2 = MathHelper.a(this.a.dA() - 1.0 + randomsource.j() * 2.0);
            int j2 = MathHelper.a(this.a.dC() + randomsource.j() * 2.0);
            int k2 = MathHelper.a(this.a.dG() - 1.0 + randomsource.j() * 2.0);
            BlockPosition blockposition = new BlockPosition(i2, j2, k2);
            IBlockData iblockdata = world.a_(blockposition);
            BlockPosition blockposition1 = blockposition.e();
            IBlockData iblockdata1 = world.a_(blockposition1);
            IBlockData iblockdata2 = this.a.gu();
            if (iblockdata2 != null && this.a(world, blockposition, iblockdata2 = Block.b(iblockdata2, this.a.dV(), blockposition), iblockdata, iblockdata1, blockposition1) && CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition, iblockdata2)) {
                world.a(blockposition, iblockdata2, 3);
                world.a(GameEvent.i, blockposition, GameEvent.a.a(this.a, iblockdata2));
                this.a.c((IBlockData)null);
            }
        }

        private boolean a(World world, BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1, IBlockData iblockdata2, BlockPosition blockposition1) {
            return iblockdata1.l() && !iblockdata2.l() && !iblockdata2.a(Blocks.I) && iblockdata2.m(world, blockposition1) && iblockdata.a((IWorldReader)world, blockposition) && world.a_(this.a, AxisAlignedBB.a(Vec3D.a(blockposition))).isEmpty();
        }
    }

    private static class PathfinderGoalEndermanPickupBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPickupBlock(EntityEnderman entityenderman) {
            this.a = entityenderman;
        }

        @Override
        public boolean b() {
            return this.a.gu() != null ? false : (!PathfinderGoalEndermanPickupBlock.a(this.a).O().c(GameRules.d) ? false : this.a.dY().a(PathfinderGoalEndermanPickupBlock.b(20)) == 0);
        }

        @Override
        public void a() {
            RandomSource randomsource = this.a.dY();
            World world = this.a.dV();
            int i2 = MathHelper.a(this.a.dA() - 2.0 + randomsource.j() * 4.0);
            int j2 = MathHelper.a(this.a.dC() + randomsource.j() * 3.0);
            int k2 = MathHelper.a(this.a.dG() - 2.0 + randomsource.j() * 4.0);
            BlockPosition blockposition = new BlockPosition(i2, j2, k2);
            IBlockData iblockdata = world.a_(blockposition);
            Vec3D vec3d = new Vec3D((double)this.a.dz() + 0.5, (double)j2 + 0.5, (double)this.a.dF() + 0.5);
            Vec3D vec3d1 = new Vec3D((double)i2 + 0.5, (double)j2 + 0.5, (double)k2 + 0.5);
            MovingObjectPositionBlock movingobjectpositionblock = world.a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.a));
            boolean flag = movingobjectpositionblock.b().equals(blockposition);
            if (iblockdata.a(TagsBlock.ao) && flag && CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition, Blocks.a.m())) {
                world.a(blockposition, false);
                world.a(GameEvent.f, blockposition, GameEvent.a.a(this.a, iblockdata));
                this.a.c(iblockdata.b().m());
            }
        }
    }

    private static class PathfinderGoalPlayerWhoLookedAtTarget
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        private final EntityEnderman i;
        @Nullable
        private EntityHuman j;
        private int k;
        private int l;
        private final PathfinderTargetCondition m;
        private final PathfinderTargetCondition n = PathfinderTargetCondition.a().d();
        private final PathfinderTargetCondition.a o;

        public PathfinderGoalPlayerWhoLookedAtTarget(EntityEnderman entityenderman, @Nullable PathfinderTargetCondition.a pathfindertargetcondition_a) {
            super(entityenderman, EntityHuman.class, 10, false, false, pathfindertargetcondition_a);
            this.i = entityenderman;
            this.o = (entityliving, worldserver) -> (entityenderman.a((EntityHuman)entityliving) || entityenderman.a(entityliving, worldserver)) && !entityenderman.A(entityliving);
            this.m = PathfinderTargetCondition.a().a(this.l()).a(this.o);
        }

        @Override
        public boolean b() {
            this.j = PathfinderGoalPlayerWhoLookedAtTarget.a(this.i).a(this.m.a(this.l()), this.i);
            return this.j != null;
        }

        @Override
        public void d() {
            this.k = this.a(5);
            this.l = 0;
            this.i.gx();
        }

        @Override
        public void e() {
            this.j = null;
            super.e();
        }

        @Override
        public boolean c() {
            if (this.j != null) {
                if (!this.o.test(this.j, PathfinderGoalPlayerWhoLookedAtTarget.a(this.i))) {
                    return false;
                }
                this.i.a((Entity)this.j, 10.0f, 10.0f);
                return true;
            }
            if (this.c != null) {
                if (this.i.A(this.c)) {
                    return false;
                }
                if (this.n.a(PathfinderGoalPlayerWhoLookedAtTarget.a(this.i), this.i, this.c)) {
                    return true;
                }
            }
            return super.c();
        }

        @Override
        public void a() {
            if (this.i.e() == null) {
                super.a((EntityLiving)null);
            }
            if (this.j != null) {
                if (--this.k <= 0) {
                    this.c = this.j;
                    this.j = null;
                    super.d();
                }
            } else {
                if (this.c != null && !this.i.bY()) {
                    if (this.i.a((EntityHuman)this.c)) {
                        if (this.c.g(this.i) < 16.0) {
                            this.i.u();
                        }
                        this.l = 0;
                    } else if (this.c.g(this.i) > 256.0 && this.l++ >= this.a(30) && this.i.b((Entity)this.c)) {
                        this.l = 0;
                    }
                }
                super.a();
            }
        }
    }
}

