/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.sheep.EntitySheep;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class EntityEvoker
extends EntityIllagerWizard {
    @Nullable
    private EntitySheep a;

    public EntityEvoker(EntityTypes<? extends EntityEvoker> entitytypes, World world) {
        super((EntityTypes<? extends EntityIllagerWizard>)entitytypes, world);
        this.bA = 10;
    }

    @Override
    protected void C() {
        super.C();
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(1, new b());
        this.bF.a(2, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 0.6, 1.0));
        this.bF.a(3, new PathfinderGoalAvoidTarget<Creaking>(this, Creaking.class, 8.0f, 0.6, 1.0));
        this.bF.a(4, new c());
        this.bF.a(5, new a());
        this.bF.a(6, new d());
        this.bF.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.bF.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.bF.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bG.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bG.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true).c(300));
        this.bG.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false).c(300));
        this.bG.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, false));
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gA().a(GenericAttributes.v, 0.5).a(GenericAttributes.m, 12.0).a(GenericAttributes.s, 24.0);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
    }

    @Override
    public SoundEffect af_() {
        return SoundEffects.iX;
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
    }

    @Override
    protected boolean t(Entity entity) {
        EntityVex entityvex;
        if (entity == this) {
            return true;
        }
        if (super.t(entity)) {
            return true;
        }
        if (entity instanceof EntityVex && (entityvex = (EntityVex)entity).u() != null) {
            return this.t(entityvex.u());
        }
        return false;
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.iV;
    }

    @Override
    protected SoundEffect j_() {
        return SoundEffects.iY;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.ja;
    }

    void a(@Nullable EntitySheep entitysheep) {
        this.a = entitysheep;
    }

    @Nullable
    EntitySheep gP() {
        return this.a;
    }

    @Override
    protected SoundEffect gu() {
        return SoundEffects.iW;
    }

    @Override
    public void a(WorldServer worldserver, int i2, boolean flag) {
    }

    private class b
    extends EntityIllagerWizard.b {
        b() {
            super(EntityEvoker.this);
        }

        @Override
        public void a() {
            if (EntityEvoker.this.e() != null) {
                EntityEvoker.this.I().a(EntityEvoker.this.e(), (float)EntityEvoker.this.ae(), (float)EntityEvoker.this.ac());
            } else if (EntityEvoker.this.gP() != null) {
                EntityEvoker.this.I().a(EntityEvoker.this.gP(), (float)EntityEvoker.this.ae(), (float)EntityEvoker.this.ac());
            }
        }
    }

    private class c
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition e;

        c() {
            super(EntityEvoker.this);
            this.e = PathfinderTargetCondition.b().a(16.0).d().e();
        }

        @Override
        public boolean b() {
            if (!super.b()) {
                return false;
            }
            int i2 = net.minecraft.world.entity.monster.EntityEvoker$c.a(EntityEvoker.this.dV()).a(EntityVex.class, this.e, EntityEvoker.this, EntityEvoker.this.cR().g(16.0)).size();
            return EntityEvoker.this.ae.a(8) + 1 > i2;
        }

        @Override
        protected int h() {
            return 100;
        }

        @Override
        protected int i() {
            return 340;
        }

        @Override
        protected void k() {
            WorldServer worldserver = (WorldServer)EntityEvoker.this.dV();
            ScoreboardTeam scoreboardteam = EntityEvoker.this.cq();
            for (int i2 = 0; i2 < 3; ++i2) {
                BlockPosition blockposition = EntityEvoker.this.dv().b(-2 + EntityEvoker.this.ae.a(5), 1, -2 + EntityEvoker.this.ae.a(5));
                EntityVex entityvex = EntityTypes.bD.a(EntityEvoker.this.dV(), EntitySpawnReason.f);
                if (entityvex == null) continue;
                entityvex.a(blockposition, 0.0f, 0.0f);
                entityvex.a((WorldAccess)worldserver, EntityEvoker.this.dV().d_(blockposition), EntitySpawnReason.f, (GroupDataEntity)null);
                entityvex.a(EntityEvoker.this);
                entityvex.h(blockposition);
                entityvex.b(20 * (30 + EntityEvoker.this.ae.a(90)));
                if (scoreboardteam != null) {
                    worldserver.g().a(entityvex.cI(), scoreboardteam);
                }
                worldserver.addFreshEntityWithPassengers(entityvex, CreatureSpawnEvent.SpawnReason.SPELL);
                worldserver.a(GameEvent.t, blockposition, GameEvent.a.a(EntityEvoker.this));
            }
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.jc;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.b;
        }
    }

    private class a
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        a() {
            super(EntityEvoker.this);
        }

        @Override
        protected int h() {
            return 40;
        }

        @Override
        protected int i() {
            return 100;
        }

        @Override
        protected void k() {
            EntityLiving entityliving = EntityEvoker.this.e();
            double d0 = Math.min(entityliving.dC(), EntityEvoker.this.dC());
            double d1 = Math.max(entityliving.dC(), EntityEvoker.this.dC()) + 1.0;
            float f2 = (float)MathHelper.d(entityliving.dG() - EntityEvoker.this.dG(), entityliving.dA() - EntityEvoker.this.dA());
            if (EntityEvoker.this.g((Entity)entityliving) < 9.0) {
                for (int i2 = 0; i2 < 5; ++i2) {
                    float f1 = f2 + (float)i2 * (float)Math.PI * 0.4f;
                    this.a(EntityEvoker.this.dA() + (double)MathHelper.b(f1) * 1.5, EntityEvoker.this.dG() + (double)MathHelper.a(f1) * 1.5, d0, d1, f1, 0);
                }
                for (int j2 = 0; j2 < 8; ++j2) {
                    float f22 = f2 + (float)j2 * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.a(EntityEvoker.this.dA() + (double)MathHelper.b(f22) * 2.5, EntityEvoker.this.dG() + (double)MathHelper.a(f22) * 2.5, d0, d1, f22, 3);
                }
            } else {
                for (int k2 = 0; k2 < 16; ++k2) {
                    double d2 = 1.25 * (double)(k2 + 1);
                    int l2 = 1 * k2;
                    this.a(EntityEvoker.this.dA() + (double)MathHelper.b(f2) * d2, EntityEvoker.this.dG() + (double)MathHelper.a(f2) * d2, d0, d1, f2, l2);
                }
            }
        }

        private void a(double d0, double d1, double d2, double d3, float f2, int i2) {
            BlockPosition blockposition = BlockPosition.a(d0, d3, d1);
            boolean flag = false;
            double d4 = 0.0;
            do {
                IBlockData iblockdata1;
                VoxelShape voxelshape;
                BlockPosition blockposition1 = blockposition.e();
                IBlockData iblockdata = EntityEvoker.this.dV().a_(blockposition1);
                if (!iblockdata.c((IBlockAccess)EntityEvoker.this.dV(), blockposition1, EnumDirection.b)) continue;
                if (!EntityEvoker.this.dV().v(blockposition) && !(voxelshape = (iblockdata1 = EntityEvoker.this.dV().a_(blockposition)).g(EntityEvoker.this.dV(), blockposition)).c()) {
                    d4 = voxelshape.c(EnumDirection.EnumAxis.b);
                }
                flag = true;
                break;
            } while ((blockposition = blockposition.e()).v() >= MathHelper.a(d2) - 1);
            if (flag) {
                EntityEvoker.this.dV().b(new EntityEvokerFangs(EntityEvoker.this.dV(), d0, (double)blockposition.v() + d4, d1, f2, i2, EntityEvoker.this));
                EntityEvoker.this.dV().a(GameEvent.t, new Vec3D(d0, (double)blockposition.v() + d4, d1), GameEvent.a.a(EntityEvoker.this));
            }
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.jb;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.c;
        }
    }

    public class d
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition e;

        public d() {
            super(EntityEvoker.this);
            this.e = PathfinderTargetCondition.b().a(16.0).a((EntityLiving entityliving, WorldServer worldserver) -> ((EntitySheep)entityliving).p() == EnumColor.l);
        }

        @Override
        public boolean b() {
            if (EntityEvoker.this.e() != null) {
                return false;
            }
            if (EntityEvoker.this.gE()) {
                return false;
            }
            if (EntityEvoker.this.af < this.c) {
                return false;
            }
            WorldServer worldserver = net.minecraft.world.entity.monster.EntityEvoker$d.a(EntityEvoker.this.dV());
            if (!worldserver.O().c(GameRules.d)) {
                return false;
            }
            List<EntitySheep> list = worldserver.a(EntitySheep.class, this.e, EntityEvoker.this, EntityEvoker.this.cR().c(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            EntityEvoker.this.a(list.get(EntityEvoker.this.ae.a(list.size())));
            return true;
        }

        @Override
        public boolean c() {
            return EntityEvoker.this.gP() != null && this.b > 0;
        }

        @Override
        public void e() {
            super.e();
            EntityEvoker.this.a((EntitySheep)null);
        }

        @Override
        protected void k() {
            EntitySheep entitysheep = EntityEvoker.this.gP();
            if (entitysheep != null && entitysheep.bJ()) {
                entitysheep.b(EnumColor.o);
            }
        }

        @Override
        protected int n() {
            return 40;
        }

        @Override
        protected int h() {
            return 60;
        }

        @Override
        protected int i() {
            return 140;
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.jd;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.d;
        }
    }
}

