/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityFlying;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityGhast
extends EntityFlying
implements IMonster {
    private static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityGhast.class, DataWatcherRegistry.k);
    private static final byte b = 1;
    private int c = 1;

    public EntityGhast(EntityTypes<? extends EntityGhast> entitytypes, World world) {
        super((EntityTypes<? extends EntityFlying>)entitytypes, world);
        this.bA = 5;
        this.bC = new ControllerGhast(this);
    }

    @Override
    protected void C() {
        this.bF.a(5, new PathfinderGoalGhastIdleMove(this));
        this.bF.a(7, new PathfinderGoalGhastMoveTowardsTarget(this));
        this.bF.a(7, new PathfinderGoalGhastAttackTarget(this));
        this.bG.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (entityliving, worldserver) -> Math.abs(entityliving.dC() - this.dC()) <= 4.0));
    }

    public boolean m() {
        return this.al.a(a);
    }

    public void w(boolean flag) {
        this.al.a(a, flag);
    }

    public int p() {
        return this.c;
    }

    @Override
    protected boolean Z() {
        return true;
    }

    private static boolean i(DamageSource damagesource) {
        return damagesource.c() instanceof EntityLargeFireball && damagesource.d() instanceof EntityHuman;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return this.cC() && !damagesource.a(DamageTypeTags.d) || !EntityGhast.i(damagesource) && super.a(worldserver, damagesource);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (EntityGhast.i(damagesource)) {
            super.a(worldserver, damagesource, 1000.0f);
            return true;
        }
        return this.a(worldserver, damagesource) ? false : super.a(worldserver, damagesource, f2);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, false);
    }

    public static AttributeProvider.Builder u() {
        return EntityInsentient.D().a(GenericAttributes.s, 10.0).a(GenericAttributes.m, 100.0);
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.kO;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.kQ;
    }

    @Override
    protected SoundEffect j_() {
        return SoundEffects.kP;
    }

    @Override
    protected float fe() {
        return 5.0f;
    }

    public static boolean b(EntityTypes<EntityGhast> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.an() != EnumDifficulty.a && randomsource.a(20) == 0 && EntityGhast.a(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource);
    }

    @Override
    public int fX() {
        return 1;
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("ExplosionPower", (byte)this.c);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.c = nbttagcompound.b("ExplosionPower", (byte)1);
    }

    private static class ControllerGhast
    extends ControllerMove {
        private final EntityGhast l;
        private int m;

        public ControllerGhast(EntityGhast entityghast) {
            super(entityghast);
            this.l = entityghast;
        }

        @Override
        public void a() {
            if (this.k == ControllerMove.Operation.b && this.m-- <= 0) {
                this.m += this.l.dY().a(5) + 2;
                Vec3D vec3d = new Vec3D(this.e - this.l.dA(), this.f - this.l.dC(), this.g - this.l.dG());
                double d0 = vec3d.g();
                if (this.a(vec3d = vec3d.d(), MathHelper.c(d0))) {
                    this.l.i(this.l.dy().e(vec3d.c(0.1)));
                } else {
                    this.k = ControllerMove.Operation.a;
                }
            }
        }

        private boolean a(Vec3D vec3d, int i2) {
            AxisAlignedBB axisalignedbb = this.l.cR();
            for (int j2 = 1; j2 < i2; ++j2) {
                axisalignedbb = axisalignedbb.c(vec3d);
                if (this.l.dV().a((Entity)this.l, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }

    private static class PathfinderGoalGhastIdleMove
    extends PathfinderGoal {
        private final EntityGhast a;

        public PathfinderGoalGhastIdleMove(EntityGhast entityghast) {
            this.a = entityghast;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            double d2;
            double d1;
            ControllerMove controllermove = this.a.K();
            if (!controllermove.b()) {
                return true;
            }
            double d0 = controllermove.d() - this.a.dA();
            double d3 = d0 * d0 + (d1 = controllermove.e() - this.a.dC()) * d1 + (d2 = controllermove.f() - this.a.dG()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public void d() {
            RandomSource randomsource = this.a.dY();
            double d0 = this.a.dA() + (double)((randomsource.i() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.a.dC() + (double)((randomsource.i() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.a.dG() + (double)((randomsource.i() * 2.0f - 1.0f) * 16.0f);
            this.a.K().a(d0, d1, d2, 1.0);
        }
    }

    private static class PathfinderGoalGhastMoveTowardsTarget
    extends PathfinderGoal {
        private final EntityGhast a;

        public PathfinderGoalGhastMoveTowardsTarget(EntityGhast entityghast) {
            this.a = entityghast;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public boolean W_() {
            return true;
        }

        @Override
        public void a() {
            if (this.a.e() == null) {
                Vec3D vec3d = this.a.dy();
                this.a.w(-((float)MathHelper.d(vec3d.d, vec3d.f)) * 57.295776f);
                this.a.aV = this.a.dL();
            } else {
                EntityLiving entityliving = this.a.e();
                double d0 = 64.0;
                if (entityliving.g(this.a) < 4096.0) {
                    double d1 = entityliving.dA() - this.a.dA();
                    double d2 = entityliving.dG() - this.a.dG();
                    this.a.w(-((float)MathHelper.d(d1, d2)) * 57.295776f);
                    this.a.aV = this.a.dL();
                }
            }
        }
    }

    private static class PathfinderGoalGhastAttackTarget
    extends PathfinderGoal {
        private final EntityGhast b;
        public int a;

        public PathfinderGoalGhastAttackTarget(EntityGhast entityghast) {
            this.b = entityghast;
        }

        @Override
        public boolean b() {
            return this.b.e() != null;
        }

        @Override
        public void d() {
            this.a = 0;
        }

        @Override
        public void e() {
            this.b.w(false);
        }

        @Override
        public boolean W_() {
            return true;
        }

        @Override
        public void a() {
            EntityLiving entityliving = this.b.e();
            if (entityliving != null) {
                double d0 = 64.0;
                if (entityliving.g(this.b) < 4096.0 && this.b.E(entityliving)) {
                    World world = this.b.dV();
                    ++this.a;
                    if (this.a == 10 && !this.b.ba()) {
                        world.a((Entity)null, 1015, this.b.dv(), 0);
                    }
                    if (this.a == 20) {
                        double d1 = 4.0;
                        Vec3D vec3d = this.b.h(1.0f);
                        double d2 = entityliving.dA() - (this.b.dA() + vec3d.d * 4.0);
                        double d3 = entityliving.e(0.5) - (0.5 + this.b.e(0.5));
                        double d4 = entityliving.dG() - (this.b.dG() + vec3d.f * 4.0);
                        Vec3D vec3d1 = new Vec3D(d2, d3, d4);
                        if (!this.b.ba()) {
                            world.a((Entity)null, 1016, this.b.dv(), 0);
                        }
                        EntityLargeFireball entitylargefireball = new EntityLargeFireball(world, (EntityLiving)this.b, vec3d1.d(), this.b.p());
                        entitylargefireball.e = this.b.p();
                        entitylargefireball.bukkitYield = entitylargefireball.e;
                        entitylargefireball.a_(this.b.dA() + vec3d.d * 4.0, this.b.e(0.5) + 0.5, entitylargefireball.dG() + vec3d.f * 4.0);
                        world.b(entitylargefireball);
                        this.a = -40;
                    }
                } else if (this.a > 0) {
                    --this.a;
                }
                this.b.w(this.a > 10);
            }
        }
    }
}

