/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.ConversionType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.SlimeSplitEvent;

public class EntitySlime
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Integer> bH = DataWatcher.a(EntitySlime.class, DataWatcherRegistry.b);
    public static final int a = 1;
    public static final int b = 127;
    public static final int c = 4;
    private static final boolean bI = false;
    public float d;
    public float e;
    public float f;
    private boolean bJ = false;

    public EntitySlime(EntityTypes<? extends EntitySlime> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)entitytypes, world);
        this.cN();
        this.bC = new ControllerMoveSlime(this);
    }

    @Override
    protected void C() {
        this.bF.a(1, new PathfinderGoalSlimeRandomJump(this));
        this.bF.a(2, new PathfinderGoalSlimeNearestPlayer(this));
        this.bF.a(3, new PathfinderGoalSlimeRandomDirection(this));
        this.bF.a(5, new PathfinderGoalSlimeIdle(this));
        this.bG.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (entityliving, worldserver) -> Math.abs(entityliving.dC() - this.dC()) <= 4.0));
        this.bG.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.f;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(bH, 1);
    }

    @VisibleForTesting
    public void a(int i2, boolean flag) {
        int j2 = MathHelper.a(i2, 1, 127);
        this.al.a(bH, j2);
        this.av();
        this.h_();
        this.g(GenericAttributes.s).a(j2 * j2);
        this.g(GenericAttributes.v).a(0.2f + 0.1f * (float)j2);
        this.g(GenericAttributes.c).a(j2);
        if (flag) {
            this.d(this.eU());
        }
        this.bA = j2;
    }

    public int gv() {
        return this.al.a(bH);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("Size", this.gv() - 1);
        nbttagcompound.a("wasOnGround", this.bJ);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        this.a(nbttagcompound.b("Size", 0) + 1, false);
        super.a(nbttagcompound);
        this.bJ = nbttagcompound.b("wasOnGround", false);
    }

    public boolean gw() {
        return this.gv() <= 1;
    }

    protected ParticleParam p() {
        return Particles.X;
    }

    @Override
    protected boolean Z() {
        return this.gv() > 0;
    }

    @Override
    public void g() {
        this.f = this.e;
        this.e += (this.d - this.e) * 0.5f;
        super.g();
        if (this.aH() && !this.bJ) {
            float f2 = this.a(this.at()).a() * 2.0f;
            float f1 = f2 / 2.0f;
            int i2 = 0;
            while ((float)i2 < f2 * 16.0f) {
                float f22 = this.ae.i() * ((float)Math.PI * 2);
                float f3 = this.ae.i() * 0.5f + 0.5f;
                float f4 = MathHelper.a(f22) * f1 * f3;
                float f5 = MathHelper.b(f22) * f1 * f3;
                this.dV().a(this.p(), this.dA() + (double)f4, this.dC(), this.dG() + (double)f5, 0.0, 0.0, 0.0);
                ++i2;
            }
            this.a(this.gt(), this.fe(), ((this.ae.i() - this.ae.i()) * 0.2f + 1.0f) / 0.8f);
            this.d = -0.5f;
        } else if (!this.aH() && this.bJ) {
            this.d = 1.0f;
        }
        this.bJ = this.aH();
        this.gq();
    }

    protected void gq() {
        this.d *= 0.6f;
    }

    protected int u() {
        return this.ae.a(20) + 10;
    }

    @Override
    public void h_() {
        double d0 = this.dA();
        double d1 = this.dC();
        double d2 = this.dG();
        super.h_();
        this.a_(d0, d1, d2);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (bH.equals(datawatcherobject)) {
            this.h_();
            this.w(this.aX);
            this.aV = this.aX;
            if (this.bi() && this.ae.a(20) == 0) {
                this.bq();
            }
        }
        super.a(datawatcherobject);
    }

    public EntityTypes<? extends EntitySlime> an() {
        return super.an();
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        int i2 = this.gv();
        if (!this.dV().C && i2 > 1 && this.eH()) {
            float f2 = this.a(this.at()).a();
            float f1 = f2 / 2.0f;
            int j2 = i2 / 2;
            int k2 = 2 + this.ae.a(3);
            ScoreboardTeam scoreboardteam = this.cq();
            SlimeSplitEvent event = new SlimeSplitEvent((Slime)this.getBukkitEntity(), k2);
            this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || event.getCount() <= 0) {
                super.remove(entity_removalreason, cause);
                return;
            }
            k2 = event.getCount();
            ArrayList<EntityLiving> slimes = new ArrayList<EntityLiving>(j2);
            for (int l2 = 0; l2 < k2; ++l2) {
                float f22 = ((float)(l2 % 2) - 0.5f) * f1;
                float f3 = ((float)(l2 / 2) - 0.5f) * f1;
                EntitySlime converted = this.convertTo(this.an(), new ConversionParams(ConversionType.b, false, false, scoreboardteam), EntitySpawnReason.k, entityslime -> {
                    entityslime.a(j2, true);
                    entityslime.b(this.dA() + (double)f22, this.dC() + 0.5, this.dG() + (double)f3, this.ae.i() * 360.0f, 0.0f);
                }, null, null);
                if (converted == null) continue;
                slimes.add(converted);
            }
            if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, slimes, EntityTransformEvent.TransformReason.SPLIT).isCancelled()) {
                super.remove(entity_removalreason, cause);
                return;
            }
            for (EntityLiving living : slimes) {
                this.dV().addFreshEntity(living, CreatureSpawnEvent.SpawnReason.SLIME_SPLIT);
            }
        }
        super.remove(entity_removalreason, cause);
    }

    @Override
    public void h(Entity entity) {
        super.h(entity);
        if (entity instanceof EntityIronGolem && this.gr()) {
            this.i((EntityLiving)entity);
        }
    }

    @Override
    public void a_(EntityHuman entityhuman) {
        if (this.gr()) {
            this.i(entityhuman);
        }
    }

    protected void i(EntityLiving entityliving) {
        World world = this.dV();
        if (world instanceof WorldServer) {
            DamageSource damagesource;
            WorldServer worldserver = (WorldServer)world;
            if (this.bJ() && this.h(entityliving) && this.E(entityliving) && entityliving.a(worldserver, damagesource = this.dW().b(this), this.gs())) {
                this.a(SoundEffects.yf, 1.0f, (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
                EnchantmentManager.a(worldserver, (Entity)entityliving, damagesource);
            }
        }
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize entitysize, float f2) {
        return new Vec3D(0.0, (double)entitysize.b() - 0.015625 * (double)this.gv() * (double)f2, 0.0);
    }

    protected boolean gr() {
        return !this.gw() && this.dj();
    }

    protected float gs() {
        return (float)this.h(GenericAttributes.c);
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return this.gw() ? SoundEffects.zk : SoundEffects.yh;
    }

    @Override
    protected SoundEffect j_() {
        return this.gw() ? SoundEffects.zj : SoundEffects.yg;
    }

    protected SoundEffect gt() {
        return this.gw() ? SoundEffects.zm : SoundEffects.yj;
    }

    public static boolean c(EntityTypes<EntitySlime> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        if (generatoraccess.an() != EnumDifficulty.a) {
            boolean flag;
            if (EntitySpawnReason.a(entityspawnreason)) {
                return EntitySlime.a(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource);
            }
            if (generatoraccess.u(blockposition).a(BiomeTags.as) && blockposition.v() > 50 && blockposition.v() < 70 && randomsource.i() < 0.5f && randomsource.i() < generatoraccess.as() && generatoraccess.B(blockposition) <= randomsource.a(8)) {
                return EntitySlime.a(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource);
            }
            if (!(generatoraccess instanceof GeneratorAccessSeed)) {
                return false;
            }
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(blockposition);
            boolean bl = flag = SeededRandom.a(chunkcoordintpair.h, chunkcoordintpair.i, ((GeneratorAccessSeed)generatoraccess).E(), generatoraccess.getMinecraftWorld().spigotConfig.slimeSeed).a(10) == 0;
            if (randomsource.a(10) == 0 && flag && blockposition.v() < 40) {
                return EntitySlime.a(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource);
            }
        }
        return false;
    }

    @Override
    protected float fe() {
        return 0.4f * (float)this.gv();
    }

    @Override
    public int ac() {
        return 0;
    }

    protected boolean gx() {
        return this.gv() > 0;
    }

    @Override
    public void r() {
        Vec3D vec3d = this.dy();
        this.n(vec3d.d, this.fh(), vec3d.f);
        this.ar = true;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.G_();
        int i2 = randomsource.a(3);
        if (i2 < 2 && randomsource.i() < 0.5f * difficultydamagescaler.d()) {
            ++i2;
        }
        int j2 = 1 << i2;
        this.a(j2, true);
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    float m() {
        float f2 = this.gw() ? 1.4f : 0.8f;
        return ((this.ae.i() - this.ae.i()) * 0.2f + 1.0f) * f2;
    }

    protected SoundEffect gu() {
        return this.gw() ? SoundEffects.zl : SoundEffects.yi;
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return super.e(entitypose).a(this.gv());
    }

    private static class ControllerMoveSlime
    extends ControllerMove {
        private float l;
        private int m;
        private final EntitySlime n;
        private boolean o;

        public ControllerMoveSlime(EntitySlime entityslime) {
            super(entityslime);
            this.n = entityslime;
            this.l = 180.0f * entityslime.dL() / (float)Math.PI;
        }

        public void a(float f2, boolean flag) {
            this.l = f2;
            this.o = flag;
        }

        public void a(double d0) {
            this.h = d0;
            this.k = ControllerMove.Operation.b;
        }

        @Override
        public void a() {
            this.d.w(this.b(this.d.dL(), this.l, 90.0f));
            this.d.aX = this.d.dL();
            this.d.aV = this.d.dL();
            if (this.k != ControllerMove.Operation.b) {
                this.d.G(0.0f);
            } else {
                this.k = ControllerMove.Operation.a;
                if (this.d.aH()) {
                    this.d.B((float)(this.h * this.d.h(GenericAttributes.v)));
                    if (this.m-- <= 0) {
                        this.m = this.n.u();
                        if (this.o) {
                            this.m /= 3;
                        }
                        this.n.M().a();
                        if (this.n.gx()) {
                            this.n.a(this.n.gu(), this.n.fe(), this.n.m());
                        }
                    } else {
                        this.n.bg = 0.0f;
                        this.n.bi = 0.0f;
                        this.d.B(0.0f);
                    }
                } else {
                    this.d.B((float)(this.h * this.d.h(GenericAttributes.v)));
                }
            }
        }
    }

    private static class PathfinderGoalSlimeRandomJump
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeRandomJump(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
            entityslime.N().a(true);
        }

        @Override
        public boolean b() {
            return (this.a.bi() || this.a.bv()) && this.a.K() instanceof ControllerMoveSlime;
        }

        @Override
        public boolean W_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            if (this.a.dY().i() < 0.8f) {
                this.a.M().a();
            }
            if ((controllermove = this.a.K()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.2);
            }
        }
    }

    private static class PathfinderGoalSlimeNearestPlayer
    extends PathfinderGoal {
        private final EntitySlime a;
        private int b;

        public PathfinderGoalSlimeNearestPlayer(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = this.a.e();
            return entityliving == null ? false : (!this.a.c(entityliving) ? false : this.a.K() instanceof ControllerMoveSlime);
        }

        @Override
        public void d() {
            this.b = PathfinderGoalSlimeNearestPlayer.b(300);
            super.d();
        }

        @Override
        public boolean c() {
            EntityLiving entityliving = this.a.e();
            return entityliving == null ? false : (!this.a.c(entityliving) ? false : --this.b > 0);
        }

        @Override
        public boolean W_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            EntityLiving entityliving = this.a.e();
            if (entityliving != null) {
                this.a.a((Entity)entityliving, 10.0f, 10.0f);
            }
            if ((controllermove = this.a.K()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.a.dL(), this.a.gr());
            }
        }
    }

    private static class PathfinderGoalSlimeRandomDirection
    extends PathfinderGoal {
        private final EntitySlime a;
        private float b;
        private int c;

        public PathfinderGoalSlimeRandomDirection(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return this.a.e() == null && (this.a.aH() || this.a.bi() || this.a.bv() || this.a.b(MobEffects.y)) && this.a.K() instanceof ControllerMoveSlime;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            if (--this.c <= 0) {
                this.c = this.a(40 + this.a.dY().a(60));
                this.b = this.a.dY().a(360);
            }
            if ((controllermove = this.a.K()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.b, false);
            }
        }
    }

    private static class PathfinderGoalSlimeIdle
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeIdle(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return !this.a.bY();
        }

        @Override
        public void a() {
            ControllerMove controllermove = this.a.K();
            if (controllermove instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.0);
            }
        }
    }
}

