/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;

public class EntityStrider
extends EntityAnimal
implements ISteerable {
    private static final MinecraftKey bI = MinecraftKey.b("suffocating");
    private static final AttributeModifier bJ = new AttributeModifier(bI, -0.34f, AttributeModifier.Operation.b);
    private static final float bK = 0.35f;
    private static final float bM = 0.55f;
    private static final DataWatcherObject<Integer> bN = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> bO = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.k);
    public final SaddleStorage bP;
    @Nullable
    private PathfinderGoalTempt bQ;

    public EntityStrider(EntityTypes<? extends EntityStrider> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.bP = new SaddleStorage(this.al, bN);
        this.I = true;
        this.a(PathType.j, -1.0f);
        this.a(PathType.i, 0.0f);
        this.a(PathType.n, 0.0f);
        this.a(PathType.o, 0.0f);
    }

    public static boolean c(EntityTypes<EntityStrider> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.k();
        do {
            blockposition_mutableblockposition.c(EnumDirection.b);
        } while (generatoraccess.b_(blockposition_mutableblockposition).a(TagsFluid.b));
        return generatoraccess.a_(blockposition_mutableblockposition).l();
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (bN.equals(datawatcherobject) && this.dV().C) {
            this.bP.a();
        }
        super.a(datawatcherobject);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(bN, 0);
        datawatcher_a.a(bO, false);
    }

    @Override
    public boolean e(EnumItemSlot enumitemslot) {
        return enumitemslot != EnumItemSlot.h ? super.e(enumitemslot) : this.bJ() && !this.e_();
    }

    @Override
    protected boolean f(EnumItemSlot enumitemslot) {
        return enumitemslot == EnumItemSlot.h || super.f(enumitemslot);
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot enumitemslot, ItemStack itemstack, Equippable equippable) {
        return enumitemslot == EnumItemSlot.h ? SoundEffects.zi : super.a(enumitemslot, itemstack, equippable);
    }

    @Override
    protected void C() {
        this.bF.a(1, new PathfinderGoalPanic(this, 1.65));
        this.bF.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bQ = new PathfinderGoalTempt(this, 1.4, itemstack -> itemstack.a(TagsItem.aA), false);
        this.bF.a(3, this.bQ);
        this.bF.a(4, new a(this, 1.0));
        this.bF.a(5, new PathfinderGoalFollowParent(this, 1.0));
        this.bF.a(7, new PathfinderGoalRandomStroll(this, 1.0, 60));
        this.bF.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bF.a(8, new PathfinderGoalRandomLookaround(this));
        this.bF.a(9, new PathfinderGoalLookAtPlayer(this, EntityStrider.class, 8.0f));
    }

    public void w(boolean flag) {
        this.al.a(bO, flag);
        AttributeModifiable attributemodifiable = this.g(GenericAttributes.v);
        if (attributemodifiable != null) {
            if (flag) {
                attributemodifiable.a(bJ);
            } else {
                attributemodifiable.c(bI);
            }
        }
    }

    public boolean m() {
        return this.al.a(bO);
    }

    @Override
    public boolean a(Fluid fluid) {
        return fluid.a(TagsFluid.b);
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize entitysize, float f2) {
        if (!this.dV().A_()) {
            return super.a(entity, entitysize, f2);
        }
        float f1 = Math.min(0.25f, this.aT.b());
        float f22 = this.aT.c();
        float f3 = 0.12f * MathHelper.b(f22 * 1.5f) * 2.0f * f1;
        return super.a(entity, entitysize, f2).b(0.0, f3 * f2, 0.0);
    }

    @Override
    public boolean a(IWorldReader iworldreader) {
        return iworldreader.f(this);
    }

    @Override
    @Nullable
    public EntityLiving cW() {
        EntityHuman entityhuman;
        Entity entity;
        if (this.fZ() && (entity = this.cZ()) instanceof EntityHuman && (entityhuman = (EntityHuman)entity).b(Items.oB)) {
            return entityhuman;
        }
        return super.cW();
    }

    @Override
    public Vec3D b(EntityLiving entityliving) {
        Vec3D[] avec3d = new Vec3D[]{EntityStrider.a(this.dq(), (double)entityliving.dq(), entityliving.dL()), EntityStrider.a(this.dq(), (double)entityliving.dq(), entityliving.dL() - 22.5f), EntityStrider.a(this.dq(), (double)entityliving.dq(), entityliving.dL() + 22.5f), EntityStrider.a(this.dq(), (double)entityliving.dq(), entityliving.dL() - 45.0f), EntityStrider.a(this.dq(), (double)entityliving.dq(), entityliving.dL() + 45.0f)};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.cR().e;
        double d1 = this.cR().b - 0.5;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (Vec3D vec3d : avec3d) {
            blockposition_mutableblockposition.b(this.dA() + vec3d.d, d0, this.dG() + vec3d.f);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockposition_mutableblockposition.j());
                blockposition_mutableblockposition.c(EnumDirection.a);
            }
        }
        for (BlockPosition blockposition : set) {
            double d3;
            if (this.dV().b_(blockposition).a(TagsFluid.b) || !DismountUtil.a(d3 = this.dV().j(blockposition))) continue;
            Vec3D vec3d1 = Vec3D.a(blockposition, d3);
            for (EntityPose entitypose : entityliving.fO()) {
                AxisAlignedBB axisalignedbb = entityliving.f(entitypose);
                if (!DismountUtil.a(this.dV(), entityliving, axisalignedbb.c(vec3d1))) continue;
                entityliving.b(entitypose);
                return vec3d1;
            }
        }
        return new Vec3D(this.dA(), this.cR().e, this.dG());
    }

    @Override
    protected void a(EntityHuman entityhuman, Vec3D vec3d) {
        this.b(entityhuman.dL(), entityhuman.dN() * 0.5f);
        this.aV = this.aX = this.dL();
        this.N = this.aX;
        this.bP.b();
        super.a(entityhuman, vec3d);
    }

    @Override
    protected Vec3D b(EntityHuman entityhuman, Vec3D vec3d) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float c(EntityHuman entityhuman) {
        return (float)(this.h(GenericAttributes.v) * (double)(this.m() ? 0.35f : 0.55f) * (double)this.bP.c());
    }

    @Override
    protected float aT() {
        return this.X + 0.6f;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(this.bv() ? SoundEffects.zg : SoundEffects.zf, 1.0f, 1.0f);
    }

    @Override
    public boolean a() {
        return this.bP.a(this.dY());
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (this.bv()) {
            this.j();
        } else {
            super.a(d0, flag, iblockdata, blockposition);
        }
    }

    @Override
    public void g() {
        if (this.u() && this.ae.a(140) == 0) {
            this.b(SoundEffects.zb);
        } else if (this.gr() && this.ae.a(60) == 0) {
            this.b(SoundEffects.zc);
        }
        if (!this.gj()) {
            boolean suffocating;
            EntityStrider entitystrider;
            IBlockData iblockdata = this.dV().a_(this.dv());
            IBlockData iblockdata1 = this.br();
            boolean flag = iblockdata.a(TagsBlock.aW) || iblockdata1.a(TagsBlock.aW) || this.b(TagsFluid.b) > 0.0;
            Entity entity = this.dk();
            boolean flag1 = entity instanceof EntityStrider && (entitystrider = (EntityStrider)entity).m();
            boolean flag2 = flag1;
            boolean bl = suffocating = !flag || flag2;
            if (suffocating ^ this.m() && CraftEventFactory.callStriderTemperatureChangeEvent(this, suffocating)) {
                this.w(suffocating);
            }
        }
        super.g();
        this.gu();
    }

    private boolean u() {
        return this.bQ != null && this.bQ.i();
    }

    @Override
    protected boolean E() {
        return true;
    }

    private void gu() {
        if (this.bv()) {
            VoxelShapeCollision voxelshapecollision = VoxelShapeCollision.a(this);
            if (voxelshapecollision.a(BlockFluids.d, this.dv(), true) && !this.dV().b_(this.dv().d()).a(TagsFluid.b)) {
                this.d(true);
            } else {
                this.i(this.dy().c(0.5).b(0.0, 0.05, 0.0));
            }
        }
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gz().a(GenericAttributes.v, 0.175f);
    }

    @Override
    protected SoundEffect s() {
        return !this.gr() && !this.u() ? SoundEffects.za : null;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.ze;
    }

    @Override
    protected SoundEffect j_() {
        return SoundEffects.zd;
    }

    @Override
    protected boolean r(Entity entity) {
        return !this.bZ() && !((Entity)this).a(TagsFluid.b);
    }

    @Override
    public boolean fr() {
        return true;
    }

    @Override
    public boolean bX() {
        return false;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new b(this, world);
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return iworldreader.a_(blockposition).y().a(TagsFluid.b) ? 10.0f : (this.bv() ? Float.NEGATIVE_INFINITY : 0.0f);
    }

    @Nullable
    public EntityStrider b(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.bu.a(worldserver, EntitySpawnReason.e);
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return itemstack.a(TagsItem.az);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        boolean flag = this.i(entityhuman.b(enumhand));
        if (!flag && this.fZ() && !this.bZ() && !entityhuman.fY()) {
            if (!this.dV().C) {
                entityhuman.n(this);
            }
            return EnumInteractionResult.a;
        }
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (!enuminteractionresult.a()) {
            ItemStack itemstack = entityhuman.b(enumhand);
            return this.a(itemstack, EnumItemSlot.h) ? itemstack.a(entityhuman, (EntityLiving)this, enumhand) : EnumInteractionResult.e;
        }
        if (flag && !this.ba()) {
            this.dV().a((Entity)null, this.dA(), this.dC(), this.dG(), SoundEffects.zh, this.dm(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
        }
        return enuminteractionresult;
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.6f * this.cS(), this.dq() * 0.4f);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        if (this.e_()) {
            return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
        }
        RandomSource randomsource = worldaccess.G_();
        if (randomsource.a(30) == 0) {
            EntityInsentient entityinsentient = EntityTypes.bS.a(worldaccess.a(), EntitySpawnReason.g);
            if (entityinsentient != null) {
                groupdataentity = this.a(worldaccess, difficultydamagescaler, entityinsentient, (GroupDataEntity)new EntityZombie.GroupDataZombie(EntityZombie.a(randomsource), false));
                entityinsentient.a(EnumItemSlot.a, new ItemStack(Items.oB));
                this.a(EnumItemSlot.h, new ItemStack(Items.ou));
                this.g(EnumItemSlot.h);
            }
        } else if (randomsource.a(10) == 0) {
            EntityAgeable entityageable = EntityTypes.bu.a(worldaccess.a(), EntitySpawnReason.g);
            if (entityageable != null) {
                entityageable.c_(-24000);
                groupdataentity = this.a(worldaccess, difficultydamagescaler, entityageable, (GroupDataEntity)null);
            }
        } else {
            groupdataentity = new EntityAgeable.a(0.5f);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    private GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntityInsentient entityinsentient, @Nullable GroupDataEntity groupdataentity) {
        entityinsentient.b(this.dA(), this.dC(), this.dG(), this.dL(), 0.0f);
        entityinsentient.a(worldaccess, difficultydamagescaler, EntitySpawnReason.g, groupdataentity);
        entityinsentient.a((Entity)this, true);
        return new EntityAgeable.a(0.0f);
    }

    private static class a
    extends PathfinderGoalGotoTarget {
        private final EntityStrider g;

        a(EntityStrider entitystrider, double d0) {
            super(entitystrider, d0, 8, 2);
            this.g = entitystrider;
        }

        @Override
        public BlockPosition k() {
            return this.e;
        }

        @Override
        public boolean c() {
            return !this.g.bv() && this.a(this.g.dV(), this.e);
        }

        @Override
        public boolean b() {
            return !this.g.bv() && super.b();
        }

        @Override
        public boolean l() {
            return this.d % 20 == 0;
        }

        @Override
        protected boolean a(IWorldReader iworldreader, BlockPosition blockposition) {
            return iworldreader.a_(blockposition).a(Blocks.K) && iworldreader.a_(blockposition.d()).a(PathMode.a);
        }
    }

    private static class b
    extends Navigation {
        b(EntityStrider entitystrider, World world) {
            super(entitystrider, world);
        }

        @Override
        protected Pathfinder a(int i2) {
            this.o = new PathfinderNormal();
            return new Pathfinder(this.o, i2);
        }

        @Override
        protected boolean a(PathType pathtype) {
            return pathtype != PathType.i && pathtype != PathType.o && pathtype != PathType.n ? super.a(pathtype) : true;
        }

        @Override
        public boolean a(BlockPosition blockposition) {
            return this.b.a_(blockposition).a(Blocks.K) || super.a(blockposition);
        }
    }
}

