/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRemoveBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityZombie
extends EntityMonster {
    private static final MinecraftKey a = MinecraftKey.b("baby");
    private static final AttributeModifier b = new AttributeModifier(a, 0.5, AttributeModifier.Operation.b);
    private static final MinecraftKey c = MinecraftKey.b("reinforcement_caller_charge");
    private static final AttributeModifier bJ = new AttributeModifier(MinecraftKey.b("reinforcement_callee_charge"), -0.05f, AttributeModifier.Operation.a);
    private static final MinecraftKey bK = MinecraftKey.b("leader_zombie_bonus");
    private static final MinecraftKey bL = MinecraftKey.b("zombie_random_spawn_bonus");
    private static final DataWatcherObject<Boolean> bM = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> bN = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Boolean> bO = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    public static final float d = 0.05f;
    public static final int e = 50;
    public static final int f = 40;
    public static final int bI = 7;
    private static final int bP = -1;
    private static final EntitySize bQ = EntityTypes.bP.n().a(0.5f).b(0.93f);
    private static final float bR = 0.1f;
    private static final Predicate<EnumDifficulty> bS = enumdifficulty -> enumdifficulty == EnumDifficulty.d;
    private static final boolean bT = false;
    private static final boolean bU = false;
    private static final int bV = 0;
    private final PathfinderGoalBreakDoor bW;
    private boolean bX = false;
    private int bY = 0;
    public int bZ;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombie(EntityTypes<? extends EntityZombie> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.bW = new PathfinderGoalBreakDoor(this, bS);
    }

    public EntityZombie(World world) {
        this((EntityTypes<? extends EntityZombie>)EntityTypes.bP, world);
    }

    @Override
    protected void C() {
        this.bF.a(4, new a((EntityCreature)this, 1.0, 3));
        this.bF.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bF.a(8, new PathfinderGoalRandomLookaround(this));
        this.p();
    }

    protected void p() {
        this.bF.a(2, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.bF.a(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::gC));
        this.bF.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bG.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(EntityPigZombie.class));
        this.bG.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        if (this.dV().spigotConfig.zombieAggressiveTowardsVillager) {
            this.bG.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        }
        this.bG.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.bG.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.bI));
    }

    public static AttributeProvider.Builder gy() {
        return EntityMonster.gA().a(GenericAttributes.m, 35.0).a(GenericAttributes.v, 0.23f).a(GenericAttributes.c, 3.0).a(GenericAttributes.a, 2.0).a(GenericAttributes.A);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(bM, false);
        datawatcher_a.a(bN, 0);
        datawatcher_a.a(bO, false);
    }

    public boolean gB() {
        return this.ar().a(bO);
    }

    public boolean gC() {
        return this.bX;
    }

    public void x(boolean flag) {
        if (PathfinderGoalUtil.a(this)) {
            if (this.bX != flag) {
                this.bX = flag;
                ((Navigation)this.N()).b(flag);
                if (flag) {
                    this.bF.a(1, this.bW);
                } else {
                    this.bF.a(this.bW);
                }
            }
        } else if (this.bX) {
            this.bF.a(this.bW);
            this.bX = false;
        }
    }

    @Override
    public boolean e_() {
        return this.ar().a(bM);
    }

    @Override
    protected int e(WorldServer worldserver) {
        if (this.e_()) {
            this.bA = (int)((double)this.bA * 2.5);
        }
        return super.e(worldserver);
    }

    @Override
    public void a(boolean flag) {
        this.ar().a(bM, flag);
        if (this.dV() != null && !this.dV().C) {
            AttributeModifiable attributemodifiable = this.g(GenericAttributes.v);
            attributemodifiable.c(a);
            if (flag) {
                attributemodifiable.b(b);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (bM.equals(datawatcherobject)) {
            this.h_();
        }
        super.a(datawatcherobject);
    }

    protected boolean gw() {
        return true;
    }

    @Override
    public void g() {
        if (!this.dV().C && this.bJ() && !this.gj()) {
            if (this.gB()) {
                int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
                this.bZ -= elapsedTicks;
                if (this.bZ < 0) {
                    this.ad_();
                }
            } else if (this.gw()) {
                if (((Entity)this).a(TagsFluid.a)) {
                    ++this.bY;
                    if (this.bY >= 600) {
                        this.r(300);
                    }
                } else {
                    this.bY = -1;
                }
            }
        }
        super.g();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public void d_() {
        if (this.bJ()) {
            boolean flag;
            boolean bl = flag = this.ae_() && this.go();
            if (flag) {
                ItemStack itemstack = this.a(EnumItemSlot.f);
                if (!itemstack.f()) {
                    if (itemstack.m()) {
                        Item item = itemstack.h();
                        itemstack.b(itemstack.o() + this.ae.a(2));
                        if (itemstack.o() >= itemstack.p()) {
                            this.a(item, EnumItemSlot.f);
                            this.a(EnumItemSlot.f, ItemStack.l);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.e(8.0f);
                }
            }
        }
        super.d_();
    }

    public void r(int i2) {
        this.lastTick = MinecraftServer.currentTick;
        this.bZ = i2;
        this.ar().a(bO, true);
    }

    protected void ad_() {
        this.b(EntityTypes.L);
        if (!this.ba()) {
            this.dV().a((Entity)null, 1040, this.dv(), 0);
        }
    }

    protected void b(EntityTypes<? extends EntityZombie> entitytypes) {
        EntityZombie converted = this.convertTo(entitytypes, ConversionParams.a(this, true, true), entityzombie -> entityzombie.J(entityzombie.dV().d_(entityzombie.dv()).d()), EntityTransformEvent.TransformReason.DROWNED, CreatureSpawnEvent.SpawnReason.DROWNED);
        if (converted == null) {
            ((Zombie)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @VisibleForTesting
    public boolean a(WorldServer worldserver, EntityVillager entityvillager) {
        return EntityZombie.convertVillagerToZombieVillager(worldserver, entityvillager, this.dv(), this.ba(), EntityTransformEvent.TransformReason.INFECTION, CreatureSpawnEvent.SpawnReason.INFECTION) != null;
    }

    public static EntityZombieVillager convertVillagerToZombieVillager(WorldServer worldserver, EntityVillager entityvillager, BlockPosition blockPosition, boolean silent, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityZombieVillager entityzombievillager = entityvillager.convertTo(EntityTypes.bR, ConversionParams.a(entityvillager, true, true), entityzombievillager1 -> {
            entityzombievillager1.a((WorldAccess)worldserver, worldserver.d_(entityzombievillager1.dv()), EntitySpawnReason.i, new GroupDataZombie(false, true));
            entityzombievillager1.a(entityvillager.gF());
            entityzombievillager1.a(entityvillager.gP().d());
            entityzombievillager1.a(entityvillager.gw().a());
            entityzombievillager1.s(entityvillager.p());
            if (!silent) {
                worldserver.a((Entity)null, 1026, blockPosition, 0);
            }
        }, transformReason, spawnReason);
        return entityzombievillager;
    }

    protected boolean ae_() {
        return true;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (!super.a(worldserver, damagesource, f2)) {
            return false;
        }
        EntityLiving entityliving = this.e();
        if (entityliving == null && damagesource.d() instanceof EntityLiving) {
            entityliving = (EntityLiving)damagesource.d();
        }
        if (entityliving != null && worldserver.an() == EnumDifficulty.d && (double)this.ae.i() < this.h(GenericAttributes.A) && worldserver.O().c(GameRules.f)) {
            int i2 = MathHelper.a(this.dA());
            int j2 = MathHelper.a(this.dC());
            int k2 = MathHelper.a(this.dG());
            EntityTypes<? extends EntityZombie> entitytypes = this.an();
            EntityZombie entityzombie = entitytypes.a(worldserver, EntitySpawnReason.j);
            if (entityzombie == null) {
                return true;
            }
            for (int l2 = 0; l2 < 50; ++l2) {
                int k1;
                int j1;
                int i1 = i2 + MathHelper.a(this.ae, 7, 40) * MathHelper.a(this.ae, -1, 1);
                BlockPosition blockposition = new BlockPosition(i1, j1 = j2 + MathHelper.a(this.ae, 7, 40) * MathHelper.a(this.ae, -1, 1), k1 = k2 + MathHelper.a(this.ae, 7, 40) * MathHelper.a(this.ae, -1, 1));
                if (!EntityPositionTypes.a(entitytypes, worldserver, blockposition) || !EntityPositionTypes.a(entitytypes, worldserver, EntitySpawnReason.j, blockposition, worldserver.A)) continue;
                entityzombie.a_(i1, j1, k1);
                if (worldserver.a((double)i1, (double)j1, (double)k1, 7.0) || !worldserver.f(entityzombie) || !worldserver.g(entityzombie) || !entityzombie.gu() && worldserver.d(entityzombie.cR())) continue;
                entityzombie.setTarget(entityliving, EntityTargetEvent.TargetReason.REINFORCEMENT_TARGET, true);
                entityzombie.a((WorldAccess)worldserver, worldserver.d_(entityzombie.dv()), EntitySpawnReason.j, (GroupDataEntity)null);
                worldserver.addFreshEntityWithPassengers(entityzombie, CreatureSpawnEvent.SpawnReason.REINFORCEMENTS);
                AttributeModifiable attributemodifiable = this.g(GenericAttributes.A);
                AttributeModifier attributemodifier = attributemodifiable.a(c);
                double d0 = attributemodifier != null ? attributemodifier.b() : 0.0;
                attributemodifiable.c(c);
                attributemodifiable.d(new AttributeModifier(c, d0 - 0.05, AttributeModifier.Operation.a));
                entityzombie.g(GenericAttributes.A).d(bJ);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean c(WorldServer worldserver, Entity entity) {
        boolean flag = super.c(worldserver, entity);
        if (flag) {
            float f2 = this.dV().d_(this.dv()).b();
            if (this.fb().f() && this.bX() && this.ae.i() < f2 * 0.3f) {
                EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), (float)(2 * (int)f2));
                this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    entity.igniteForSeconds(event.getDuration(), false);
                }
            }
        }
        return flag;
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.Er;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.EB;
    }

    @Override
    protected SoundEffect j_() {
        return SoundEffects.Ew;
    }

    protected SoundEffect u() {
        return SoundEffects.EH;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(this.u(), 0.15f, 1.0f);
    }

    public EntityTypes<? extends EntityZombie> an() {
        return super.an();
    }

    protected boolean gu() {
        return false;
    }

    @Override
    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        super.a(randomsource, difficultydamagescaler);
        float f2 = randomsource.i();
        float f3 = this.dV().an() == EnumDifficulty.d ? 0.05f : 0.01f;
        if (f2 < f3) {
            int i2 = randomsource.a(3);
            if (i2 == 0) {
                this.a(EnumItemSlot.a, new ItemStack(Items.pP));
            } else {
                this.a(EnumItemSlot.a, new ItemStack(Items.pQ));
            }
        }
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("IsBaby", this.e_());
        nbttagcompound.a("CanBreakDoors", this.gC());
        nbttagcompound.a("InWaterTime", this.bi() ? this.bY : -1);
        nbttagcompound.a("DrownedConversionTime", this.gB() ? this.bZ : -1);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.a(nbttagcompound.b("IsBaby", false));
        this.x(nbttagcompound.b("CanBreakDoors", false));
        this.bY = nbttagcompound.b("InWaterTime", 0);
        int i2 = nbttagcompound.b("DrownedConversionTime", -1);
        if (i2 != -1) {
            this.r(i2);
        } else {
            this.ar().a(bO, false);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, EntityLiving entityliving) {
        boolean flag = super.a(worldserver, entityliving);
        if ((worldserver.an() == EnumDifficulty.c || worldserver.an() == EnumDifficulty.d) && entityliving instanceof EntityVillager) {
            EntityVillager entityvillager = (EntityVillager)entityliving;
            if (worldserver.an() != EnumDifficulty.d && this.ae.h()) {
                return flag;
            }
            if (this.a(worldserver, entityvillager)) {
                flag = false;
            }
        }
        return flag;
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return this.e_() ? bQ : super.e(entitypose);
    }

    @Override
    public boolean g(ItemStack itemstack) {
        return itemstack.a(TagsItem.aa) && this.e_() && this.bY() ? false : super.g(itemstack);
    }

    @Override
    public boolean c(WorldServer worldserver, ItemStack itemstack) {
        return itemstack.a(Items.so) ? false : super.c(worldserver, itemstack);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.G_();
        groupdataentity = super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
        float f2 = difficultydamagescaler.d();
        if (entityspawnreason != EntitySpawnReason.i) {
            this.a_(randomsource.i() < 0.55f * f2);
        }
        if (groupdataentity == null) {
            groupdataentity = new GroupDataZombie(EntityZombie.a(randomsource), true);
        }
        if (groupdataentity instanceof GroupDataZombie) {
            GroupDataZombie entityzombie_groupdatazombie = (GroupDataZombie)groupdataentity;
            if (entityzombie_groupdatazombie.a) {
                this.a(true);
                if (entityzombie_groupdatazombie.b) {
                    EntityChicken entitychicken1;
                    if ((double)randomsource.i() < 0.05) {
                        List<Entity> list = worldaccess.a(EntityChicken.class, this.cR().c(5.0, 3.0, 5.0), IEntitySelector.c);
                        if (!list.isEmpty()) {
                            EntityChicken entitychicken = (EntityChicken)list.get(0);
                            entitychicken.w(true);
                            this.n(entitychicken);
                        }
                    } else if ((double)randomsource.i() < 0.05 && (entitychicken1 = EntityTypes.A.a(this.dV(), EntitySpawnReason.g)) != null) {
                        entitychicken1.b(this.dA(), this.dC(), this.dG(), this.dL(), 0.0f);
                        entitychicken1.a(worldaccess, difficultydamagescaler, EntitySpawnReason.g, (GroupDataEntity)null);
                        entitychicken1.w(true);
                        this.n(entitychicken1);
                        worldaccess.addFreshEntity(entitychicken1, CreatureSpawnEvent.SpawnReason.MOUNT);
                    }
                }
            }
            this.x(randomsource.i() < f2 * 0.1f);
            if (entityspawnreason != EntitySpawnReason.i) {
                this.a(randomsource, difficultydamagescaler);
                this.a(worldaccess, randomsource, difficultydamagescaler);
            }
        }
        if (this.a(EnumItemSlot.f).f()) {
            LocalDate localdate = LocalDate.now();
            int i2 = localdate.get(ChronoField.DAY_OF_MONTH);
            int j2 = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j2 == 10 && i2 == 31 && randomsource.i() < 0.25f) {
                this.a(EnumItemSlot.f, new ItemStack(randomsource.i() < 0.1f ? Blocks.ew : Blocks.ev));
                this.a(EnumItemSlot.f, 0.0f);
            }
        }
        this.J(f2);
        return groupdataentity;
    }

    @VisibleForTesting
    public void b(int i2) {
        this.bY = i2;
    }

    @VisibleForTesting
    public void c(int i2) {
        this.bZ = i2;
    }

    public static boolean a(RandomSource randomsource) {
        return randomsource.i() < 0.05f;
    }

    protected void J(float f2) {
        this.gD();
        this.g(GenericAttributes.p).c(new AttributeModifier(by, this.ae.j() * (double)0.05f, AttributeModifier.Operation.a));
        double d0 = this.ae.j() * 1.5 * (double)f2;
        if (d0 > 1.0) {
            this.g(GenericAttributes.m).c(new AttributeModifier(bL, d0, AttributeModifier.Operation.c));
        }
        if (this.ae.i() < f2 * 0.05f) {
            this.g(GenericAttributes.A).c(new AttributeModifier(bK, this.ae.j() * 0.25 + 0.5, AttributeModifier.Operation.a));
            this.g(GenericAttributes.s).c(new AttributeModifier(bK, this.ae.j() * 3.0 + 1.0, AttributeModifier.Operation.c));
            this.x(true);
        }
    }

    protected void gD() {
        this.g(GenericAttributes.A).a(this.ae.j() * (double)0.1f);
    }

    @Override
    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        ItemStack itemstack;
        EntityCreeper entitycreeper;
        super.a(worldserver, damagesource, flag);
        Entity entity = damagesource.d();
        if (entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).gw() && !(itemstack = this.gv()).f()) {
            entitycreeper.gx();
            this.a(worldserver, itemstack);
        }
    }

    protected ItemStack gv() {
        return new ItemStack(Items.vy);
    }

    private class a
    extends PathfinderGoalRemoveBlock {
        a(EntityCreature entitycreature, double d0, int i2) {
            super(Blocks.mL, entitycreature, d0, i2);
        }

        @Override
        public void a(GeneratorAccess generatoraccess, BlockPosition blockposition) {
            generatoraccess.a((Entity)null, blockposition, SoundEffects.Ex, SoundCategory.f, 0.5f, 0.9f + EntityZombie.this.ae.i() * 0.2f);
        }

        @Override
        public void a(World world, BlockPosition blockposition) {
            world.a((Entity)null, blockposition, SoundEffects.Bm, SoundCategory.e, 0.7f, 0.9f + world.A.i() * 0.2f);
        }

        @Override
        public double i() {
            return 1.14;
        }
    }

    public static class GroupDataZombie
    implements GroupDataEntity {
        public final boolean a;
        public final boolean b;

        public GroupDataZombie(boolean flag, boolean flag1) {
            this.a = flag;
            this.b = flag1;
        }
    }
}

