/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityZombieVillager
extends EntityZombie
implements VillagerDataHolder {
    public static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<VillagerData> b = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.u);
    private static final int c = 3600;
    private static final int bJ = 6000;
    private static final int bK = 14;
    private static final int bL = 4;
    private static final int bM = -1;
    private static final int bN = 0;
    public int bO;
    @Nullable
    public UUID bP;
    @Nullable
    private Reputation bQ;
    @Nullable
    private MerchantRecipeList bR;
    private int bS = 0;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombieVillager(EntityTypes<? extends EntityZombieVillager> entitytypes, World world) {
        super((EntityTypes<? extends EntityZombie>)entitytypes, world);
        BuiltInRegistries.x.a(this.ae).ifPresent(holder_c -> this.a(this.gF().b((Holder<VillagerProfession>)holder_c)));
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, false);
        datawatcher_a.a(b, EntityVillager.gJ());
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("VillagerData", VillagerData.c, this.gF());
        nbttagcompound.b("Offers", MerchantRecipeList.a, this.dX().a(DynamicOpsNBT.a), this.bR);
        nbttagcompound.b("Gossips", Reputation.a, this.bQ);
        nbttagcompound.a("ConversionTime", this.gE() ? this.bO : -1);
        nbttagcompound.b("ConversionPlayer", UUIDUtil.a, this.bP);
        nbttagcompound.a("Xp", this.bS);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.al.a(b, nbttagcompound.a("VillagerData", VillagerData.c).orElseGet(EntityVillager::gJ));
        this.bR = nbttagcompound.a("Offers", MerchantRecipeList.a, (DynamicOps<NBTBase>)this.dX().a(DynamicOpsNBT.a)).orElse(null);
        this.bQ = nbttagcompound.a("Gossips", Reputation.a).orElse(null);
        int i2 = nbttagcompound.b("ConversionTime", -1);
        if (i2 != -1) {
            UUID uuid = nbttagcompound.a("ConversionPlayer", UUIDUtil.a).orElse(null);
            this.b(uuid, i2);
        } else {
            this.ar().a(a, false);
            this.bO = -1;
        }
        this.bS = nbttagcompound.b("Xp", 0);
    }

    @Override
    public void g() {
        if (!this.dV().C && this.bJ() && this.gE()) {
            int i2 = this.gH();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            this.bO -= (i2 *= elapsedTicks);
            if (this.bO <= 0) {
                this.g((WorldServer)this.dV());
            }
        }
        super.g();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.qO)) {
            if (this.b(MobEffects.r)) {
                itemstack.a(1, (EntityLiving)entityhuman);
                if (!this.dV().C) {
                    this.b(entityhuman.cG(), this.ae.a(2401) + 3600);
                }
                return EnumInteractionResult.b;
            }
            return EnumInteractionResult.c;
        }
        return super.b(entityhuman, enumhand);
    }

    @Override
    protected boolean gw() {
        return false;
    }

    @Override
    public boolean h(double d0) {
        return !this.gE() && this.bS == 0;
    }

    public boolean gE() {
        return this.ar().a(a);
    }

    public void b(@Nullable UUID uuid, int i2) {
        this.bP = uuid;
        this.bO = i2;
        this.ar().a(a, true);
        this.removeEffect(MobEffects.r, EntityPotionEffectEvent.Cause.CONVERSION);
        this.addEffect(new MobEffect(MobEffects.e, i2, Math.min(this.dV().an().a() - 1, 0)), EntityPotionEffectEvent.Cause.CONVERSION);
        this.dV().a((Entity)this, (byte)16);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 16) {
            if (!this.ba()) {
                this.dV().a(this.dA(), this.dE(), this.dG(), SoundEffects.EK, this.dm(), 1.0f + this.ae.i(), this.ae.i() * 0.7f + 0.3f, false);
            }
        } else {
            super.b(b0);
        }
    }

    private void g(WorldServer worldserver) {
        EntityVillager converted = this.convertTo(EntityTypes.bE, ConversionParams.a(this, false, false), entityvillager -> {
            EntityHuman entityhuman;
            this.forceDrops = false;
            for (EnumItemSlot enumitemslot : this.a(worldserver, (ItemStack itemstack) -> !EnchantmentManager.a(itemstack, EnchantmentEffectComponents.E))) {
                SlotAccess slotaccess = entityvillager.a_(enumitemslot.b() + 300);
                slotaccess.a(this.a(enumitemslot));
            }
            entityvillager.a(this.gF());
            if (this.bQ != null) {
                entityvillager.a(this.bQ);
            }
            if (this.bR != null) {
                entityvillager.b(this.bR.a());
            }
            entityvillager.t(this.bS);
            entityvillager.a((WorldAccess)worldserver, worldserver.d_(entityvillager.dv()), EntitySpawnReason.i, (GroupDataEntity)null);
            entityvillager.g(worldserver);
            if (this.bP != null && (entityhuman = worldserver.a(this.bP)) instanceof EntityPlayer) {
                CriterionTriggers.s.a((EntityPlayer)entityhuman, this, (EntityVillager)entityvillager);
                worldserver.a(ReputationEvent.a, (Entity)entityhuman, (ReputationHandler)((Object)entityvillager));
            }
            entityvillager.addEffect(new MobEffect(MobEffects.i, 200, 0), EntityPotionEffectEvent.Cause.CONVERSION);
            if (!this.ba()) {
                worldserver.a((Entity)null, 1027, this.dv(), 0);
            }
        }, EntityTransformEvent.TransformReason.CURED, CreatureSpawnEvent.SpawnReason.CURED);
        if (converted == null) {
            ((ZombieVillager)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @Override
    @VisibleForTesting
    public void r(int i2) {
        this.bO = i2;
    }

    private int gH() {
        int i2 = 1;
        if (this.ae.i() < 0.01f) {
            int j2 = 0;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k2 = (int)this.dA() - 4; k2 < (int)this.dA() + 4 && j2 < 14; ++k2) {
                for (int l2 = (int)this.dC() - 4; l2 < (int)this.dC() + 4 && j2 < 14; ++l2) {
                    for (int i1 = (int)this.dG() - 4; i1 < (int)this.dG() + 4 && j2 < 14; ++i1) {
                        IBlockData iblockdata = this.dV().a_(blockposition_mutableblockposition.d(k2, l2, i1));
                        if (!iblockdata.a(Blocks.fo) && !(iblockdata.b() instanceof BlockBed)) continue;
                        if (this.ae.i() < 0.3f) {
                            ++i2;
                        }
                        ++j2;
                    }
                }
            }
        }
        return i2;
    }

    @Override
    public float ff() {
        return this.e_() ? (this.ae.i() - this.ae.i()) * 0.2f + 2.0f : (this.ae.i() - this.ae.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.EI;
    }

    @Override
    public SoundEffect e(DamageSource damagesource) {
        return SoundEffects.EM;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.EL;
    }

    @Override
    public SoundEffect u() {
        return SoundEffects.EN;
    }

    @Override
    protected ItemStack gv() {
        return ItemStack.l;
    }

    public void a(MerchantRecipeList merchantrecipelist) {
        this.bR = merchantrecipelist;
    }

    public void a(Reputation reputation) {
        this.bQ = reputation;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        this.a(this.gF().a(worldaccess.J_(), VillagerType.a(worldaccess.u(this.dv()))));
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public void a(VillagerData villagerdata) {
        VillagerData villagerdata1 = this.gF();
        if (!villagerdata1.b().equals(villagerdata.b())) {
            this.bR = null;
        }
        this.al.a(b, villagerdata);
    }

    @Override
    public VillagerData gF() {
        return this.al.a(b);
    }

    public int gG() {
        return this.bS;
    }

    public void s(int i2) {
        this.bS = i2;
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.av ? EntityZombieVillager.c(datacomponenttype, this.gF().a()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.av);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.av) {
            Holder<VillagerType> holder = EntityZombieVillager.c(DataComponents.av, t0);
            this.a(this.gF().a(holder));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }
}

