/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.hoglin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.hoglin.HoglinAI;
import net.minecraft.world.entity.monster.hoglin.IOglin;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityHoglin
extends EntityAnimal
implements IMonster,
IOglin {
    private static final DataWatcherObject<Boolean> bM = DataWatcher.a(EntityHoglin.class, DataWatcherRegistry.k);
    private static final int bN = 40;
    private static final float bO = 0.3f;
    private static final int bP = 1;
    private static final float bQ = 0.6f;
    private static final int bR = 6;
    private static final float bS = 0.5f;
    private static final boolean bT = false;
    private static final int bU = 0;
    private static final boolean bV = false;
    public static final int bI = 300;
    private int bW;
    public int bX = 0;
    public boolean bY = false;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super EntityHoglin>>> bJ = ImmutableList.of(SensorType.c, SensorType.d, SensorType.o, SensorType.n);
    protected static final ImmutableList<? extends MemoryModuleType<?>> bK = ImmutableList.of(MemoryModuleType.s, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.o, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.ar, (Object[])new MemoryModuleType[]{MemoryModuleType.A, MemoryModuleType.at, MemoryModuleType.au, MemoryModuleType.aq, MemoryModuleType.L, MemoryModuleType.ax, MemoryModuleType.ay, MemoryModuleType.aa});

    public EntityHoglin(EntityTypes<? extends EntityHoglin> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.bA = 5;
    }

    @VisibleForTesting
    public void s(int i2) {
        this.bX = i2;
    }

    @Override
    public boolean w() {
        return true;
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gA().a(GenericAttributes.s, 40.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.p, 0.6f).a(GenericAttributes.d, 1.0).a(GenericAttributes.c, 6.0);
    }

    @Override
    public boolean c(WorldServer worldserver, Entity entity) {
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            this.bW = 10;
            this.dV().a((Entity)this, (byte)4);
            this.b(SoundEffects.mS);
            HoglinAI.a(this, entityliving);
            return IOglin.a(worldserver, this, entityliving);
        }
        return false;
    }

    @Override
    protected void d(EntityLiving entityliving) {
        if (this.p()) {
            IOglin.a(this, entityliving);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        Entity entity;
        boolean flag = super.a(worldserver, damagesource, f2);
        if (flag && (entity = damagesource.d()) instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            HoglinAI.a(worldserver, this, entityliving);
        }
        return flag;
    }

    protected BehaviorController.b<EntityHoglin> ed() {
        return BehaviorController.a(bK, bJ);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return HoglinAI.a(this.ed().a(dynamic));
    }

    public BehaviorController<EntityHoglin> ec() {
        return super.ec();
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("hoglinBrain");
        this.ec().a(worldserver, this);
        gameprofilerfiller.c();
        HoglinAI.a(this);
        if (this.u()) {
            ++this.bX;
            if (this.bX > 300) {
                this.b(SoundEffects.mT);
                this.gw();
            }
        } else {
            this.bX = 0;
        }
    }

    @Override
    public void d_() {
        if (this.bW > 0) {
            --this.bW;
        }
        super.d_();
    }

    @Override
    protected void h() {
        if (this.e_()) {
            this.bA = 3;
            this.g(GenericAttributes.c).a(0.5);
        } else {
            this.bA = 5;
            this.g(GenericAttributes.c).a(6.0);
        }
    }

    public static boolean c(EntityTypes<EntityHoglin> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return !generatoraccess.a_(blockposition.e()).a(Blocks.lq);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        if (worldaccess.G_().i() < 0.2f) {
            this.a(true);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public boolean h(double d0) {
        return !this.gd();
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return HoglinAI.a(this, blockposition) ? -1.0f : (iworldreader.a_(blockposition.e()).a(Blocks.pc) ? 10.0f : 0.0f);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (enuminteractionresult.a()) {
            this.gc();
        }
        return enuminteractionresult;
    }

    @Override
    public void b(byte b0) {
        if (b0 == 4) {
            this.bW = 10;
            this.b(SoundEffects.mS);
        } else {
            super.b(b0);
        }
    }

    @Override
    public int gu() {
        return this.bW;
    }

    @Override
    public boolean eo() {
        return true;
    }

    @Override
    protected int e(WorldServer worldserver) {
        return this.bA;
    }

    private void gw() {
        this.convertTo(EntityTypes.bO, ConversionParams.a(this, true, false), entityzoglin -> entityzoglin.a(new MobEffect(MobEffects.i, 200, 0)), EntityTransformEvent.TransformReason.PIGLIN_ZOMBIFIED, CreatureSpawnEvent.SpawnReason.PIGLIN_ZOMBIFIED);
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return itemstack.a(TagsItem.ar);
    }

    public boolean p() {
        return !this.e_();
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(bM, false);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("IsImmuneToZombification", this.gx());
        nbttagcompound.a("TimeInOverworld", this.bX);
        nbttagcompound.a("CannotBeHunted", this.bY);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.w(nbttagcompound.b("IsImmuneToZombification", false));
        this.bX = nbttagcompound.b("TimeInOverworld", 0);
        this.x(nbttagcompound.b("CannotBeHunted", false));
    }

    public void w(boolean flag) {
        this.ar().a(bM, flag);
    }

    public boolean gx() {
        return this.ar().a(bM);
    }

    public boolean u() {
        return !this.dV().F_().b() && !this.gx() && !this.gj();
    }

    private void x(boolean flag) {
        this.bY = flag;
    }

    public boolean gv() {
        return this.p() && !this.bY;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer worldserver, EntityAgeable entityageable) {
        EntityHoglin entityhoglin = EntityTypes.ak.a(worldserver, EntitySpawnReason.e);
        if (entityhoglin != null) {
            entityhoglin.gc();
        }
        return entityhoglin;
    }

    @Override
    public boolean gB() {
        return !HoglinAI.c(this) && super.gB();
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect s() {
        return this.dV().C ? null : (SoundEffect)HoglinAI.b(this).orElse(null);
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.mV;
    }

    @Override
    protected SoundEffect j_() {
        return SoundEffects.mU;
    }

    @Override
    protected SoundEffect aU() {
        return SoundEffects.nA;
    }

    @Override
    protected SoundEffect aV() {
        return SoundEffects.nz;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.mX, 0.15f, 1.0f);
    }

    @Override
    protected void ab() {
        super.ab();
        PacketDebug.a(this);
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.P();
    }
}

