/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinArmPose;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityPiglin
extends EntityPiglinAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> bI = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bJ = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bK = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final MinecraftKey bL = MinecraftKey.b("baby");
    private static final AttributeModifier bM = new AttributeModifier(bL, 0.2f, AttributeModifier.Operation.b);
    private static final int bN = 16;
    private static final float bO = 0.35f;
    private static final int bP = 5;
    private static final float bQ = 0.1f;
    private static final int bR = 3;
    private static final float bS = 0.2f;
    private static final EntitySize bT = EntityTypes.aS.n().a(0.5f).b(0.97f);
    private static final double bU = 0.5;
    private static final boolean bV = false;
    private static final boolean bW = false;
    public final InventorySubcontainer bX = new InventorySubcontainer(8);
    public boolean bY = false;
    protected static final ImmutableList<SensorType<? extends Sensor<? super EntityPiglin>>> d = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.f, SensorType.l);
    protected static final ImmutableList<MemoryModuleType<?>> e = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.w, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.ap, MemoryModuleType.ao, MemoryModuleType.M, MemoryModuleType.aQ, MemoryModuleType.y, MemoryModuleType.z, (Object[])new MemoryModuleType[]{MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.r, MemoryModuleType.u, MemoryModuleType.ac, MemoryModuleType.ad, MemoryModuleType.A, MemoryModuleType.ae, MemoryModuleType.af, MemoryModuleType.ah, MemoryModuleType.ag, MemoryModuleType.aj, MemoryModuleType.ak, MemoryModuleType.ai, MemoryModuleType.am, MemoryModuleType.N, MemoryModuleType.as, MemoryModuleType.t, MemoryModuleType.at, MemoryModuleType.au, MemoryModuleType.al, MemoryModuleType.an, MemoryModuleType.av, MemoryModuleType.aw, MemoryModuleType.ax});
    public Set<Item> allowedBarterItems = new HashSet<Item>();
    public Set<Item> interestItems = new HashSet<Item>();

    public EntityPiglin(EntityTypes<? extends EntityPiglinAbstract> entitytypes, World world) {
        super(entitytypes, world);
        this.bA = 5;
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("IsBaby", this.e_());
        nbttagcompound.a("CannotHunt", this.bY);
        this.b(nbttagcompound, this.dX());
        NBTTagList barterList = new NBTTagList();
        this.allowedBarterItems.stream().map(BuiltInRegistries.g::b).map(MinecraftKey::toString).map(NBTTagString::a).forEach(barterList::add);
        nbttagcompound.a("Bukkit.BarterList", barterList);
        NBTTagList interestList = new NBTTagList();
        this.interestItems.stream().map(BuiltInRegistries.g::b).map(MinecraftKey::toString).map(NBTTagString::a).forEach(interestList::add);
        nbttagcompound.a("Bukkit.InterestList", interestList);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.a(nbttagcompound.b("IsBaby", false));
        this.y(nbttagcompound.b("CannotHunt", false));
        this.a(nbttagcompound, this.dX());
        this.allowedBarterItems = nbttagcompound.o("Bukkit.BarterList").stream().flatMap(item -> item.p_().stream()).map(MinecraftKey::c).map(BuiltInRegistries.g::a).collect(Collectors.toCollection(HashSet::new));
        this.interestItems = nbttagcompound.o("Bukkit.InterestList").stream().flatMap(item -> item.p_().stream()).map(MinecraftKey::c).map(BuiltInRegistries.g::a).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    @VisibleForDebug
    public InventorySubcontainer u() {
        return this.bX;
    }

    @Override
    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        EntityCreeper entitycreeper;
        super.a(worldserver, damagesource, flag);
        Entity entity = damagesource.d();
        if (entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).gw()) {
            ItemStack itemstack = new ItemStack(Items.vB);
            entitycreeper.gx();
            this.a(worldserver, itemstack);
        }
        this.bX.f().forEach(itemstack1 -> this.a(worldserver, (ItemStack)itemstack1));
    }

    protected ItemStack i(ItemStack itemstack) {
        return this.bX.b(itemstack);
    }

    protected boolean j(ItemStack itemstack) {
        return this.bX.c(itemstack);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(bI, false);
        datawatcher_a.a(bJ, false);
        datawatcher_a.a(bK, false);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        super.a(datawatcherobject);
        if (bI.equals(datawatcherobject)) {
            this.h_();
        }
    }

    public static AttributeProvider.Builder gB() {
        return EntityMonster.gA().a(GenericAttributes.s, 16.0).a(GenericAttributes.v, 0.35f).a(GenericAttributes.c, 5.0);
    }

    public static boolean b(EntityTypes<EntityPiglin> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return !generatoraccess.a_(blockposition.e()).a(Blocks.lq);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.G_();
        if (entityspawnreason != EntitySpawnReason.d) {
            if (randomsource.i() < 0.2f) {
                this.a(true);
            } else if (this.gv()) {
                this.a(EnumItemSlot.a, this.gD());
            }
        }
        PiglinAI.a(this, worldaccess.G_());
        this.a(randomsource, difficultydamagescaler);
        this.a(worldaccess, randomsource, difficultydamagescaler);
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    protected boolean Z() {
        return false;
    }

    @Override
    public boolean h(double d0) {
        return !this.gd();
    }

    @Override
    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        if (this.gv()) {
            this.a(EnumItemSlot.f, new ItemStack(Items.qC), randomsource);
            this.a(EnumItemSlot.e, new ItemStack(Items.qD), randomsource);
            this.a(EnumItemSlot.d, new ItemStack(Items.qE), randomsource);
            this.a(EnumItemSlot.c, new ItemStack(Items.qF), randomsource);
        }
    }

    private void a(EnumItemSlot enumitemslot, ItemStack itemstack, RandomSource randomsource) {
        if (randomsource.i() < 0.1f) {
            this.a(enumitemslot, itemstack);
        }
    }

    protected BehaviorController.b<EntityPiglin> ed() {
        return BehaviorController.a(e, d);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return PiglinAI.a(this, this.ed().a(dynamic));
    }

    public BehaviorController<EntityPiglin> ec() {
        return super.ec();
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (enuminteractionresult.a()) {
            return enuminteractionresult;
        }
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return PiglinAI.a(worldserver, this, entityhuman, enumhand);
        }
        boolean flag = PiglinAI.b(this, entityhuman.b(enumhand)) && this.gw() != EntityPiglinArmPose.d;
        return (EnumInteractionResult)((Object)(flag ? EnumInteractionResult.a : EnumInteractionResult.e));
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return this.e_() ? bT : super.e(entitypose);
    }

    @Override
    public void a(boolean flag) {
        this.ar().a(bI, flag);
        if (!this.dV().C) {
            AttributeModifiable attributemodifiable = this.g(GenericAttributes.v);
            attributemodifiable.c(bM.a());
            if (flag) {
                attributemodifiable.b(bM);
            }
        }
    }

    @Override
    public boolean e_() {
        return this.ar().a(bI);
    }

    private void y(boolean flag) {
        this.bY = flag;
    }

    @Override
    protected boolean m() {
        return !this.bY;
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("piglinBrain");
        this.ec().a(worldserver, this);
        gameprofilerfiller.c();
        PiglinAI.a(this);
        super.a(worldserver);
    }

    @Override
    protected int e(WorldServer worldserver) {
        return this.bA;
    }

    @Override
    protected void g(WorldServer worldserver) {
        PiglinAI.a(worldserver, this);
        this.bX.f().forEach(itemstack -> this.a(worldserver, (ItemStack)itemstack));
        super.g(worldserver);
    }

    private ItemStack gD() {
        return (double)this.ae.i() < 0.5 ? new ItemStack(Items.xg) : new ItemStack(Items.pK);
    }

    @Override
    @Nullable
    public TagKey<Item> X() {
        return this.e_() ? null : TagsItem.bW;
    }

    private boolean gE() {
        return this.al.a(bJ);
    }

    @Override
    public void b(boolean flag) {
        this.al.a(bJ, flag);
    }

    @Override
    public void a() {
        this.bd = 0;
    }

    @Override
    public EntityPiglinArmPose gw() {
        return this.gC() ? EntityPiglinArmPose.e : (PiglinAI.a(this.fc()) ? EntityPiglinArmPose.d : (this.gl() && this.gx() ? EntityPiglinArmPose.a : (this.gE() ? EntityPiglinArmPose.c : (this.b(Items.xg) && ItemCrossbow.g(this.dZ()) ? EntityPiglinArmPose.b : EntityPiglinArmPose.f))));
    }

    public boolean gC() {
        return this.al.a(bK);
    }

    public void x(boolean flag) {
        this.al.a(bK, flag);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        Entity entity;
        boolean flag = super.a(worldserver, damagesource, f2);
        if (flag && (entity = damagesource.d()) instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            PiglinAI.a(worldserver, this, entityliving);
        }
        return flag;
    }

    @Override
    public void a(EntityLiving entityliving, float f2) {
        this.b(this, 1.6f);
    }

    @Override
    public boolean a(ItemProjectileWeapon itemprojectileweapon) {
        return itemprojectileweapon == Items.xg;
    }

    protected void k(ItemStack itemstack) {
        this.b(EnumItemSlot.a, itemstack);
    }

    protected void l(ItemStack itemstack) {
        if (itemstack.a(PiglinAI.c) || this.allowedBarterItems.contains(itemstack.h())) {
            this.a(EnumItemSlot.b, itemstack);
            this.g(EnumItemSlot.b);
        } else {
            this.b(EnumItemSlot.b, itemstack);
        }
    }

    @Override
    public boolean c(WorldServer worldserver, ItemStack itemstack) {
        return worldserver.O().c(GameRules.d) && this.fN() && PiglinAI.a(this, itemstack);
    }

    protected boolean m(ItemStack itemstack) {
        EnumItemSlot enumitemslot = this.f(itemstack);
        ItemStack itemstack1 = this.a(enumitemslot);
        return this.a(itemstack, itemstack1, enumitemslot);
    }

    @Override
    protected boolean a(ItemStack itemstack, ItemStack itemstack1, EnumItemSlot enumitemslot) {
        boolean flag1;
        if (EnchantmentManager.a(itemstack1, EnchantmentEffectComponents.E)) {
            return false;
        }
        TagKey<Item> tagkey = this.X();
        boolean flag = PiglinAI.isLovedItem(itemstack, this) || tagkey != null && itemstack.a(tagkey);
        boolean bl = flag1 = PiglinAI.isLovedItem(itemstack1, this) || tagkey != null && itemstack1.a(tagkey);
        return flag && !flag1 ? true : (!flag && flag1 ? false : super.a(itemstack, itemstack1, enumitemslot));
    }

    @Override
    protected void a(WorldServer worldserver, EntityItem entityitem) {
        this.a(entityitem);
        PiglinAI.a(worldserver, this, entityitem);
    }

    @Override
    public boolean a(Entity entity, boolean flag) {
        if (this.e_() && entity.an() == EntityTypes.ak) {
            entity = this.b(entity, 3);
        }
        return super.a(entity, flag);
    }

    private Entity b(Entity entity, int i2) {
        List<Entity> list = entity.cY();
        return i2 != 1 && !list.isEmpty() ? this.b(list.getFirst(), i2 - 1) : entity;
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        return this.dV().C ? null : (SoundEffect)PiglinAI.b(this).orElse(null);
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.uz;
    }

    @Override
    protected SoundEffect j_() {
        return SoundEffects.ux;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.uB, 0.15f, 1.0f);
    }

    @Override
    protected void gy() {
        this.b(SoundEffects.uC);
    }
}

