/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.warden.SonicBoom;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.monster.warden.WardenAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jetbrains.annotations.Contract;

public class Warden
extends EntityMonster
implements VibrationSystem {
    private static final int bI = 40;
    private static final int bJ = 200;
    private static final int bK = 500;
    private static final float bL = 0.3f;
    private static final float bM = 1.0f;
    private static final float bN = 1.5f;
    private static final int bO = 30;
    private static final int bP = 24;
    private static final DataWatcherObject<Integer> bQ = DataWatcher.a(Warden.class, DataWatcherRegistry.b);
    private static final int bR = 200;
    private static final int bS = 260;
    private static final int bT = 20;
    private static final int bU = 120;
    private static final int bV = 20;
    private static final int bW = 35;
    private static final int bX = 10;
    private static final int bY = 20;
    private static final int bZ = 100;
    private static final int ca = 20;
    private static final int cb = 30;
    private static final float cc = 4.5f;
    private static final float cd = 0.7f;
    private static final int ce = 30;
    private int cf;
    private int cg;
    private int ch;
    private int ci;
    public AnimationState a = new AnimationState();
    public AnimationState b = new AnimationState();
    public AnimationState c = new AnimationState();
    public AnimationState d = new AnimationState();
    public AnimationState e = new AnimationState();
    public AnimationState f = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.b> cj = new DynamicGameEventListener<VibrationSystem.b>(new VibrationSystem.b(this));
    private final VibrationSystem.d ck = new a();
    private VibrationSystem.a cl = new VibrationSystem.a();
    AngerManagement cm = new AngerManagement(this::b, Collections.emptyList());

    public Warden(EntityTypes<? extends EntityMonster> entitytypes, World world) {
        super(entitytypes, world);
        this.bA = 5;
        this.N().a(true);
        this.a(PathType.m, 0.0f);
        this.a(PathType.q, 8.0f);
        this.a(PathType.f, 8.0f);
        this.a(PathType.i, 8.0f);
        this.a(PathType.o, 0.0f);
        this.a(PathType.n, 0.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntity((Entity)this, entitytrackerentry, this.c(EntityPose.n) ? 1 : 0);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        if (packetplayoutspawnentity.p() == 1) {
            this.b(EntityPose.n);
        }
    }

    @Override
    public boolean a(IWorldReader iworldreader) {
        return super.a(iworldreader) && iworldreader.a((Entity)this, this.an().n().a(this.dt()));
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return 0.0f;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return this.gy() && !damagesource.a(DamageTypeTags.d) ? true : super.a(worldserver, damagesource);
    }

    boolean gy() {
        return this.c(EntityPose.o) || this.c(EntityPose.n);
    }

    @Override
    protected boolean o(Entity entity) {
        return false;
    }

    @Override
    public float fU() {
        return 5.0f;
    }

    @Override
    protected float aT() {
        return this.X + 0.55f;
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gA().a(GenericAttributes.s, 500.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.p, 1.0).a(GenericAttributes.d, 1.5).a(GenericAttributes.c, 30.0).a(GenericAttributes.m, 24.0);
    }

    @Override
    public boolean bg() {
        return true;
    }

    @Override
    protected float fe() {
        return 4.0f;
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        return !this.c(EntityPose.l) && !this.gy() ? this.u().b() : null;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.CS;
    }

    @Override
    protected SoundEffect j_() {
        return SoundEffects.CO;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.Dc, 10.0f, 1.0f);
    }

    @Override
    public boolean c(WorldServer worldserver, Entity entity) {
        worldserver.a((Entity)this, (byte)4);
        this.a(SoundEffects.CN, 10.0f, this.ff());
        SonicBoom.a((EntityLiving)this, 40);
        return super.c(worldserver, entity);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(bQ, 0);
    }

    public int p() {
        return this.al.a(bQ);
    }

    private void gB() {
        this.al.a(bQ, this.gE());
    }

    @Override
    public void g() {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            VibrationSystem.c.a((World)worldserver, this.cl, this.ck);
            if (this.gd() || this.Y()) {
                WardenAi.a((EntityLiving)this);
            }
        }
        super.g();
        if (this.dV().A_()) {
            if (this.af % this.gC() == 0) {
                this.ch = 10;
                if (!this.ba()) {
                    this.dV().a(this.dA(), this.dC(), this.dG(), SoundEffects.CR, this.dm(), 5.0f, this.ff(), false);
                }
            }
            this.cg = this.cf;
            if (this.cf > 0) {
                --this.cf;
            }
            this.ci = this.ch;
            if (this.ch > 0) {
                --this.ch;
            }
            switch (this.at()) {
                case n: {
                    this.a(this.c);
                    break;
                }
                case o: {
                    this.a(this.d);
                }
            }
        }
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("wardenBrain");
        this.ec().a(worldserver, this);
        gameprofilerfiller.c();
        super.a(worldserver);
        if ((this.af + this.ao()) % 120 == 0) {
            Warden.a(worldserver, this.dt(), this, 20);
        }
        if (this.af % 20 == 0) {
            this.cm.a(worldserver, this::b);
            this.gB();
        }
        WardenAi.a(this);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 4) {
            this.a.a();
            this.e.a(this.af);
        } else if (b0 == 61) {
            this.cf = 10;
        } else if (b0 == 62) {
            this.f.a(this.af);
        } else {
            super.b(b0);
        }
    }

    private int gC() {
        float f2 = (float)this.p() / (float)AngerLevel.c.a();
        return 40 - MathHelper.d(MathHelper.a(f2, 0.0f, 1.0f) * 30.0f);
    }

    public float J(float f2) {
        return MathHelper.h(f2, this.cg, this.cf) / 10.0f;
    }

    public float K(float f2) {
        return MathHelper.h(f2, this.ci, this.ch) / 10.0f;
    }

    private void a(AnimationState animationstate) {
        if ((float)animationstate.a((float)this.af) < 4500.0f) {
            RandomSource randomsource = this.dY();
            IBlockData iblockdata = this.bs();
            if (iblockdata.o() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    double d0 = this.dA() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    double d1 = this.dC();
                    double d2 = this.dG() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    this.dV().a(new ParticleParamBlock(Particles.b, iblockdata), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (aq.equals(datawatcherobject)) {
            switch (this.at()) {
                case n: {
                    this.c.a(this.af);
                    break;
                }
                case o: {
                    this.d.a(this.af);
                    break;
                }
                case l: {
                    this.a.a(this.af);
                    break;
                }
                case m: {
                    this.b.a(this.af);
                }
            }
        }
        super.a(datawatcherobject);
    }

    @Override
    public boolean a(Explosion explosion) {
        return this.gy();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return WardenAi.a(this, dynamic);
    }

    public BehaviorController<Warden> ec() {
        return super.ec();
    }

    @Override
    protected void ab() {
        super.ab();
        PacketDebug.a(this);
    }

    @Override
    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> biconsumer) {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            biconsumer.accept(this.cj, worldserver);
        }
    }

    @Contract(value="null->false")
    public boolean b(@Nullable Entity entity) {
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            if (this.dV() == entity.dV() && IEntitySelector.e.test(entity) && !this.s(entity) && entityliving.an() != EntityTypes.g && entityliving.an() != EntityTypes.bH && !entityliving.cC() && !entityliving.eH() && this.dV().E_().a(entityliving.cR())) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    public static void a(WorldServer worldserver, Vec3D vec3d, @Nullable Entity entity, int i2) {
        MobEffect mobeffect = new MobEffect(MobEffects.G, 260, 0, false, false);
        MobEffectUtil.addEffectToPlayersAround(worldserver, entity, vec3d, i2, mobeffect, 200, EntityPotionEffectEvent.Cause.WARDEN);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
        nbttagcompound.a("anger", AngerManagement.a(this::b), registryops, this.cm);
        nbttagcompound.a("listener", VibrationSystem.a.a, registryops, this.cl);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
        this.cm = nbttagcompound.a("anger", AngerManagement.a(this::b), (DynamicOps<NBTBase>)registryops).orElseGet(() -> new AngerManagement(this::b, Collections.emptyList()));
        this.gB();
        this.cl = nbttagcompound.a("listener", VibrationSystem.a.a, (DynamicOps<NBTBase>)registryops).orElseGet(VibrationSystem.a::new);
    }

    private void gD() {
        if (!this.c(EntityPose.l)) {
            this.a(this.u().c(), 10.0f, this.ff());
        }
    }

    public AngerLevel u() {
        return AngerLevel.a(this.gE());
    }

    private int gE() {
        return this.cm.b(this.e());
    }

    public void c(Entity entity) {
        this.cm.a(entity);
    }

    public void d(@Nullable Entity entity) {
        this.a(entity, 35, true);
    }

    @VisibleForTesting
    public void a(@Nullable Entity entity, int i2, boolean flag) {
        if (!this.gj() && this.b(entity)) {
            WardenAi.a((EntityLiving)this);
            boolean flag1 = !(this.e() instanceof EntityHuman);
            int j2 = this.cm.a(entity, i2);
            if (entity instanceof EntityHuman && flag1 && AngerLevel.a(j2).d()) {
                this.ec().b(MemoryModuleType.p);
            }
            if (flag) {
                this.gD();
            }
        }
    }

    public Optional<EntityLiving> gu() {
        return this.u().d() ? this.cm.a() : Optional.empty();
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.P();
    }

    @Override
    public boolean h(double d0) {
        return false;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        this.ec().a(MemoryModuleType.aF, Unit.a, 1200L);
        if (entityspawnreason == EntitySpawnReason.k) {
            this.b(EntityPose.n);
            this.ec().a(MemoryModuleType.aD, Unit.a, WardenAi.a);
            this.a(SoundEffects.CK, 5.0f, 1.0f);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        boolean flag = super.a(worldserver, damagesource, f2);
        if (!this.gj() && !this.gy()) {
            Entity entity = damagesource.d();
            this.a(entity, AngerLevel.c.a() + 20, false);
            if (this.bs.c(MemoryModuleType.p).isEmpty() && entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                if (damagesource.b() || this.a((Entity)entityliving, 5.0)) {
                    this.i(entityliving);
                }
            }
        }
        return flag;
    }

    public void i(EntityLiving entityliving) {
        this.ec().b(MemoryModuleType.az);
        this.ec().a(MemoryModuleType.p, entityliving);
        this.ec().b(MemoryModuleType.F);
        SonicBoom.a((EntityLiving)this, 200);
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        EntitySize entitysize = super.e(entitypose);
        return this.gy() ? EntitySize.c(entitysize.a(), 1.0f) : entitysize;
    }

    @Override
    public boolean bG() {
        return !this.gy() && super.bG();
    }

    @Override
    protected void D(Entity entity) {
        if (!this.gj() && !this.ec().a(MemoryModuleType.aI)) {
            this.ec().a(MemoryModuleType.aI, Unit.a, 20L);
            this.d(entity);
            WardenAi.a(this, entity.dv());
        }
        super.D(entity);
    }

    @VisibleForTesting
    public AngerManagement gv() {
        return this.cm;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new Navigation(this, this, world){

            @Override
            protected Pathfinder a(int i2) {
                this.o = new PathfinderNormal();
                return new Pathfinder(this, this.o, i2){

                    @Override
                    protected float a(PathPoint pathpoint, PathPoint pathpoint1) {
                        return pathpoint.b(pathpoint1);
                    }
                };
            }
        };
    }

    @Override
    public VibrationSystem.a gw() {
        return this.cl;
    }

    @Override
    public VibrationSystem.d gx() {
        return this.ck;
    }

    private class a
    implements VibrationSystem.d {
        private static final int b = 16;
        private final PositionSource c;

        a() {
            this.c = new EntityPositionSource(Warden.this, Warden.this.cS());
        }

        @Override
        public int a() {
            return 16;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.b;
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean a(WorldServer worldserver, BlockPosition blockposition, Holder<GameEvent> holder, GameEvent.a gameevent_a) {
            if (!(Warden.this.gj() || Warden.this.eH() || Warden.this.ec().a(MemoryModuleType.aJ) || Warden.this.gy() || !worldserver.E_().a(blockposition))) {
                EntityLiving entityliving;
                Entity entity = gameevent_a.a();
                if (entity instanceof EntityLiving && !Warden.this.b((Entity)(entityliving = (EntityLiving)entity))) {
                    boolean flag = false;
                    return flag;
                }
                boolean flag = true;
                return flag;
            }
            return false;
        }

        @Override
        public void a(WorldServer worldserver, BlockPosition blockposition, Holder<GameEvent> holder, @Nullable Entity entity, @Nullable Entity entity1, float f2) {
            if (!Warden.this.eH()) {
                Warden.this.bs.a(MemoryModuleType.aJ, Unit.a, 40L);
                worldserver.a((Entity)Warden.this, (byte)61);
                Warden.this.a(SoundEffects.Dd, 5.0f, Warden.this.ff());
                BlockPosition blockposition1 = blockposition;
                if (entity1 != null) {
                    if (Warden.this.a(entity1, 30.0)) {
                        if (Warden.this.ec().a(MemoryModuleType.aB)) {
                            if (Warden.this.b(entity1)) {
                                blockposition1 = entity1.dv();
                            }
                            Warden.this.d(entity1);
                        } else {
                            Warden.this.a(entity1, 10, true);
                        }
                    }
                    Warden.this.ec().a(MemoryModuleType.aB, Unit.a, 100L);
                } else {
                    Warden.this.d(entity);
                }
                if (!Warden.this.u().d()) {
                    Optional<EntityLiving> optional = Warden.this.cm.a();
                    if (entity1 != null || optional.isEmpty() || optional.get() == entity) {
                        WardenAi.a(Warden.this, blockposition1);
                    }
                }
            }
        }
    }
}

