/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.Behaviors;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorGolemLastSeen;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftVillager;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.VillagerReplenishTradeEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class EntityVillager
extends EntityVillagerAbstract
implements ReputationHandler,
VillagerDataHolder {
    private static final Logger bO = LogUtils.getLogger();
    private static final DataWatcherObject<VillagerData> bP = DataWatcher.a(EntityVillager.class, DataWatcherRegistry.u);
    public static final int bK = 12;
    public static final Map<Item, Integer> bL = ImmutableMap.of((Object)Items.ql, (Object)4, (Object)Items.vq, (Object)1, (Object)Items.vp, (Object)1, (Object)Items.wv, (Object)1);
    private static final int bQ = 2;
    private static final int bR = 10;
    private static final int bS = 1200;
    private static final int bT = 24000;
    private static final int bU = 10;
    private static final int bV = 5;
    private static final long bW = 24000L;
    @VisibleForTesting
    public static final float bM = 0.5f;
    private static final int bX = 0;
    private static final byte bY = 0;
    private static final int bZ = 0;
    private static final int ca = 0;
    private static final int cb = 0;
    private static final boolean cc = false;
    private int cd;
    private boolean ce;
    @Nullable
    private EntityHuman cf;
    private boolean cg;
    private int ch = 0;
    private final Reputation ci = new Reputation(this);
    private long cj;
    private long ck = 0L;
    private int cl = 0;
    private long cm = 0L;
    private int cn = 0;
    private long cq;
    private boolean cr = false;
    private static final ImmutableList<MemoryModuleType<?>> cs = ImmutableList.of(MemoryModuleType.b, MemoryModuleType.c, MemoryModuleType.d, MemoryModuleType.e, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.i, MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.M, MemoryModuleType.aQ, (Object[])new MemoryModuleType[]{MemoryModuleType.n, MemoryModuleType.o, MemoryModuleType.r, MemoryModuleType.s, MemoryModuleType.u, MemoryModuleType.w, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.z, MemoryModuleType.B, MemoryModuleType.f, MemoryModuleType.D, MemoryModuleType.E, MemoryModuleType.F, MemoryModuleType.I, MemoryModuleType.J, MemoryModuleType.K, MemoryModuleType.G});
    private static final ImmutableList<SensorType<? extends Sensor<? super EntityVillager>>> ct = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.e, SensorType.f, SensorType.g, SensorType.h, SensorType.i, SensorType.j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<EntityVillager, Holder<VillagePlaceType>>> bN = ImmutableMap.of(MemoryModuleType.b, (entityvillager, holder) -> holder.a(PoiTypes.n), MemoryModuleType.c, (entityvillager, holder) -> entityvillager.gF().b().a().b().test((Holder<VillagePlaceType>)holder), MemoryModuleType.d, (entityvillager, holder) -> VillagerProfession.a.test((Holder<VillagePlaceType>)holder), MemoryModuleType.e, (entityvillager, holder) -> holder.a(PoiTypes.o));
    public long gossipDecayInterval = 24000L;

    public EntityVillager(EntityTypes<? extends EntityVillager> entitytypes, World world) {
        this(entitytypes, world, VillagerType.c);
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entitytypes, World world, ResourceKey<VillagerType> resourcekey) {
        this(entitytypes, world, world.J_().d(resourcekey));
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entitytypes, World world, Holder<VillagerType> holder) {
        super((EntityTypes<? extends EntityVillagerAbstract>)entitytypes, world);
        ((Navigation)this.N()).b(true);
        this.N().a(true);
        this.N().a(48.0f);
        this.a_(true);
        this.a(this.gF().a(holder).b(world.J_(), VillagerProfession.b));
    }

    public BehaviorController<EntityVillager> ec() {
        return super.ec();
    }

    protected BehaviorController.b<EntityVillager> ed() {
        return BehaviorController.a(cs, ct);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        BehaviorController<EntityVillager> behaviorcontroller = this.ed().a(dynamic);
        this.a(behaviorcontroller);
        return behaviorcontroller;
    }

    public void g(WorldServer worldserver) {
        BehaviorController<EntityVillager> behaviorcontroller = this.ec();
        behaviorcontroller.b(worldserver, this);
        this.bs = behaviorcontroller.i();
        this.a(this.ec());
    }

    private void a(BehaviorController<EntityVillager> behaviorcontroller) {
        Holder<VillagerProfession> holder = this.gF().b();
        if (this.e_()) {
            behaviorcontroller.a(Schedule.e);
            behaviorcontroller.a(Activity.d, Behaviors.a(0.5f));
        } else {
            behaviorcontroller.a(Schedule.f);
            behaviorcontroller.a(Activity.c, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.b(holder, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.c, (Object)((Object)MemoryStatus.a))));
        }
        behaviorcontroller.a(Activity.a, Behaviors.a(holder, 0.5f));
        behaviorcontroller.a(Activity.f, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.d(holder, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.e, (Object)((Object)MemoryStatus.a))));
        behaviorcontroller.a(Activity.e, Behaviors.c(holder, 0.5f));
        behaviorcontroller.a(Activity.b, Behaviors.e(holder, 0.5f));
        behaviorcontroller.a(Activity.g, Behaviors.f(holder, 0.5f));
        behaviorcontroller.a(Activity.i, Behaviors.g(holder, 0.5f));
        behaviorcontroller.a(Activity.h, Behaviors.h(holder, 0.5f));
        behaviorcontroller.a(Activity.j, Behaviors.i(holder, 0.5f));
        behaviorcontroller.a((Set<Activity>)ImmutableSet.of((Object)Activity.a));
        behaviorcontroller.b(Activity.b);
        behaviorcontroller.a(Activity.b);
        behaviorcontroller.a(this.dV().af(), this.dV().ae());
    }

    @Override
    protected void h() {
        super.h();
        if (this.dV() instanceof WorldServer) {
            this.g((WorldServer)this.dV());
        }
    }

    public static AttributeProvider.Builder gD() {
        return EntityInsentient.D().a(GenericAttributes.v, 0.5);
    }

    public boolean gE() {
        return this.cr;
    }

    @Override
    public void inactiveTick() {
        if (this.dV().spigotConfig.tickInactiveVillagers && this.dj()) {
            this.a((WorldServer)this.dV());
        }
        super.inactiveTick();
    }

    @Override
    protected void a(WorldServer worldserver) {
        Raid raid;
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("villagerBrain");
        this.ec().a(worldserver, this);
        gameprofilerfiller.c();
        if (this.cr) {
            this.cr = false;
        }
        if (!this.gv() && this.cd > 0) {
            --this.cd;
            if (this.cd <= 0) {
                if (this.ce) {
                    this.hb();
                    this.ce = false;
                }
                this.addEffect(new MobEffect(MobEffects.j, 200, 0), EntityPotionEffectEvent.Cause.VILLAGER_TRADE);
            }
        }
        if (this.cf != null) {
            worldserver.a(ReputationEvent.e, (Entity)this.cf, this);
            worldserver.a((Entity)this, (byte)14);
            this.cf = null;
        }
        if (!this.gj() && this.ae.a(100) == 0 && (raid = worldserver.d(this.dv())) != null && raid.r() && !raid.a()) {
            worldserver.a((Entity)this, (byte)42);
        }
        if (this.gF().b().a(VillagerProfession.b) && this.gv()) {
            this.gA();
        }
        super.a(worldserver);
    }

    @Override
    public void g() {
        super.g();
        if (this.m() > 0) {
            this.r(this.m() - 1);
        }
        this.hd();
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (!itemstack.a(Items.uR) && this.bJ() && !this.gv() && !this.fR()) {
            if (this.e_()) {
                this.gQ();
                return EnumInteractionResult.a;
            }
            if (!this.dV().C) {
                boolean flag = this.gw().isEmpty();
                if (enumhand == EnumHand.a) {
                    if (flag) {
                        this.gQ();
                    }
                    entityhuman.a(StatisticList.S);
                }
                if (flag) {
                    return EnumInteractionResult.c;
                }
                this.g(entityhuman);
            }
            return EnumInteractionResult.a;
        }
        return super.b(entityhuman, enumhand);
    }

    public void gQ() {
        this.r(40);
        if (!this.dV().A_()) {
            this.b(SoundEffects.Ca);
        }
    }

    private void g(EntityHuman entityhuman) {
        this.h(entityhuman);
        this.a(entityhuman);
        this.a(entityhuman, this.P_(), this.gF().c());
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman) {
        boolean flag = this.gu() != null && entityhuman == null;
        super.a(entityhuman);
        if (flag) {
            this.gA();
        }
    }

    @Override
    protected void gA() {
        super.gA();
        this.gR();
    }

    private void gR() {
        if (!this.dV().A_()) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gw()) {
                merchantrecipe.n();
            }
        }
    }

    @Override
    public boolean gG() {
        return true;
    }

    public void gH() {
        this.gW();
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gw()) {
            VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            merchantrecipe.j();
        }
        this.gS();
        this.cm = this.dV().ae();
        ++this.cn;
    }

    private void gS() {
        MerchantRecipeList merchantrecipelist = this.gw();
        EntityHuman entityhuman = this.gu();
        if (entityhuman != null && !merchantrecipelist.isEmpty()) {
            entityhuman.a(entityhuman.bR.l, merchantrecipelist, this.gF().c(), this.p(), this.gx(), this.gG());
        }
    }

    private boolean gT() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gw()) {
            if (!merchantrecipe.t()) continue;
            return true;
        }
        return false;
    }

    private boolean gU() {
        return this.cn == 0 || this.cn < 2 && this.dV().ae() > this.cm + 2400L;
    }

    public boolean gI() {
        long i2 = this.cm + 12000L;
        long j2 = this.dV().ae();
        boolean flag = j2 > i2;
        long k2 = this.dV().af();
        if (this.cq > 0L) {
            long i1 = k2 / 24000L;
            long l2 = this.cq / 24000L;
            flag |= i1 > l2;
        }
        this.cq = k2;
        if (flag) {
            this.cm = j2;
            this.he();
        }
        return this.gU() && this.gT();
    }

    private void gV() {
        int i2 = 2 - this.cn;
        if (i2 > 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gw()) {
                VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                merchantrecipe.j();
            }
        }
        for (int j2 = 0; j2 < i2; ++j2) {
            this.gW();
        }
        this.gS();
    }

    private void gW() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gw()) {
            merchantrecipe.g();
        }
    }

    private void h(EntityHuman entityhuman) {
        int i2 = this.f(entityhuman);
        if (i2 != 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gw()) {
                merchantrecipe.a(-MathHelper.d((float)i2 * merchantrecipe.p()));
            }
        }
        if (entityhuman.b(MobEffects.F)) {
            MobEffect mobeffect = entityhuman.c(MobEffects.F);
            int j2 = mobeffect.e();
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe1 : this.gw()) {
                double d0 = 0.3 + 0.0625 * (double)j2;
                int k2 = (int)Math.floor(d0 * (double)merchantrecipe1.a().M());
                merchantrecipe1.a(-Math.max(k2, 1));
            }
        }
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(bP, EntityVillager.gJ());
    }

    public static VillagerData gJ() {
        return new VillagerData(BuiltInRegistries.w.b(VillagerType.c), BuiltInRegistries.x.b(VillagerProfession.b), 1);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("VillagerData", VillagerData.c, this.gF());
        nbttagcompound.a("FoodLevel", (byte)this.ch);
        nbttagcompound.a("Gossips", Reputation.a, this.ci);
        nbttagcompound.a("Xp", this.cl);
        nbttagcompound.a("LastRestock", this.cm);
        nbttagcompound.a("LastGossipDecay", this.ck);
        nbttagcompound.a("RestocksToday", this.cn);
        if (this.cr) {
            nbttagcompound.a("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.al.a(bP, nbttagcompound.a("VillagerData", VillagerData.c).orElseGet(EntityVillager::gJ));
        this.ch = nbttagcompound.b("FoodLevel", (byte)0);
        this.ci.c();
        Optional<Reputation> optional = nbttagcompound.a("Gossips", Reputation.a);
        Reputation reputation = this.ci;
        Objects.requireNonNull(this.ci);
        optional.ifPresent(reputation::a);
        this.cl = nbttagcompound.b("Xp", 0);
        this.cm = nbttagcompound.b("LastRestock", 0L);
        this.ck = nbttagcompound.b("LastGossipDecay", 0L);
        if (this.dV() instanceof WorldServer) {
            this.g((WorldServer)this.dV());
        }
        this.cn = nbttagcompound.b("RestocksToday", 0);
        this.cr = nbttagcompound.b("AssignProfessionWhenSpawned", false);
    }

    @Override
    public boolean h(double d0) {
        return false;
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        return this.fR() ? null : (this.gv() ? SoundEffects.Cb : SoundEffects.BW);
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.BZ;
    }

    @Override
    protected SoundEffect j_() {
        return SoundEffects.BY;
    }

    public void gK() {
        this.b(this.gF().b().a().f());
    }

    @Override
    public void a(VillagerData villagerdata) {
        VillagerData villagerdata1 = this.gF();
        if (!villagerdata1.b().equals(villagerdata.b())) {
            this.bJ = null;
        }
        this.al.a(bP, villagerdata);
    }

    @Override
    public VillagerData gF() {
        return this.al.a(bP);
    }

    @Override
    protected void b(net.minecraft.world.item.trading.MerchantRecipe merchantrecipe) {
        int i2 = 3 + this.ae.a(4);
        this.cl += merchantrecipe.q();
        this.cf = this.gu();
        if (this.ha()) {
            this.cd = 40;
            this.ce = true;
            i2 += 5;
        }
        if (merchantrecipe.u()) {
            this.dV().b(new EntityExperienceOrb(this.dV(), this.dA(), this.dC() + 0.5, this.dG(), i2));
        }
    }

    @Override
    public void a(@Nullable EntityLiving entityliving) {
        if (entityliving != null && this.dV() instanceof WorldServer) {
            ((WorldServer)this.dV()).a(ReputationEvent.c, (Entity)entityliving, this);
            if (this.bJ() && entityliving instanceof EntityHuman) {
                this.dV().a((Entity)this, (byte)13);
            }
        }
        super.a(entityliving);
    }

    @Override
    public void a(DamageSource damagesource) {
        Entity entity;
        if (SpigotConfig.logVillagerDeaths) {
            bO.info("Villager {} died, message: '{}'", (Object)this, (Object)damagesource.a(this).getString());
        }
        if ((entity = damagesource.d()) != null) {
            this.b(entity);
        }
        this.gX();
        super.a(damagesource);
    }

    public void gX() {
        this.a(MemoryModuleType.b);
        this.a(MemoryModuleType.c);
        this.a(MemoryModuleType.d);
        this.a(MemoryModuleType.e);
    }

    private void b(Entity entity) {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Optional<NearestVisibleLivingEntities> optional = this.bs.c(MemoryModuleType.h);
            if (!optional.isEmpty()) {
                NearestVisibleLivingEntities nearestvisiblelivingentities = optional.get();
                Objects.requireNonNull(ReputationHandler.class);
                nearestvisiblelivingentities.b(ReputationHandler.class::isInstance).forEach(entityliving -> worldserver.a(ReputationEvent.d, entity, (ReputationHandler)((Object)entityliving)));
            }
        }
    }

    public void a(MemoryModuleType<GlobalPos> memorymoduletype) {
        if (this.dV() instanceof WorldServer) {
            MinecraftServer minecraftserver = ((WorldServer)this.dV()).p();
            this.bs.c(memorymoduletype).ifPresent(globalpos -> {
                WorldServer worldserver = minecraftserver.a(globalpos.a());
                if (worldserver != null) {
                    VillagePlace villageplace = worldserver.A();
                    Optional<Holder<VillagePlaceType>> optional = villageplace.c(globalpos.b());
                    BiPredicate<EntityVillager, Holder<VillagePlaceType>> bipredicate = bN.get(memorymoduletype);
                    if (optional.isPresent() && bipredicate.test(this, optional.get())) {
                        villageplace.b(globalpos.b());
                        PacketDebug.c(worldserver, globalpos.b());
                    }
                }
            });
        }
    }

    @Override
    public boolean X_() {
        return this.ch + this.hc() >= 12 && !this.fR() && this.Y_() == 0;
    }

    private boolean gY() {
        return this.ch < 12;
    }

    private void gZ() {
        if (this.gY() && this.hc() != 0) {
            for (int i2 = 0; i2 < this.u().b(); ++i2) {
                int j2;
                Integer integer;
                ItemStack itemstack = this.u().a(i2);
                if (itemstack.f() || (integer = bL.get(itemstack.h())) == null) continue;
                for (int k2 = j2 = itemstack.M(); k2 > 0; --k2) {
                    this.ch += integer.intValue();
                    this.u().a(i2, 1);
                    if (this.gY()) continue;
                    return;
                }
            }
        }
    }

    public int f(EntityHuman entityhuman) {
        return this.ci.a(entityhuman.cG(), (ReputationType reputationtype) -> true);
    }

    private void u(int i2) {
        this.ch -= i2;
    }

    public void gL() {
        this.gZ();
        this.u(12);
    }

    public void b(MerchantRecipeList merchantrecipelist) {
        this.bJ = merchantrecipelist;
    }

    private boolean ha() {
        int i2 = this.gF().c();
        return VillagerData.d(i2) && this.cl >= VillagerData.c(i2);
    }

    public void hb() {
        this.a(this.gF().a(this.gF().c() + 1));
        this.gB();
    }

    @Override
    protected IChatBaseComponent cz() {
        return this.gF().b().a().a();
    }

    @Override
    public void b(byte b0) {
        if (b0 == 12) {
            this.a(Particles.S);
        } else if (b0 == 13) {
            this.a(Particles.a);
        } else if (b0 == 14) {
            this.a(Particles.Q);
        } else if (b0 == 42) {
            this.a(Particles.ap);
        } else {
            super.b(b0);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        if (entityspawnreason == EntitySpawnReason.e) {
            this.a(this.gF().b(worldaccess.J_(), VillagerProfession.b));
        }
        if (entityspawnreason == EntitySpawnReason.n || entityspawnreason == EntitySpawnReason.m || EntitySpawnReason.a(entityspawnreason) || entityspawnreason == EntitySpawnReason.o) {
            this.a(this.gF().a(worldaccess.J_(), VillagerType.a(worldaccess.u(this.dv()))));
        }
        if (entityspawnreason == EntitySpawnReason.d) {
            this.cr = true;
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Nullable
    public EntityVillager b(WorldServer worldserver, EntityAgeable entityageable) {
        double d0 = this.ae.j();
        Holder<VillagerType> holder = d0 < 0.5 ? worldserver.J_().d(VillagerType.a(worldserver.u(this.dv()))) : (d0 < 0.75 ? this.gF().a() : ((EntityVillager)entityageable).gF().a());
        EntityVillager entityvillager = new EntityVillager(EntityTypes.bE, (World)worldserver, holder);
        entityvillager.a((WorldAccess)worldserver, worldserver.d_(entityvillager.dv()), EntitySpawnReason.e, (GroupDataEntity)null);
        return entityvillager;
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        if (worldserver.an() != EnumDifficulty.a) {
            bO.info("Villager {} was struck by lightning {}.", (Object)this, (Object)entitylightning);
            EntityWitch entitywitch = this.convertTo(EntityTypes.bJ, ConversionParams.a(this, false, false), entitywitch1 -> {
                entitywitch1.a((WorldAccess)worldserver, worldserver.d_(entitywitch1.dv()), EntitySpawnReason.i, (GroupDataEntity)null);
                entitywitch1.gc();
                this.gX();
            }, EntityTransformEvent.TransformReason.LIGHTNING, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            if (entitywitch == null) {
                super.a(worldserver, entitylightning);
            }
        } else {
            super.a(worldserver, entitylightning);
        }
    }

    @Override
    protected void a(WorldServer worldserver, EntityItem entityitem) {
        InventoryCarrier.a(worldserver, this, this, entityitem);
    }

    @Override
    public boolean c(WorldServer worldserver, ItemStack itemstack) {
        Item item = itemstack.h();
        return (itemstack.a(TagsItem.bP) || this.gF().b().a().d().contains((Object)item)) && this.u().c(itemstack);
    }

    public boolean gM() {
        return this.hc() >= 24;
    }

    public boolean gN() {
        return this.hc() < 12;
    }

    private int hc() {
        InventorySubcontainer inventorysubcontainer = this.u();
        return bL.entrySet().stream().mapToInt(entry -> inventorysubcontainer.a_((Item)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    public boolean gO() {
        return this.u().a_((ItemStack itemstack) -> itemstack.a(TagsItem.bO));
    }

    @Override
    protected void gB() {
        VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap1;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap;
        VillagerData villagerdata = this.gF();
        ResourceKey resourcekey = villagerdata.b().e().orElse(null);
        if (resourcekey != null && (int2objectmap = this.dV().K().b(FeatureFlags.b) ? ((int2objectmap1 = VillagerTrades.c.get(resourcekey)) != null ? int2objectmap1 : VillagerTrades.a.get(resourcekey)) : VillagerTrades.a.get(resourcekey)) != null && !int2objectmap.isEmpty() && (avillagertrades_imerchantrecipeoption = (VillagerTrades.IMerchantRecipeOption[])int2objectmap.get(villagerdata.c())) != null) {
            MerchantRecipeList merchantrecipelist = this.gw();
            this.a(merchantrecipelist, avillagertrades_imerchantrecipeoption, 2);
        }
    }

    public void a(WorldServer worldserver, EntityVillager entityvillager, long i2) {
        if (!(i2 >= this.cj && i2 < this.cj + 1200L || i2 >= entityvillager.cj && i2 < entityvillager.cj + 1200L)) {
            this.ci.a(entityvillager.ci, this.ae, 10);
            this.cj = i2;
            entityvillager.cj = i2;
            this.a(worldserver, i2, 5);
        }
    }

    private void hd() {
        long i2 = this.dV().ae();
        if (this.ck == 0L) {
            this.ck = i2;
        } else if (i2 >= this.ck + this.gossipDecayInterval) {
            this.ci.b();
            this.ck = i2;
        }
    }

    public void a(WorldServer worldserver, long i2, int j2) {
        AxisAlignedBB axisalignedbb;
        List<EntityVillager> list;
        List<EntityVillager> list1;
        if (this.a(i2) && (list1 = (list = worldserver.a(EntityVillager.class, axisalignedbb = this.cR().c(10.0, 10.0, 10.0))).stream().filter(entityvillager -> entityvillager.a(i2)).limit(5L).toList()).size() >= j2 && !SpawnUtil.trySpawnMob(EntityTypes.aq, EntitySpawnReason.f, worldserver, this.dv(), 10, 8, 6, SpawnUtil.a.a, false, CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE).isEmpty()) {
            list.forEach(SensorGolemLastSeen::b);
        }
    }

    public boolean a(long i2) {
        return !this.b(this.dV().ae()) ? false : !this.bs.a(MemoryModuleType.G);
    }

    @Override
    public void a(ReputationEvent reputationevent, Entity entity) {
        Villager.ReputationEvent bukkitReputationEvent = CraftVillager.CraftReputationEvent.minecraftToBukkit(reputationevent);
        if (reputationevent == ReputationEvent.a) {
            this.ci.add(entity.cG(), ReputationType.d, 20, bukkitReputationEvent);
            this.ci.add(entity.cG(), ReputationType.c, 25, bukkitReputationEvent);
        } else if (reputationevent == ReputationEvent.e) {
            this.ci.add(entity.cG(), ReputationType.e, 2, bukkitReputationEvent);
        } else if (reputationevent == ReputationEvent.c) {
            this.ci.add(entity.cG(), ReputationType.b, 25, bukkitReputationEvent);
        } else if (reputationevent == ReputationEvent.d) {
            this.ci.add(entity.cG(), ReputationType.a, 25, bukkitReputationEvent);
        }
    }

    @Override
    public int p() {
        return this.cl;
    }

    public void t(int i2) {
        this.cl = i2;
    }

    private void he() {
        this.gV();
        this.cn = 0;
    }

    public Reputation gP() {
        return this.ci;
    }

    public void a(Reputation reputation) {
        this.ci.a(reputation);
    }

    @Override
    protected void ab() {
        super.ab();
        PacketDebug.a(this);
    }

    @Override
    public void b(BlockPosition blockposition) {
        super.b(blockposition);
        this.bs.a(MemoryModuleType.I, Long.valueOf(this.dV().ae()));
        this.bs.b(MemoryModuleType.n);
        this.bs.b(MemoryModuleType.F);
    }

    @Override
    public void fS() {
        super.fS();
        this.bs.a(MemoryModuleType.J, Long.valueOf(this.dV().ae()));
    }

    private boolean b(long i2) {
        Optional<Long> optional = this.bs.c(MemoryModuleType.I);
        return optional.filter(olong -> i2 - olong < 24000L).isPresent();
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.av ? EntityVillager.c(datacomponenttype, this.gF().a()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.av);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.av) {
            Holder<VillagerType> holder = EntityVillager.c(DataComponents.av, t0);
            this.a(this.gF().a(holder));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }
}

