/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMerchantRecipe;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;

public abstract class EntityVillagerAbstract
extends EntityAgeable
implements InventoryCarrier,
NPC,
IMerchant {
    private static final DataWatcherObject<Integer> bK = DataWatcher.a(EntityVillagerAbstract.class, DataWatcherRegistry.b);
    public static final int bI = 300;
    private static final int bL = 8;
    @Nullable
    private EntityHuman bM;
    @Nullable
    protected MerchantRecipeList bJ;
    private final InventorySubcontainer bN = new InventorySubcontainer(8, (CraftAbstractVillager)this.getBukkitEntity());

    @Override
    public CraftMerchant getCraftMerchant() {
        return (CraftAbstractVillager)this.getBukkitEntity();
    }

    public EntityVillagerAbstract(EntityTypes<? extends EntityVillagerAbstract> entitytypes, World world) {
        super((EntityTypes<? extends EntityAgeable>)entitytypes, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        if (groupdataentity == null) {
            groupdataentity = new EntityAgeable.a(false);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    public int m() {
        return this.al.a(bK);
    }

    public void r(int i2) {
        this.al.a(bK, i2);
    }

    @Override
    public int p() {
        return 0;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(bK, 0);
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman) {
        this.bM = entityhuman;
    }

    @Override
    @Nullable
    public EntityHuman gu() {
        return this.bM;
    }

    public boolean gv() {
        return this.bM != null;
    }

    @Override
    public MerchantRecipeList gw() {
        if (this.dV().C) {
            throw new IllegalStateException("Cannot load Villager offers on the client");
        }
        if (this.bJ == null) {
            this.bJ = new MerchantRecipeList();
            this.gB();
        }
        return this.bJ;
    }

    @Override
    public void a(@Nullable MerchantRecipeList merchantrecipelist) {
    }

    @Override
    public void s(int i2) {
    }

    @Override
    public void a(MerchantRecipe merchantrecipe) {
        merchantrecipe.l();
        this.bz = -this.R();
        this.b(merchantrecipe);
        if (this.bM instanceof EntityPlayer) {
            CriterionTriggers.t.a((EntityPlayer)this.bM, this, merchantrecipe.f());
        }
    }

    protected abstract void b(MerchantRecipe var1);

    @Override
    public boolean gx() {
        return true;
    }

    @Override
    public void i(ItemStack itemstack) {
        if (!this.dV().C && this.bz > -this.R() + 20) {
            this.bz = -this.R();
            this.b(this.w(!itemstack.f()));
        }
    }

    @Override
    public SoundEffect gy() {
        return SoundEffects.Cc;
    }

    protected SoundEffect w(boolean flag) {
        return flag ? SoundEffects.Cc : SoundEffects.Ca;
    }

    public void gz() {
        this.b(SoundEffects.BX);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        MerchantRecipeList merchantrecipelist;
        super.b(nbttagcompound);
        if (!this.dV().C && !(merchantrecipelist = this.gw()).isEmpty()) {
            nbttagcompound.a("Offers", MerchantRecipeList.a, this.dX().a(DynamicOpsNBT.a), merchantrecipelist);
        }
        this.b(nbttagcompound, this.dX());
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.bJ = nbttagcompound.a("Offers", MerchantRecipeList.a, (DynamicOps<NBTBase>)this.dX().a(DynamicOpsNBT.a)).orElse(null);
        this.a(nbttagcompound, this.dX());
    }

    @Override
    @Nullable
    public Entity b(TeleportTransition teleporttransition) {
        this.gA();
        return super.b(teleporttransition);
    }

    protected void gA() {
        this.a((EntityHuman)null);
    }

    @Override
    public void a(DamageSource damagesource) {
        super.a(damagesource);
        this.gA();
    }

    protected void a(ParticleParam particleparam) {
        for (int i2 = 0; i2 < 5; ++i2) {
            double d0 = this.ae.k() * 0.02;
            double d1 = this.ae.k() * 0.02;
            double d2 = this.ae.k() * 0.02;
            this.dV().a(particleparam, this.d(1.0), this.dD() + 1.0, this.g(1.0), d0, d1, d2);
        }
    }

    @Override
    public boolean w() {
        return false;
    }

    @Override
    public InventorySubcontainer u() {
        return this.bN;
    }

    @Override
    public SlotAccess a_(int i2) {
        int j2 = i2 - 300;
        return j2 >= 0 && j2 < this.bN.b() ? SlotAccess.a(this.bN, j2) : super.a_(i2);
    }

    protected abstract void gB();

    protected void a(MerchantRecipeList merchantrecipelist, VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption, int i2) {
        ArrayList arraylist = Lists.newArrayList((Object[])avillagertrades_imerchantrecipeoption);
        int j2 = 0;
        while (j2 < i2 && !arraylist.isEmpty()) {
            MerchantRecipe merchantrecipe = ((VillagerTrades.IMerchantRecipeOption)arraylist.remove(this.ae.a(arraylist.size()))).a(this, this.ae);
            if (merchantrecipe == null) continue;
            VillagerAcquireTradeEvent event = new VillagerAcquireTradeEvent((AbstractVillager)this.getBukkitEntity(), (org.bukkit.inventory.MerchantRecipe)merchantrecipe.asBukkit());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                merchantrecipelist.add(CraftMerchantRecipe.fromBukkit(event.getRecipe()).toMinecraft());
            }
            ++j2;
        }
    }

    @Override
    public Vec3D v(float f2) {
        float f1 = MathHelper.h(f2, this.aW, this.aV) * ((float)Math.PI / 180);
        Vec3D vec3d = new Vec3D(0.0, this.cR().c() - 1.0, 0.2);
        return this.p(f2).e(vec3d.b(-f1));
    }

    @Override
    public boolean gC() {
        return this.dV().C;
    }

    @Override
    public boolean e(EntityHuman entityhuman) {
        return this.gu() == entityhuman && this.bJ() && entityhuman.b((Entity)this, 4.0);
    }
}

