/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerEquipment;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftVector;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public abstract class EntityHuman
extends EntityLiving {
    public static final EnumMainHand bu = EnumMainHand.b;
    public static final int bv = 0;
    public static final int bw = 20;
    public static final int bx = 100;
    public static final int by = 10;
    public static final int bz = 200;
    public static final int bA = 499;
    public static final int bB = 500;
    public static final float bC = 4.5f;
    public static final float bD = 3.0f;
    public static final float bE = 1.5f;
    public static final float bF = 0.6f;
    public static final float bG = 0.6f;
    public static final float bH = 1.62f;
    private static final int a = 40;
    public static final Vec3D bI = new Vec3D(0.0, 0.6, 0.0);
    public static final EntitySize bJ = EntitySize.b(0.6f, 1.8f).b(1.62f).a(EntityAttachments.a().a(EntityAttachment.b, bI));
    private static final Map<EntityPose, EntitySize> b = ImmutableMap.builder().put((Object)EntityPose.a, (Object)bJ).put((Object)EntityPose.c, (Object)aD).put((Object)EntityPose.b, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.d, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.e, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.f, (Object)EntitySize.b(0.6f, 1.5f).b(1.27f).a(EntityAttachments.a().a(EntityAttachment.b, bI))).put((Object)EntityPose.h, (Object)EntitySize.c(0.2f, 0.2f).b(1.62f)).build();
    private static final DataWatcherObject<Float> c = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> d = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.b);
    protected static final DataWatcherObject<Byte> bK = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Byte> bL = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<NBTTagCompound> bM = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.t);
    protected static final DataWatcherObject<NBTTagCompound> bN = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.t);
    public static final int bO = 60;
    private static final short e = 0;
    private static final float f = 0.0f;
    private static final int g = 0;
    private static final int h = 0;
    private static final int i = 0;
    private static final int j = 0;
    private static final int k = 0;
    private static final boolean cq = false;
    private static final int cr = 0;
    private long cs;
    final PlayerInventory ct;
    protected InventoryEnderChest bP = new InventoryEnderChest(this);
    public final ContainerPlayer bQ;
    public Container bR;
    protected FoodMetaData bS = new FoodMetaData();
    protected int bT;
    private boolean cu = false;
    protected int bU = 60;
    public float bV;
    public float bW;
    public int bX;
    public double bY;
    public double bZ;
    public double ca;
    public double cb;
    public double cc;
    public double cd;
    public int cv = 0;
    protected boolean ce;
    private final PlayerAbilities cw = new PlayerAbilities();
    public int cf = 0;
    public int cg = 0;
    public float ch = 0.0f;
    public int ci = 0;
    protected final float cj = 0.02f;
    private int cx;
    private final GameProfile cy;
    private boolean cz;
    private ItemStack cA = ItemStack.l;
    private final ItemCooldown cB = this.f();
    private Optional<GlobalPos> cC = Optional.empty();
    @Nullable
    public EntityFishingHook ck;
    protected float cl;
    @Nullable
    public Vec3D cm;
    @Nullable
    public Entity cn;
    private boolean cD = false;
    private int cE = 0;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public EntityHuman(World world, BlockPosition blockposition, float f2, GameProfile gameprofile) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.bT, world);
        this.a_(gameprofile.getId());
        this.cy = gameprofile;
        this.ct = new PlayerInventory(this, this.bt);
        this.bQ = new ContainerPlayer(this.ct, !world.C, this);
        this.bR = this.bQ;
        this.b((double)blockposition.u() + 0.5, blockposition.v() + 1, (double)blockposition.w() + 0.5, f2, 0.0f);
    }

    @Override
    protected EntityEquipment eb() {
        return new PlayerEquipment(this);
    }

    public boolean a(World world, BlockPosition blockposition, EnumGamemode enumgamemode) {
        if (!enumgamemode.f()) {
            return false;
        }
        if (enumgamemode == EnumGamemode.d) {
            return true;
        }
        if (this.gw()) {
            return false;
        }
        ItemStack itemstack = this.fb();
        return itemstack.f() || !itemstack.b(new ShapeDetectorBlock(world, blockposition, false));
    }

    public static AttributeProvider.Builder fX() {
        return EntityLiving.ee().a(GenericAttributes.c, 1.0).a(GenericAttributes.v, 0.1f).a(GenericAttributes.e).a(GenericAttributes.q).a(GenericAttributes.g, 4.5).a(GenericAttributes.j, 3.0).a(GenericAttributes.f).a(GenericAttributes.C).a(GenericAttributes.z).a(GenericAttributes.t).a(GenericAttributes.D);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(c, Float.valueOf(0.0f));
        datawatcher_a.a(d, 0);
        datawatcher_a.a(bK, (byte)0);
        datawatcher_a.a(bL, (byte)bu.b());
        datawatcher_a.a(bM, new NBTTagCompound());
        datawatcher_a.a(bN, new NBTTagCompound());
    }

    @Override
    public void g() {
        this.ad = this.ak();
        if (this.ak() || this.bY()) {
            this.d(false);
        }
        if (this.bX > 0) {
            --this.bX;
        }
        if (this.fR()) {
            ++this.cv;
            if (this.cv > 100) {
                this.cv = 100;
            }
            if (!this.dV().C && this.dV().V()) {
                this.a(false, true);
            }
        } else if (this.cv > 0) {
            ++this.cv;
            if (this.cv >= 110) {
                this.cv = 0;
            }
        }
        this.gb();
        super.g();
        if (!this.dV().C && this.bR != null && !this.bR.b(this)) {
            this.o();
            this.bR = this.bQ;
        }
        this.s();
        EntityHuman entityHuman = this;
        if (entityHuman instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityHuman;
            this.bS.a(entityplayer);
            this.a(StatisticList.k);
            this.a(StatisticList.l);
            if (this.bJ()) {
                this.a(StatisticList.m);
            }
            if (this.cf()) {
                this.a(StatisticList.o);
            }
            if (!this.fR()) {
                this.a(StatisticList.n);
            }
        }
        int i2 = 29999999;
        double d0 = MathHelper.a(this.dA(), -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.a(this.dG(), -2.9999999E7, 2.9999999E7);
        if (d0 != this.dA() || d1 != this.dG()) {
            this.a_(d0, this.dC(), d1);
        }
        ++this.aS;
        ItemStack itemstack = this.fb();
        if (!ItemStack.a(this.cA, itemstack)) {
            if (!ItemStack.b(this.cA, itemstack)) {
                this.gF();
            }
            this.cA = itemstack.v();
        }
        if (!((Entity)this).a(TagsFluid.a) && this.c(Items.pc)) {
            this.m();
        }
        this.cB.a();
        this.gc();
        if (this.cE > 0) {
            --this.cE;
        }
    }

    @Override
    protected float fp() {
        return this.fG() ? 15.0f : super.fp();
    }

    public boolean fY() {
        return this.cc();
    }

    protected boolean fZ() {
        return this.cc();
    }

    protected boolean ga() {
        return this.cc();
    }

    protected boolean gb() {
        this.ce = ((Entity)this).a(TagsFluid.a);
        return this.ce;
    }

    @Override
    public void a(boolean flag, BlockPosition blockposition) {
        if (!this.gk().b) {
            super.a(flag, blockposition);
        }
    }

    @Override
    public void l(boolean flag) {
        if (!this.gk().b) {
            super.l(flag);
        }
    }

    private void m() {
        this.addEffect(new MobEffect(MobEffects.m, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
    }

    private boolean c(Item item) {
        for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
            ItemStack itemstack = this.a(enumitemslot);
            Equippable equippable = itemstack.a(DataComponents.D);
            if (!itemstack.a(item) || equippable == null || equippable.b() != enumitemslot) continue;
            return true;
        }
        return false;
    }

    protected ItemCooldown f() {
        return new ItemCooldown();
    }

    private void s() {
        this.bY = this.cb;
        this.bZ = this.cc;
        this.ca = this.cd;
        double d0 = this.dA() - this.cb;
        double d1 = this.dC() - this.cc;
        double d2 = this.dG() - this.cd;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.bY = this.cb = this.dA();
        }
        if (d2 > 10.0) {
            this.ca = this.cd = this.dG();
        }
        if (d1 > 10.0) {
            this.bZ = this.cc = this.dC();
        }
        if (d0 < -10.0) {
            this.bY = this.cb = this.dA();
        }
        if (d2 < -10.0) {
            this.ca = this.cd = this.dG();
        }
        if (d1 < -10.0) {
            this.bZ = this.cc = this.dC();
        }
        this.cb += d0 * 0.25;
        this.cd += d2 * 0.25;
        this.cc += d1 * 0.25;
    }

    protected void gc() {
        if (this.h(EntityPose.d)) {
            EntityPose entitypose = this.u();
            EntityPose entitypose1 = !(this.ak() || this.bY() || this.h(entitypose)) ? (this.h(EntityPose.f) ? EntityPose.f : EntityPose.d) : entitypose;
            this.b(entitypose1);
        }
    }

    private EntityPose u() {
        return this.fR() ? EntityPose.c : (this.cj() ? EntityPose.d : (this.fJ() ? EntityPose.b : (this.fv() ? EntityPose.e : (this.cc() && !this.cw.b ? EntityPose.f : EntityPose.a))));
    }

    protected boolean h(EntityPose entitypose) {
        return this.dV().a((Entity)this, this.a(entitypose).a(this.dt()).h(1.0E-7));
    }

    @Override
    protected SoundEffect aU() {
        return SoundEffects.vi;
    }

    @Override
    protected SoundEffect aV() {
        return SoundEffects.vg;
    }

    @Override
    protected SoundEffect aW() {
        return SoundEffects.vh;
    }

    @Override
    public int bW() {
        return 10;
    }

    @Override
    public void a(SoundEffect soundeffect, float f2, float f1) {
        this.dV().a((Entity)this, this.dA(), this.dC(), this.dG(), soundeffect, this.dm(), f2, f1);
    }

    public void a(SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.h;
    }

    @Override
    public int dn() {
        return 20;
    }

    @Override
    public void b(byte b0) {
        if (b0 == 9) {
            this.v();
        } else if (b0 == 23) {
            this.cz = false;
        } else if (b0 == 22) {
            this.cz = true;
        } else {
            super.b(b0);
        }
    }

    public void o() {
        this.bR = this.bQ;
    }

    protected void p() {
    }

    @Override
    public void q() {
        if (!this.dV().C && this.fZ() && this.bY()) {
            this.bO();
            if (!this.bY()) {
                this.g(false);
                return;
            }
        }
        super.q();
        this.bV = this.bW;
        this.bW = 0.0f;
    }

    @Override
    public void d_() {
        if (this.bT > 0) {
            --this.bT;
        }
        this.i();
        this.ct.l();
        this.bV = this.bW;
        if (this.cw.b && !this.bY()) {
            this.j();
        }
        super.d_();
        this.eZ();
        this.aX = this.dL();
        this.B((float)this.h(GenericAttributes.v));
        float f2 = this.aH() && !this.eH() && !this.cj() ? Math.min(0.1f, (float)this.dy().i()) : 0.0f;
        this.bW += (f2 - this.bW) * 0.4f;
        if (this.eG() > 0.0f && !this.ak()) {
            AxisAlignedBB axisalignedbb = this.bY() && !this.dk().dQ() ? this.cR().b(this.dk().cR()).c(1.0, 0.0, 1.0) : this.cR().c(1.0, 0.5, 1.0);
            List<Entity> list = this.dV().a_(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.an() == EntityTypes.W) {
                    list1.add(entity);
                    continue;
                }
                if (entity.dQ()) continue;
                this.d(entity);
            }
            if (!list1.isEmpty()) {
                this.d((Entity)SystemUtils.a(list1, this.ae));
            }
        }
        this.c(this.gC());
        this.c(this.gD());
        if (!this.dV().C && (this.Z > 0.5 || this.bi()) || this.cw.b || this.fR() || this.av) {
            this.gy();
        }
    }

    protected void i() {
    }

    private void c(NBTTagCompound nbttagcompound) {
        EntityTypes entitytypes;
        if (!(nbttagcompound.j() || nbttagcompound.b("Silent", false) || this.dV().A.a(200) != 0 || (entitytypes = (EntityTypes)nbttagcompound.a("id", EntityTypes.a).orElse(null)) != EntityTypes.aP || EntityParrot.a(this.dV(), this))) {
            this.dV().a((Entity)null, this.dA(), this.dC(), this.dG(), EntityParrot.a(this.dV(), this.dV().A), this.dm(), 1.0f, EntityParrot.a(this.dV().A));
        }
    }

    private void d(Entity entity) {
        entity.a_(this);
    }

    public int gd() {
        return this.al.a(d);
    }

    public void q(int i2) {
        this.al.a(d, i2);
    }

    public void r(int i2) {
        int j2 = this.gd();
        this.al.a(d, j2 + i2);
    }

    public void a(int i2, float f2, ItemStack itemstack) {
        this.bp = i2;
        this.bq = f2;
        this.br = itemstack;
        if (!this.dV().C) {
            this.gy();
            this.c(4, true);
        }
    }

    @Override
    @Nonnull
    public ItemStack dZ() {
        return this.fv() && this.br != null ? this.br : super.dZ();
    }

    @Override
    public void a(DamageSource damagesource) {
        World world;
        super.a(damagesource);
        this.av();
        if (!this.ak() && (world = this.dV()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.b(worldserver, damagesource);
        }
        if (damagesource != null) {
            this.n(-MathHelper.b((this.eM() + this.dL()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -MathHelper.a((this.eM() + this.dL()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.n(0.0, 0.1, 0.0);
        }
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aF();
        this.c(false);
        this.a(Optional.of(GlobalPos.a(this.dV().aj(), this.dv())));
    }

    @Override
    protected void f(WorldServer worldserver) {
        super.f(worldserver);
        if (!worldserver.O().c(GameRules.e)) {
            this.ge();
            this.ct.m();
        }
    }

    protected void ge() {
        for (int i2 = 0; i2 < this.ct.b(); ++i2) {
            ItemStack itemstack = this.ct.a(i2);
            if (itemstack.f() || !EnchantmentManager.a(itemstack, EnchantmentEffectComponents.D)) continue;
            this.ct.b(i2);
        }
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return damagesource.k().d().a();
    }

    @Override
    protected SoundEffect j_() {
        return SoundEffects.uY;
    }

    public void g(ItemStack itemstack) {
    }

    @Nullable
    public EntityItem a(ItemStack itemstack, boolean flag) {
        return this.a(itemstack, false, flag);
    }

    public float c(IBlockData iblockdata) {
        float f2 = this.ct.g().a(iblockdata);
        if (f2 > 1.0f) {
            f2 += (float)this.h(GenericAttributes.t);
        }
        if (MobEffectUtil.a(this)) {
            f2 *= 1.0f + (float)(MobEffectUtil.b(this) + 1) * 0.2f;
        }
        if (this.b(MobEffects.d)) {
            float f22 = switch (this.c(MobEffects.d).e()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            f2 *= f22;
        }
        f2 *= (float)this.h(GenericAttributes.f);
        if (((Entity)this).a(TagsFluid.a)) {
            f2 *= (float)this.g(GenericAttributes.C).g();
        }
        if (!this.aH()) {
            f2 /= 5.0f;
        }
        return f2;
    }

    public boolean d(IBlockData iblockdata) {
        return !iblockdata.C() || this.ct.g().b(iblockdata);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.a_(this.cy.getId());
        NBTTagList nbttaglist = nbttagcompound.p("Inventory");
        this.ct.b(nbttaglist);
        this.ct.c(nbttagcompound.b("SelectedItemSlot", 0));
        this.cv = nbttagcompound.b("SleepTimer", (short)0);
        this.ch = nbttagcompound.b("XpP", 0.0f);
        this.cf = nbttagcompound.b("XpLevel", 0);
        this.cg = nbttagcompound.b("XpTotal", 0);
        this.ci = nbttagcompound.b("XpSeed", 0);
        if (this.ci == 0) {
            this.ci = this.ae.f();
        }
        this.q(nbttagcompound.b("Score", 0));
        this.bS.a(nbttagcompound);
        this.cw.b(nbttagcompound);
        this.g(GenericAttributes.v).a(this.cw.b());
        nbttagcompound.o("EnderItems").ifPresent(nbttaglist1 -> this.bP.a((NBTTagList)nbttaglist1, this.dX()));
        this.k(nbttagcompound.n("ShoulderEntityLeft"));
        this.l(nbttagcompound.n("ShoulderEntityRight"));
        this.a(nbttagcompound.a("LastDeathLocation", GlobalPos.b));
        this.cm = nbttagcompound.a("current_explosion_impact_pos", Vec3D.a).orElse(null);
        this.cD = nbttagcompound.b("ignore_fall_damage_from_current_explosion", false);
        this.cE = nbttagcompound.b("current_impulse_context_reset_grace_time", 0);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        GameProfileSerializer.e(nbttagcompound);
        nbttagcompound.a("Inventory", this.ct.a(new NBTTagList()));
        nbttagcompound.a("SelectedItemSlot", this.ct.f());
        nbttagcompound.a("SleepTimer", (short)this.cv);
        nbttagcompound.a("XpP", this.ch);
        nbttagcompound.a("XpLevel", this.cf);
        nbttagcompound.a("XpTotal", this.cg);
        nbttagcompound.a("XpSeed", this.ci);
        nbttagcompound.a("Score", this.gd());
        this.bS.b(nbttagcompound);
        this.cw.a(nbttagcompound);
        nbttagcompound.a("EnderItems", this.bP.a(this.dX()));
        if (!this.gC().j()) {
            nbttagcompound.a("ShoulderEntityLeft", this.gC());
        }
        if (!this.gD().j()) {
            nbttagcompound.a("ShoulderEntityRight", this.gD());
        }
        this.cC.ifPresent(globalpos -> nbttagcompound.a("LastDeathLocation", GlobalPos.b, globalpos));
        nbttagcompound.b("current_explosion_impact_pos", Vec3D.a, this.cm);
        nbttagcompound.a("ignore_fall_damage_from_current_explosion", this.cD);
        nbttagcompound.a("current_impulse_context_reset_grace_time", this.cE);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return super.a(worldserver, damagesource) ? true : (damagesource.a(DamageTypeTags.n) ? !worldserver.O().c(GameRules.I) : (damagesource.a(DamageTypeTags.m) ? !worldserver.O().c(GameRules.J) : (damagesource.a(DamageTypeTags.i) ? !worldserver.O().c(GameRules.K) : (damagesource.a(DamageTypeTags.o) ? !worldserver.O().c(GameRules.L) : false))));
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        boolean damaged;
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        if (this.cw.a && !damagesource.a(DamageTypeTags.d)) {
            return false;
        }
        this.bd = 0;
        if (this.eH()) {
            return false;
        }
        if (damagesource.g()) {
            if (worldserver.an() == EnumDifficulty.a) {
                return false;
            }
            if (worldserver.an() == EnumDifficulty.b) {
                f2 = Math.min(f2 / 2.0f + 1.0f, f2);
            }
            if (worldserver.an() == EnumDifficulty.d) {
                f2 = f2 * 3.0f / 2.0f;
            }
        }
        if (damaged = super.a(worldserver, damagesource, f2)) {
            this.gy();
        }
        return damaged;
    }

    @Override
    protected void b(WorldServer worldserver, EntityLiving entityliving) {
        super.b(worldserver, entityliving);
        ItemStack itemstack = this.fH();
        BlocksAttacks blocksattacks = itemstack != null ? itemstack.a(DataComponents.I) : null;
        float f2 = entityliving.fU();
        if (f2 > 0.0f && blocksattacks != null) {
            blocksattacks.a(worldserver, this, f2, itemstack);
        }
    }

    @Override
    public boolean ez() {
        return !this.gk().a && super.ez();
    }

    public boolean a(EntityHuman entityhuman) {
        Team team;
        if (entityhuman instanceof EntityPlayer) {
            EntityPlayer thatPlayer = (EntityPlayer)entityhuman;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = entityhuman.dV().getCraftServer().getOfflinePlayer(entityhuman.cI());
            team = entityhuman.dV().getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof EntityPlayer) {
            return !team.hasPlayer((OfflinePlayer)((EntityPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.dV().getCraftServer().getOfflinePlayer(this.cI()));
    }

    @Override
    protected void c(DamageSource damagesource, float f2) {
        this.a(damagesource, f2, EnumItemSlot.c, EnumItemSlot.d, EnumItemSlot.e, EnumItemSlot.f);
    }

    @Override
    protected void d(DamageSource damagesource, float f2) {
        this.a(damagesource, f2, EnumItemSlot.f);
    }

    @Override
    protected boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        return super.actuallyHurt(worldserver, damagesource, f2, event);
    }

    public boolean W() {
        return false;
    }

    public void a(TileEntitySign tileentitysign, boolean flag) {
    }

    public void a(CommandBlockListenerAbstract commandblocklistenerabstract) {
    }

    public void a(TileEntityCommand tileentitycommand) {
    }

    public void a(TileEntityStructure tileentitystructure) {
    }

    public void a(TestBlockEntity testblockentity) {
    }

    public void a(TestInstanceBlockEntity testinstanceblockentity) {
    }

    public void a(TileEntityJigsaw tileentityjigsaw) {
    }

    public void a(EntityHorseAbstract entityhorseabstract, IInventory iinventory) {
    }

    public OptionalInt a(@Nullable ITileInventory itileinventory) {
        return OptionalInt.empty();
    }

    public void a(int i2, MerchantRecipeList merchantrecipelist, int j2, int k2, boolean flag, boolean flag1) {
    }

    public void a(ItemStack itemstack, EnumHand enumhand) {
    }

    public EnumInteractionResult a(Entity entity, EnumHand enumhand) {
        if (this.ak()) {
            if (entity instanceof ITileInventory) {
                this.a((ITileInventory)((Object)entity));
            }
            return EnumInteractionResult.e;
        }
        ItemStack itemstack = this.b(enumhand);
        ItemStack itemstack1 = itemstack.v();
        EnumInteractionResult enuminteractionresult = entity.a(this, enumhand);
        if (enuminteractionresult.a()) {
            if (this.fV() && itemstack == this.b(enumhand) && itemstack.M() < itemstack1.M()) {
                itemstack.e(itemstack1.M());
            }
            return enuminteractionresult;
        }
        if (!itemstack.f() && entity instanceof EntityLiving) {
            EnumInteractionResult enuminteractionresult1;
            if (this.fV()) {
                itemstack = itemstack1;
            }
            if ((enuminteractionresult1 = itemstack.a(this, (EntityLiving)entity, enumhand)).a()) {
                this.dV().a(GameEvent.r, entity.dt(), GameEvent.a.a(this));
                if (itemstack.f() && !this.fV()) {
                    this.a(enumhand, ItemStack.l);
                }
                return enuminteractionresult1;
            }
        }
        return EnumInteractionResult.e;
    }

    @Override
    public void aa() {
        super.aa();
        this.J = 0;
    }

    @Override
    protected boolean fg() {
        return super.fg() || this.fR();
    }

    @Override
    public boolean em() {
        return !this.cw.b;
    }

    @Override
    protected Vec3D a(Vec3D vec3d, EnumMoveType enummovetype) {
        float f2 = this.dP();
        if (!this.cw.b && vec3d.e <= 0.0 && (enummovetype == EnumMoveType.a || enummovetype == EnumMoveType.b) && this.ga() && this.I(f2)) {
            double d0;
            double d1 = vec3d.f;
            double d2 = 0.05;
            double d3 = Math.signum(d0) * 0.05;
            double d4 = Math.signum(d1) * 0.05;
            for (d0 = vec3d.d; d0 != 0.0 && this.q(d0, 0.0, f2); d0 -= d3) {
                if (!(Math.abs(d0) <= 0.05)) continue;
                d0 = 0.0;
                break;
            }
            while (d1 != 0.0 && this.q(0.0, d1, f2)) {
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    break;
                }
                d1 -= d4;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.q(d0, d1, f2)) {
                d0 = Math.abs(d0) <= 0.05 ? 0.0 : (d0 -= d3);
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    continue;
                }
                d1 -= d4;
            }
            return new Vec3D(d0, vec3d.e, d1);
        }
        return vec3d;
    }

    private boolean I(float f2) {
        return this.aH() || this.Z < (double)f2 && !this.q(0.0, 0.0, (double)f2 - this.Z);
    }

    private boolean q(double d0, double d1, double d2) {
        AxisAlignedBB axisalignedbb = this.cR();
        return this.dV().a((Entity)this, new AxisAlignedBB(axisalignedbb.a + 1.0E-7 + d0, axisalignedbb.b - d2 - 1.0E-7, axisalignedbb.c + 1.0E-7 + d1, axisalignedbb.d - 1.0E-7 + d0, axisalignedbb.b, axisalignedbb.f - 1.0E-7 + d1));
    }

    public void e(Entity entity) {
        if (entity.cB() && !entity.v(this)) {
            float f2 = this.fv() ? this.bq : (float)this.h(GenericAttributes.c);
            ItemStack itemstack = this.dZ();
            DamageSource damagesource = Optional.ofNullable(itemstack.h().a(this)).orElse(this.dW().a(this));
            float f1 = this.a(entity, f2, damagesource) - f2;
            float f22 = this.H(0.5f);
            f2 *= 0.2f + f22 * f22 * 0.8f;
            f1 *= f22;
            if (entity.an().a(TagsEntity.H) && entity instanceof IProjectile) {
                IProjectile iprojectile = (IProjectile)entity;
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(entity, damagesource, f1, false)) {
                    return;
                }
                if (iprojectile.a(ProjectileDeflection.c, this, this, true)) {
                    this.dV().a((Entity)null, this.dA(), this.dC(), this.dG(), SoundEffects.uR, this.dm());
                    return;
                }
            }
            if (f2 > 0.0f || f1 > 0.0f) {
                double d1;
                double d0;
                boolean flag2;
                boolean flag1;
                boolean flag;
                boolean bl = flag = f22 > 0.9f;
                if (this.ci() && flag) {
                    this.dV().a((Entity)null, this.dA(), this.dC(), this.dG(), SoundEffects.uQ, this.dm(), 1.0f, 1.0f);
                    flag1 = true;
                } else {
                    flag1 = false;
                }
                f2 += itemstack.h().a(entity, f2, damagesource);
                boolean bl2 = flag2 = flag && this.Z > 0.0 && !this.aH() && !this.k_() && !this.bi() && !this.b(MobEffects.o) && !this.bY() && entity instanceof EntityLiving && !this.ci();
                if (flag2) {
                    f2 *= 1.5f;
                }
                float f3 = f2 + f1;
                boolean flag3 = false;
                if (flag && !flag2 && !flag1 && this.aH() && (d0 = this.ad().j()) < MathHelper.k(d1 = (double)this.fo() * 2.5) && this.b(EnumHand.a).a(TagsItem.bI)) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                if (entity instanceof EntityLiving) {
                    EntityLiving entityliving = (EntityLiving)entity;
                    f4 = entityliving.eG();
                }
                Vec3D vec3d = entity.dy();
                boolean flag4 = entity.b(damagesource, f3);
                if (flag4) {
                    float f5 = this.b(entity, damagesource) + (flag1 ? 1.0f : 0.0f);
                    if (f5 > 0.0f) {
                        if (entity instanceof EntityLiving) {
                            EntityLiving entityliving1 = (EntityLiving)entity;
                            entityliving1.p(f5 * 0.5f, MathHelper.a(this.dL() * ((float)Math.PI / 180)), -MathHelper.b(this.dL() * ((float)Math.PI / 180)));
                        } else {
                            entity.i(-MathHelper.a(this.dL() * ((float)Math.PI / 180)) * f5 * 0.5f, 0.1, MathHelper.b(this.dL() * ((float)Math.PI / 180)) * f5 * 0.5f);
                        }
                        this.i(this.dy().d(0.6, 1.0, 0.6));
                        this.h(false);
                    }
                    if (flag3) {
                        float f6 = 1.0f + (float)this.h(GenericAttributes.D) * f2;
                        for (EntityLiving entityliving2 : this.dV().a(EntityLiving.class, entity.cR().c(1.0, 0.25, 1.0))) {
                            WorldServer worldserver;
                            EntityArmorStand entityarmorstand;
                            if (entityliving2 == this || entityliving2 == entity || this.s(entityliving2) || entityliving2 instanceof EntityArmorStand && (entityarmorstand = (EntityArmorStand)entityliving2).w() || !(this.g(entityliving2) < 9.0)) continue;
                            float f7 = this.a((Entity)entityliving2, f6, damagesource) * f22;
                            World world = this.dV();
                            if (!(world instanceof WorldServer) || !entityliving2.a(worldserver = (WorldServer)world, damagesource, f7)) continue;
                            entityliving2.p(0.4f, MathHelper.a(this.dL() * ((float)Math.PI / 180)), -MathHelper.b(this.dL() * ((float)Math.PI / 180)));
                            EnchantmentManager.a(worldserver, (Entity)entityliving2, damagesource);
                        }
                        this.dV().a((Entity)null, this.dA(), this.dC(), this.dG(), SoundEffects.uT, this.dm(), 1.0f, 1.0f);
                        this.gf();
                    }
                    if (entity instanceof EntityPlayer && entity.T) {
                        boolean cancelled = false;
                        Player player = (Player)entity.getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit(vec3d);
                        PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                        this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals((Object)event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((EntityPlayer)entity).f.b(new PacketPlayOutEntityVelocity(entity));
                            entity.T = false;
                            entity.i(vec3d);
                        }
                    }
                    if (flag2) {
                        this.dV().a((Entity)null, this.dA(), this.dC(), this.dG(), SoundEffects.uP, this.dm(), 1.0f, 1.0f);
                        this.b(entity);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            this.dV().a((Entity)null, this.dA(), this.dC(), this.dG(), SoundEffects.uS, this.dm(), 1.0f, 1.0f);
                        } else {
                            this.dV().a((Entity)null, this.dA(), this.dC(), this.dG(), SoundEffects.uU, this.dm(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.c(entity);
                    }
                    this.B(entity);
                    Entity entity1 = entity;
                    if (entity instanceof EntityComplexPart) {
                        entity1 = ((EntityComplexPart)entity).a;
                    }
                    boolean flag5 = false;
                    World world1 = this.dV();
                    if (world1 instanceof WorldServer) {
                        WorldServer worldserver1 = (WorldServer)world1;
                        if (entity1 instanceof EntityLiving) {
                            EntityLiving entityliving3 = (EntityLiving)entity1;
                            flag5 = itemstack.a(entityliving3, (EntityLiving)this);
                        }
                        EnchantmentManager.a(worldserver1, entity, damagesource);
                    }
                    if (!this.dV().C && !itemstack.f() && entity1 instanceof EntityLiving) {
                        if (flag5) {
                            itemstack.b((EntityLiving)entity1, (EntityLiving)this);
                        }
                        if (itemstack.f()) {
                            if (itemstack == this.fb()) {
                                this.a(EnumHand.a, ItemStack.l);
                            } else {
                                this.a(EnumHand.b, ItemStack.l);
                            }
                        }
                    }
                    if (entity instanceof EntityLiving) {
                        float f8 = f4 - ((EntityLiving)entity).eG();
                        this.a(StatisticList.G, Math.round(f8 * 10.0f));
                        if (this.dV() instanceof WorldServer && f8 > 2.0f) {
                            int i2 = (int)((double)f8 * 0.5);
                            ((WorldServer)this.dV()).a(Particles.g, entity.dA(), entity.e(0.5), entity.dG(), i2, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.causeFoodExhaustion(this.dV().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                } else {
                    this.dV().a((Entity)null, this.dA(), this.dC(), this.dG(), SoundEffects.uR, this.dm(), 1.0f, 1.0f);
                    if (this instanceof EntityPlayer) {
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                    }
                }
            }
        }
    }

    protected float a(Entity entity, float f2, DamageSource damagesource) {
        return f2;
    }

    @Override
    protected void f(EntityLiving entityliving) {
        this.e((Entity)entityliving);
    }

    public void b(Entity entity) {
    }

    public void c(Entity entity) {
    }

    public void gf() {
        double d0 = -MathHelper.a(this.dL() * ((float)Math.PI / 180));
        double d1 = MathHelper.b(this.dL() * ((float)Math.PI / 180));
        if (this.dV() instanceof WorldServer) {
            ((WorldServer)this.dV()).a(Particles.am, this.dA() + d0, this.e(0.5), this.dG() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    public void gg() {
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        super.remove(entity_removalreason, cause);
        this.bQ.a(this);
        if (this.bR != null && this.gm()) {
            this.p();
        }
    }

    @Override
    public boolean Z_() {
        return true;
    }

    @Override
    protected boolean dh() {
        return this.gh();
    }

    public boolean gh() {
        return false;
    }

    @Override
    public boolean di() {
        return !this.dV().C || this.gh();
    }

    @Override
    public boolean dj() {
        return !this.dV().C || this.gh();
    }

    public GameProfile gi() {
        return this.cy;
    }

    public PlayerInventory gj() {
        return this.ct;
    }

    public PlayerAbilities gk() {
        return this.cw;
    }

    @Override
    public boolean fV() {
        return this.cw.d;
    }

    public boolean gl() {
        return this.cw.d;
    }

    public void a(ItemStack itemstack, ItemStack itemstack1, ClickAction clickaction) {
    }

    public boolean gm() {
        return this.bR != this.bQ;
    }

    public boolean gn() {
        return true;
    }

    public Either<EnumBedResult, Unit> a(BlockPosition blockposition) {
        return this.startSleepInBed(blockposition, false);
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        this.b(blockposition);
        this.cv = 0;
        return Either.right((Object)((Object)Unit.a));
    }

    public void a(boolean flag, boolean flag1) {
        super.fS();
        if (this.dV() instanceof WorldServer && flag1) {
            ((WorldServer)this.dV()).f();
        }
        this.cv = flag ? 0 : 100;
    }

    @Override
    public void fS() {
        this.a(true, true);
    }

    public boolean go() {
        return this.fR() && this.cv >= 100;
    }

    public int gp() {
        return this.cv;
    }

    public void a(IChatBaseComponent ichatbasecomponent, boolean flag) {
    }

    public void a(MinecraftKey minecraftkey) {
        this.b(StatisticList.i.b(minecraftkey));
    }

    public void a(MinecraftKey minecraftkey, int i2) {
        this.a(StatisticList.i.b(minecraftkey), i2);
    }

    public void b(Statistic<?> statistic) {
        this.a(statistic, 1);
    }

    public void a(Statistic<?> statistic, int i2) {
    }

    public void a(Statistic<?> statistic) {
    }

    public int a(Collection<RecipeHolder<?>> collection) {
        return 0;
    }

    public void a(RecipeHolder<?> recipeholder, List<ItemStack> list) {
    }

    public void b(List<ResourceKey<IRecipe<?>>> list) {
    }

    public int b(Collection<RecipeHolder<?>> collection) {
        return 0;
    }

    @Override
    public void a_(Vec3D vec3d) {
        if (this.bY()) {
            super.a_(vec3d);
        } else {
            if (this.cj()) {
                double d1;
                double d0 = this.bS().e;
                double d2 = d1 = d0 < -0.2 ? 0.085 : 0.06;
                if (d0 <= 0.0 || this.bf || !this.dV().b_(BlockPosition.a(this.dA(), this.dC() + 1.0 - 0.1, this.dG())).c()) {
                    Vec3D vec3d1 = this.dy();
                    this.i(vec3d1.b(0.0, (d0 - vec3d1.e) * d1, 0.0));
                }
            }
            if (this.gk().b) {
                double d2 = this.dy().e;
                super.a_(vec3d);
                this.i(this.dy().a(EnumDirection.EnumAxis.b, d2 * 0.6));
            } else {
                super.a_(vec3d);
            }
        }
    }

    @Override
    protected boolean ft() {
        return !this.cw.b && super.ft();
    }

    @Override
    public void bn() {
        if (this.cw.b) {
            this.i(false);
        } else {
            super.bn();
        }
    }

    protected boolean h(BlockPosition blockposition) {
        return !this.dV().a_(blockposition).j(this.dV(), blockposition);
    }

    @Override
    public float fo() {
        return (float)this.h(GenericAttributes.v);
    }

    @Override
    public boolean a(double d0, float f2, DamageSource damagesource) {
        double d1;
        boolean flag;
        if (this.cw.c) {
            return false;
        }
        if (d0 >= 2.0) {
            this.a(StatisticList.t, (int)Math.round(d0 * 100.0));
        }
        boolean bl = flag = this.cm != null && this.cD;
        if (flag) {
            boolean flag1;
            d1 = Math.min(d0, this.cm.e - this.dC());
            boolean bl2 = flag1 = d1 <= 0.0;
            if (flag1) {
                this.gQ();
            } else {
                this.gP();
            }
        } else {
            d1 = d0;
        }
        if (d1 > 0.0 && super.a(d1, f2, damagesource)) {
            this.gQ();
            return true;
        }
        this.b(d0, f2, damagesource);
        return false;
    }

    public boolean gq() {
        if (!this.fJ() && this.ft() && !this.bi()) {
            this.gr();
            return true;
        }
        return false;
    }

    public void gr() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.b(7, true);
        } else {
            this.b(7, true);
            this.b(7, false);
        }
    }

    @Override
    protected void bq() {
        if (!this.ak()) {
            super.bq();
        }
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        if (this.bi()) {
            this.aX();
            this.b(iblockdata);
        } else {
            BlockPosition blockposition1 = this.e(blockposition);
            if (!blockposition.equals(blockposition1)) {
                IBlockData iblockdata1 = this.dV().a_(blockposition1);
                if (iblockdata1.a(TagsBlock.br)) {
                    this.a(iblockdata1, iblockdata);
                } else {
                    super.b(blockposition1, iblockdata1);
                }
            } else {
                super.b(blockposition, iblockdata);
            }
        }
    }

    @Override
    public EntityLiving.a eO() {
        return new EntityLiving.a(SoundEffects.vf, SoundEffects.uV);
    }

    @Override
    public boolean a(WorldServer worldserver, EntityLiving entityliving) {
        this.b(StatisticList.g.b(entityliving.an()));
        return true;
    }

    @Override
    public void a(IBlockData iblockdata, Vec3D vec3d) {
        if (!this.cw.b) {
            super.a(iblockdata, vec3d);
        }
        this.gP();
    }

    public void d(int i2) {
        this.r(i2);
        this.ch += (float)i2 / (float)this.gt();
        this.cg = MathHelper.a(this.cg + i2, 0, Integer.MAX_VALUE);
        while (this.ch < 0.0f) {
            float f2 = this.ch * (float)this.gt();
            if (this.cf > 0) {
                this.c(-1);
                this.ch = 1.0f + f2 / (float)this.gt();
                continue;
            }
            this.c(-1);
            this.ch = 0.0f;
        }
        while (this.ch >= 1.0f) {
            this.ch = (this.ch - 1.0f) * (float)this.gt();
            this.c(1);
            this.ch /= (float)this.gt();
        }
    }

    public int gs() {
        return this.ci;
    }

    public void a(ItemStack itemstack, int i2) {
        this.cf -= i2;
        if (this.cf < 0) {
            this.cf = 0;
            this.ch = 0.0f;
            this.cg = 0;
        }
        this.ci = this.ae.f();
    }

    public void c(int i2) {
        this.cf = IntMath.saturatedAdd((int)this.cf, (int)i2);
        if (this.cf < 0) {
            this.cf = 0;
            this.ch = 0.0f;
            this.cg = 0;
        }
        if (i2 > 0 && this.cf % 5 == 0 && (float)this.cx < (float)this.af - 100.0f) {
            float f2 = this.cf > 30 ? 1.0f : (float)this.cf / 30.0f;
            this.dV().a((Entity)null, this.dA(), this.dC(), this.dG(), SoundEffects.ve, this.dm(), f2 * 0.75f, 1.0f);
            this.cx = this.af;
        }
    }

    public int gt() {
        return this.cf >= 30 ? 112 + (this.cf - 30) * 9 : (this.cf >= 15 ? 37 + (this.cf - 15) * 5 : 7 + this.cf * 2);
    }

    public void G(float f2) {
        this.causeFoodExhaustion(f2, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float f2, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.cw.a || this.dV().C || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, f2)).isCancelled())) {
            this.bS.a(event.getExhaustion());
        }
    }

    public Optional<WardenSpawnTracker> Y() {
        return Optional.empty();
    }

    public FoodMetaData gu() {
        return this.bS;
    }

    public boolean t(boolean flag) {
        return this.cw.a || flag || this.bS.b();
    }

    public boolean gv() {
        return this.eG() > 0.0f && this.eG() < this.eU();
    }

    public boolean gw() {
        return this.cw.e;
    }

    public boolean a(BlockPosition blockposition, EnumDirection enumdirection, ItemStack itemstack) {
        if (this.cw.e) {
            return true;
        }
        BlockPosition blockposition1 = blockposition.a(enumdirection.g());
        ShapeDetectorBlock shapedetectorblock = new ShapeDetectorBlock(this.dV(), blockposition1, false);
        return itemstack.a(shapedetectorblock);
    }

    @Override
    protected int e(WorldServer worldserver) {
        return !worldserver.O().c(GameRules.e) && !this.ak() ? Math.min(this.cf * 7, 100) : 0;
    }

    @Override
    protected boolean eq() {
        return true;
    }

    @Override
    public boolean cM() {
        return true;
    }

    @Override
    protected Entity.MovementEmission bf() {
        return this.cw.b || this.aH() && this.cf() ? Entity.MovementEmission.a : Entity.MovementEmission.d;
    }

    public void w() {
    }

    @Override
    public IChatBaseComponent ah() {
        return IChatBaseComponent.b(this.cy.getName());
    }

    public InventoryEnderChest gx() {
        return this.bP;
    }

    @Override
    protected boolean b(EnumItemSlot enumitemslot) {
        return enumitemslot.a() == EnumItemSlot.Function.b;
    }

    public boolean h(ItemStack itemstack) {
        return this.ct.g(itemstack);
    }

    public boolean j(NBTTagCompound nbttagcompound) {
        if (!this.bY() && this.aH() && !this.bi() && !this.av) {
            if (this.gC().j()) {
                this.k(nbttagcompound);
                this.cs = this.dV().ae();
                return true;
            }
            if (this.gD().j()) {
                this.l(nbttagcompound);
                this.cs = this.dV().ae();
                return true;
            }
            return false;
        }
        return false;
    }

    protected void gy() {
        if (this.cs + 20L < this.dV().ae()) {
            if (this.respawnEntityOnShoulder(this.gC())) {
                this.k(new NBTTagCompound());
            }
            if (this.respawnEntityOnShoulder(this.gD())) {
                this.l(new NBTTagCompound());
            }
        }
    }

    private boolean respawnEntityOnShoulder(NBTTagCompound nbttagcompound) {
        if (!this.dV().C && !nbttagcompound.j()) {
            return EntityTypes.a(nbttagcompound, this.dV(), EntitySpawnReason.r).map(entity -> {
                if (entity instanceof EntityTameableAnimal) {
                    EntityTameableAnimal entitytameableanimal = (EntityTameableAnimal)entity;
                    entitytameableanimal.i(this);
                }
                entity.a_(this.dA(), this.dC() + (double)0.7f, this.dG());
                return ((WorldServer)this.dV()).addWithUUID((Entity)entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY);
            }).orElse(true);
        }
        return true;
    }

    @Nullable
    public abstract EnumGamemode a();

    @Override
    public boolean ak() {
        return this.a() == EnumGamemode.d;
    }

    @Override
    public boolean bE() {
        return !this.ak() && super.bE();
    }

    @Override
    public boolean cj() {
        return !this.cw.b && !this.ak() && super.cj();
    }

    public boolean gz() {
        return this.a() == EnumGamemode.b;
    }

    @Override
    public boolean cJ() {
        return !this.cw.b;
    }

    public Scoreboard gA() {
        return this.dV().R();
    }

    @Override
    public IChatBaseComponent P_() {
        IChatMutableComponent ichatmutablecomponent = ScoreboardTeam.a(this.cq(), this.ah());
        return this.a(ichatmutablecomponent);
    }

    private IChatMutableComponent a(IChatMutableComponent ichatmutablecomponent) {
        String s2 = this.gi().getName();
        return ichatmutablecomponent.a(chatmodifier -> chatmodifier.a(new ChatClickable.SuggestCommand("/tell " + s2 + " ")).a(this.cQ()).a(s2));
    }

    @Override
    public String cI() {
        return this.gi().getName();
    }

    @Override
    protected void F(float f2) {
        this.ar().a(c, Float.valueOf(f2));
    }

    @Override
    public float fw() {
        return this.ar().a(c).floatValue();
    }

    public boolean a(PlayerModelPart playermodelpart) {
        return (this.ar().a(bK) & playermodelpart.a()) == playermodelpart.a();
    }

    @Override
    public SlotAccess a_(int i2) {
        if (i2 == 499) {
            return new SlotAccess(){

                @Override
                public ItemStack a() {
                    return EntityHuman.this.bR.g();
                }

                @Override
                public boolean a(ItemStack itemstack) {
                    EntityHuman.this.bR.a(itemstack);
                    return true;
                }
            };
        }
        final int j2 = i2 - 500;
        if (j2 >= 0 && j2 < 4) {
            return new SlotAccess(){

                @Override
                public ItemStack a() {
                    return EntityHuman.this.bQ.r().a(j2);
                }

                @Override
                public boolean a(ItemStack itemstack) {
                    EntityHuman.this.bQ.r().a(j2, itemstack);
                    EntityHuman.this.bQ.a(EntityHuman.this.ct);
                    return true;
                }
            };
        }
        if (i2 >= 0 && i2 < this.ct.i().size()) {
            return SlotAccess.a(this.ct, i2);
        }
        int k2 = i2 - 200;
        return k2 >= 0 && k2 < this.bP.b() ? SlotAccess.a(this.bP, k2) : super.a_(i2);
    }

    public boolean gB() {
        return this.cz;
    }

    public void u(boolean flag) {
        this.cz = flag;
    }

    @Override
    public void h(int i2) {
        super.h(this.cw.a ? Math.min(i2, 1) : i2);
    }

    @Override
    public EnumMainHand fy() {
        return this.al.a(bL) == 0 ? EnumMainHand.a : EnumMainHand.b;
    }

    public void b(EnumMainHand enummainhand) {
        this.al.a(bL, (byte)(enummainhand != EnumMainHand.a ? 1 : 0));
    }

    public NBTTagCompound gC() {
        return this.al.a(bM);
    }

    public void k(NBTTagCompound nbttagcompound) {
        this.al.a(bM, nbttagcompound);
    }

    public NBTTagCompound gD() {
        return this.al.a(bN);
    }

    public void l(NBTTagCompound nbttagcompound) {
        this.al.a(bN, nbttagcompound);
    }

    public float gE() {
        return (float)(1.0 / this.h(GenericAttributes.e) * 20.0);
    }

    public float H(float f2) {
        return MathHelper.a(((float)this.aS + f2) / this.gE(), 0.0f, 1.0f);
    }

    public void gF() {
        this.aS = 0;
    }

    public ItemCooldown gG() {
        return this.cB;
    }

    @Override
    protected float aS() {
        return !this.cw.b && !this.fJ() ? super.aS() : 1.0f;
    }

    @Override
    public float eh() {
        return (float)this.h(GenericAttributes.q);
    }

    public boolean gH() {
        return this.cw.d && this.F() >= 2;
    }

    public int F() {
        return 0;
    }

    public boolean s(int i2) {
        return this.F() >= i2;
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return b.getOrDefault((Object)entitypose, bJ);
    }

    @Override
    public ImmutableList<EntityPose> fO() {
        return ImmutableList.of((Object)((Object)EntityPose.a), (Object)((Object)EntityPose.f), (Object)((Object)EntityPose.d));
    }

    @Override
    public ItemStack d(ItemStack itemstack) {
        if (!(itemstack.h() instanceof ItemProjectileWeapon)) {
            return ItemStack.l;
        }
        Predicate<ItemStack> predicate = ((ItemProjectileWeapon)itemstack.h()).c();
        ItemStack itemstack1 = ItemProjectileWeapon.a(this, predicate);
        if (!itemstack1.f()) {
            return itemstack1;
        }
        predicate = ((ItemProjectileWeapon)itemstack.h()).a();
        for (int i2 = 0; i2 < this.ct.b(); ++i2) {
            ItemStack itemstack2 = this.ct.a(i2);
            if (!predicate.test(itemstack2)) continue;
            return itemstack2;
        }
        return this.fV() ? new ItemStack(Items.pk) : ItemStack.l;
    }

    @Override
    public Vec3D v(float f2) {
        float f3;
        double d0 = 0.22 * (this.fy() == EnumMainHand.b ? -1.0 : 1.0);
        float f1 = MathHelper.h(f2 * 0.5f, this.dN(), this.O) * ((float)Math.PI / 180);
        float f22 = MathHelper.h(f2, this.aW, this.aV) * ((float)Math.PI / 180);
        if (!this.fJ() && !this.fv()) {
            if (this.ck()) {
                return this.p(f2).e(new Vec3D(d0, 0.2, -0.15).a(-f1).b(-f22));
            }
            double d1 = this.cR().c() - 1.0;
            double d2 = this.ch() ? -0.2 : 0.07;
            return this.p(f2).e(new Vec3D(d0, d1, d2).b(-f22));
        }
        Vec3D vec3d = this.h(f2);
        Vec3D vec3d1 = this.dy();
        double d3 = vec3d1.j();
        double d4 = vec3d.j();
        if (d3 > 0.0 && d4 > 0.0) {
            double d5 = (vec3d1.d * vec3d.d + vec3d1.f * vec3d.f) / Math.sqrt(d3 * d4);
            double d6 = vec3d1.d * vec3d.f - vec3d1.f * vec3d.d;
            f3 = (float)(Math.signum(d6) * Math.acos(d5));
        } else {
            f3 = 0.0f;
        }
        return this.p(f2).e(new Vec3D(d0, -0.11, 0.85).c(-f3).a(-f1).b(-f22));
    }

    @Override
    public boolean dU() {
        return true;
    }

    public boolean gI() {
        return this.fz() && this.fB().a(Items.sf);
    }

    @Override
    public boolean dT() {
        return false;
    }

    public Optional<GlobalPos> gJ() {
        return this.cC;
    }

    public void a(Optional<GlobalPos> optional) {
        this.cC = optional;
    }

    @Override
    public float eM() {
        return this.cl;
    }

    @Override
    public void q(float f2) {
        super.q(f2);
        this.cl = f2;
    }

    @Override
    public boolean dO() {
        return true;
    }

    @Override
    protected float fn() {
        return this.cw.b && !this.bY() ? (this.ci() ? this.cw.a() * 2.0f : this.cw.a()) : (this.ci() ? 0.025999999f : 0.02f);
    }

    public boolean gK() {
        return this.cu || this.bU <= 0;
    }

    public void gL() {
        if (!this.cu) {
            --this.bU;
        }
    }

    public void v(boolean flag) {
        this.cu = flag;
        if (!this.cu) {
            this.bU = 60;
        }
    }

    public double gM() {
        return this.h(GenericAttributes.g);
    }

    public double gN() {
        return this.h(GenericAttributes.j);
    }

    public boolean b(Entity entity, double d0) {
        return entity.dQ() ? false : this.a(entity.cR(), d0);
    }

    public boolean a(AxisAlignedBB axisalignedbb, double d0) {
        double d1 = this.gN() + d0;
        return axisalignedbb.e(this.bD()) < d1 * d1;
    }

    public boolean a(BlockPosition blockposition, double d0) {
        double d1 = this.gM() + d0;
        return new AxisAlignedBB(blockposition).e(this.bD()) < d1 * d1;
    }

    public void w(boolean flag) {
        this.cD = flag;
        this.cE = flag ? 40 : 0;
    }

    public boolean gO() {
        return this.cD;
    }

    public void gP() {
        if (this.cE == 0) {
            this.gQ();
        }
    }

    public void gQ() {
        this.cE = 0;
        this.cn = null;
        this.cm = null;
        this.cD = false;
    }

    public boolean gR() {
        return false;
    }

    @Override
    public boolean k_() {
        return this.cw.b ? false : super.k_();
    }

    public String gS() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.ah().getString()).add("id", this.ao()).add("pos", (Object)this.dt()).add("mode", (Object)this.a()).add("permission", this.F()).toString();
    }

    public static enum EnumBedResult {
        a,
        b(IChatBaseComponent.c("block.minecraft.bed.no_sleep")),
        c(IChatBaseComponent.c("block.minecraft.bed.too_far_away")),
        d(IChatBaseComponent.c("block.minecraft.bed.obstructed")),
        e,
        f(IChatBaseComponent.c("block.minecraft.bed.not_safe"));

        @Nullable
        private final IChatBaseComponent g;

        private EnumBedResult() {
            this.g = null;
        }

        private EnumBedResult(IChatBaseComponent ichatbasecomponent) {
            this.g = ichatbasecomponent;
        }

        @Nullable
        public IChatBaseComponent a() {
            return this.g;
        }
    }
}

