/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftItem;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;

public abstract class EntityArrow
extends IProjectile {
    private static final double d = 2.0;
    private static final int e = 7;
    private static final float f = 0.6f;
    private static final float g = 0.99f;
    private static final short h = 0;
    private static final byte i = 0;
    private static final boolean j = false;
    private static final boolean k = false;
    private static final byte l = 0;
    private static final DataWatcherObject<Byte> m = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> n = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Boolean> o = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.k);
    private static final int p = 1;
    private static final int q = 2;
    @Nullable
    private IBlockData r;
    protected int a;
    public PickupStatus b = PickupStatus.a;
    public int c = 0;
    public int s = 0;
    public double t = 2.0;
    private SoundEffect u = this.i();
    @Nullable
    private IntOpenHashSet ay;
    @Nullable
    private List<Entity> az;
    public ItemStack aA = this.n();
    @Nullable
    public ItemStack aB = null;

    @Override
    public void inactiveTick() {
        if (this.e()) {
            ++this.s;
        }
        super.inactiveTick();
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entitytypes, World world) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entitytypes, double d0, double d1, double d2, World world, ItemStack itemstack, @Nullable ItemStack itemstack1) {
        this(entitytypes, d0, d1, d2, world, itemstack, itemstack1, null);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entitytypes, double d0, double d1, double d2, World world, ItemStack itemstack, @Nullable ItemStack itemstack1, @Nullable EntityLiving ownerEntity) {
        this(entitytypes, world);
        this.c(ownerEntity);
        this.aA = itemstack.v();
        this.c(itemstack);
        Unit unit = itemstack.e(DataComponents.u);
        if (unit != null) {
            this.b = PickupStatus.c;
        }
        this.a_(d0, d1, d2);
        if (itemstack1 != null && world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (itemstack1.f()) {
                throw new IllegalArgumentException("Invalid weapon firing an arrow");
            }
            this.aB = itemstack1.v();
            int i2 = EnchantmentManager.a(worldserver, itemstack1, this.aA);
            if (i2 > 0) {
                this.a((byte)i2);
            }
        }
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entitytypes, EntityLiving entityliving, World world, ItemStack itemstack, @Nullable ItemStack itemstack1) {
        this(entitytypes, entityliving.dA(), entityliving.dE() - (double)0.1f, entityliving.dG(), world, itemstack, itemstack1, entityliving);
    }

    public void b(SoundEffect soundeffect) {
        this.u = soundeffect;
    }

    @Override
    public boolean a(double d0) {
        double d1 = this.cR().a() * 10.0;
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return d0 < (d1 *= 64.0 * EntityArrow.cK()) * d1;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(m, (byte)0);
        datawatcher_a.a(n, (byte)0);
        datawatcher_a.a(o, false);
    }

    @Override
    public void c(double d0, double d1, double d2, float f2, float f1) {
        super.c(d0, d1, d2, f2, f1);
        this.s = 0;
    }

    @Override
    public void k(double d0, double d1, double d2) {
        super.k(d0, d1, d2);
        this.s = 0;
        if (this.e() && MathHelper.f(d0, d1, d2) > 0.0) {
            this.a(false);
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        super.a(datawatcherobject);
        if (!this.ak && this.c <= 0 && datawatcherobject.equals(o) && this.e()) {
            this.c = 7;
        }
    }

    @Override
    public void g() {
        VoxelShape voxelshape;
        boolean flag = !this.v();
        Vec3D vec3d = this.dy();
        BlockPosition blockposition = this.dv();
        IBlockData iblockdata = this.dV().a_(blockposition);
        if (!iblockdata.l() && flag && !(voxelshape = iblockdata.g(this.dV(), blockposition)).c()) {
            Vec3D vec3d1 = this.dt();
            for (AxisAlignedBB axisalignedbb : voxelshape.e()) {
                if (!axisalignedbb.a(blockposition).d(vec3d1)) continue;
                this.i(Vec3D.c);
                this.a(true);
                break;
            }
        }
        if (this.c > 0) {
            --this.c;
        }
        if (this.bk() || iblockdata.a(Blocks.rx)) {
            this.aF();
        }
        if (this.e() && flag) {
            if (!this.dV().A_()) {
                if (this.r != iblockdata && this.x()) {
                    this.A();
                } else {
                    this.f();
                }
            }
            ++this.a;
            if (this.bJ()) {
                this.aI();
            }
            if (!this.dV().C) {
                this.c(this.aE() > 0);
            }
        } else {
            this.a = 0;
            Vec3D vec3d2 = this.dt();
            if (this.bi()) {
                this.b(this.u());
                this.a(vec3d2);
            }
            if (this.s()) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.dV().a(Particles.f, vec3d2.d + vec3d.d * (double)i2 / 4.0, vec3d2.e + vec3d.e * (double)i2 / 4.0, vec3d2.f + vec3d.f * (double)i2 / 4.0, -vec3d.d, -vec3d.e + 0.2, -vec3d.f);
                }
            }
            float f2 = !flag ? (float)(MathHelper.d(-vec3d.d, -vec3d.f) * 57.2957763671875) : (float)(MathHelper.d(vec3d.d, vec3d.f) * 57.2957763671875);
            float f1 = (float)(MathHelper.d(vec3d.e, vec3d.i()) * 57.2957763671875);
            this.x(EntityArrow.f(this.dN(), f1));
            this.w(EntityArrow.f(this.dL(), f2));
            if (flag) {
                MovingObjectPositionBlock movingobjectpositionblock = this.dV().b(new RayTrace(vec3d2, vec3d2.e(vec3d), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                this.b(movingobjectpositionblock);
            } else {
                this.b(vec3d2.e(vec3d));
                this.aI();
            }
            if (!this.bi()) {
                this.b(0.99f);
            }
            if (flag && !this.e()) {
                this.be();
            }
            super.g();
        }
    }

    private void b(MovingObjectPositionBlock movingobjectpositionblock) {
        while (this.bJ()) {
            Vec3D vec3d = this.dt();
            MovingObjectPositionEntity movingobjectpositionentity = this.b(vec3d, movingobjectpositionblock.g());
            Vec3D vec3d1 = ((MovingObjectPosition)Objects.requireNonNullElse(movingobjectpositionentity, movingobjectpositionblock)).g();
            this.b(vec3d1);
            this.a(vec3d, vec3d1);
            if (this.as != null && this.as.e()) {
                this.bV();
            }
            if (movingobjectpositionentity == null) {
                if (!this.bJ() || movingobjectpositionblock.d() == MovingObjectPosition.EnumMovingObjectType.a) break;
                this.preHitTargetOrDeflectSelf(movingobjectpositionblock);
                this.ar = true;
                break;
            }
            if (!this.bJ() || this.ad) continue;
            ProjectileDeflection projectiledeflection = this.preHitTargetOrDeflectSelf(movingobjectpositionentity);
            this.ar = true;
            if (this.t() > 0 && projectiledeflection == ProjectileDeflection.a) continue;
        }
    }

    private void b(float f2) {
        Vec3D vec3d = this.dy();
        this.i(vec3d.c((double)f2));
    }

    private void a(Vec3D vec3d) {
        Vec3D vec3d1 = this.dy();
        for (int i2 = 0; i2 < 4; ++i2) {
            float f2 = 0.25f;
            this.dV().a(Particles.d, vec3d.d - vec3d1.d * 0.25, vec3d.e - vec3d1.e * 0.25, vec3d.f - vec3d1.f * 0.25, vec3d1.d, vec3d1.e, vec3d1.f);
        }
    }

    @Override
    protected double bc() {
        return 0.05;
    }

    private boolean x() {
        return this.e() && this.dV().b(new AxisAlignedBB(this.dt(), this.dt()).g(0.06));
    }

    private void A() {
        this.a(false);
        Vec3D vec3d = this.dy();
        this.i(vec3d.d(this.ae.i() * 0.2f, this.ae.i() * 0.2f, this.ae.i() * 0.2f));
        this.s = 0;
    }

    public boolean e() {
        return this.al.a(o);
    }

    protected void a(boolean flag) {
        this.al.a(o, flag);
    }

    @Override
    public boolean cJ() {
        return !this.e();
    }

    @Override
    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        super.a(enummovetype, vec3d);
        if (enummovetype != EnumMoveType.a && this.x()) {
            this.A();
        }
    }

    protected void f() {
        ++this.s;
        if (this.s >= (this instanceof EntityThrownTrident ? this.dV().spigotConfig.tridentDespawnRate : this.dV().spigotConfig.arrowDespawnRate)) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    private void B() {
        if (this.az != null) {
            this.az.clear();
        }
        if (this.ay != null) {
            this.ay.clear();
        }
    }

    @Override
    protected void b(Item item) {
        this.aB = null;
    }

    @Override
    public void a(boolean flag, BlockPosition blockposition) {
        if (!this.e()) {
            super.a(flag, blockposition);
        }
    }

    @Override
    public void l(boolean flag) {
        if (!this.e()) {
            super.l(flag);
        }
    }

    @Override
    public void i(double d0, double d1, double d2) {
        if (!this.e()) {
            super.i(d0, d1, d2);
        }
    }

    @Override
    protected void a(MovingObjectPositionEntity movingobjectpositionentity) {
        World world;
        super.a(movingobjectpositionentity);
        Entity entity = movingobjectpositionentity.a();
        float f2 = (float)this.dy().g();
        double d0 = this.t;
        Entity entity1 = this.p();
        DamageSource damagesource = this.dW().a(this, entity1 != null ? entity1 : this);
        if (this.dZ() != null && (world = this.dV()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            d0 = EnchantmentManager.a(worldserver, this.dZ(), entity, damagesource, (float)d0);
        }
        int i2 = MathHelper.c(MathHelper.a((double)f2 * d0, 0.0, 2.147483647E9));
        if (this.t() > 0) {
            if (this.ay == null) {
                this.ay = new IntOpenHashSet(5);
            }
            if (this.az == null) {
                this.az = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.ay.size() >= this.t() + 1) {
                this.discard(EntityRemoveEvent.Cause.HIT);
                return;
            }
            this.ay.add(entity.ao());
        }
        if (this.s()) {
            long j2 = this.ae.a(i2 / 2 + 2);
            i2 = (int)Math.min(j2 + (long)i2, Integer.MAX_VALUE);
        }
        if (entity1 instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity1;
            entityliving.B(entity);
        }
        boolean flag = entity.an() == EntityTypes.O;
        int k2 = entity.aE();
        if (this.bX() && !flag) {
            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5.0f);
            Bukkit.getPluginManager().callEvent((Event)combustEvent);
            if (!combustEvent.isCancelled()) {
                entity.igniteForSeconds(combustEvent.getDuration(), false);
            }
        }
        if (entity.b(damagesource, (float)i2)) {
            if (flag) {
                return;
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity;
                if (!this.dV().C && this.t() <= 0) {
                    entityliving1.o(entityliving1.eW() + 1);
                }
                this.a(entityliving1, damagesource);
                World world1 = this.dV();
                if (world1 instanceof WorldServer) {
                    WorldServer worldserver1 = (WorldServer)world1;
                    EnchantmentManager.a(worldserver1, (Entity)entityliving1, damagesource, this.dZ());
                }
                this.a(entityliving1);
                if (entityliving1 instanceof EntityHuman && entity1 instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity1;
                    if (!this.ba() && entityliving1 != entityplayer) {
                        entityplayer.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, 0.0f));
                    }
                }
                if (!entity.bJ() && this.az != null) {
                    this.az.add(entityliving1);
                }
                if (!this.dV().C && entity1 instanceof EntityPlayer) {
                    EntityPlayer entityplayer1 = (EntityPlayer)entity1;
                    if (this.az != null) {
                        CriterionTriggers.H.a(entityplayer1, this.az, this.aB);
                    } else if (!entity.bJ()) {
                        CriterionTriggers.H.a(entityplayer1, List.of(entity), this.aB);
                    }
                }
            }
            this.a(this.u, 1.0f, 1.2f / (this.ae.i() * 0.2f + 0.9f));
            if (this.t() <= 0) {
                this.discard(EntityRemoveEvent.Cause.HIT);
            }
        } else {
            entity.h(k2);
            this.a(ProjectileDeflection.b, entity, this.p(), false);
            this.i(this.dy().c(0.2));
            World world2 = this.dV();
            if (world2 instanceof WorldServer) {
                WorldServer worldserver2 = (WorldServer)world2;
                if (this.dy().h() < 1.0E-7) {
                    if (this.b == PickupStatus.b) {
                        this.a(worldserver2, this.m(), 0.1f);
                    }
                    this.discard(EntityRemoveEvent.Cause.HIT);
                }
            }
        }
    }

    protected void a(EntityLiving entityliving, DamageSource damagesource) {
        float f2;
        World world;
        if (this.aB != null && (world = this.dV()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            f2 = EnchantmentManager.d(worldserver, this.aB, entityliving, damagesource, 0.0f);
        } else {
            f2 = 0.0f;
        }
        double d0 = f2;
        if (d0 > 0.0) {
            double d1 = Math.max(0.0, 1.0 - entityliving.h(GenericAttributes.p));
            Vec3D vec3d = this.dy().d(1.0, 0.0, 1.0).d().c(d0 * 0.6 * d1);
            if (vec3d.h() > 0.0) {
                entityliving.i(vec3d.d, 0.1, vec3d.f);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        this.r = this.dV().a_(movingobjectpositionblock.b());
        super.a(movingobjectpositionblock);
        ItemStack itemstack = this.dZ();
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (itemstack != null) {
                this.a(worldserver, movingobjectpositionblock, itemstack);
            }
        }
        Vec3D vec3d = this.dy();
        Vec3D vec3d1 = new Vec3D(Math.signum(vec3d.d), Math.signum(vec3d.e), Math.signum(vec3d.f));
        Vec3D vec3d2 = vec3d1.c((double)0.05f);
        this.b(this.dt().d(vec3d2));
        this.i(Vec3D.c);
        this.a(this.l(), 1.0f, 1.2f / (this.ae.i() * 0.2f + 0.9f));
        this.a(true);
        this.c = 7;
        this.b(false);
        this.a((byte)0);
        this.b(SoundEffects.aE);
        this.B();
    }

    protected void a(WorldServer worldserver, MovingObjectPositionBlock movingobjectpositionblock, ItemStack itemstack) {
        EntityLiving entityliving1;
        Vec3D vec3d = movingobjectpositionblock.b().a(movingobjectpositionblock.g());
        Entity entity = this.p();
        EntityLiving entityliving = entity instanceof EntityLiving ? (entityliving1 = (EntityLiving)entity) : null;
        EnchantmentManager.a(worldserver, itemstack, entityliving, this, (EnumItemSlot)null, vec3d, worldserver.a_(movingobjectpositionblock.b()), item -> {
            this.aB = null;
        });
    }

    @Override
    public ItemStack dZ() {
        return this.aB;
    }

    protected SoundEffect i() {
        return SoundEffects.aE;
    }

    protected final SoundEffect l() {
        return this.u;
    }

    protected void a(EntityLiving entityliving) {
    }

    @Nullable
    protected MovingObjectPositionEntity b(Vec3D vec3d, Vec3D vec3d1) {
        return ProjectileHelper.a(this.dV(), this, vec3d, vec3d1, this.cR().b(this.dy()).g(1.0), this::b);
    }

    @Override
    protected boolean b(Entity entity) {
        EntityHuman entityhuman;
        Entity entity1;
        if (entity instanceof EntityHuman && (entity1 = this.p()) instanceof EntityHuman && !(entityhuman = (EntityHuman)entity1).a((EntityHuman)entity)) {
            return false;
        }
        return super.b(entity) && (this.ay == null || !this.ay.contains(entity.ao()));
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
        nbttagcompound.a("life", (short)this.s);
        nbttagcompound.b("inBlockState", IBlockData.a, registryops, this.r);
        nbttagcompound.a("shake", (byte)this.c);
        nbttagcompound.a("inGround", this.e());
        nbttagcompound.a("pickup", PickupStatus.d, this.b);
        nbttagcompound.a("damage", this.t);
        nbttagcompound.a("crit", this.s());
        nbttagcompound.a("PierceLevel", this.t());
        nbttagcompound.a("SoundEvent", BuiltInRegistries.b.q(), this.u);
        nbttagcompound.a("item", ItemStack.b, registryops, this.aA);
        nbttagcompound.b("weapon", ItemStack.b, registryops, this.aB);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
        this.s = nbttagcompound.b("life", (short)0);
        this.r = nbttagcompound.a("inBlockState", IBlockData.a, (DynamicOps<NBTBase>)registryops).orElse(null);
        this.c = nbttagcompound.b("shake", (byte)0) & 0xFF;
        this.a(nbttagcompound.b("inGround", false));
        this.t = nbttagcompound.b("damage", 2.0);
        this.b = nbttagcompound.a("pickup", PickupStatus.d).orElse(PickupStatus.a);
        this.b(nbttagcompound.b("crit", false));
        this.a(nbttagcompound.b("PierceLevel", (byte)0));
        this.u = nbttagcompound.a("SoundEvent", BuiltInRegistries.b.q()).orElse(this.i());
        this.a(nbttagcompound.a("item", ItemStack.b, (DynamicOps<NBTBase>)registryops).orElse(this.n()));
        this.aB = nbttagcompound.a("weapon", ItemStack.b, (DynamicOps<NBTBase>)registryops).orElse(null);
    }

    @Override
    public void c(@Nullable Entity entity) {
        super.c(entity);
        Entity entity1 = entity;
        boolean b0 = false;
        PickupStatus entityarrow_pickupstatus = this.b;
        Entity entity2 = entity1;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityHuman.class, OminousItemSpawner.class}, (Object)entity2, n2)) {
            case 0: {
                EntityHuman entityhuman = (EntityHuman)entity2;
                if (this.b != PickupStatus.a) {
                    b0 = true;
                    break;
                }
                entityarrow_pickupstatus = PickupStatus.b;
                break;
            }
            case 1: {
                OminousItemSpawner ominousitemspawner = (OminousItemSpawner)entity2;
                entityarrow_pickupstatus = PickupStatus.a;
                break;
            }
            default: {
                entityarrow_pickupstatus = this.b;
                break;
            }
        }
        this.b = entityarrow_pickupstatus;
    }

    @Override
    public void a_(EntityHuman entityhuman) {
        if (!this.dV().C && (this.e() || this.v()) && this.c <= 0) {
            ItemStack itemstack = this.m();
            if (this.b == PickupStatus.b && !itemstack.f() && entityhuman.gj().canHold(itemstack) > 0) {
                EntityItem item = new EntityItem(this.dV(), this.dA(), this.dC(), this.dG(), itemstack);
                PlayerPickupArrowEvent event = new PlayerPickupArrowEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Item)new CraftItem(this.dV().getCraftServer(), item), (AbstractArrow)this.getBukkitEntity());
                this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = item.e();
            }
            if (this.b == PickupStatus.b && entityhuman.gj().g(itemstack) || this.b == PickupStatus.c && entityhuman.gk().d) {
                entityhuman.a((Entity)this, 1);
                this.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    protected boolean a(EntityHuman entityhuman) {
        return switch (this.b.ordinal()) {
            case 0 -> false;
            case 1 -> entityhuman.gj().g(this.m());
            case 2 -> entityhuman.fV();
            default -> throw new MatchException(null, null);
        };
    }

    protected ItemStack m() {
        return this.aA.v();
    }

    protected abstract ItemStack n();

    @Override
    protected Entity.MovementEmission bf() {
        return Entity.MovementEmission.a;
    }

    public ItemStack r() {
        return this.aA;
    }

    public void h(double d0) {
        this.t = d0;
    }

    @Override
    public boolean cB() {
        return this.an().a(TagsEntity.H);
    }

    public void b(boolean flag) {
        this.a(1, flag);
    }

    public void a(byte b0) {
        this.al.a(n, b0);
    }

    private void a(int i2, boolean flag) {
        byte b0 = this.al.a(m);
        if (flag) {
            this.al.a(m, (byte)(b0 | i2));
        } else {
            this.al.a(m, (byte)(b0 & ~i2));
        }
    }

    protected void a(ItemStack itemstack) {
        this.aA = !itemstack.f() ? itemstack : this.n();
    }

    public boolean s() {
        byte b0 = this.al.a(m);
        return (b0 & 1) != 0;
    }

    public byte t() {
        return this.al.a(n);
    }

    public void a(float f2) {
        this.h((double)(f2 * 2.0f) + this.ae.a((double)this.dV().an().a() * 0.11, 0.57425));
    }

    protected float u() {
        return 0.6f;
    }

    public void q(boolean flag) {
        this.ad = flag;
        this.a(2, flag);
    }

    public boolean v() {
        return !this.dV().C ? this.ad : (this.al.a(m) & 2) != 0;
    }

    @Override
    public boolean bF() {
        return super.bF() && !this.e();
    }

    @Override
    public SlotAccess a_(int i2) {
        return i2 == 0 ? SlotAccess.a(this::r, this::a) : super.a_(i2);
    }

    @Override
    protected boolean w() {
        return true;
    }

    public static enum PickupStatus {
        a,
        b,
        c;

        public static final Codec<PickupStatus> d;

        public static PickupStatus a(int i2) {
            if (i2 < 0 || i2 > PickupStatus.values().length) {
                i2 = 0;
            }
            return PickupStatus.values()[i2];
        }

        static {
            d = Codec.BYTE.xmap(PickupStatus::a, entityarrow_pickupstatus -> (byte)entityarrow_pickupstatus.ordinal());
        }
    }
}

