/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityFireworks
extends IProjectile
implements ItemSupplier {
    public static final DataWatcherObject<ItemStack> a = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.h);
    private static final DataWatcherObject<OptionalInt> b = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.v);
    public static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.k);
    private static final int d = 0;
    private static final int e = 0;
    private static final boolean f = false;
    public int g = 0;
    public int h = 0;
    @Nullable
    public EntityLiving i;

    public EntityFireworks(EntityTypes<? extends EntityFireworks> entitytypes, World world) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
    }

    public EntityFireworks(World world, double d0, double d1, double d2, ItemStack itemstack) {
        super((EntityTypes<? extends IProjectile>)EntityTypes.aa, world);
        this.g = 0;
        this.a_(d0, d1, d2);
        this.al.a(a, itemstack.v());
        int i2 = 1;
        Fireworks fireworks = itemstack.a(DataComponents.aj);
        if (fireworks != null) {
            i2 += fireworks.a();
        }
        this.n(this.ae.a(0.0, 0.002297), 0.05, this.ae.a(0.0, 0.002297));
        this.h = 10 * i2 + this.ae.a(6) + this.ae.a(7);
    }

    public EntityFireworks(World world, @Nullable Entity entity, double d0, double d1, double d2, ItemStack itemstack) {
        this(world, d0, d1, d2, itemstack);
        this.c(entity);
    }

    public EntityFireworks(World world, ItemStack itemstack, EntityLiving entityliving) {
        this(world, entityliving, entityliving.dA(), entityliving.dC(), entityliving.dG(), itemstack);
        this.al.a(b, OptionalInt.of(entityliving.ao()));
        this.i = entityliving;
    }

    public EntityFireworks(World world, ItemStack itemstack, double d0, double d1, double d2, boolean flag) {
        this(world, d0, d1, d2, itemstack);
        this.al.a(c, flag);
    }

    public EntityFireworks(World world, ItemStack itemstack, Entity entity, double d0, double d1, double d2, boolean flag) {
        this(world, itemstack, d0, d1, d2, flag);
        this.c(entity);
    }

    @Override
    public void inactiveTick() {
        World world;
        ++this.g;
        if (this.g > this.h && (world = this.dV()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
        super.inactiveTick();
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(a, EntityFireworks.n());
        datawatcher_a.a(b, OptionalInt.empty());
        datawatcher_a.a(c, false);
    }

    @Override
    public boolean a(double d0) {
        return d0 < 4096.0 && !this.l();
    }

    @Override
    public boolean j(double d0, double d1, double d2) {
        return super.j(d0, d1, d2) && !this.l();
    }

    @Override
    public void g() {
        World world;
        MovingObjectPosition movingobjectposition;
        super.g();
        if (this.l()) {
            if (this.i == null) {
                this.al.a(b).ifPresent(i2 -> {
                    Entity entity = this.dV().a(i2);
                    if (entity instanceof EntityLiving) {
                        this.i = (EntityLiving)entity;
                    }
                });
            }
            if (this.i != null) {
                Vec3D vec3d;
                if (this.i.fJ()) {
                    Vec3D vec3d1 = this.i.bS();
                    double d0 = 1.5;
                    double d1 = 0.1;
                    Vec3D vec3d2 = this.i.dy();
                    this.i.i(vec3d2.b(vec3d1.d * 0.1 + (vec3d1.d * 1.5 - vec3d2.d) * 0.5, vec3d1.e * 0.1 + (vec3d1.e * 1.5 - vec3d2.e) * 0.5, vec3d1.f * 0.1 + (vec3d1.f * 1.5 - vec3d2.f) * 0.5));
                    vec3d = this.i.a(Items.vE);
                } else {
                    vec3d = Vec3D.c;
                }
                this.a_(this.i.dA() + vec3d.d, this.i.dC() + vec3d.e, this.i.dG() + vec3d.f);
                this.i(this.i.dy());
            }
            movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
        } else {
            if (!this.f()) {
                double d2 = this.P ? 1.0 : 1.15;
                this.i(this.dy().d(d2, 1.0, d2).b(0.0, 0.04, 0.0));
            }
            Vec3D vec3d3 = this.dy();
            movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
            this.a(EnumMoveType.a, vec3d3);
            this.aI();
            this.i(vec3d3);
        }
        if (!this.ad && this.bJ() && movingobjectposition.d() != MovingObjectPosition.EnumMovingObjectType.a) {
            this.preHitTargetOrDeflectSelf(movingobjectposition);
            this.ar = true;
        }
        this.z();
        if (this.g == 0 && !this.ba()) {
            this.dV().a((Entity)null, this.dA(), this.dC(), this.dG(), SoundEffects.jt, SoundCategory.i, 3.0f, 1.0f);
        }
        ++this.g;
        if (this.dV().C && this.g % 2 < 2) {
            this.dV().a(Particles.D, this.dA(), this.dC(), this.dG(), this.ae.k() * 0.05, -this.dy().e * 0.5, this.ae.k() * 0.05);
        }
        if (this.g > this.h && (world = this.dV()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
    }

    private void b(WorldServer worldserver) {
        worldserver.a((Entity)this, (byte)17);
        this.a(GameEvent.w, this.p());
        this.e(worldserver);
        this.discard(EntityRemoveEvent.Cause.EXPLODE);
    }

    @Override
    protected void a(MovingObjectPositionEntity movingobjectpositionentity) {
        super.a(movingobjectpositionentity);
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        BlockPosition blockposition = new BlockPosition(movingobjectpositionblock.b());
        this.dV().a_(blockposition).a(this.dV(), blockposition, (Entity)this, InsideBlockEffectApplier.a);
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.i() && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
        super.a(movingobjectpositionblock);
    }

    private boolean i() {
        return !this.m().isEmpty();
    }

    private void e(WorldServer worldserver) {
        float f2 = 0.0f;
        List<FireworkExplosion> list = this.m();
        if (!list.isEmpty()) {
            f2 = 5.0f + (float)(list.size() * 2);
        }
        if (f2 > 0.0f) {
            if (this.i != null) {
                this.i.a(worldserver, this.dW().a(this, this.p()), 5.0f + (float)(list.size() * 2));
            }
            double d0 = 5.0;
            Vec3D vec3d = this.dt();
            for (EntityLiving entityliving : this.dV().a(EntityLiving.class, this.cR().g(5.0))) {
                if (entityliving == this.i || !(this.g(entityliving) <= 25.0)) continue;
                boolean flag = false;
                for (int i2 = 0; i2 < 2; ++i2) {
                    Vec3D vec3d1 = new Vec3D(entityliving.dA(), entityliving.e(0.5 * (double)i2), entityliving.dG());
                    MovingObjectPositionBlock movingobjectposition = this.dV().a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                    if (((MovingObjectPosition)movingobjectposition).d() != MovingObjectPosition.EnumMovingObjectType.a) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float f1 = f2 * (float)Math.sqrt((5.0 - (double)this.f(entityliving)) / 5.0);
                entityliving.a(worldserver, this.dW().a(this, this.p()), f1);
            }
        }
    }

    private boolean l() {
        return this.al.a(b).isPresent();
    }

    public boolean f() {
        return this.al.a(c);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 17 && this.dV().C) {
            Vec3D vec3d = this.dy();
            this.dV().a(this.dA(), this.dC(), this.dG(), vec3d.d, vec3d.e, vec3d.f, this.m());
        }
        super.b(b0);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("Life", this.g);
        nbttagcompound.a("LifeTime", this.h);
        RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
        nbttagcompound.a("FireworksItem", ItemStack.b, registryops, this.e());
        nbttagcompound.a("ShotAtAngle", this.al.a(c));
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.g = nbttagcompound.b("Life", 0);
        this.h = nbttagcompound.b("LifeTime", 0);
        RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
        this.al.a(a, nbttagcompound.a("FireworksItem", ItemStack.b, (DynamicOps<NBTBase>)registryops).orElse(EntityFireworks.n()));
        this.al.a(c, nbttagcompound.b("ShotAtAngle", false));
    }

    private List<FireworkExplosion> m() {
        ItemStack itemstack = this.al.a(a);
        Fireworks fireworks = itemstack.a(DataComponents.aj);
        return fireworks != null ? fireworks.b() : List.of();
    }

    @Override
    public ItemStack e() {
        return this.al.a(a);
    }

    @Override
    public boolean cB() {
        return false;
    }

    private static ItemStack n() {
        return new ItemStack(Items.vE);
    }

    @Override
    public DoubleDoubleImmutablePair a_(EntityLiving entityliving, DamageSource damagesource) {
        double d0 = entityliving.dt().d - this.dt().d;
        double d1 = entityliving.dt().f - this.dt().f;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }
}

