/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.slf4j.Logger;

public class EntityFishingHook
extends IProjectile {
    private static final Logger a = LogUtils.getLogger();
    private final RandomSource b = RandomSource.a();
    private boolean c;
    private int d;
    private static final int e = 10;
    public static final DataWatcherObject<Integer> f = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> g = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.k);
    private int h;
    private int i;
    public int j;
    public int k;
    private float l;
    private boolean m = true;
    @Nullable
    public Entity n;
    public HookState o = HookState.a;
    private final int p;
    private final int q;
    public int minWaitTime = 100;
    public int maxWaitTime = 600;
    public int minLureTime = 20;
    public int maxLureTime = 80;
    public float minLureAngle = 0.0f;
    public float maxLureAngle = 360.0f;
    public boolean applyLure = true;
    public boolean rainInfluenced = true;
    public boolean skyInfluenced = true;

    private EntityFishingHook(EntityTypes<? extends EntityFishingHook> entitytypes, World world, int i2, int j2) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
        this.p = Math.max(0, i2);
        this.q = Math.max(0, j2);
    }

    public EntityFishingHook(EntityTypes<? extends EntityFishingHook> entitytypes, World world) {
        this(entitytypes, world, 0, 0);
    }

    public EntityFishingHook(EntityHuman entityhuman, World world, int i2, int j2) {
        this(EntityTypes.bU, world, i2, j2);
        this.c(entityhuman);
        float f2 = entityhuman.dN();
        float f1 = entityhuman.dL();
        float f22 = MathHelper.b(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f3 = MathHelper.a(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f4 = -MathHelper.b(-f2 * ((float)Math.PI / 180));
        float f5 = MathHelper.a(-f2 * ((float)Math.PI / 180));
        double d0 = entityhuman.dA() - (double)f3 * 0.3;
        double d1 = entityhuman.dE();
        double d2 = entityhuman.dG() - (double)f22 * 0.3;
        this.b(d0, d1, d2, f1, f2);
        Vec3D vec3d = new Vec3D(-f3, MathHelper.a(-(f5 / f4), -5.0f, 5.0f), -f22);
        double d3 = vec3d.g();
        vec3d = vec3d.d(0.6 / d3 + this.ae.a(0.5, 0.0103365), 0.6 / d3 + this.ae.a(0.5, 0.0103365), 0.6 / d3 + this.ae.a(0.5, 0.0103365));
        this.i(vec3d);
        this.w((float)(MathHelper.d(vec3d.d, vec3d.f) * 57.2957763671875));
        this.x((float)(MathHelper.d(vec3d.e, vec3d.i()) * 57.2957763671875));
        this.N = this.dL();
        this.O = this.dN();
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(f, 0);
        datawatcher_a.a(g, false);
    }

    @Override
    protected boolean w() {
        return true;
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (f.equals(datawatcherobject)) {
            int i2 = this.ar().a(f);
            Entity entity = this.n = i2 > 0 ? this.dV().a(i2 - 1) : null;
        }
        if (g.equals(datawatcherobject)) {
            this.c = this.ar().a(g);
            if (this.c) {
                this.n(this.dy().d, -0.4f * MathHelper.a(this.b, 0.6f, 1.0f), this.dy().f);
            }
        }
        super.a(datawatcherobject);
    }

    @Override
    public boolean a(double d0) {
        double d1 = 64.0;
        return d0 < 4096.0;
    }

    @Override
    public void g() {
        this.b.b(this.cG().getLeastSignificantBits() ^ this.dV().ae());
        super.g();
        EntityHuman entityhuman = this.f();
        if (entityhuman == null) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (this.dV().C || !this.a(entityhuman)) {
            boolean flag;
            if (this.aH()) {
                ++this.h;
                if (this.h >= 1200) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
            } else {
                this.h = 0;
            }
            float f2 = 0.0f;
            BlockPosition blockposition = this.dv();
            Fluid fluid = this.dV().b_(blockposition);
            if (fluid.a(TagsFluid.a)) {
                f2 = fluid.a(this.dV(), blockposition);
            }
            boolean bl = flag = f2 > 0.0f;
            if (this.o == HookState.a) {
                if (this.n != null) {
                    this.i(Vec3D.c);
                    this.o = HookState.b;
                    return;
                }
                if (flag) {
                    this.i(this.dy().d(0.3, 0.2, 0.3));
                    this.o = HookState.c;
                    return;
                }
                this.l();
            } else {
                if (this.o == HookState.b) {
                    if (this.n != null) {
                        if (!this.n.dQ() && this.n.dV().aj() == this.dV().aj()) {
                            this.a_(this.n.dA(), this.n.e(0.8), this.n.dG());
                        } else {
                            this.B(null);
                            this.o = HookState.a;
                        }
                    }
                    return;
                }
                if (this.o == HookState.c) {
                    Vec3D vec3d = this.dy();
                    double d0 = this.dC() + vec3d.e - (double)blockposition.v() - (double)f2;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.n(vec3d.d * 0.9, vec3d.e - d0 * (double)this.ae.i() * 0.2, vec3d.f * 0.9);
                    if (this.i <= 0 && this.k <= 0) {
                        this.m = true;
                    } else {
                        boolean bl2 = this.m = this.m && this.d < 10 && this.b(blockposition);
                    }
                    if (flag) {
                        this.d = Math.max(0, this.d - 1);
                        if (this.c) {
                            this.i(this.dy().b(0.0, -0.1 * (double)this.b.i() * (double)this.b.i(), 0.0));
                        }
                        if (!this.dV().C) {
                            this.a(blockposition);
                        }
                    } else {
                        this.d = Math.min(10, this.d + 1);
                    }
                }
            }
            if (!fluid.a(TagsFluid.a)) {
                this.i(this.dy().b(0.0, -0.03, 0.0));
            }
            this.a(EnumMoveType.a, this.dy());
            this.aI();
            this.z();
            if (this.o == HookState.a && (this.aH() || this.P)) {
                this.i(Vec3D.c);
            }
            double d1 = 0.92;
            this.i(this.dy().c(0.92));
            this.av();
        }
    }

    private boolean a(EntityHuman entityhuman) {
        ItemStack itemstack = entityhuman.fb();
        ItemStack itemstack1 = entityhuman.fc();
        boolean flag = itemstack.a(Items.sd);
        boolean flag1 = itemstack1.a(Items.sd);
        if (!entityhuman.dQ() && entityhuman.bJ() && (flag || flag1) && this.g(entityhuman) <= 1024.0) {
            return false;
        }
        this.discard(EntityRemoveEvent.Cause.DESPAWN);
        return true;
    }

    private void l() {
        MovingObjectPosition movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
        this.preHitTargetOrDeflectSelf(movingobjectposition);
    }

    @Override
    protected boolean b(Entity entity) {
        return super.b(entity) || entity.bJ() && entity instanceof EntityItem;
    }

    @Override
    protected void a(MovingObjectPositionEntity movingobjectpositionentity) {
        super.a(movingobjectpositionentity);
        if (!this.dV().C) {
            this.B(movingobjectpositionentity.a());
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        super.a(movingobjectpositionblock);
        this.i(this.dy().d().c(movingobjectpositionblock.a(this)));
    }

    public void B(@Nullable Entity entity) {
        this.n = entity;
        this.ar().a(f, entity == null ? 0 : entity.ao() + 1);
    }

    private void a(BlockPosition blockposition) {
        WorldServer worldserver = (WorldServer)this.dV();
        int i2 = 1;
        BlockPosition blockposition1 = blockposition.d();
        if (this.rainInfluenced && this.ae.i() < 0.25f && this.dV().r(blockposition1)) {
            ++i2;
        }
        if (this.skyInfluenced && this.ae.i() < 0.5f && !this.dV().h(blockposition1)) {
            --i2;
        }
        if (this.i > 0) {
            --this.i;
            if (this.i <= 0) {
                this.j = 0;
                this.k = 0;
                this.ar().a(g, false);
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.f().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.FAILED_ATTEMPT);
                this.dV().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
            }
        } else if (this.k > 0) {
            this.k -= i2;
            if (this.k > 0) {
                double d2;
                double d1;
                this.l += (float)this.ae.a(0.0, 9.188);
                float f2 = this.l * ((float)Math.PI / 180);
                float f1 = MathHelper.a(f2);
                float f22 = MathHelper.b(f2);
                double d0 = this.dA() + (double)(f1 * (float)this.k * 0.1f);
                IBlockData iblockdata = worldserver.a_(BlockPosition.a(d0, (d1 = (double)((float)MathHelper.a(this.dC()) + 1.0f)) - 1.0, d2 = this.dG() + (double)(f22 * (float)this.k * 0.1f)));
                if (iblockdata.a(Blocks.J)) {
                    if (this.ae.i() < 0.15f) {
                        worldserver.a(Particles.d, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f22, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f22 * 0.04f;
                    worldserver.a(Particles.E, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    worldserver.a(Particles.E, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.f().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.BITE);
                this.dV().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return;
                }
                this.a(SoundEffects.jB, 0.25f, 1.0f + (this.ae.i() - this.ae.i()) * 0.4f);
                double d3 = this.dC() + 0.5;
                worldserver.a(Particles.d, this.dA(), d3, this.dG(), (int)(1.0f + this.dq() * 20.0f), (double)this.dq(), 0.0, (double)this.dq(), (double)0.2f);
                worldserver.a(Particles.E, this.dA(), d3, this.dG(), (int)(1.0f + this.dq() * 20.0f), (double)this.dq(), 0.0, (double)this.dq(), (double)0.2f);
                this.i = MathHelper.a(this.ae, 20, 40);
                this.ar().a(g, true);
            }
        } else if (this.j > 0) {
            this.j -= i2;
            float f5 = 0.15f;
            if (this.j < 20) {
                f5 += (float)(20 - this.j) * 0.05f;
            } else if (this.j < 40) {
                f5 += (float)(40 - this.j) * 0.02f;
            } else if (this.j < 60) {
                f5 += (float)(60 - this.j) * 0.01f;
            }
            if (this.ae.i() < f5) {
                double d6;
                double d5;
                float f6 = MathHelper.a(this.ae, 0.0f, 360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.a(this.ae, 25.0f, 60.0f);
                double d4 = this.dA() + (double)(MathHelper.a(f6) * f7) * 0.1;
                IBlockData iblockdata1 = worldserver.a_(BlockPosition.a(d4, (d5 = (double)((float)MathHelper.a(this.dC()) + 1.0f)) - 1.0, d6 = this.dG() + (double)(MathHelper.b(f6) * f7) * 0.1));
                if (iblockdata1.a(Blocks.J)) {
                    worldserver.a(Particles.ap, d4, d5, d6, 2 + this.ae.a(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.j <= 0) {
                this.l = MathHelper.a(this.ae, this.minLureAngle, this.maxLureAngle);
                this.k = MathHelper.a(this.ae, this.minLureTime, this.maxLureTime);
            }
        } else {
            this.j = MathHelper.a(this.ae, this.minWaitTime, this.maxWaitTime);
            this.j -= this.applyLure ? this.q : 0;
        }
    }

    private boolean b(BlockPosition blockposition) {
        WaterPosition entityfishinghook_waterposition = WaterPosition.c;
        for (int i2 = -1; i2 <= 2; ++i2) {
            WaterPosition entityfishinghook_waterposition1 = this.a(blockposition.b(-2, i2, -2), blockposition.b(2, i2, 2));
            switch (entityfishinghook_waterposition1.ordinal()) {
                case 0: {
                    if (entityfishinghook_waterposition != WaterPosition.c) break;
                    return false;
                }
                case 1: {
                    if (entityfishinghook_waterposition != WaterPosition.a) break;
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            entityfishinghook_waterposition = entityfishinghook_waterposition1;
        }
        return true;
    }

    private WaterPosition a(BlockPosition blockposition, BlockPosition blockposition1) {
        return BlockPosition.d(blockposition, blockposition1).map(this::c).reduce((entityfishinghook_waterposition, entityfishinghook_waterposition1) -> entityfishinghook_waterposition == entityfishinghook_waterposition1 ? entityfishinghook_waterposition : WaterPosition.c).orElse(WaterPosition.c);
    }

    private WaterPosition c(BlockPosition blockposition) {
        IBlockData iblockdata = this.dV().a_(blockposition);
        if (!iblockdata.l() && !iblockdata.a(Blocks.fF)) {
            Fluid fluid = iblockdata.y();
            return fluid.a(TagsFluid.a) && fluid.b() && iblockdata.g(this.dV(), blockposition).c() ? WaterPosition.b : WaterPosition.c;
        }
        return WaterPosition.a;
    }

    public boolean e() {
        return this.m;
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
    }

    public int a(ItemStack itemstack) {
        EntityHuman entityhuman = this.f();
        if (!this.dV().C && entityhuman != null && !this.a(entityhuman)) {
            PlayerFishEvent playerFishEvent;
            int i2 = 0;
            if (this.n != null) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)this.n.getBukkitEntity(), (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.CAUGHT_ENTITY);
                this.dV().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                this.d(this.n);
                CriterionTriggers.E.a((EntityPlayer)entityhuman, itemstack, this, Collections.emptyList());
                this.dV().a((Entity)this, (byte)31);
                i2 = this.n instanceof EntityItem ? 3 : 5;
            } else if (this.i > 0) {
                LootParams lootparams = new LootParams.a((WorldServer)this.dV()).a(LootContextParameters.f, this.dt()).a(LootContextParameters.i, itemstack).a(LootContextParameters.a, this).a((float)this.p + entityhuman.eh()).a(LootContextParameterSets.f);
                LootTable loottable = this.dV().p().bc().b(LootTables.am);
                ObjectArrayList<ItemStack> list = loottable.a(lootparams);
                CriterionTriggers.E.a((EntityPlayer)entityhuman, itemstack, this, (Collection<ItemStack>)list);
                for (ItemStack itemstack1 : list) {
                    EntityItem entityitem = new EntityItem(this.dV(), this.dA(), this.dC(), this.dG(), itemstack1);
                    PlayerFishEvent playerFishEvent2 = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)entityitem.getBukkitEntity(), (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.CAUGHT_FISH);
                    playerFishEvent2.setExpToDrop(this.ae.a(6) + 1);
                    this.dV().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent2);
                    if (playerFishEvent2.isCancelled()) {
                        return 0;
                    }
                    double d0 = entityhuman.dA() - this.dA();
                    double d1 = entityhuman.dC() - this.dC();
                    double d2 = entityhuman.dG() - this.dG();
                    double d3 = 0.1;
                    entityitem.n(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.dV().b(entityitem);
                    if (playerFishEvent2.getExpToDrop() > 0) {
                        entityhuman.dV().b(new EntityExperienceOrb(entityhuman.dV(), entityhuman.dA(), entityhuman.dC() + 0.5, entityhuman.dG() + 0.5, playerFishEvent2.getExpToDrop()));
                    }
                    if (!itemstack1.a(TagsItem.aV)) continue;
                    entityhuman.a(StatisticList.R, 1);
                }
                i2 = 1;
            }
            if (this.aH()) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.IN_GROUND);
                this.dV().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                i2 = 2;
            }
            if (i2 == 0) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.REEL_IN);
                this.dV().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return i2;
        }
        return 0;
    }

    @Override
    public void b(byte b0) {
        EntityHuman entityhuman;
        Entity entity;
        if (b0 == 31 && this.dV().C && (entity = this.n) instanceof EntityHuman && (entityhuman = (EntityHuman)entity).gh()) {
            this.d(this.n);
        }
        super.b(b0);
    }

    public void d(Entity entity) {
        Entity entity1 = this.p();
        if (entity1 != null) {
            Vec3D vec3d = new Vec3D(entity1.dA() - this.dA(), entity1.dC() - this.dC(), entity1.dG() - this.dG()).c(0.1);
            entity.i(entity.dy().e(vec3d));
        }
    }

    @Override
    protected Entity.MovementEmission bf() {
        return Entity.MovementEmission.a;
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        this.a((EntityFishingHook)null);
        super.remove(entity_removalreason, cause);
    }

    @Override
    public void as() {
        this.a((EntityFishingHook)null);
    }

    @Override
    public void c(@Nullable Entity entity) {
        super.c(entity);
        this.a(this);
    }

    private void a(@Nullable EntityFishingHook entityfishinghook) {
        EntityHuman entityhuman = this.f();
        if (entityhuman != null) {
            entityhuman.ck = entityfishinghook;
        }
    }

    @Nullable
    public EntityHuman f() {
        EntityHuman entityhuman1;
        Entity entity = this.p();
        EntityHuman entityhuman = entity instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entity) : null;
        return entityhuman;
    }

    @Nullable
    public Entity i() {
        return this.n;
    }

    @Override
    public boolean n(boolean flag) {
        return false;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        Entity entity = this.p();
        return new PacketPlayOutSpawnEntity((Entity)this, entitytrackerentry, entity == null ? this.ao() : entity.ao());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        if (this.f() == null) {
            int i2 = packetplayoutspawnentity.p();
            a.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.dV().a(i2), (Object)i2);
            this.discard(null);
        }
    }

    public static enum HookState {
        a,
        b,
        c;

    }

    private static enum WaterPosition {
        a,
        b,
        c;

    }
}

