/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityShulkerBullet
extends IProjectile {
    private static final double a = 0.15;
    @Nullable
    private Entity b;
    @Nullable
    private EnumDirection c;
    private int d;
    private double e;
    private double f;
    private double g;
    @Nullable
    private UUID h;

    public EntityShulkerBullet(EntityTypes<? extends EntityShulkerBullet> entitytypes, World world) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
        this.ad = true;
    }

    public EntityShulkerBullet(World world, EntityLiving entityliving, Entity entity, EnumDirection.EnumAxis enumdirection_enumaxis) {
        this((EntityTypes<? extends EntityShulkerBullet>)EntityTypes.be, world);
        this.c(entityliving);
        Vec3D vec3d = entityliving.cR().f();
        this.b(vec3d.d, vec3d.e, vec3d.f, this.dL(), this.dN());
        this.b = entity;
        this.c = EnumDirection.b;
        this.a(enumdirection_enumaxis);
        this.projectileSource = (LivingEntity)entityliving.getBukkitEntity();
    }

    public Entity getTarget() {
        return this.b;
    }

    public void setTarget(Entity e2) {
        this.b = e2;
        this.c = EnumDirection.b;
        this.a(EnumDirection.EnumAxis.a);
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.f;
    }

    @Override
    protected void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        if (this.b != null) {
            nbttagcompound.a("Target", UUIDUtil.a, this.b.cG());
        }
        nbttagcompound.b("Dir", EnumDirection.k, this.c);
        nbttagcompound.a("Steps", this.d);
        nbttagcompound.a("TXD", this.e);
        nbttagcompound.a("TYD", this.f);
        nbttagcompound.a("TZD", this.g);
    }

    @Override
    protected void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.d = nbttagcompound.b("Steps", 0);
        this.e = nbttagcompound.b("TXD", 0.0);
        this.f = nbttagcompound.b("TYD", 0.0);
        this.g = nbttagcompound.b("TZD", 0.0);
        this.c = nbttagcompound.a("Dir", EnumDirection.k).orElse(null);
        this.h = nbttagcompound.a("Target", UUIDUtil.a).orElse(null);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
    }

    @Nullable
    private EnumDirection e() {
        return this.c;
    }

    private void a(@Nullable EnumDirection enumdirection) {
        this.c = enumdirection;
    }

    private void a(@Nullable EnumDirection.EnumAxis enumdirection_enumaxis) {
        BlockPosition blockposition;
        double d0 = 0.5;
        if (this.b == null) {
            blockposition = this.dv().e();
        } else {
            d0 = (double)this.b.dr() * 0.5;
            blockposition = BlockPosition.a(this.b.dA(), this.b.dC() + d0, this.b.dG());
        }
        double d1 = (double)blockposition.u() + 0.5;
        double d2 = (double)blockposition.v() + d0;
        double d3 = (double)blockposition.w() + 0.5;
        EnumDirection enumdirection = null;
        if (!blockposition.a(this.dt(), 2.0)) {
            BlockPosition blockposition1 = this.dv();
            ArrayList list = Lists.newArrayList();
            if (enumdirection_enumaxis != EnumDirection.EnumAxis.a) {
                if (blockposition1.u() < blockposition.u() && this.dV().v(blockposition1.i())) {
                    list.add(EnumDirection.f);
                } else if (blockposition1.u() > blockposition.u() && this.dV().v(blockposition1.h())) {
                    list.add(EnumDirection.e);
                }
            }
            if (enumdirection_enumaxis != EnumDirection.EnumAxis.b) {
                if (blockposition1.v() < blockposition.v() && this.dV().v(blockposition1.d())) {
                    list.add(EnumDirection.b);
                } else if (blockposition1.v() > blockposition.v() && this.dV().v(blockposition1.e())) {
                    list.add(EnumDirection.a);
                }
            }
            if (enumdirection_enumaxis != EnumDirection.EnumAxis.c) {
                if (blockposition1.w() < blockposition.w() && this.dV().v(blockposition1.g())) {
                    list.add(EnumDirection.d);
                } else if (blockposition1.w() > blockposition.w() && this.dV().v(blockposition1.f())) {
                    list.add(EnumDirection.c);
                }
            }
            enumdirection = EnumDirection.b(this.ae);
            if (list.isEmpty()) {
                for (int i2 = 5; !this.dV().v(blockposition1.a(enumdirection)) && i2 > 0; --i2) {
                    enumdirection = EnumDirection.b(this.ae);
                }
            } else {
                enumdirection = (EnumDirection)list.get(this.ae.a(list.size()));
            }
            d1 = this.dA() + (double)enumdirection.j();
            d2 = this.dC() + (double)enumdirection.k();
            d3 = this.dG() + (double)enumdirection.l();
        }
        this.a(enumdirection);
        double d4 = d1 - this.dA();
        double d5 = d2 - this.dC();
        double d6 = d3 - this.dG();
        double d7 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        if (d7 == 0.0) {
            this.e = 0.0;
            this.f = 0.0;
            this.g = 0.0;
        } else {
            this.e = d4 / d7 * 0.15;
            this.f = d5 / d7 * 0.15;
            this.g = d6 / d7 * 0.15;
        }
        this.ar = true;
        this.d = 10 + this.ae.a(5) * 10;
    }

    @Override
    public void dH() {
        if (this.dV().an() == EnumDifficulty.a) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    protected double bc() {
        return 0.04;
    }

    @Override
    public void g() {
        super.g();
        MovingObjectPosition movingobjectposition = null;
        if (!this.dV().C) {
            if (this.b == null && this.h != null) {
                this.b = ((WorldServer)this.dV()).b(this.h);
                if (this.b == null) {
                    this.h = null;
                }
            }
            if (this.b == null || !this.b.bJ() || this.b instanceof EntityHuman && this.b.ak()) {
                this.be();
            } else {
                this.e = MathHelper.a(this.e * 1.025, -1.0, 1.0);
                this.f = MathHelper.a(this.f * 1.025, -1.0, 1.0);
                this.g = MathHelper.a(this.g * 1.025, -1.0, 1.0);
                Vec3D vec3d = this.dy();
                this.i(vec3d.b((this.e - vec3d.d) * 0.2, (this.f - vec3d.e) * 0.2, (this.g - vec3d.f) * 0.2));
            }
            movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
        }
        Vec3D vec3d1 = this.dy();
        this.b(this.dt().e(vec3d1));
        this.aI();
        if (this.as != null && this.as.e()) {
            this.bV();
        }
        if (movingobjectposition != null && this.bJ() && movingobjectposition.d() != MovingObjectPosition.EnumMovingObjectType.a) {
            this.preHitTargetOrDeflectSelf(movingobjectposition);
        }
        ProjectileHelper.a((Entity)this, 0.5f);
        if (this.dV().C) {
            this.dV().a(Particles.t, this.dA() - vec3d1.d, this.dC() - vec3d1.e + 0.15, this.dG() - vec3d1.f, 0.0, 0.0, 0.0);
        } else if (this.b != null && !this.b.dQ()) {
            if (this.d > 0) {
                --this.d;
                if (this.d == 0) {
                    this.a(this.c == null ? null : this.c.o());
                }
            }
            if (this.c != null) {
                BlockPosition blockposition = this.dv();
                EnumDirection.EnumAxis enumdirection_enumaxis = this.c.o();
                if (this.dV().a(blockposition.a(this.c), this)) {
                    this.a(enumdirection_enumaxis);
                } else {
                    BlockPosition blockposition1 = this.b.dv();
                    if (enumdirection_enumaxis == EnumDirection.EnumAxis.a && blockposition.u() == blockposition1.u() || enumdirection_enumaxis == EnumDirection.EnumAxis.c && blockposition.w() == blockposition1.w() || enumdirection_enumaxis == EnumDirection.EnumAxis.b && blockposition.v() == blockposition1.v()) {
                        this.a(enumdirection_enumaxis);
                    }
                }
            }
        }
    }

    @Override
    protected boolean aK() {
        return !this.dQ();
    }

    @Override
    protected boolean b(Entity entity) {
        return super.b(entity) && !entity.ad;
    }

    @Override
    public boolean bX() {
        return false;
    }

    @Override
    public boolean a(double d0) {
        return d0 < 16384.0;
    }

    @Override
    public float bw() {
        return 1.0f;
    }

    @Override
    protected void a(MovingObjectPositionEntity movingobjectpositionentity) {
        super.a(movingobjectpositionentity);
        Entity entity = movingobjectpositionentity.a();
        Entity entity1 = this.p();
        EntityLiving entityliving = entity1 instanceof EntityLiving ? (EntityLiving)entity1 : null;
        DamageSource damagesource = this.dW().a((Entity)this, entityliving);
        boolean flag = entity.b(damagesource, 4.0f);
        if (flag) {
            World world = this.dV();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                EnchantmentManager.a(worldserver, entity, damagesource);
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity;
                entityliving1.addEffect(new MobEffect(MobEffects.y, 200), (Entity)MoreObjects.firstNonNull((Object)entity1, (Object)this), EntityPotionEffectEvent.Cause.ATTACK);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        super.a(movingobjectpositionblock);
        ((WorldServer)this.dV()).a(Particles.w, this.dA(), this.dC(), this.dG(), 2, 0.2, 0.2, 0.2, 0.0);
        this.a(SoundEffects.xE, 1.0f, 1.0f);
    }

    private void f() {
        this.destroy(null);
    }

    private void destroy(EntityRemoveEvent.Cause cause) {
        this.discard(cause);
        this.dV().a(GameEvent.o, this.dt(), GameEvent.a.a(this));
    }

    @Override
    protected void a(MovingObjectPosition movingobjectposition) {
        super.a(movingobjectposition);
        this.destroy(EntityRemoveEvent.Cause.HIT);
    }

    @Override
    public boolean bF() {
        return true;
    }

    @Override
    public boolean b(DamageSource damagesource) {
        return true;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f2, false)) {
            return false;
        }
        this.a(SoundEffects.xF, 1.0f, 1.0f);
        worldserver.a(Particles.f, this.dA(), this.dC(), this.dG(), 15, 0.2, 0.2, 0.2, 0.0);
        this.destroy(EntityRemoveEvent.Cause.DEATH);
        return true;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        double d0 = packetplayoutspawnentity.j();
        double d1 = packetplayoutspawnentity.k();
        double d2 = packetplayoutspawnentity.l();
        this.n(d0, d1, d2);
    }
}

