/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;

public class PersistentRaid
extends PersistentBase {
    private static final String d = "raids";
    public static final Codec<PersistentRaid> a = RecordCodecBuilder.create(instance -> instance.group((App)net.minecraft.world.entity.raid.PersistentRaid$a.a.listOf().optionalFieldOf(d, List.of()).forGetter(persistentraid -> persistentraid.e.int2ObjectEntrySet().stream().map(a::a).toList()), (App)Codec.INT.fieldOf("next_id").forGetter(persistentraid -> persistentraid.f), (App)Codec.INT.fieldOf("tick").forGetter(persistentraid -> persistentraid.g)).apply((Applicative)instance, PersistentRaid::new));
    public static final SavedDataType<PersistentRaid> b = new SavedDataType<PersistentRaid>("raids", PersistentRaid::new, a, DataFixTypes.l);
    public static final SavedDataType<PersistentRaid> c = new SavedDataType<PersistentRaid>("raids_end", PersistentRaid::new, a, DataFixTypes.l);
    public final Int2ObjectMap<Raid> e = new Int2ObjectOpenHashMap();
    private int f = 1;
    private int g;

    public static SavedDataType<PersistentRaid> a(Holder<DimensionManager> holder) {
        return holder.a(BuiltinDimensionTypes.c) ? c : b;
    }

    public PersistentRaid() {
        this.f();
    }

    private PersistentRaid(List<a> list, int i2, int j2) {
        for (a persistentraid_a : list) {
            this.e.put(persistentraid_a.b, (Object)persistentraid_a.c);
        }
        this.f = i2;
        this.g = j2;
    }

    @Nullable
    public Raid a(int i2) {
        return (Raid)this.e.get(i2);
    }

    public OptionalInt a(Raid raid) {
        for (Int2ObjectMap.Entry int2objectmap_entry : this.e.int2ObjectEntrySet()) {
            if (int2objectmap_entry.getValue() != raid) continue;
            return OptionalInt.of(int2objectmap_entry.getIntKey());
        }
        return OptionalInt.empty();
    }

    public void a(WorldServer worldserver) {
        ++this.g;
        ObjectIterator iterator = this.e.values().iterator();
        while (iterator.hasNext()) {
            Raid raid = (Raid)iterator.next();
            if (worldserver.O().c(GameRules.D)) {
                raid.m();
            }
            if (raid.d()) {
                iterator.remove();
                this.f();
                continue;
            }
            raid.a(worldserver);
        }
        if (this.g % 200 == 0) {
            this.f();
        }
        PacketDebug.a(worldserver, (Collection<Raid>)this.e.values());
    }

    public static boolean a(EntityRaider entityraider) {
        return entityraider.bJ() && entityraider.gH() && entityraider.ew() <= 2400;
    }

    @Nullable
    public Raid a(EntityPlayer entityplayer, BlockPosition blockposition) {
        BlockPosition blockposition2;
        if (entityplayer.ak()) {
            return null;
        }
        WorldServer worldserver = entityplayer.x();
        if (worldserver.O().c(GameRules.D)) {
            return null;
        }
        DimensionManager dimensionmanager = worldserver.F_();
        if (!dimensionmanager.c()) {
            return null;
        }
        List<VillagePlaceRecord> list = worldserver.A().c(holder -> holder.a(PoiTypeTags.b), blockposition, 64, VillagePlace.Occupancy.b).toList();
        int i2 = 0;
        Vec3D vec3d = Vec3D.c;
        for (VillagePlaceRecord villageplacerecord : list) {
            BlockPosition blockposition1 = villageplacerecord.g();
            vec3d = vec3d.b(blockposition1.u(), blockposition1.v(), blockposition1.w());
            ++i2;
        }
        if (i2 > 0) {
            vec3d = vec3d.c(1.0 / (double)i2);
            blockposition2 = BlockPosition.a(vec3d);
        } else {
            blockposition2 = blockposition;
        }
        Raid raid = this.a(worldserver, blockposition2);
        if (!raid.i() || raid.isInProgress() && raid.l() < raid.k()) {
            if (!CraftEventFactory.callRaidTriggerEvent(raid, worldserver, entityplayer)) {
                entityplayer.e(MobEffects.I);
                return null;
            }
            if (!raid.i() && !this.e.containsValue((Object)raid)) {
                this.e.put(this.a(), (Object)raid);
            }
            raid.a(entityplayer);
        }
        this.f();
        return raid;
    }

    private Raid a(WorldServer worldserver, BlockPosition blockposition) {
        Raid raid = worldserver.d(blockposition);
        return raid != null ? raid : new Raid(blockposition, worldserver.an());
    }

    public static PersistentRaid a(NBTTagCompound nbttagcompound) {
        return a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound).resultOrPartial().orElseGet(PersistentRaid::new);
    }

    private int a() {
        return ++this.f;
    }

    @Nullable
    public Raid a(BlockPosition blockposition, int i2) {
        Raid raid = null;
        double d0 = i2;
        for (Raid raid1 : this.e.values()) {
            double d1 = raid1.q().j(blockposition);
            if (!raid1.r() || !(d1 < d0)) continue;
            raid = raid1;
            d0 = d1;
        }
        return raid;
    }

    private static final class a
    extends Record {
        private final int b;
        private final Raid c;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(a::a), (App)Raid.b.forGetter(a::b)).apply((Applicative)instance, a::new));

        private a(int id, Raid raid) {
            this.b = id;
            this.c = raid;
        }

        public static a a(Int2ObjectMap.Entry<Raid> int2objectmap_entry) {
            return new a(int2objectmap_entry.getIntKey(), (Raid)int2objectmap_entry.getValue());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "id;raid", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "id;raid", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "id;raid", "b", "c"}, this, o2);
        }

        public int a() {
            return this.b;
        }

        public Raid b() {
            return this.c;
        }
    }
}

