/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.entity.vehicle.OldMinecartBehavior;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.BlockPoweredRail;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.util.Vector;

public abstract class EntityMinecartAbstract
extends VehicleEntity {
    private static final Vec3D b = new Vec3D(0.0, 0.0, 0.0);
    private static final DataWatcherObject<Optional<IBlockData>> c = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.j);
    private static final DataWatcherObject<Integer> d = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final ImmutableMap<EntityPose, ImmutableList<Integer>> h = ImmutableMap.of((Object)((Object)EntityPose.a), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.f), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.d), (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float a = 0.95f;
    private static final boolean i = false;
    private boolean j;
    private boolean k = false;
    private final MinecartBehavior l;
    private static final Map<BlockPropertyTrackPosition, Pair<BaseBlockPosition, BaseBlockPosition>> m = Maps.newEnumMap((Map)((Map)SystemUtils.a(() -> {
        BaseBlockPosition baseblockposition = EnumDirection.e.q();
        BaseBlockPosition baseblockposition1 = EnumDirection.f.q();
        BaseBlockPosition baseblockposition2 = EnumDirection.c.q();
        BaseBlockPosition baseblockposition3 = EnumDirection.d.q();
        BaseBlockPosition baseblockposition4 = baseblockposition.p();
        BaseBlockPosition baseblockposition5 = baseblockposition1.p();
        BaseBlockPosition baseblockposition6 = baseblockposition2.p();
        BaseBlockPosition baseblockposition7 = baseblockposition3.p();
        return ImmutableMap.of((Object)BlockPropertyTrackPosition.a, (Object)Pair.of((Object)baseblockposition2, (Object)baseblockposition3), (Object)BlockPropertyTrackPosition.b, (Object)Pair.of((Object)baseblockposition, (Object)baseblockposition1), (Object)BlockPropertyTrackPosition.c, (Object)Pair.of((Object)baseblockposition4, (Object)baseblockposition1), (Object)BlockPropertyTrackPosition.d, (Object)Pair.of((Object)baseblockposition, (Object)baseblockposition5), (Object)BlockPropertyTrackPosition.e, (Object)Pair.of((Object)baseblockposition2, (Object)baseblockposition7), (Object)BlockPropertyTrackPosition.f, (Object)Pair.of((Object)baseblockposition6, (Object)baseblockposition3), (Object)BlockPropertyTrackPosition.g, (Object)Pair.of((Object)baseblockposition3, (Object)baseblockposition1), (Object)BlockPropertyTrackPosition.h, (Object)Pair.of((Object)baseblockposition3, (Object)baseblockposition), (Object)BlockPropertyTrackPosition.i, (Object)Pair.of((Object)baseblockposition2, (Object)baseblockposition), (Object)BlockPropertyTrackPosition.j, (Object)Pair.of((Object)baseblockposition2, (Object)baseblockposition1));
    })));
    public boolean slowWhenEmpty = true;
    private double derailedX = 0.5;
    private double derailedY = 0.5;
    private double derailedZ = 0.5;
    private double flyingX = 0.95;
    private double flyingY = 0.95;
    private double flyingZ = 0.95;
    public Double maxSpeed;

    protected EntityMinecartAbstract(EntityTypes<?> entitytypes, World world) {
        super(entitytypes, world);
        this.I = true;
        this.l = EntityMinecartAbstract.b(world) ? new NewMinecartBehavior(this) : new OldMinecartBehavior(this);
    }

    protected EntityMinecartAbstract(EntityTypes<?> entitytypes, World world, double d0, double d1, double d2) {
        this(entitytypes, world);
        this.p(d0, d1, d2);
    }

    public void p(double d0, double d1, double d2) {
        this.a_(d0, d1, d2);
        this.K = d0;
        this.L = d1;
        this.M = d2;
    }

    @Nullable
    public static <T extends EntityMinecartAbstract> T a(World world, double d0, double d1, double d2, EntityTypes<T> entitytypes, EntitySpawnReason entityspawnreason, ItemStack itemstack, @Nullable EntityHuman entityhuman) {
        EntityMinecartAbstract t0 = (EntityMinecartAbstract)entitytypes.a(world, entityspawnreason);
        if (t0 != null) {
            t0.p(d0, d1, d2);
            EntityTypes.a(world, itemstack, entityhuman).accept(t0);
            MinecartBehavior minecartbehavior = t0.f();
            if (minecartbehavior instanceof NewMinecartBehavior) {
                NewMinecartBehavior newminecartbehavior = (NewMinecartBehavior)minecartbehavior;
                BlockPosition blockposition = t0.l();
                IBlockData iblockdata = world.a_(blockposition);
                newminecartbehavior.a(blockposition, iblockdata, true);
            }
        }
        return (T)t0;
    }

    public MinecartBehavior f() {
        return this.l;
    }

    @Override
    protected Entity.MovementEmission bf() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(c, Optional.empty());
        datawatcher_a.a(d, this.x());
    }

    @Override
    public boolean i(Entity entity) {
        return AbstractBoat.a(this, entity);
    }

    @Override
    public boolean bG() {
        return true;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis enumdirection_enumaxis, BlockUtil.Rectangle blockutil_rectangle) {
        return EntityLiving.k(super.a(enumdirection_enumaxis, blockutil_rectangle));
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize entitysize, float f2) {
        boolean flag = entity instanceof EntityVillager || entity instanceof EntityVillagerTrader;
        return flag ? b : super.a(entity, entitysize, f2);
    }

    @Override
    public Vec3D b(EntityLiving entityliving) {
        EnumDirection enumdirection = this.cP();
        if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            return super.b(entityliving);
        }
        int[][] aint = DismountUtil.a(enumdirection);
        BlockPosition blockposition = this.dv();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        ImmutableList<EntityPose> immutablelist = entityliving.fO();
        for (EntityPose entitypose : immutablelist) {
            EntitySize entitysize = entityliving.a(entitypose);
            float f2 = Math.min(entitysize.a(), 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableiterator1 = ((ImmutableList)h.get((Object)entitypose)).iterator();
            while (unmodifiableiterator1.hasNext()) {
                int i2 = (Integer)unmodifiableiterator1.next();
                for (int[] aint1 : aint) {
                    blockposition_mutableblockposition.d(blockposition.u() + aint1[0], blockposition.v() + i2, blockposition.w() + aint1[1]);
                    double d0 = this.dV().a(DismountUtil.a((IBlockAccess)this.dV(), (BlockPosition)blockposition_mutableblockposition), () -> DismountUtil.a((IBlockAccess)this.dV(), blockposition_mutableblockposition.e()));
                    if (!DismountUtil.a(d0)) continue;
                    AxisAlignedBB axisalignedbb = new AxisAlignedBB(-f2, 0.0, -f2, f2, entitysize.b(), f2);
                    Vec3D vec3d = Vec3D.a(blockposition_mutableblockposition, d0);
                    if (!DismountUtil.a(this.dV(), entityliving, axisalignedbb.c(vec3d))) continue;
                    entityliving.b(entitypose);
                    return vec3d;
                }
            }
        }
        double d1 = this.cR().e;
        blockposition_mutableblockposition.b((double)blockposition.u(), d1, (double)blockposition.w());
        for (EntityPose entitypose1 : immutablelist) {
            int j2;
            double d3;
            double d2 = entityliving.a(entitypose1).b();
            if (!(d1 + d2 <= (d3 = DismountUtil.a(blockposition_mutableblockposition, j2 = MathHelper.c(d1 - (double)blockposition_mutableblockposition.v() + d2), (BlockPosition blockposition1) -> this.dV().a_((BlockPosition)blockposition1).g(this.dV(), (BlockPosition)blockposition1))))) continue;
            entityliving.b(entitypose1);
            break;
        }
        return super.b(entityliving);
    }

    @Override
    protected float aS() {
        IBlockData iblockdata = this.dV().a_(this.dv());
        return iblockdata.a(TagsBlock.P) ? 1.0f : super.aS();
    }

    @Override
    public void q(float f2) {
        this.l(-this.I());
        this.d(10);
        this.b(this.G() + this.G() * 10.0f);
    }

    @Override
    public boolean bF() {
        return !this.dQ();
    }

    public static Pair<BaseBlockPosition, BaseBlockPosition> a(BlockPropertyTrackPosition blockpropertytrackposition) {
        return m.get(blockpropertytrackposition);
    }

    @Override
    public EnumDirection cP() {
        return this.l.l();
    }

    @Override
    protected double bc() {
        return this.bi() ? 0.005 : 0.04;
    }

    @Override
    public void g() {
        double prevX = this.dA();
        double prevY = this.dC();
        double prevZ = this.dG();
        float prevYaw = this.dL();
        float prevPitch = this.dN();
        if (this.H() > 0) {
            this.d(this.H() - 1);
        }
        if (this.G() > 0.0f) {
            this.b(this.G() - 1.0f);
        }
        this.ax();
        this.l.b();
        CraftWorld bworld = this.dV().getWorld();
        Location from = new Location((org.bukkit.World)bworld, prevX, prevY, prevZ, prevYaw, prevPitch);
        Location to = CraftLocation.toBukkit(this.dt(), (org.bukkit.World)bworld, this.dL(), this.dN());
        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
        this.dV().getCraftServer().getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
        if (!from.equals((Object)to)) {
            this.dV().getCraftServer().getPluginManager().callEvent((Event)new VehicleMoveEvent(vehicle, from, to));
        }
        this.bo();
        if (this.bv()) {
            this.aB();
            this.aC();
            this.Z *= 0.5;
        }
        this.ak = false;
    }

    public boolean i() {
        return this.ak;
    }

    public BlockPosition l() {
        int i2 = MathHelper.a(this.dA());
        int j2 = MathHelper.a(this.dC());
        int k2 = MathHelper.a(this.dG());
        if (EntityMinecartAbstract.b(this.dV())) {
            double d0 = this.dC() - 0.1 - (double)1.0E-5f;
            if (this.dV().a_(BlockPosition.a((double)i2, d0, (double)k2)).a(TagsBlock.P)) {
                j2 = MathHelper.a(d0);
            }
        } else if (this.dV().a_(new BlockPosition(i2, j2 - 1, k2)).a(TagsBlock.P)) {
            --j2;
        }
        return new BlockPosition(i2, j2, k2);
    }

    protected double a(WorldServer worldserver) {
        return this.l.b(worldserver);
    }

    public void a(int i2, int j2, int k2, boolean flag) {
    }

    @Override
    public void a(int i2, double d0, double d1, double d2, double d3, double d4) {
        super.a(i2, d0, d1, d2, d3, d4);
    }

    @Override
    public void be() {
        super.be();
    }

    @Override
    public void av() {
        super.av();
    }

    @Override
    public boolean bo() {
        return super.bo();
    }

    @Override
    public Vec3D ad() {
        return this.l.c(super.ad());
    }

    @Override
    public InterpolationHandler l_() {
        return this.l.a();
    }

    @Override
    public void k(double d0, double d1, double d2) {
        this.l.a(d0, d1, d2);
    }

    protected void b(WorldServer worldserver) {
        this.l.a(worldserver);
    }

    protected void e(WorldServer worldserver) {
        double d0 = this.a(worldserver);
        Vec3D vec3d = this.dy();
        this.n(MathHelper.a(vec3d.d, -d0, d0), vec3d.e, MathHelper.a(vec3d.f, -d0, d0));
        if (this.aH()) {
            this.i(new Vec3D(this.dy().d * this.derailedX, this.dy().e * this.derailedY, this.dy().f * this.derailedZ));
        }
        this.a(EnumMoveType.a, this.dy());
        if (!this.aH()) {
            this.i(new Vec3D(this.dy().d * this.flyingX, this.dy().e * this.flyingY, this.dy().f * this.flyingZ));
        }
    }

    protected double a(BlockPosition blockposition, BlockPropertyTrackPosition blockpropertytrackposition, double d0) {
        return this.l.a(blockposition, blockpropertytrackposition, d0);
    }

    @Override
    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        if (EntityMinecartAbstract.b(this.dV())) {
            Vec3D vec3d1 = this.dt().e(vec3d);
            super.a(enummovetype, vec3d);
            boolean flag = this.l.d();
            if (flag) {
                super.a(enummovetype, vec3d1.d(this.dt()));
            }
            if (enummovetype.equals((Object)EnumMoveType.c)) {
                this.j = false;
            }
        } else {
            super.a(enummovetype, vec3d);
            this.aI();
        }
    }

    @Override
    public void aI() {
        if (!EntityMinecartAbstract.b(this.dV())) {
            this.a(this.dt(), this.dt());
        } else {
            super.aI();
        }
    }

    @Override
    public boolean cp() {
        return this.j;
    }

    public void a(boolean flag) {
        this.j = flag;
    }

    public boolean m() {
        return this.k;
    }

    public void b(boolean flag) {
        this.k = flag;
    }

    public Vec3D a(BlockPosition blockposition) {
        IBlockData iblockdata = this.dV().a_(blockposition);
        if (iblockdata.a(Blocks.bw) && iblockdata.c(BlockPoweredRail.d).booleanValue()) {
            BlockPropertyTrackPosition blockpropertytrackposition = iblockdata.c(((BlockMinecartTrackAbstract)iblockdata.b()).c());
            if (blockpropertytrackposition == BlockPropertyTrackPosition.b) {
                if (this.b(blockposition.h())) {
                    return new Vec3D(1.0, 0.0, 0.0);
                }
                if (this.b(blockposition.i())) {
                    return new Vec3D(-1.0, 0.0, 0.0);
                }
            } else if (blockpropertytrackposition == BlockPropertyTrackPosition.a) {
                if (this.b(blockposition.f())) {
                    return new Vec3D(0.0, 0.0, 1.0);
                }
                if (this.b(blockposition.g())) {
                    return new Vec3D(0.0, 0.0, -1.0);
                }
            }
            return Vec3D.c;
        }
        return Vec3D.c;
    }

    public boolean b(BlockPosition blockposition) {
        return this.dV().a_(blockposition).d(this.dV(), blockposition);
    }

    protected Vec3D a(Vec3D vec3d) {
        double d0 = this.l.m();
        Vec3D vec3d1 = vec3d.d(d0, 0.0, d0);
        if (this.bi()) {
            vec3d1 = vec3d1.c((double)0.95f);
        }
        return vec3d1;
    }

    @Override
    protected void a(NBTTagCompound nbttagcompound) {
        RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
        this.a(nbttagcompound.a("DisplayState", IBlockData.a, (DynamicOps<NBTBase>)registryops));
        this.c(nbttagcompound.b("DisplayOffset", this.x()));
        this.k = nbttagcompound.b("FlippedRotation", false);
        this.ak = nbttagcompound.b("HasTicked", false);
    }

    @Override
    protected void b(NBTTagCompound nbttagcompound) {
        this.A().ifPresent(iblockdata -> {
            RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
            nbttagcompound.a("DisplayState", IBlockData.a, registryops, iblockdata);
        });
        int i2 = this.w();
        if (i2 != this.x()) {
            nbttagcompound.a("DisplayOffset", i2);
        }
        nbttagcompound.a("FlippedRotation", this.k);
        nbttagcompound.a("HasTicked", this.ak);
    }

    @Override
    public void h(Entity entity) {
        if (!(this.dV().C || entity.ad || this.ad || this.y(entity))) {
            double d1;
            VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
            this.dV().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
            if (collisionEvent.isCancelled()) {
                return;
            }
            double d0 = entity.dA() - this.dA();
            double d2 = d0 * d0 + (d1 = entity.dG() - this.dG()) * d1;
            if (d2 >= (double)1.0E-4f) {
                d2 = Math.sqrt(d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.1f;
                d1 *= (double)0.1f;
                d0 *= 0.5;
                d1 *= 0.5;
                if (entity instanceof EntityMinecartAbstract) {
                    EntityMinecartAbstract entityminecartabstract = (EntityMinecartAbstract)entity;
                    this.a(entityminecartabstract, d0, d1);
                } else {
                    this.i(-d0, 0.0, -d1);
                    entity.i(d0 / 4.0, 0.0, d1 / 4.0);
                }
            }
        }
    }

    private void a(EntityMinecartAbstract entityminecartabstract, double d0, double d1) {
        double d3;
        double d2;
        if (EntityMinecartAbstract.b(this.dV())) {
            d2 = this.dy().d;
            d3 = this.dy().f;
        } else {
            d2 = entityminecartabstract.dA() - this.dA();
            d3 = entityminecartabstract.dG() - this.dG();
        }
        Vec3D vec3d = new Vec3D(d2, 0.0, d3).d();
        Vec3D vec3d1 = new Vec3D(MathHelper.b(this.dL() * ((float)Math.PI / 180)), 0.0, MathHelper.a(this.dL() * ((float)Math.PI / 180))).d();
        double d4 = Math.abs(vec3d.b(vec3d1));
        if (d4 >= (double)0.8f || EntityMinecartAbstract.b(this.dV())) {
            Vec3D vec3d2 = this.dy();
            Vec3D vec3d3 = entityminecartabstract.dy();
            if (entityminecartabstract.z() && !this.z()) {
                this.i(vec3d2.d(0.2, 1.0, 0.2));
                this.i(vec3d3.d - d0, 0.0, vec3d3.f - d1);
                entityminecartabstract.i(vec3d3.d(0.95, 1.0, 0.95));
            } else if (!entityminecartabstract.z() && this.z()) {
                entityminecartabstract.i(vec3d3.d(0.2, 1.0, 0.2));
                entityminecartabstract.i(vec3d2.d + d0, 0.0, vec3d2.f + d1);
                this.i(vec3d2.d(0.95, 1.0, 0.95));
            } else {
                double d5 = (vec3d3.d + vec3d2.d) / 2.0;
                double d6 = (vec3d3.f + vec3d2.f) / 2.0;
                this.i(vec3d2.d(0.2, 1.0, 0.2));
                this.i(d5 - d0, 0.0, d6 - d1);
                entityminecartabstract.i(vec3d3.d(0.2, 1.0, 0.2));
                entityminecartabstract.i(d5 + d0, 0.0, d6 + d1);
            }
        }
    }

    public IBlockData n() {
        return this.A().orElseGet(this::v);
    }

    private Optional<IBlockData> A() {
        return this.ar().a(c);
    }

    public IBlockData v() {
        return Blocks.a.m();
    }

    public int w() {
        return this.ar().a(d);
    }

    public int x() {
        return 6;
    }

    public void a(Optional<IBlockData> optional) {
        this.ar().a(c, optional);
    }

    public void c(int i2) {
        this.ar().a(d, i2);
    }

    public static boolean b(World world) {
        return world.K().b(FeatureFlags.d);
    }

    @Override
    public abstract ItemStack dI();

    public boolean y() {
        return false;
    }

    public boolean z() {
        return false;
    }

    public Vector getFlyingVelocityMod() {
        return new Vector(this.flyingX, this.flyingY, this.flyingZ);
    }

    public void setFlyingVelocityMod(Vector flying) {
        this.flyingX = flying.getX();
        this.flyingY = flying.getY();
        this.flyingZ = flying.getZ();
    }

    public Vector getDerailedVelocityMod() {
        return new Vector(this.derailedX, this.derailedY, this.derailedZ);
    }

    public void setDerailedVelocityMod(Vector derailed) {
        this.derailedX = derailed.getX();
        this.derailedY = derailed.getY();
        this.derailedZ = derailed.getZ();
    }
}

