/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class ItemMonsterEgg
extends Item {
    private static final Map<EntityTypes<? extends EntityInsentient>, ItemMonsterEgg> a = Maps.newIdentityHashMap();
    private final EntityTypes<?> b;

    public ItemMonsterEgg(EntityTypes<? extends EntityInsentient> entitytypes, Item.Info item_info) {
        super(item_info);
        this.b = entitytypes;
        a.put(entitytypes, this);
    }

    @Override
    public EnumInteractionResult a(ItemActionContext itemactioncontext) {
        World world = itemactioncontext.q();
        if (world.C) {
            return EnumInteractionResult.a;
        }
        ItemStack itemstack = itemactioncontext.n();
        BlockPosition blockposition = itemactioncontext.a();
        EnumDirection enumdirection = itemactioncontext.k();
        IBlockData iblockdata = world.a_(blockposition);
        TileEntity tileentity = world.c_(blockposition);
        if (tileentity instanceof Spawner) {
            Spawner spawner = (Spawner)((Object)tileentity);
            EntityTypes<?> entitytypes = this.a(world.J_(), itemstack);
            spawner.a(entitytypes, world.G_());
            world.a(blockposition, iblockdata, iblockdata, 3);
            world.a((Entity)itemactioncontext.o(), GameEvent.c, blockposition);
            itemstack.h(1);
            return EnumInteractionResult.a;
        }
        BlockPosition blockposition1 = iblockdata.g(world, blockposition).c() ? blockposition : blockposition.a(enumdirection);
        EntityTypes<?> entitytypes1 = this.a(world.J_(), itemstack);
        if (entitytypes1.a((WorldServer)world, itemstack, itemactioncontext.o(), blockposition1, EntitySpawnReason.m, true, !Objects.equals(blockposition, blockposition1) && enumdirection == EnumDirection.b) != null) {
            itemstack.h(1);
            world.a((Entity)itemactioncontext.o(), GameEvent.t, blockposition);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public EnumInteractionResult a(World world, EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        MovingObjectPositionBlock movingobjectpositionblock = ItemMonsterEgg.a(world, entityhuman, RayTrace.FluidCollisionOption.b);
        if (movingobjectpositionblock.d() != MovingObjectPosition.EnumMovingObjectType.b) {
            return EnumInteractionResult.e;
        }
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            BlockPosition blockposition = movingobjectpositionblock.b();
            if (!(world.a_(blockposition).b() instanceof BlockFluids)) {
                return EnumInteractionResult.e;
            }
            if (world.a((Entity)entityhuman, blockposition) && entityhuman.a(blockposition, movingobjectpositionblock.c(), itemstack)) {
                EntityTypes<?> entitytypes = this.a(worldserver.J_(), itemstack);
                Object entity = entitytypes.a(worldserver, itemstack, entityhuman, blockposition, EntitySpawnReason.m, false, false);
                if (entity == null) {
                    return EnumInteractionResult.e;
                }
                itemstack.a(1, (EntityLiving)entityhuman);
                entityhuman.b(StatisticList.c.b(this));
                world.a((Entity)entityhuman, GameEvent.t, ((Entity)entity).dt());
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.d;
        }
        return EnumInteractionResult.a;
    }

    public boolean a(HolderLookup.a holderlookup_a, ItemStack itemstack, EntityTypes<?> entitytypes) {
        return Objects.equals(this.a(holderlookup_a, itemstack), entitytypes);
    }

    @Nullable
    public static ItemMonsterEgg a(@Nullable EntityTypes<?> entitytypes) {
        return a.get(entitytypes);
    }

    public static Iterable<ItemMonsterEgg> a() {
        return Iterables.unmodifiableIterable(a.values());
    }

    public EntityTypes<?> a(HolderLookup.a holderlookup_a, ItemStack itemstack) {
        EntityTypes<?> entitytypes;
        CustomData customdata = itemstack.a(DataComponents.Y, CustomData.a);
        if (!customdata.c() && (entitytypes = customdata.a(holderlookup_a, Registries.B)) != null) {
            return entitytypes;
        }
        return this.b;
    }

    @Override
    public FeatureFlagSet k() {
        return this.b.k();
    }

    public Optional<EntityInsentient> a(EntityHuman entityhuman, EntityInsentient entityinsentient, EntityTypes<? extends EntityInsentient> entitytypes, WorldServer worldserver, Vec3D vec3d, ItemStack itemstack) {
        if (!this.a(worldserver.J_(), itemstack, entitytypes)) {
            return Optional.empty();
        }
        EntityInsentient entityinsentient1 = entityinsentient instanceof EntityAgeable ? ((EntityAgeable)entityinsentient).a(worldserver, (EntityAgeable)entityinsentient) : entitytypes.a(worldserver, EntitySpawnReason.m);
        if (entityinsentient1 == null) {
            return Optional.empty();
        }
        entityinsentient1.a(true);
        if (!entityinsentient1.e_()) {
            return Optional.empty();
        }
        entityinsentient1.b(vec3d.a(), vec3d.b(), vec3d.c(), 0.0f, 0.0f);
        entityinsentient1.c(itemstack);
        worldserver.addFreshEntityWithPassengers(entityinsentient1, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        itemstack.a(1, (EntityLiving)entityhuman);
        return Optional.of(entityinsentient1);
    }

    @Override
    public boolean a(ItemStack itemstack, @Nullable EntityHuman entityhuman) {
        CustomData customdata;
        if (entityhuman != null && entityhuman.F() >= 2 && (customdata = itemstack.a(DataComponents.Y)) != null) {
            EntityTypes<?> entitytypes = customdata.a(entityhuman.dV().J_(), Registries.B);
            return entitytypes != null && entitytypes.s();
        }
        return false;
    }
}

