/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ExplosionDamageCalculatorEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;

public class ServerExplosion
implements Explosion {
    private static final ExplosionDamageCalculator a = new ExplosionDamageCalculator();
    private static final int b = 16;
    private static final float c = 2.0f;
    private final boolean d;
    private final Explosion.Effect e;
    private final WorldServer f;
    private final Vec3D g;
    @Nullable
    private final Entity h;
    private final float i;
    private final DamageSource j;
    private final ExplosionDamageCalculator k;
    private final Map<EntityHuman, Vec3D> l = new HashMap<EntityHuman, Vec3D>();
    public boolean wasCanceled = false;
    public float yield;

    public ServerExplosion(WorldServer worldserver, @Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, Vec3D vec3d, float f2, boolean flag, Explosion.Effect explosion_effect) {
        this.f = worldserver;
        this.h = entity;
        this.i = (float)Math.max((double)f2, 0.0);
        this.g = vec3d;
        this.d = flag;
        this.e = explosion_effect;
        this.j = damagesource == null ? worldserver.al().a(this) : damagesource;
        this.k = explosiondamagecalculator == null ? this.b(entity) : explosiondamagecalculator;
        this.yield = this.e == Explosion.Effect.c ? 1.0f / this.i : 1.0f;
    }

    private ExplosionDamageCalculator b(@Nullable Entity entity) {
        return entity == null ? a : new ExplosionDamageCalculatorEntity(entity);
    }

    public static float a(Vec3D vec3d, Entity entity) {
        AxisAlignedBB axisalignedbb = entity.cR();
        double d0 = 1.0 / ((axisalignedbb.d - axisalignedbb.a) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.e - axisalignedbb.b) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.f - axisalignedbb.c) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (d0 >= 0.0 && d1 >= 0.0 && d2 >= 0.0) {
            int i2 = 0;
            int j2 = 0;
            for (double d5 = 0.0; d5 <= 1.0; d5 += d0) {
                for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                    for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                        double d8 = MathHelper.d(d5, axisalignedbb.a, axisalignedbb.d);
                        double d9 = MathHelper.d(d6, axisalignedbb.b, axisalignedbb.e);
                        double d10 = MathHelper.d(d7, axisalignedbb.c, axisalignedbb.f);
                        Vec3D vec3d1 = new Vec3D(d8 + d3, d9, d10 + d4);
                        if (entity.dV().a(new RayTrace(vec3d1, vec3d, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, entity)).d() == MovingObjectPosition.EnumMovingObjectType.a) {
                            ++i2;
                        }
                        ++j2;
                    }
                }
            }
            return (float)i2 / (float)j2;
        }
        return 0.0f;
    }

    @Override
    public float e() {
        return this.i;
    }

    @Override
    public Vec3D f() {
        return this.g;
    }

    private List<BlockPosition> m() {
        HashSet<BlockPosition> set = new HashSet<BlockPosition>();
        int i2 = 16;
        for (int j2 = 0; j2 < 16; ++j2) {
            for (int k2 = 0; k2 < 16; ++k2) {
                block2: for (int l2 = 0; l2 < 16; ++l2) {
                    if (j2 != 0 && j2 != 15 && k2 != 0 && k2 != 15 && l2 != 0 && l2 != 15) continue;
                    double d0 = (float)j2 / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k2 / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l2 / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.g.d;
                    double d5 = this.g.e;
                    double d6 = this.g.f;
                    float f1 = 0.3f;
                    for (float f2 = this.i * (0.7f + this.f.A.i() * 0.6f); f2 > 0.0f; f2 -= 0.22500001f) {
                        BlockPosition blockposition = BlockPosition.a(d4, d5, d6);
                        IBlockData iblockdata = this.f.a_(blockposition);
                        Fluid fluid = this.f.b_(blockposition);
                        if (!this.f.k(blockposition)) continue block2;
                        Optional<Float> optional = this.k.a((Explosion)this, (IBlockAccess)this.f, blockposition, iblockdata, fluid);
                        if (optional.isPresent()) {
                            f2 -= (optional.get().floatValue() + 0.3f) * 0.3f;
                        }
                        if (f2 > 0.0f && this.k.a((Explosion)this, (IBlockAccess)this.f, blockposition, iblockdata, f2)) {
                            set.add(blockposition);
                        }
                        d4 += d0 * (double)0.3f;
                        d5 += d1 * (double)0.3f;
                        d6 += d2 * (double)0.3f;
                    }
                }
            }
        }
        return new ObjectArrayList(set);
    }

    private void n() {
        float f2 = this.i * 2.0f;
        int i2 = MathHelper.a(this.g.d - (double)f2 - 1.0);
        int j2 = MathHelper.a(this.g.d + (double)f2 + 1.0);
        int k2 = MathHelper.a(this.g.e - (double)f2 - 1.0);
        int l2 = MathHelper.a(this.g.e + (double)f2 + 1.0);
        int i1 = MathHelper.a(this.g.f - (double)f2 - 1.0);
        int j1 = MathHelper.a(this.g.f + (double)f2 + 1.0);
        List<Entity> list = this.f.a_(this.h, new AxisAlignedBB(i2, k2, i1, j2, l2, j1));
        for (Entity entity : list) {
            EntityHuman entityhuman;
            double d6;
            float f22;
            double d3;
            double d2;
            double d1;
            double d4;
            double d0;
            if (entity.a(this) || !((d0 = Math.sqrt(entity.g(this.g)) / (double)f2) <= 1.0) || (d4 = Math.sqrt((d1 = entity.dA() - this.g.d) * d1 + (d2 = (entity instanceof EntityTNTPrimed ? entity.dC() : entity.dE()) - this.g.e) * d2 + (d3 = entity.dG() - this.g.f) * d3)) == 0.0) continue;
            d1 /= d4;
            d2 /= d4;
            d3 /= d4;
            boolean flag = this.k.a(this, entity);
            float f1 = this.k.a(entity);
            float f3 = f22 = !flag && f1 == 0.0f ? 0.0f : ServerExplosion.a(this.g, entity);
            if (flag) {
                if (entity instanceof EntityComplexPart) continue;
                entity.lastDamageCancelled = false;
                if (entity instanceof EntityEnderDragon) {
                    for (EntityComplexPart entityComplexPart : ((EntityEnderDragon)entity).bS) {
                        if (!list.contains(entityComplexPart)) continue;
                        entityComplexPart.a(this.f, this.j, this.k.a(this, entity, f22));
                    }
                } else {
                    entity.a(this.f, this.j, this.k.a(this, entity, f22));
                }
                if (entity.lastDamageCancelled) continue;
            }
            double d5 = (1.0 - d0) * (double)f22 * (double)f1;
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                d6 = d5 * (1.0 - entityliving.h(GenericAttributes.i));
            } else {
                d6 = d5;
            }
            Vec3D vec3d = new Vec3D(d1 *= d6, d2 *= d6, d3 *= d6);
            if (entity instanceof EntityLiving) {
                Vec3D result = entity.dy().e(vec3d);
                EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)entity.getBukkitEntity(), this.h, EntityKnockbackEvent.KnockbackCause.EXPLOSION, d6, vec3d, result.d, result.e, result.f);
                vec3d = event.isCancelled() ? Vec3D.c : new Vec3D(event.getFinalKnockback().getX(), event.getFinalKnockback().getY(), event.getFinalKnockback().getZ()).d(entity.dy());
            }
            entity.h(vec3d);
            if (!(!(entity instanceof EntityHuman) || (entityhuman = (EntityHuman)entity).ak() || entityhuman.gz() && entityhuman.gk().b)) {
                this.l.put(entityhuman, vec3d);
            }
            entity.b_(this.h);
        }
    }

    private void a(List<BlockPosition> list) {
        ArrayList list1 = new ArrayList();
        SystemUtils.c(list, this.f.A);
        List<org.bukkit.block.Block> bukkitBlocks = CraftEventFactory.handleExplodeEvent(this, list);
        list.clear();
        list.addAll(bukkitBlocks.stream().map(bblock -> new BlockPosition(bblock.getX(), bblock.getY(), bblock.getZ())).toList());
        if (this.wasCanceled) {
            return;
        }
        for (BlockPosition blockposition : list) {
            IBlockData iblockdata = this.f.a_(blockposition);
            Block block = iblockdata.b();
            if (block instanceof BlockTNT) {
                BlockPosition sourceBlock;
                BlockPosition blockPosition = sourceBlock = this.h == null ? BlockPosition.a(this.g) : null;
                if (!CraftEventFactory.callTNTPrimeEvent(this.f, blockposition, TNTPrimeEvent.PrimeCause.EXPLOSION, this.h, sourceBlock)) {
                    this.f.a(blockposition, Blocks.a.m(), iblockdata, 3);
                    continue;
                }
            }
            this.f.a_(blockposition).a(this.f, blockposition, this, (itemstack, blockposition1) -> ServerExplosion.a(list1, itemstack, blockposition1));
        }
        for (a serverexplosion_a : list1) {
            Block.a((World)this.f, serverexplosion_a.a, serverexplosion_a.b);
        }
    }

    private void b(List<BlockPosition> list) {
        for (BlockPosition blockposition : list) {
            if (this.f.A.a(3) != 0 || !this.f.a_(blockposition).l() || !this.f.a_(blockposition.e()).s() || CraftEventFactory.callBlockIgniteEvent((World)this.f, blockposition, this).isCancelled()) continue;
            this.f.b(blockposition, BlockFireAbstract.a(this.f, blockposition));
        }
    }

    public void i() {
        if (this.i < 0.1f) {
            return;
        }
        this.f.a(this.h, GameEvent.w, this.g);
        List<BlockPosition> list = this.m();
        this.n();
        if (this.o()) {
            GameProfilerFiller gameprofilerfiller = Profiler.a();
            gameprofilerfiller.a("explosion_blocks");
            this.a(list);
            gameprofilerfiller.c();
        } else {
            SystemUtils.c(list, this.f.A);
            List<org.bukkit.block.Block> bukkitBlocks = CraftEventFactory.handleExplodeEvent(this, list);
            list.clear();
            list.addAll(bukkitBlocks.stream().map(bblock -> new BlockPosition(bblock.getX(), bblock.getY(), bblock.getZ())).toList());
        }
        if (this.d) {
            this.b(list);
        }
    }

    private static void a(List<a> list, ItemStack itemstack, BlockPosition blockposition) {
        if (itemstack.f()) {
            return;
        }
        for (a serverexplosion_a : list) {
            serverexplosion_a.a(itemstack);
            if (!itemstack.f()) continue;
            return;
        }
        list.add(new a(blockposition, itemstack));
    }

    private boolean o() {
        return this.e != Explosion.Effect.a;
    }

    public Map<EntityHuman, Vec3D> j() {
        return this.l;
    }

    @Override
    public WorldServer a() {
        return this.f;
    }

    @Override
    @Nullable
    public EntityLiving c() {
        return Explosion.a(this.h);
    }

    @Override
    @Nullable
    public Entity d() {
        return this.h;
    }

    public DamageSource k() {
        return this.j;
    }

    @Override
    public Explosion.Effect b() {
        return this.e;
    }

    @Override
    public boolean g() {
        return this.e != Explosion.Effect.d ? false : (this.h != null && this.h.an() == EntityTypes.t ? this.f.O().c(GameRules.d) : true);
    }

    @Override
    public boolean h() {
        boolean flag2;
        boolean flag = this.f.O().c(GameRules.d);
        boolean flag1 = this.h == null || !this.h.bi();
        boolean bl = flag2 = this.h == null || this.h.an() != EntityTypes.t && this.h.an() != EntityTypes.bI;
        return flag ? flag1 && flag2 : this.e.a() && flag1 && flag2;
    }

    public boolean l() {
        return this.i < 2.0f || !this.o();
    }

    private static class a {
        final BlockPosition a;
        ItemStack b;

        a(BlockPosition blockposition, ItemStack itemstack) {
            this.a = blockposition;
            this.b = itemstack;
        }

        public void a(ItemStack itemstack) {
            if (EntityItem.a(this.b, itemstack)) {
                this.b = EntityItem.a(this.b, itemstack, 16);
            }
        }
    }
}

