/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.PointGroupO;
import com.mojang.math.Quadrant;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockFinder;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBed;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBedPart;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;

public class BlockBed
extends BlockFacingHorizontal
implements ITileEntity {
    public static final MapCodec<BlockBed> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EnumColor.q.fieldOf("color").forGetter(BlockBed::b), BlockBed.t()).apply((Applicative)instance, BlockBed::new));
    public static final BlockStateEnum<BlockPropertyBedPart> b = BlockProperties.be;
    public static final BlockStateBoolean c = BlockProperties.x;
    private static final Map<EnumDirection, VoxelShape> d = SystemUtils.a(() -> {
        VoxelShape voxelshape = Block.a(0.0, 0.0, 0.0, 3.0, 3.0, 3.0);
        VoxelShape voxelshape1 = VoxelShapes.a(voxelshape, PointGroupO.a(Quadrant.a, Quadrant.b));
        return VoxelShapes.c(VoxelShapes.a(Block.b(16.0, 3.0, 9.0), voxelshape, voxelshape1));
    });
    private final EnumColor f;

    public MapCodec<BlockBed> a() {
        return a;
    }

    public BlockBed(EnumColor enumcolor, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.f = enumcolor;
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b()).b(b, BlockPropertyBedPart.b)).b(c, false));
    }

    @Nullable
    public static EnumDirection a(IBlockAccess iblockaccess, BlockPosition blockposition) {
        IBlockData iblockdata = iblockaccess.a_(blockposition);
        return iblockdata.b() instanceof BlockBed ? (EnumDirection)iblockdata.c(e) : null;
    }

    @Override
    protected EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (world.C) {
            return EnumInteractionResult.b;
        }
        if (iblockdata.c(b) != BlockPropertyBedPart.a && !(iblockdata = world.a_(blockposition = blockposition.a((EnumDirection)iblockdata.c(e)))).a(this)) {
            return EnumInteractionResult.c;
        }
        if (iblockdata.c(c).booleanValue()) {
            if (!this.a(world, blockposition)) {
                entityhuman.a(IChatBaseComponent.c("block.minecraft.bed.occupied"), true);
            }
            return EnumInteractionResult.b;
        }
        IBlockData finaliblockdata = iblockdata;
        BlockPosition finalblockposition = blockposition;
        entityhuman.a(blockposition).ifLeft(entityhuman_enumbedresult -> {
            if (!world.F_().l()) {
                this.explodeBed(finaliblockdata, world, finalblockposition);
            } else if (entityhuman_enumbedresult.a() != null) {
                entityhuman.a(entityhuman_enumbedresult.a(), true);
            }
        });
        return EnumInteractionResult.b;
    }

    private EnumInteractionResult explodeBed(IBlockData iblockdata, World world, BlockPosition blockposition) {
        BlockState blockState = CraftBlock.at(world, blockposition).getState();
        world.a(blockposition, false);
        BlockPosition blockposition1 = blockposition.a(((EnumDirection)iblockdata.c(e)).g());
        if (world.a_(blockposition1).b() == this) {
            world.a(blockposition1, false);
        }
        Vec3D vec3d = blockposition.b();
        world.a((Entity)null, world.al().badRespawnPointExplosion(vec3d, blockState), (ExplosionDamageCalculator)null, vec3d, 5.0f, true, World.a.b);
        return EnumInteractionResult.a;
    }

    public static boolean a(World world) {
        return true;
    }

    private boolean a(World world, BlockPosition blockposition) {
        List<EntityVillager> list = world.a(EntityVillager.class, new AxisAlignedBB(blockposition), EntityLiving::fR);
        if (list.isEmpty()) {
            return false;
        }
        list.get(0).fS();
        return true;
    }

    @Override
    public void a(World world, IBlockData iblockdata, BlockPosition blockposition, Entity entity, double d0) {
        super.a(world, iblockdata, blockposition, entity, d0 * 0.5);
    }

    @Override
    public void a(IBlockAccess iblockaccess, Entity entity) {
        if (entity.ce()) {
            super.a(iblockaccess, entity);
        } else {
            this.a(entity);
        }
    }

    private void a(Entity entity) {
        Vec3D vec3d = entity.dy();
        if (vec3d.e < 0.0) {
            double d0 = entity instanceof EntityLiving ? 1.0 : 0.8;
            entity.n(vec3d.d, -vec3d.e * (double)0.66f * d0, vec3d.f);
        }
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, IWorldReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata1, RandomSource randomsource) {
        return enumdirection == BlockBed.a(iblockdata.c(b), (EnumDirection)iblockdata.c(e)) ? (iblockdata1.a(this) && iblockdata1.c(b) != iblockdata.c(b) ? (IBlockData)iblockdata.b(c, iblockdata1.c(c)) : Blocks.a.m()) : super.a(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    private static EnumDirection a(BlockPropertyBedPart blockpropertybedpart, EnumDirection enumdirection) {
        return blockpropertybedpart == BlockPropertyBedPart.b ? enumdirection : enumdirection.g();
    }

    @Override
    public IBlockData a(World world, BlockPosition blockposition, IBlockData iblockdata, EntityHuman entityhuman) {
        BlockPosition blockposition1;
        IBlockData iblockdata1;
        BlockPropertyBedPart blockpropertybedpart;
        if (!world.C && entityhuman.gl() && (blockpropertybedpart = iblockdata.c(b)) == BlockPropertyBedPart.b && (iblockdata1 = world.a_(blockposition1 = blockposition.a(BlockBed.a(blockpropertybedpart, (EnumDirection)iblockdata.c(e))))).a(this) && iblockdata1.c(b) == BlockPropertyBedPart.a) {
            world.a(blockposition1, Blocks.a.m(), 35);
            world.a((Entity)entityhuman, 2001, blockposition1, Block.j(iblockdata1));
        }
        return super.a(world, blockposition, iblockdata, entityhuman);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext blockactioncontext) {
        EnumDirection enumdirection = blockactioncontext.g();
        BlockPosition blockposition = blockactioncontext.a();
        BlockPosition blockposition1 = blockposition.a(enumdirection);
        World world = blockactioncontext.q();
        return world.a_(blockposition1).a(blockactioncontext) && world.E_().a(blockposition1) ? (IBlockData)this.m().b(e, enumdirection) : null;
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return d.get(BlockBed.h(iblockdata).g());
    }

    public static EnumDirection h(IBlockData iblockdata) {
        EnumDirection enumdirection = (EnumDirection)iblockdata.c(e);
        return iblockdata.c(b) == BlockPropertyBedPart.a ? enumdirection.g() : enumdirection;
    }

    public static DoubleBlockFinder.BlockType i(IBlockData iblockdata) {
        BlockPropertyBedPart blockpropertybedpart = iblockdata.c(b);
        return blockpropertybedpart == BlockPropertyBedPart.a ? DoubleBlockFinder.BlockType.b : DoubleBlockFinder.BlockType.c;
    }

    private static boolean b(IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockaccess.a_(blockposition.e()).b() instanceof BlockBed;
    }

    public static Optional<Vec3D> a(EntityTypes<?> entitytypes, ICollisionAccess icollisionaccess, BlockPosition blockposition, EnumDirection enumdirection, float f2) {
        EnumDirection enumdirection2;
        EnumDirection enumdirection1 = enumdirection.h();
        EnumDirection enumDirection = enumdirection2 = enumdirection1.a(f2) ? enumdirection1.g() : enumdirection1;
        if (BlockBed.b(icollisionaccess, blockposition)) {
            return BlockBed.a(entitytypes, icollisionaccess, blockposition, enumdirection, enumdirection2);
        }
        int[][] aint = BlockBed.a(enumdirection, enumdirection2);
        Optional<Vec3D> optional = BlockBed.a(entitytypes, icollisionaccess, blockposition, aint, true);
        return optional.isPresent() ? optional : BlockBed.a(entitytypes, icollisionaccess, blockposition, aint, false);
    }

    private static Optional<Vec3D> a(EntityTypes<?> entitytypes, ICollisionAccess icollisionaccess, BlockPosition blockposition, EnumDirection enumdirection, EnumDirection enumdirection1) {
        int[][] aint = BlockBed.b(enumdirection, enumdirection1);
        Optional<Vec3D> optional = BlockBed.a(entitytypes, icollisionaccess, blockposition, aint, true);
        if (optional.isPresent()) {
            return optional;
        }
        BlockPosition blockposition1 = blockposition.e();
        Optional<Vec3D> optional1 = BlockBed.a(entitytypes, icollisionaccess, blockposition1, aint, true);
        if (optional1.isPresent()) {
            return optional1;
        }
        int[][] aint1 = BlockBed.a(enumdirection);
        Optional<Vec3D> optional2 = BlockBed.a(entitytypes, icollisionaccess, blockposition, aint1, true);
        if (optional2.isPresent()) {
            return optional2;
        }
        Optional<Vec3D> optional3 = BlockBed.a(entitytypes, icollisionaccess, blockposition, aint, false);
        if (optional3.isPresent()) {
            return optional3;
        }
        Optional<Vec3D> optional4 = BlockBed.a(entitytypes, icollisionaccess, blockposition1, aint, false);
        return optional4.isPresent() ? optional4 : BlockBed.a(entitytypes, icollisionaccess, blockposition, aint1, false);
    }

    private static Optional<Vec3D> a(EntityTypes<?> entitytypes, ICollisionAccess icollisionaccess, BlockPosition blockposition, int[][] aint, boolean flag) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int[] aint1 : aint) {
            blockposition_mutableblockposition.d(blockposition.u() + aint1[0], blockposition.v(), blockposition.w() + aint1[1]);
            Vec3D vec3d = DismountUtil.a(entitytypes, icollisionaccess, blockposition_mutableblockposition, flag);
            if (vec3d == null) continue;
            return Optional.of(vec3d);
        }
        return Optional.empty();
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(e, b, c);
    }

    @Override
    public TileEntity a(BlockPosition blockposition, IBlockData iblockdata) {
        return new TileEntityBed(blockposition, iblockdata, this.f);
    }

    @Override
    public void a(World world, BlockPosition blockposition, IBlockData iblockdata, @Nullable EntityLiving entityliving, ItemStack itemstack) {
        super.a(world, blockposition, iblockdata, entityliving, itemstack);
        if (!world.C) {
            BlockPosition blockposition1 = blockposition.a((EnumDirection)iblockdata.c(e));
            world.a(blockposition1, (IBlockData)iblockdata.b(b, BlockPropertyBedPart.a), 3);
            if (world.captureBlockStates) {
                return;
            }
            world.a(blockposition, Blocks.a);
            iblockdata.a((GeneratorAccess)world, blockposition, 3);
        }
    }

    public EnumColor b() {
        return this.f;
    }

    @Override
    protected long a(IBlockData iblockdata, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.a((EnumDirection)iblockdata.c(e), iblockdata.c(b) == BlockPropertyBedPart.a ? 0 : 1);
        return MathHelper.b(blockposition1.u(), blockposition.v(), blockposition1.w());
    }

    @Override
    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }

    private static int[][] a(EnumDirection enumdirection, EnumDirection enumdirection1) {
        return (int[][])ArrayUtils.addAll((Object[])BlockBed.b(enumdirection, enumdirection1), (Object[])BlockBed.a(enumdirection));
    }

    private static int[][] b(EnumDirection enumdirection, EnumDirection enumdirection1) {
        return new int[][]{{enumdirection1.j(), enumdirection1.l()}, {enumdirection1.j() - enumdirection.j(), enumdirection1.l() - enumdirection.l()}, {enumdirection1.j() - enumdirection.j() * 2, enumdirection1.l() - enumdirection.l() * 2}, {-enumdirection.j() * 2, -enumdirection.l() * 2}, {-enumdirection1.j() - enumdirection.j() * 2, -enumdirection1.l() - enumdirection.l() * 2}, {-enumdirection1.j() - enumdirection.j(), -enumdirection1.l() - enumdirection.l()}, {-enumdirection1.j(), -enumdirection1.l()}, {-enumdirection1.j() + enumdirection.j(), -enumdirection1.l() + enumdirection.l()}, {enumdirection.j(), enumdirection.l()}, {enumdirection1.j() + enumdirection.j(), enumdirection1.l() + enumdirection.l()}};
    }

    private static int[][] a(EnumDirection enumdirection) {
        return new int[][]{{0, 0}, {-enumdirection.j(), -enumdirection.l()}};
    }
}

