/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.block.NotePlayEvent;

public class BlockNote
extends Block {
    public static final MapCodec<BlockNote> a = BlockNote.b(BlockNote::new);
    public static final BlockStateEnum<BlockPropertyInstrument> b = BlockProperties.bi;
    public static final BlockStateBoolean c = BlockProperties.A;
    public static final BlockStateInteger d = BlockProperties.aU;
    public static final int e = 3;

    public MapCodec<BlockNote> a() {
        return a;
    }

    public BlockNote(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b()).b(b, BlockPropertyInstrument.a)).b(d, 0)).b(c, false));
    }

    private IBlockData a(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        BlockPropertyInstrument blockpropertyinstrument = iworldreader.a_(blockposition.d()).E();
        if (blockpropertyinstrument.e()) {
            return (IBlockData)iblockdata.b(b, blockpropertyinstrument);
        }
        BlockPropertyInstrument blockpropertyinstrument1 = iworldreader.a_(blockposition.e()).E();
        BlockPropertyInstrument blockpropertyinstrument2 = blockpropertyinstrument1.e() ? BlockPropertyInstrument.a : blockpropertyinstrument1;
        return (IBlockData)iblockdata.b(b, blockpropertyinstrument2);
    }

    @Override
    public IBlockData a(BlockActionContext blockactioncontext) {
        return this.a((IWorldReader)blockactioncontext.q(), blockactioncontext.a(), this.m());
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, IWorldReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata1, RandomSource randomsource) {
        boolean flag = enumdirection.o() == EnumDirection.EnumAxis.b;
        return flag ? this.a(iworldreader, blockposition, iblockdata) : super.a(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        boolean flag1 = world.D(blockposition);
        if (flag1 != iblockdata.c(c)) {
            if (flag1) {
                this.a((Entity)null, iblockdata, world, blockposition);
                iblockdata = world.a_(blockposition);
            }
            world.a(blockposition, (IBlockData)iblockdata.b(c, flag1), 3);
        }
    }

    private void a(@Nullable Entity entity, IBlockData iblockdata, World world, BlockPosition blockposition) {
        if (iblockdata.c(b).e() || world.a_(blockposition.d()).l()) {
            NotePlayEvent event = CraftEventFactory.callNotePlayEvent(world, blockposition, iblockdata.c(b), iblockdata.c(d));
            if (event.isCancelled()) {
                return;
            }
            world.a(blockposition, (Block)this, 0, 0);
            world.a(entity, GameEvent.H, blockposition);
        }
    }

    @Override
    protected EnumInteractionResult a(ItemStack itemstack, IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        return itemstack.a(TagsItem.by) && movingobjectpositionblock.c() == EnumDirection.b ? EnumInteractionResult.e : super.a(itemstack, iblockdata, world, blockposition, entityhuman, enumhand, movingobjectpositionblock);
    }

    @Override
    protected EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (!world.C) {
            iblockdata = (IBlockData)iblockdata.a(d);
            world.a(blockposition, iblockdata, 3);
            this.a(entityhuman, iblockdata, world, blockposition);
            entityhuman.a(StatisticList.ag);
        }
        return EnumInteractionResult.a;
    }

    @Override
    protected void a_(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman) {
        if (!world.C) {
            this.a(entityhuman, iblockdata, world, blockposition);
            entityhuman.a(StatisticList.af);
        }
    }

    public static float b(int i2) {
        return (float)Math.pow(2.0, (double)(i2 - 12) / 12.0);
    }

    @Override
    protected boolean a(IBlockData iblockdata, World world, BlockPosition blockposition, int i2, int j2) {
        Holder<SoundEffect> holder;
        float f2;
        BlockPropertyInstrument blockpropertyinstrument = iblockdata.c(b);
        if (blockpropertyinstrument.b()) {
            int k2 = iblockdata.c(d);
            f2 = BlockNote.b(k2);
            world.a(Particles.ad, (double)blockposition.u() + 0.5, (double)blockposition.v() + 1.2, (double)blockposition.w() + 0.5, (double)k2 / 24.0, 0.0, 0.0);
        } else {
            f2 = 1.0f;
        }
        if (blockpropertyinstrument.d()) {
            MinecraftKey minecraftkey = this.a(world, blockposition);
            if (minecraftkey == null) {
                return false;
            }
            holder = Holder.a(SoundEffect.a(minecraftkey));
        } else {
            holder = blockpropertyinstrument.a();
        }
        world.a((Entity)null, (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, holder, SoundCategory.c, 3.0f, f2, world.A.g());
        return true;
    }

    @Nullable
    private MinecraftKey a(World world, BlockPosition blockposition) {
        TileEntity tileentity = world.c_(blockposition.d());
        if (tileentity instanceof TileEntitySkull) {
            TileEntitySkull tileentityskull = (TileEntitySkull)tileentity;
            return tileentityskull.d();
        }
        return null;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(b, c, d);
    }
}

