/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.BlockPistonMoving;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BlockSoil
extends Block {
    public static final MapCodec<BlockSoil> a = BlockSoil.b(BlockSoil::new);
    public static final BlockStateInteger b = BlockProperties.aT;
    private static final VoxelShape d = Block.b(16.0, 0.0, 15.0);
    public static final int c = 7;

    public MapCodec<BlockSoil> a() {
        return a;
    }

    protected BlockSoil(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.l((IBlockData)((IBlockData)this.C.b()).b(b, 0));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, IWorldReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata1, RandomSource randomsource) {
        if (enumdirection == EnumDirection.b && !iblockdata.a(iworldreader, blockposition)) {
            scheduledtickaccess.a(blockposition, this, 1);
        }
        return super.a(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    protected boolean a(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        IBlockData iblockdata1 = iworldreader.a_(blockposition.d());
        return !iblockdata1.e() || iblockdata1.b() instanceof BlockFenceGate || iblockdata1.b() instanceof BlockPistonMoving;
    }

    @Override
    public IBlockData a(BlockActionContext blockactioncontext) {
        return !this.m().a((IWorldReader)blockactioncontext.q(), blockactioncontext.a()) ? Blocks.j.m() : super.a(blockactioncontext);
    }

    @Override
    protected boolean g_(IBlockData iblockdata) {
        return true;
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return d;
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (!iblockdata.a((IWorldReader)worldserver, blockposition)) {
            BlockSoil.a((net.minecraft.world.entity.Entity)null, iblockdata, worldserver, blockposition);
        }
    }

    @Override
    protected void b(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        int i2 = iblockdata.c(b);
        if (!BlockSoil.a(worldserver, blockposition) && !worldserver.r(blockposition.d())) {
            if (i2 > 0) {
                CraftEventFactory.handleMoistureChangeEvent(worldserver, blockposition, (IBlockData)iblockdata.b(b, i2 - 1), 2);
            } else if (!BlockSoil.a((IBlockAccess)worldserver, blockposition)) {
                BlockSoil.a((net.minecraft.world.entity.Entity)null, iblockdata, worldserver, blockposition);
            }
        } else if (i2 < 7) {
            CraftEventFactory.handleMoistureChangeEvent(worldserver, blockposition, (IBlockData)iblockdata.b(b, 7), 2);
        }
    }

    @Override
    public void a(World world, IBlockData iblockdata, BlockPosition blockposition, net.minecraft.world.entity.Entity entity, double d0) {
        super.a(world, iblockdata, blockposition, entity, d0);
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if ((double)world.A.i() < d0 - 0.5 && entity instanceof EntityLiving && (entity instanceof EntityHuman || worldserver.O().c(GameRules.d)) && entity.dq() * entity.dq() * entity.dr() > 0.512f) {
                PlayerInteractEvent cancellable;
                if (entity instanceof EntityHuman) {
                    cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, blockposition, null, null, null);
                } else {
                    cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()));
                    world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
                }
                if (cancellable.isCancelled()) {
                    return;
                }
                if (!CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, Blocks.j.m())) {
                    return;
                }
                BlockSoil.a(entity, iblockdata, world, blockposition);
            }
        }
    }

    public static void a(@Nullable net.minecraft.world.entity.Entity entity, IBlockData iblockdata, World world, BlockPosition blockposition) {
        if (CraftEventFactory.callBlockFadeEvent(world, blockposition, Blocks.j.m()).isCancelled()) {
            return;
        }
        IBlockData iblockdata1 = BlockSoil.a(iblockdata, Blocks.j.m(), world, blockposition);
        world.b(blockposition, iblockdata1);
        world.a(GameEvent.c, blockposition, GameEvent.a.a(entity, iblockdata1));
    }

    private static boolean a(IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockaccess.a_(blockposition.d()).a(TagsBlock.cE);
    }

    private static boolean a(IWorldReader iworldreader, BlockPosition blockposition) {
        for (BlockPosition blockposition1 : BlockPosition.c(blockposition.b(-4, 0, -4), blockposition.b(4, 1, 4))) {
            if (!iworldreader.b_(blockposition1).a(TagsFluid.a)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(new IBlockState[]{b});
    }

    @Override
    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }
}

