/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;

public class BlockStem
extends VegetationBlock
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockStem> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.a(Registries.i).fieldOf("fruit").forGetter(blockstem -> blockstem.e), (App)ResourceKey.a(Registries.i).fieldOf("attached_stem").forGetter(blockstem -> blockstem.f), (App)ResourceKey.a(Registries.K).fieldOf("seed").forGetter(blockstem -> blockstem.g), BlockStem.t()).apply((Applicative)instance, BlockStem::new));
    public static final int b = 7;
    public static final BlockStateInteger c = BlockProperties.ay;
    private static final VoxelShape[] d = Block.a(7, (int i2) -> Block.b(2.0, 0.0, 2 + i2 * 2));
    private final ResourceKey<Block> e;
    private final ResourceKey<Block> f;
    private final ResourceKey<Item> g;

    public MapCodec<BlockStem> a() {
        return a;
    }

    protected BlockStem(ResourceKey<Block> resourcekey, ResourceKey<Block> resourcekey1, ResourceKey<Item> resourcekey2, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.e = resourcekey;
        this.f = resourcekey1;
        this.g = resourcekey2;
        this.l((IBlockData)((IBlockData)this.C.b()).b(c, 0));
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return d[iblockdata.c(c)];
    }

    @Override
    protected boolean b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockdata.a(Blocks.cN);
    }

    @Override
    protected void b(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (worldserver.b(blockposition, 0) >= 9) {
            float f2 = BlockCrops.a(this, worldserver, blockposition);
            double d2 = randomsource.i();
            int n2 = this == Blocks.fv ? worldserver.spigotConfig.pumpkinModifier : worldserver.spigotConfig.melonModifier;
            if (d2 < (double)n2 / (100.0 * Math.floor(25.0f / f2 + 1.0f))) {
                int i2 = iblockdata.c(c);
                if (i2 < 7) {
                    iblockdata = (IBlockData)iblockdata.b(c, i2 + 1);
                    CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, iblockdata, 2);
                } else {
                    EnumDirection enumdirection = EnumDirection.EnumDirectionLimit.a.a(randomsource);
                    BlockPosition blockposition1 = blockposition.a(enumdirection);
                    IBlockData iblockdata1 = worldserver.a_(blockposition1.e());
                    if (worldserver.a_(blockposition1).l() && (iblockdata1.a(Blocks.cN) || iblockdata1.a(TagsBlock.ah))) {
                        IRegistry<Block> iregistry = worldserver.J_().f(Registries.i);
                        Optional<Block> optional = iregistry.f(this.e);
                        Optional<Block> optional1 = iregistry.f(this.f);
                        if (optional.isPresent() && optional1.isPresent()) {
                            if (!CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition1, optional.get().m())) {
                                return;
                            }
                            worldserver.b(blockposition, (IBlockData)optional1.get().m().b(BlockFacingHorizontal.e, enumdirection));
                        }
                    }
                }
            }
        }
    }

    @Override
    protected ItemStack a(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata, boolean flag) {
        return new ItemStack((IMaterial)DataFixUtils.orElse(iworldreader.J_().f(Registries.K).f(this.g), (Object)this));
    }

    @Override
    public boolean a(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        return iblockdata.c(c) != 7;
    }

    @Override
    public boolean a(World world, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        return true;
    }

    @Override
    public void a(WorldServer worldserver, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        int i2 = Math.min(7, iblockdata.c(c) + MathHelper.a(worldserver.A, 2, 5));
        IBlockData iblockdata1 = (IBlockData)iblockdata.b(c, i2);
        CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, iblockdata1, 2);
        if (i2 == 7) {
            iblockdata1.b(worldserver, blockposition, worldserver.A);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(new IBlockState[]{c});
    }
}

