/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.block.TNTPrimeEvent;

public class BlockTNT
extends Block {
    public static final MapCodec<BlockTNT> a = BlockTNT.b(BlockTNT::new);
    public static final BlockStateBoolean b = BlockProperties.H;

    public MapCodec<BlockTNT> a() {
        return a;
    }

    public BlockTNT(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.l((IBlockData)this.m().b(b, false));
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!iblockdata1.a(iblockdata.b()) && world.D(blockposition) && CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.REDSTONE, null, null) && BlockTNT.a(world, blockposition)) {
            world.a(blockposition, false);
        }
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        if (world.D(blockposition) && CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.REDSTONE, null, null) && BlockTNT.a(world, blockposition)) {
            world.a(blockposition, false);
        }
    }

    @Override
    public IBlockData a(World world, BlockPosition blockposition, IBlockData iblockdata, EntityHuman entityhuman) {
        if (!world.A_() && !entityhuman.gk().d && iblockdata.c(b).booleanValue() && CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.BLOCK_BREAK, entityhuman, null)) {
            BlockTNT.a(world, blockposition);
        }
        return super.a(world, blockposition, iblockdata, entityhuman);
    }

    @Override
    public void a(WorldServer worldserver, BlockPosition blockposition, Explosion explosion) {
        if (worldserver.O().c(GameRules.ad)) {
            EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(worldserver, (double)blockposition.u() + 0.5, blockposition.v(), (double)blockposition.w() + 0.5, explosion.c());
            int i2 = entitytntprimed.f();
            entitytntprimed.b((short)(worldserver.A.a(i2 / 4) + i2 / 8));
            worldserver.b(entitytntprimed);
        }
    }

    public static boolean a(World world, BlockPosition blockposition) {
        return BlockTNT.a(world, blockposition, (EntityLiving)null);
    }

    private static boolean a(World world, BlockPosition blockposition, @Nullable EntityLiving entityliving) {
        WorldServer worldserver;
        if (world instanceof WorldServer && (worldserver = (WorldServer)world).O().c(GameRules.ad)) {
            EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (double)blockposition.u() + 0.5, blockposition.v(), (double)blockposition.w() + 0.5, entityliving);
            world.b(entitytntprimed);
            world.a((Entity)null, entitytntprimed.dA(), entitytntprimed.dC(), entitytntprimed.dG(), SoundEffects.AC, SoundCategory.e, 1.0f, 1.0f);
            world.a((Entity)entityliving, GameEvent.I, blockposition);
            return true;
        }
        return false;
    }

    @Override
    protected EnumInteractionResult a(ItemStack itemstack, IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        WorldServer worldserver;
        if (!itemstack.a(Items.pg) && !itemstack.a(Items.vg)) {
            return super.a(itemstack, iblockdata, world, blockposition, entityhuman, enumhand, movingobjectpositionblock);
        }
        if (!CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.PLAYER, entityhuman, null)) {
            return EnumInteractionResult.c;
        }
        if (BlockTNT.a(world, blockposition, entityhuman)) {
            world.a(blockposition, Blocks.a.m(), 11);
            Item item = itemstack.h();
            if (itemstack.a(Items.pg)) {
                itemstack.a(1, (EntityLiving)entityhuman, EntityLiving.d(enumhand));
            } else {
                itemstack.a(1, (EntityLiving)entityhuman);
            }
            entityhuman.b(StatisticList.c.b(item));
        } else if (world instanceof WorldServer && !(worldserver = (WorldServer)world).O().c(GameRules.ad)) {
            entityhuman.a(IChatBaseComponent.c("block.minecraft.tnt.disabled"), true);
            return EnumInteractionResult.e;
        }
        return EnumInteractionResult.a;
    }

    @Override
    protected void a(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            BlockPosition blockposition = movingobjectpositionblock.b();
            Entity entity = iprojectile.p();
            if (iprojectile.bX() && iprojectile.c(worldserver, blockposition) && CraftEventFactory.callEntityChangeBlockEvent(iprojectile, blockposition, Blocks.a.m()) && CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.PROJECTILE, iprojectile, null) && BlockTNT.a(world, blockposition, entity instanceof EntityLiving ? (EntityLiving)entity : null)) {
                world.a(blockposition, false);
            }
        }
    }

    @Override
    public boolean a(Explosion explosion) {
        return false;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(new IBlockState[]{b});
    }
}

