/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockTrapdoor
extends BlockFacingHorizontal
implements IBlockWaterlogged {
    public static final MapCodec<BlockTrapdoor> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.a.fieldOf("block_set_type").forGetter(blocktrapdoor -> blocktrapdoor.h), BlockTrapdoor.t()).apply((Applicative)instance, BlockTrapdoor::new));
    public static final BlockStateBoolean b = BlockProperties.y;
    public static final BlockStateEnum<BlockPropertyHalf> c = BlockProperties.ai;
    public static final BlockStateBoolean d = BlockProperties.A;
    public static final BlockStateBoolean f = BlockProperties.I;
    private static final Map<EnumDirection, VoxelShape> g = VoxelShapes.d(Block.c(16.0, 13.0, 16.0));
    private final BlockSetType h;

    public MapCodec<? extends BlockTrapdoor> a() {
        return a;
    }

    protected BlockTrapdoor(BlockSetType blocksettype, BlockBase.Info blockbase_info) {
        super(blockbase_info.a(blocksettype.g()));
        this.h = blocksettype;
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b()).b(e, EnumDirection.c)).b(b, false)).b(c, BlockPropertyHalf.b)).b(d, false)).b(f, false));
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return g.get(iblockdata.c(b) != false ? iblockdata.c(e) : (iblockdata.c(c) == BlockPropertyHalf.a ? EnumDirection.a : EnumDirection.b));
    }

    @Override
    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        switch (pathmode) {
            case a: {
                return iblockdata.c(b);
            }
            case b: {
                return iblockdata.c(f);
            }
            case c: {
                return iblockdata.c(b);
            }
        }
        return false;
    }

    @Override
    protected EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (!this.h.c()) {
            return EnumInteractionResult.e;
        }
        this.b(iblockdata, world, blockposition, entityhuman);
        return EnumInteractionResult.a;
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPosition> biconsumer) {
        if (explosion.g() && this.h.d() && !iblockdata.c(d).booleanValue()) {
            this.b(iblockdata, (World)worldserver, blockposition, (EntityHuman)null);
        }
        super.a(iblockdata, worldserver, blockposition, explosion, biconsumer);
    }

    private void b(IBlockData iblockdata, World world, BlockPosition blockposition, @Nullable EntityHuman entityhuman) {
        IBlockData iblockdata1 = (IBlockData)iblockdata.a(b);
        world.a(blockposition, iblockdata1, 2);
        if (iblockdata1.c(f).booleanValue()) {
            world.a(blockposition, FluidTypes.c, FluidTypes.c.a(world));
        }
        this.a(entityhuman, world, blockposition, (boolean)iblockdata1.c(b));
    }

    protected void a(@Nullable EntityHuman entityhuman, World world, BlockPosition blockposition, boolean flag) {
        world.a((Entity)entityhuman, blockposition, flag ? this.h.k() : this.h.j(), SoundCategory.e, 1.0f, world.G_().i() * 0.1f + 0.9f);
        world.a((Entity)entityhuman, flag ? GameEvent.h : GameEvent.d, blockposition);
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        boolean flag1;
        if (!world.C && (flag1 = world.D(blockposition)) != iblockdata.c(d)) {
            CraftWorld bworld = world.getWorld();
            org.bukkit.block.Block bblock = bworld.getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
            int power = bblock.getBlockPower();
            int oldPower = iblockdata.c(b) != false ? 15 : 0;
            if (oldPower == 0 ^ power == 0 || block.m().p()) {
                BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(bblock, oldPower, power);
                world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
                boolean bl = flag1 = eventRedstone.getNewCurrent() > 0;
            }
            if (iblockdata.c(b) != flag1) {
                iblockdata = (IBlockData)iblockdata.b(b, flag1);
                this.a((EntityHuman)null, world, blockposition, flag1);
            }
            world.a(blockposition, (IBlockData)iblockdata.b(d, flag1), 2);
            if (iblockdata.c(f).booleanValue()) {
                world.a(blockposition, FluidTypes.c, FluidTypes.c.a(world));
            }
        }
    }

    @Override
    public IBlockData a(BlockActionContext blockactioncontext) {
        IBlockData iblockdata = this.m();
        Fluid fluid = blockactioncontext.q().b_(blockactioncontext.a());
        EnumDirection enumdirection = blockactioncontext.k();
        iblockdata = !blockactioncontext.c() && enumdirection.o().d() ? (IBlockData)((IBlockData)iblockdata.b(e, enumdirection)).b(c, blockactioncontext.l().e - (double)blockactioncontext.a().v() > 0.5 ? BlockPropertyHalf.a : BlockPropertyHalf.b) : (IBlockData)((IBlockData)iblockdata.b(e, blockactioncontext.g().g())).b(c, enumdirection == EnumDirection.b ? BlockPropertyHalf.b : BlockPropertyHalf.a);
        if (blockactioncontext.q().D(blockactioncontext.a())) {
            iblockdata = (IBlockData)((IBlockData)iblockdata.b(b, true)).b(d, true);
        }
        return (IBlockData)iblockdata.b(f, fluid.a() == FluidTypes.c);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(e, b, c, d, f);
    }

    @Override
    protected Fluid b_(IBlockData iblockdata) {
        return iblockdata.c(f) != false ? FluidTypes.c.a(false) : super.b_(iblockdata);
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, IWorldReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata1, RandomSource randomsource) {
        if (iblockdata.c(f).booleanValue()) {
            scheduledtickaccess.a(blockposition, FluidTypes.c, FluidTypes.c.a(iworldreader));
        }
        return super.a(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    protected BlockSetType q() {
        return this.h;
    }
}

