/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;

public class DecoratedPotBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<DecoratedPotBlock> a = DecoratedPotBlock.b(DecoratedPotBlock::new);
    public static final MinecraftKey b = MinecraftKey.b("sherds");
    public static final BlockStateEnum<EnumDirection> c = BlockProperties.T;
    public static final BlockStateBoolean d = BlockProperties.bz;
    public static final BlockStateBoolean e = BlockProperties.I;
    private static final VoxelShape f = Block.b(14.0, 0.0, 16.0);

    public MapCodec<DecoratedPotBlock> a() {
        return a;
    }

    protected DecoratedPotBlock(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b()).b(c, EnumDirection.c)).b(e, false)).b(d, false));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, IWorldReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata1, RandomSource randomsource) {
        if (iblockdata.c(e).booleanValue()) {
            scheduledtickaccess.a(blockposition, FluidTypes.c, FluidTypes.c.a(iworldreader));
        }
        return super.a(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    public IBlockData a(BlockActionContext blockactioncontext) {
        Fluid fluid = blockactioncontext.q().b_(blockactioncontext.a());
        return (IBlockData)((IBlockData)((IBlockData)this.m().b(c, blockactioncontext.g())).b(e, fluid.a() == FluidTypes.c)).b(d, false);
    }

    @Override
    protected EnumInteractionResult a(ItemStack itemstack, IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        TileEntity tileentity = world.c_(blockposition);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            if (world.C) {
                return EnumInteractionResult.a;
            }
            ItemStack itemstack1 = decoratedpotblockentity.f();
            if (!itemstack.f() && (itemstack1.f() || ItemStack.c(itemstack1, itemstack) && itemstack1.M() < itemstack1.k())) {
                float f2;
                decoratedpotblockentity.a(DecoratedPotBlockEntity.a.a);
                entityhuman.b(StatisticList.c.b(itemstack.h()));
                ItemStack itemstack2 = itemstack.b(1, (EntityLiving)entityhuman);
                if (decoratedpotblockentity.c()) {
                    decoratedpotblockentity.b(itemstack2);
                    f2 = (float)itemstack2.M() / (float)itemstack2.k();
                } else {
                    itemstack1.g(1);
                    f2 = (float)itemstack1.M() / (float)itemstack1.k();
                }
                world.a((Entity)null, blockposition, SoundEffects.gW, SoundCategory.e, 1.0f, 0.7f + 0.5f * f2);
                if (world instanceof WorldServer) {
                    WorldServer worldserver = (WorldServer)world;
                    worldserver.a(Particles.ba, (double)blockposition.u() + 0.5, (double)blockposition.v() + 1.2, (double)blockposition.w() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
                }
                decoratedpotblockentity.e();
                world.a((Entity)entityhuman, GameEvent.c, blockposition);
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.f;
        }
        return EnumInteractionResult.e;
    }

    @Override
    protected EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        TileEntity tileentity = world.c_(blockposition);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            world.a((Entity)null, blockposition, SoundEffects.gX, SoundCategory.e, 1.0f, 1.0f);
            decoratedpotblockentity.a(DecoratedPotBlockEntity.a.b);
            world.a((Entity)entityhuman, GameEvent.c, blockposition);
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return f;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(c, e, d);
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition blockposition, IBlockData iblockdata) {
        return new DecoratedPotBlockEntity(blockposition, iblockdata);
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, boolean flag) {
        InventoryUtils.a(iblockdata, worldserver, blockposition);
    }

    @Override
    protected List<ItemStack> a(IBlockData iblockdata, LootParams.a lootparams_a) {
        TileEntity tileentity = lootparams_a.b(LootContextParameters.h);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            lootparams_a.a(b, (Consumer<ItemStack> consumer) -> {
                for (Item item : decoratedpotblockentity.s().a()) {
                    consumer.accept(item.m());
                }
            });
        }
        return super.a(iblockdata, lootparams_a);
    }

    @Override
    public IBlockData a(World world, BlockPosition blockposition, IBlockData iblockdata, EntityHuman entityhuman) {
        ItemStack itemstack = entityhuman.fb();
        IBlockData iblockdata1 = iblockdata;
        if (itemstack.a(TagsItem.bN) && !EnchantmentManager.a(itemstack, EnchantmentTags.r)) {
            iblockdata1 = (IBlockData)iblockdata.b(d, true);
            world.a(blockposition, iblockdata1, 260);
        }
        return super.a(world, blockposition, iblockdata1, entityhuman);
    }

    @Override
    protected Fluid b_(IBlockData iblockdata) {
        return iblockdata.c(e) != false ? FluidTypes.c.a(false) : super.b_(iblockdata);
    }

    @Override
    protected SoundEffectType h_(IBlockData iblockdata) {
        return iblockdata.c(d) != false ? SoundEffectType.be : SoundEffectType.bd;
    }

    @Override
    protected void a(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
        WorldServer worldserver;
        BlockPosition blockposition = movingobjectpositionblock.b();
        if (world instanceof WorldServer && iprojectile.c(worldserver = (WorldServer)world, blockposition) && iprojectile.a(worldserver)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(iprojectile, blockposition, this.b_(iblockdata).g())) {
                return;
            }
            world.a(blockposition, (IBlockData)iblockdata.b(d, true), 260);
            world.a(blockposition, true, iprojectile);
        }
    }

    @Override
    protected ItemStack a(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata, boolean flag) {
        TileEntity tileentity = iworldreader.c_(blockposition);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            PotDecorations potdecorations = decoratedpotblockentity.s();
            return DecoratedPotBlockEntity.a(potdecorations);
        }
        return super.a(iworldreader, blockposition, iblockdata, flag);
    }

    @Override
    protected boolean c_(IBlockData iblockdata) {
        return true;
    }

    @Override
    protected int a(IBlockData iblockdata, World world, BlockPosition blockposition) {
        return Container.a(world.c_(blockposition));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return (IBlockData)iblockdata.b(c, enumblockrotation.a(iblockdata.c(c)));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return iblockdata.a(enumblockmirror.a(iblockdata.c(c)));
    }
}

