/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockNote;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class SculkSensorBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<SculkSensorBlock> c = SculkSensorBlock.b(SculkSensorBlock::new);
    public static final int d = 30;
    public static final int e = 10;
    public static final BlockStateEnum<SculkSensorPhase> f = BlockProperties.br;
    public static final BlockStateInteger g = BlockProperties.aW;
    public static final BlockStateBoolean h = BlockProperties.I;
    private static final VoxelShape a = Block.b(16.0, 0.0, 8.0);
    private static final float[] b = SystemUtils.a(new float[16], (? super T afloat) -> {
        int[] aint = new int[]{0, 0, 2, 4, 6, 7, 9, 10, 12, 14, 15, 18, 19, 21, 22, 24};
        for (int i2 = 0; i2 < 16; ++i2) {
            afloat[i2] = BlockNote.b(aint[i2]);
        }
    });

    public MapCodec<? extends SculkSensorBlock> a() {
        return c;
    }

    public SculkSensorBlock(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b()).b(f, SculkSensorPhase.a)).b(g, 0)).b(h, false));
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext blockactioncontext) {
        BlockPosition blockposition = blockactioncontext.a();
        Fluid fluid = blockactioncontext.q().b_(blockposition);
        return (IBlockData)this.m().b(h, fluid.a() == FluidTypes.c);
    }

    @Override
    protected Fluid b_(IBlockData iblockdata) {
        return iblockdata.c(h) != false ? FluidTypes.c.a(false) : super.b_(iblockdata);
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (SculkSensorBlock.o(iblockdata) != SculkSensorPhase.b) {
            if (SculkSensorBlock.o(iblockdata) == SculkSensorPhase.c) {
                worldserver.a(blockposition, (IBlockData)iblockdata.b(f, SculkSensorPhase.a), 3);
                if (!iblockdata.c(h).booleanValue()) {
                    worldserver.a((net.minecraft.world.entity.Entity)null, blockposition, SoundEffects.wX, SoundCategory.e, 1.0f, worldserver.A.i() * 0.2f + 0.8f);
                }
            }
        } else {
            SculkSensorBlock.a((World)worldserver, blockposition, iblockdata);
        }
    }

    @Override
    public void a(World world, BlockPosition blockposition, IBlockData iblockdata, net.minecraft.world.entity.Entity entity) {
        if (!world.A_() && SculkSensorBlock.q(iblockdata) && entity.an() != EntityTypes.bH) {
            PlayerInteractEvent cancellable;
            if (entity instanceof EntityHuman) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, blockposition, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()));
                world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) {
                return;
            }
            TileEntity tileentity = world.c_(blockposition);
            if (tileentity instanceof SculkSensorBlockEntity) {
                SculkSensorBlockEntity sculksensorblockentity = (SculkSensorBlockEntity)tileentity;
                if (world instanceof WorldServer) {
                    WorldServer worldserver = (WorldServer)world;
                    if (sculksensorblockentity.gx().a(worldserver, blockposition, GameEvent.P, GameEvent.a.a(iblockdata))) {
                        sculksensorblockentity.f().b(worldserver, GameEvent.P, GameEvent.a.a(entity), entity.dt());
                    }
                }
            }
        }
        super.a(world, blockposition, iblockdata, entity);
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!(world.A_() || iblockdata.a(iblockdata1.b()) || iblockdata.c(g) <= 0 || world.U().a(blockposition, this))) {
            world.a(blockposition, (IBlockData)iblockdata.b(g, 0), 18);
        }
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, boolean flag) {
        if (SculkSensorBlock.o(iblockdata) == SculkSensorPhase.b) {
            SculkSensorBlock.b(worldserver, blockposition, iblockdata);
        }
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, IWorldReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata1, RandomSource randomsource) {
        if (iblockdata.c(h).booleanValue()) {
            scheduledtickaccess.a(blockposition, FluidTypes.c, FluidTypes.c.a(iworldreader));
        }
        return super.a(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    private static void b(World world, BlockPosition blockposition, IBlockData iblockdata) {
        Block block = iblockdata.b();
        world.a(blockposition, block);
        world.a(blockposition.e(), block);
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition blockposition, IBlockData iblockdata) {
        return new SculkSensorBlockEntity(blockposition, iblockdata);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData iblockdata, TileEntityTypes<T> tileentitytypes) {
        return !world.C ? SculkSensorBlock.a(tileentitytypes, TileEntityTypes.J, (World world1, BlockPosition blockposition, IBlockData iblockdata1, ? super E sculksensorblockentity) -> VibrationSystem.c.a(world1, sculksensorblockentity.gw(), sculksensorblockentity.gx())) : null;
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return a;
    }

    @Override
    protected boolean f_(IBlockData iblockdata) {
        return true;
    }

    @Override
    protected int a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return iblockdata.c(g);
    }

    @Override
    public int b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return enumdirection == EnumDirection.b ? iblockdata.a(iblockaccess, blockposition, enumdirection) : 0;
    }

    public static SculkSensorPhase o(IBlockData iblockdata) {
        return iblockdata.c(f);
    }

    public static boolean q(IBlockData iblockdata) {
        return SculkSensorBlock.o(iblockdata) == SculkSensorPhase.a;
    }

    public static void a(World world, BlockPosition blockposition, IBlockData iblockdata) {
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), iblockdata.c(g).intValue(), 0);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() > 0) {
            world.a(blockposition, (IBlockData)iblockdata.b(g, eventRedstone.getNewCurrent()), 3);
            return;
        }
        world.a(blockposition, (IBlockData)((IBlockData)iblockdata.b(f, SculkSensorPhase.c)).b(g, 0), 3);
        world.a(blockposition, iblockdata.b(), 10);
        SculkSensorBlock.b(world, blockposition, iblockdata);
    }

    @VisibleForTesting
    public int c() {
        return 30;
    }

    public void a(@Nullable net.minecraft.world.entity.Entity entity, World world, BlockPosition blockposition, IBlockData iblockdata, int i2, int j2) {
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), iblockdata.c(g).intValue(), i2);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() <= 0) {
            return;
        }
        i2 = eventRedstone.getNewCurrent();
        world.a(blockposition, (IBlockData)((IBlockData)iblockdata.b(f, SculkSensorPhase.b)).b(g, i2), 3);
        world.a(blockposition, iblockdata.b(), this.c());
        SculkSensorBlock.b(world, blockposition, iblockdata);
        SculkSensorBlock.a(entity, world, blockposition, j2);
        world.a(entity, GameEvent.L, blockposition);
        if (!iblockdata.c(h).booleanValue()) {
            world.a((net.minecraft.world.entity.Entity)null, (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, SoundEffects.wW, SoundCategory.e, 1.0f, world.A.i() * 0.2f + 0.8f);
        }
    }

    public static void a(@Nullable net.minecraft.world.entity.Entity entity, World world, BlockPosition blockposition, int i2) {
        for (EnumDirection enumdirection : EnumDirection.values()) {
            BlockPosition blockposition1 = blockposition.a(enumdirection);
            IBlockData iblockdata = world.a_(blockposition1);
            if (!iblockdata.a(TagsBlock.bZ)) continue;
            world.a(VibrationSystem.b(i2), blockposition1, GameEvent.a.a(entity, iblockdata));
            float f2 = b[i2];
            world.a((net.minecraft.world.entity.Entity)null, blockposition1, SoundEffects.I, SoundCategory.e, 1.0f, f2);
        }
    }

    @Override
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        EnumDirection enumdirection;
        if (SculkSensorBlock.o(iblockdata) == SculkSensorPhase.b && (enumdirection = EnumDirection.b(randomsource)) != EnumDirection.b && enumdirection != EnumDirection.a) {
            double d0 = (double)blockposition.u() + 0.5 + (enumdirection.j() == 0 ? 0.5 - randomsource.j() : (double)enumdirection.j() * 0.6);
            double d1 = (double)blockposition.v() + 0.25;
            double d2 = (double)blockposition.w() + 0.5 + (enumdirection.l() == 0 ? 0.5 - randomsource.j() : (double)enumdirection.l() * 0.6);
            double d3 = (double)randomsource.i() * 0.04;
            world.a(DustColorTransitionOptions.b, d0, d1, d2, 0.0, d3, 0.0);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(f, g, h);
    }

    @Override
    protected boolean c_(IBlockData iblockdata) {
        return true;
    }

    @Override
    protected int a(IBlockData iblockdata, World world, BlockPosition blockposition) {
        TileEntity tileentity = world.c_(blockposition);
        if (tileentity instanceof SculkSensorBlockEntity) {
            SculkSensorBlockEntity sculksensorblockentity = (SculkSensorBlockEntity)tileentity;
            return SculkSensorBlock.o(iblockdata) == SculkSensorPhase.b ? sculksensorblockentity.d() : 0;
        }
        return 0;
    }

    @Override
    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }

    @Override
    protected boolean g_(IBlockData iblockdata) {
        return true;
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        super.a(iblockdata, worldserver, blockposition, itemstack, flag);
    }

    @Override
    public int getExpDrop(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        if (flag) {
            return this.tryDropExperience(worldserver, blockposition, itemstack, ConstantInt.a(5));
        }
        return 0;
    }
}

