/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.block.BlockBrushEvent;
import org.slf4j.Logger;

public class BrushableBlockEntity
extends TileEntity {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "LootTable";
    private static final String c = "LootTableSeed";
    private static final String d = "hit_direction";
    private static final String e = "item";
    private static final int f = 10;
    private static final int g = 40;
    private static final int h = 10;
    private int i;
    private long j;
    private long k;
    public ItemStack l = ItemStack.l;
    @Nullable
    private EnumDirection m;
    @Nullable
    public ResourceKey<LootTable> q;
    public long r;

    public BrushableBlockEntity(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.O, blockposition, iblockdata);
    }

    public boolean a(long i2, WorldServer worldserver, EntityLiving entityliving, EnumDirection enumdirection, ItemStack itemstack) {
        if (this.m == null) {
            this.m = enumdirection;
        }
        this.j = i2 + 40L;
        if (i2 < this.k) {
            return false;
        }
        this.k = i2 + 10L;
        this.a(worldserver, entityliving, itemstack);
        int j2 = this.f();
        if (++this.i >= 10) {
            this.b(worldserver, entityliving, itemstack);
            return true;
        }
        worldserver.a(this.ax_(), this.m().b(), 2);
        int k2 = this.f();
        if (j2 != k2) {
            IBlockData iblockdata = this.m();
            IBlockData iblockdata1 = (IBlockData)iblockdata.b(BlockProperties.by, k2);
            BlockBrushEvent event = CraftEventFactory.callBlockBrushEvent(worldserver, this.ax_(), iblockdata1, 3, (EntityPlayer)entityliving);
            if (!event.isCancelled()) {
                event.getNewState().update(true);
            }
        }
        return false;
    }

    private void a(WorldServer worldserver, EntityLiving entityliving, ItemStack itemstack) {
        if (this.q != null) {
            LootTable loottable = worldserver.p().bc().b(this.q);
            if (entityliving instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityliving;
                CriterionTriggers.Q.a(entityplayer, this.q);
            }
            LootParams lootparams = new LootParams.a(worldserver).a(LootContextParameters.f, Vec3D.b(this.o)).a(entityliving.eh()).a(LootContextParameters.a, entityliving).a(LootContextParameters.i, itemstack).a(LootContextParameterSets.i);
            ObjectArrayList<ItemStack> objectarraylist = loottable.a(lootparams, this.r);
            this.l = switch (objectarraylist.size()) {
                case 0 -> ItemStack.l;
                case 1 -> (ItemStack)objectarraylist.getFirst();
                default -> {
                    a.warn("Expected max 1 loot from loot table {}, but got {}", (Object)this.q.a(), (Object)objectarraylist.size());
                    yield (ItemStack)objectarraylist.getFirst();
                }
            };
            this.q = null;
            this.e();
        }
    }

    private void b(WorldServer worldserver, EntityLiving entityliving, ItemStack itemstack) {
        Block block1;
        IBlockData iblockdata = this.m();
        Block block = this.m().b();
        if (block instanceof BrushableBlock) {
            BrushableBlock brushableblock = (BrushableBlock)block;
            block1 = brushableblock.b();
        } else {
            block1 = Blocks.a;
        }
        BlockBrushEvent event = CraftEventFactory.callBlockBrushEvent(worldserver, this.o, block1.m(), 3, (EntityPlayer)entityliving);
        if (!event.isCancelled()) {
            this.c(worldserver, entityliving, itemstack);
            worldserver.c(3008, this.ax_(), Block.j(iblockdata));
            event.getNewState().update(true);
        }
    }

    private void c(WorldServer worldserver, EntityLiving entityliving, ItemStack itemstack) {
        this.a(worldserver, entityliving, itemstack);
        if (!this.l.f()) {
            double d0 = EntityTypes.ar.l();
            double d1 = 1.0 - d0;
            double d2 = d0 / 2.0;
            EnumDirection enumdirection = Objects.requireNonNullElse(this.m, EnumDirection.b);
            BlockPosition blockposition = this.o.a(enumdirection, 1);
            double d3 = (double)blockposition.u() + 0.5 * d1 + d2;
            double d4 = (double)blockposition.v() + 0.5 + (double)(EntityTypes.ar.m() / 2.0f);
            double d5 = (double)blockposition.w() + 0.5 * d1 + d2;
            EntityItem entityitem = new EntityItem(worldserver, d3, d4, d5, this.l.a(worldserver.A.a(21) + 10));
            entityitem.i(Vec3D.c);
            if (entityliving instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityliving;
                CraftBlock bblock = CraftBlock.at(this.n, this.o);
                CraftEventFactory.handleBlockDropItemEvent(bblock, bblock.getState(), entityplayer, Arrays.asList(entityitem));
            }
            this.l = ItemStack.l;
        }
    }

    public void a(WorldServer worldserver) {
        if (this.i != 0 && worldserver.ae() >= this.j) {
            int i2 = this.f();
            this.i = Math.max(0, this.i - 2);
            int j2 = this.f();
            if (i2 != j2) {
                worldserver.a(this.ax_(), (IBlockData)this.m().b(BlockProperties.by, j2), 3);
            }
            int k2 = 4;
            this.j = worldserver.ae() + 4L;
        }
        if (this.i == 0) {
            this.m = null;
            this.j = 0L;
            this.k = 0L;
        } else {
            worldserver.a(this.ax_(), this.m().b(), 2);
        }
    }

    private boolean b(NBTTagCompound nbttagcompound) {
        this.q = nbttagcompound.a(b, LootTable.a).orElse(null);
        this.r = nbttagcompound.b(c, 0L);
        return this.q != null;
    }

    private boolean c(NBTTagCompound nbttagcompound) {
        if (this.q == null) {
            return false;
        }
        nbttagcompound.a(b, LootTable.a, this.q);
        if (this.r != 0L) {
            nbttagcompound.a(c, this.r);
        }
        return true;
    }

    @Override
    public NBTTagCompound a(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = super.a(holderlookup_a);
        nbttagcompound.b(d, EnumDirection.k, this.m);
        if (!this.l.f()) {
            RegistryOps<NBTBase> registryops = holderlookup_a.a(DynamicOpsNBT.a);
            nbttagcompound.a(e, ItemStack.b, registryops, this.l);
        }
        return nbttagcompound;
    }

    public PacketPlayOutTileEntityData a() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    protected void a(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.a(nbttagcompound, holderlookup_a);
        RegistryOps<NBTBase> registryops = holderlookup_a.a(DynamicOpsNBT.a);
        this.l = !this.b(nbttagcompound) ? nbttagcompound.a(e, ItemStack.b, (DynamicOps<NBTBase>)registryops).orElse(ItemStack.l) : ItemStack.l;
        this.m = nbttagcompound.a(d, EnumDirection.k).orElse(null);
    }

    @Override
    protected void b(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.b(nbttagcompound, holderlookup_a);
        if (!this.c(nbttagcompound) && !this.l.f()) {
            RegistryOps<NBTBase> registryops = holderlookup_a.a(DynamicOpsNBT.a);
            nbttagcompound.a(e, ItemStack.b, registryops, this.l);
        }
    }

    public void a(ResourceKey<LootTable> resourcekey, long i2) {
        this.q = resourcekey;
        this.r = i2;
    }

    private int f() {
        return this.i == 0 ? 0 : (this.i < 3 ? 1 : (this.i < 6 ? 2 : 3));
    }

    @Nullable
    public EnumDirection c() {
        return this.m;
    }

    public ItemStack d() {
        return this.l;
    }
}

