/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R4.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R4.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R4.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.inventory.InventoryHolder;
import org.slf4j.Logger;
import org.spigotmc.CustomTimingsHandler;

public abstract class TileEntity {
    public CustomTimingsHandler tickTimer = SpigotTimings.getTileEntityTimings(this);
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public CraftPersistentDataContainer persistentDataContainer;
    private static final Codec<TileEntityTypes<?>> d = BuiltInRegistries.j.q();
    private static final Logger e = LogUtils.getLogger();
    private final TileEntityTypes<?> f;
    @Nullable
    protected World n;
    protected final BlockPosition o;
    protected boolean p;
    private IBlockData g;
    private DataComponentMap h = DataComponentMap.a;

    public TileEntity(TileEntityTypes<?> tileentitytypes, BlockPosition blockposition, IBlockData iblockdata) {
        this.f = tileentitytypes;
        this.o = blockposition.j();
        this.a(iblockdata);
        this.g = iblockdata;
    }

    private void a(IBlockData iblockdata) {
        if (!this.b(iblockdata)) {
            String s2 = this.k();
            throw new IllegalStateException("Invalid block entity " + s2 + " state at " + String.valueOf(this.o) + ", got " + String.valueOf(iblockdata));
        }
    }

    public boolean b(IBlockData iblockdata) {
        return this.f.a(iblockdata);
    }

    public static BlockPosition a(ChunkCoordIntPair chunkcoordintpair, NBTTagCompound nbttagcompound) {
        int i2 = nbttagcompound.b("x", 0);
        int j2 = nbttagcompound.b("y", 0);
        int k2 = nbttagcompound.b("z", 0);
        int l2 = SectionPosition.a(i2);
        int i1 = SectionPosition.a(k2);
        if (chunkcoordintpair != null && (l2 != chunkcoordintpair.h || i1 != chunkcoordintpair.i)) {
            e.warn("Block entity {} found in a wrong chunk, expected position from chunk {}", (Object)nbttagcompound, (Object)chunkcoordintpair);
            i2 = chunkcoordintpair.a(SectionPosition.b(i2));
            k2 = chunkcoordintpair.b(SectionPosition.b(k2));
        }
        return new BlockPosition(i2, j2, k2);
    }

    @Nullable
    public World i() {
        return this.n;
    }

    public void a(World world) {
        this.n = world;
    }

    public boolean l() {
        return this.n != null;
    }

    protected void a(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        this.persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
        NBTBase persistentDataTag = nbttagcompound.a("PublicBukkitValues");
        if (persistentDataTag instanceof NBTTagCompound) {
            this.persistentDataContainer.putAll((NBTTagCompound)persistentDataTag);
        }
    }

    public final void c(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        this.a(nbttagcompound, holderlookup_a);
        this.h = nbttagcompound.a(a.a, (DynamicOps<NBTBase>)holderlookup_a.a(DynamicOpsNBT.a)).orElse(DataComponentMap.a);
    }

    public final void d(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        this.a(nbttagcompound, holderlookup_a);
    }

    protected void b(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
    }

    public final NBTTagCompound b(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = this.d(holderlookup_a);
        this.d(nbttagcompound);
        return nbttagcompound;
    }

    public final NBTTagCompound c(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = this.d(holderlookup_a);
        this.c(nbttagcompound);
        return nbttagcompound;
    }

    public final NBTTagCompound d(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.b(nbttagcompound, holderlookup_a);
        nbttagcompound.a(a.a, holderlookup_a.a(DynamicOpsNBT.a), this.h);
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            nbttagcompound.a("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return nbttagcompound;
    }

    public final NBTTagCompound e(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.b(nbttagcompound, holderlookup_a);
        return nbttagcompound;
    }

    public final NBTTagCompound f(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = this.e(holderlookup_a);
        this.d(nbttagcompound);
        return nbttagcompound;
    }

    private void c(NBTTagCompound nbttagcompound) {
        TileEntity.a(nbttagcompound, this.p());
    }

    public static void a(NBTTagCompound nbttagcompound, TileEntityTypes<?> tileentitytypes) {
        nbttagcompound.a("id", d, tileentitytypes);
    }

    private void d(NBTTagCompound nbttagcompound) {
        this.c(nbttagcompound);
        nbttagcompound.a("x", this.o.u());
        nbttagcompound.a("y", this.o.v());
        nbttagcompound.a("z", this.o.w());
    }

    @Nullable
    public static TileEntity a(BlockPosition blockposition, IBlockData iblockdata, NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        Object tileentity;
        TileEntityTypes tileentitytypes = nbttagcompound.a("id", d).orElse(null);
        if (tileentitytypes == null) {
            e.error("Skipping block entity with invalid type: {}", (Object)nbttagcompound.a("id"));
            return null;
        }
        try {
            tileentity = tileentitytypes.a(blockposition, iblockdata);
        }
        catch (Throwable throwable) {
            e.error("Failed to create block entity {} for block {} at position {} ", new Object[]{tileentitytypes, blockposition, iblockdata, throwable});
            return null;
        }
        try {
            ((TileEntity)tileentity).c(nbttagcompound, holderlookup_a);
            return tileentity;
        }
        catch (Throwable throwable1) {
            e.error("Failed to load data for block entity {} for block {} at position {}", new Object[]{tileentitytypes, blockposition, iblockdata, throwable1});
            return null;
        }
    }

    public void e() {
        if (this.n != null) {
            TileEntity.a(this.n, this.o, this.g);
        }
    }

    protected static void a(World world, BlockPosition blockposition, IBlockData iblockdata) {
        world.q(blockposition);
        if (!iblockdata.l()) {
            world.b(blockposition, iblockdata.b());
        }
    }

    public BlockPosition ax_() {
        return this.o;
    }

    public IBlockData m() {
        return this.g;
    }

    @Nullable
    public Packet<PacketListenerPlayOut> au_() {
        return null;
    }

    public NBTTagCompound a(HolderLookup.a holderlookup_a) {
        return new NBTTagCompound();
    }

    public boolean n() {
        return this.p;
    }

    public void as_() {
        this.p = true;
    }

    public void o() {
        this.p = false;
    }

    public void a(BlockPosition blockposition, IBlockData iblockdata) {
        TileEntity tileEntity = this;
        if (tileEntity instanceof IInventory) {
            IInventory iinventory = (IInventory)((Object)tileEntity);
            if (this.n != null) {
                InventoryUtils.a(this.n, blockposition, iinventory);
            }
        }
    }

    public boolean a_(int i2, int j2) {
        return false;
    }

    public void a(CrashReportSystemDetails crashreportsystemdetails) {
        crashreportsystemdetails.a("Name", this::k);
        IBlockData iblockdata = this.m();
        Objects.requireNonNull(iblockdata);
        crashreportsystemdetails.a("Cached block", iblockdata::toString);
        if (this.n == null) {
            crashreportsystemdetails.a("Block location", () -> String.valueOf(this.o) + " (world missing)");
        } else {
            iblockdata = this.n.a_(this.o);
            Objects.requireNonNull(iblockdata);
            crashreportsystemdetails.a("Actual block", iblockdata::toString);
            CrashReportSystemDetails.a(crashreportsystemdetails, this.n, this.o);
        }
    }

    private String k() {
        String s2 = String.valueOf(BuiltInRegistries.j.b(this.p()));
        return s2 + " // " + this.getClass().getCanonicalName();
    }

    public TileEntityTypes<?> p() {
        return this.f;
    }

    @Deprecated
    public void c(IBlockData iblockdata) {
        this.a(iblockdata);
        this.g = iblockdata;
    }

    protected void a(DataComponentGetter datacomponentgetter) {
    }

    public final void a(ItemStack itemstack) {
        this.a(itemstack.c(), itemstack.d());
    }

    public final void a(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        this.applyComponentsSet(datacomponentmap, datacomponentpatch);
    }

    public final Set<DataComponentType<?>> applyComponentsSet(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        final HashSet set = new HashSet();
        set.add(DataComponents.aa);
        set.add(DataComponents.aq);
        final PatchedDataComponentMap datacomponentmap1 = PatchedDataComponentMap.a(datacomponentmap, datacomponentpatch);
        this.a(new DataComponentGetter(){

            @Override
            @Nullable
            public <T> T a(DataComponentType<? extends T> datacomponenttype) {
                set.add(datacomponenttype);
                return datacomponentmap1.a(datacomponenttype);
            }

            @Override
            public <T> T a(DataComponentType<? extends T> datacomponenttype, T t0) {
                set.add(datacomponenttype);
                return datacomponentmap1.a(datacomponenttype, t0);
            }
        });
        Objects.requireNonNull(set);
        DataComponentPatch datacomponentpatch1 = datacomponentpatch.a(set::contains);
        this.h = datacomponentpatch1.e().a();
        set.remove(DataComponents.aa);
        set.remove(DataComponents.aq);
        return set;
    }

    protected void a(DataComponentMap.a datacomponentmap_a) {
    }

    @Deprecated
    public void a(NBTTagCompound nbttagcompound) {
    }

    public final DataComponentMap q() {
        DataComponentMap.a datacomponentmap_a = DataComponentMap.a();
        datacomponentmap_a.a(this.h);
        this.a(datacomponentmap_a);
        return datacomponentmap_a.a();
    }

    public DataComponentMap r() {
        return this.h;
    }

    public void a(DataComponentMap datacomponentmap) {
        this.h = datacomponentmap;
    }

    @Nullable
    public static IChatBaseComponent a(@Nullable NBTBase nbtbase, HolderLookup.a holderlookup_a) {
        return nbtbase == null ? null : (IChatBaseComponent)ComponentSerialization.a.parse(holderlookup_a.a(DynamicOpsNBT.a), (Object)nbtbase).resultOrPartial(s2 -> e.warn("Failed to parse custom name, discarding: {}", s2)).orElse(null);
    }

    public InventoryHolder getOwner() {
        if (this.n == null) {
            return null;
        }
        BlockState state = this.n.getWorld().getBlockAt(this.o.u(), this.o.v(), this.o.w()).getState();
        if (state instanceof InventoryHolder) {
            return (InventoryHolder)state;
        }
        return null;
    }

    private static class a {
        public static final MapCodec<DataComponentMap> a = DataComponentMap.b.optionalFieldOf("components", (Object)DataComponentMap.a);

        private a() {
        }
    }
}

