/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenEndGatewayConfiguration;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class TileEntityEndGateway
extends TileEntityEnderPortal {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 200;
    private static final int c = 40;
    private static final int d = 2400;
    private static final int e = 1;
    private static final int f = 10;
    private static final long g = 0L;
    private static final boolean h = false;
    public long i = 0L;
    private int j;
    @Nullable
    public BlockPosition k;
    public boolean l = false;

    public TileEntityEndGateway(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.w, blockposition, iblockdata);
    }

    @Override
    protected void b(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.b(nbttagcompound, holderlookup_a);
        nbttagcompound.a("Age", this.i);
        nbttagcompound.b("exit_portal", BlockPosition.a, this.k);
        if (this.l) {
            nbttagcompound.a("ExactTeleport", true);
        }
    }

    @Override
    protected void a(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.a(nbttagcompound, holderlookup_a);
        this.i = nbttagcompound.b("Age", 0L);
        this.k = nbttagcompound.a("exit_portal", BlockPosition.a).filter(World::l).orElse(null);
        this.l = nbttagcompound.b("ExactTeleport", false);
    }

    public static void a(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityEndGateway tileentityendgateway) {
        ++tileentityendgateway.i;
        if (tileentityendgateway.c()) {
            --tileentityendgateway.j;
        }
    }

    public static void b(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityEndGateway tileentityendgateway) {
        boolean flag = tileentityendgateway.a();
        boolean flag1 = tileentityendgateway.c();
        ++tileentityendgateway.i;
        if (flag1) {
            --tileentityendgateway.j;
        } else if (tileentityendgateway.i % 2400L == 0L) {
            TileEntityEndGateway.c(world, blockposition, iblockdata, tileentityendgateway);
        }
        if (flag != tileentityendgateway.a() || flag1 != tileentityendgateway.c()) {
            TileEntityEndGateway.a(world, blockposition, iblockdata);
        }
    }

    public boolean a() {
        return this.i < 200L;
    }

    public boolean c() {
        return this.j > 0;
    }

    public float a(float f2) {
        return MathHelper.a(((float)this.i + f2) / 200.0f, 0.0f, 1.0f);
    }

    public float b(float f2) {
        return 1.0f - MathHelper.a(((float)this.j - f2) / 40.0f, 0.0f, 1.0f);
    }

    public PacketPlayOutTileEntityData d() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a holderlookup_a) {
        return this.e(holderlookup_a);
    }

    public static void c(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityEndGateway tileentityendgateway) {
        if (!world.C) {
            tileentityendgateway.j = 40;
            world.a(blockposition, iblockdata.b(), 1, 0);
            TileEntityEndGateway.a(world, blockposition, iblockdata);
        }
    }

    @Override
    public boolean a_(int i2, int j2) {
        if (i2 == 1) {
            this.j = 40;
            return true;
        }
        return super.a_(i2, j2);
    }

    @Nullable
    public Vec3D a(WorldServer worldserver, BlockPosition blockposition) {
        if (this.k == null && worldserver.getTypeKey() == WorldDimension.d) {
            BlockPosition blockposition1 = TileEntityEndGateway.b(worldserver, blockposition);
            blockposition1 = blockposition1.b(10);
            a.debug("Creating portal at {}", (Object)blockposition1);
            TileEntityEndGateway.a(worldserver, blockposition1, WorldGenEndGatewayConfiguration.a(blockposition, false));
            this.a(blockposition1, this.l);
        }
        if (this.k != null) {
            BlockPosition blockposition2 = this.l ? this.k : TileEntityEndGateway.a((World)worldserver, this.k);
            return blockposition2.c();
        }
        return null;
    }

    private static BlockPosition a(World world, BlockPosition blockposition) {
        BlockPosition blockposition1 = TileEntityEndGateway.a((IBlockAccess)world, blockposition.b(0, 2, 0), 5, false);
        a.debug("Best exit position for portal at {} is {}", (Object)blockposition, (Object)blockposition1);
        return blockposition1.d();
    }

    private static BlockPosition b(WorldServer worldserver, BlockPosition blockposition) {
        Vec3D vec3d = TileEntityEndGateway.c(worldserver, blockposition);
        Chunk chunk = TileEntityEndGateway.a((World)worldserver, vec3d);
        BlockPosition blockposition1 = TileEntityEndGateway.a(chunk);
        if (blockposition1 == null) {
            BlockPosition blockposition2 = BlockPosition.a(vec3d.d + 0.5, 75.0, vec3d.f + 0.5);
            a.debug("Failed to find a suitable block to teleport to, spawning an island on {}", (Object)blockposition2);
            worldserver.J_().a(Registries.aL).flatMap(iregistry -> iregistry.a(EndFeatures.f)).ifPresent(holder_c -> ((WorldGenFeatureConfigured)holder_c.a()).a(worldserver, worldserver.m().g(), RandomSource.a(blockposition2.a()), blockposition2));
            blockposition1 = blockposition2;
        } else {
            a.debug("Found suitable block to teleport to: {}", (Object)blockposition1);
        }
        return TileEntityEndGateway.a((IBlockAccess)worldserver, blockposition1, 16, true);
    }

    private static Vec3D c(WorldServer worldserver, BlockPosition blockposition) {
        Vec3D vec3d = new Vec3D(blockposition.u(), 0.0, blockposition.w()).d();
        int i2 = 1024;
        Vec3D vec3d1 = vec3d.c(1024.0);
        int j2 = 16;
        while (!TileEntityEndGateway.a(worldserver, vec3d1) && j2-- > 0) {
            a.debug("Skipping backwards past nonempty chunk at {}", (Object)vec3d1);
            vec3d1 = vec3d1.e(vec3d.c(-16.0));
        }
        int k2 = 16;
        while (TileEntityEndGateway.a(worldserver, vec3d1) && k2-- > 0) {
            a.debug("Skipping forward past empty chunk at {}", (Object)vec3d1);
            vec3d1 = vec3d1.e(vec3d.c(16.0));
        }
        a.debug("Found chunk at {}", (Object)vec3d1);
        return vec3d1;
    }

    private static boolean a(WorldServer worldserver, Vec3D vec3d) {
        return TileEntityEndGateway.a((World)worldserver, vec3d).a() == -1;
    }

    private static BlockPosition a(IBlockAccess iblockaccess, BlockPosition blockposition, int i2, boolean flag) {
        BaseBlockPosition blockposition1 = null;
        for (int j2 = -i2; j2 <= i2; ++j2) {
            block1: for (int k2 = -i2; k2 <= i2; ++k2) {
                if (j2 == 0 && k2 == 0 && !flag) continue;
                for (int l2 = iblockaccess.ao(); l2 > (blockposition1 == null ? iblockaccess.K_() : blockposition1.v()); --l2) {
                    BlockPosition blockposition2 = new BlockPosition(blockposition.u() + j2, l2, blockposition.w() + k2);
                    IBlockData iblockdata = iblockaccess.a_(blockposition2);
                    if (!iblockdata.m(iblockaccess, blockposition2) || !flag && iblockdata.a(Blocks.I)) continue;
                    blockposition1 = blockposition2;
                    continue block1;
                }
            }
        }
        return blockposition1 == null ? blockposition : blockposition1;
    }

    private static Chunk a(World world, Vec3D vec3d) {
        return world.d(MathHelper.a(vec3d.d / 16.0), MathHelper.a(vec3d.f / 16.0));
    }

    @Nullable
    private static BlockPosition a(Chunk chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        BlockPosition blockposition = new BlockPosition(chunkcoordintpair.d(), 30, chunkcoordintpair.e());
        int i2 = chunk.b() + 16 - 1;
        BlockPosition blockposition1 = new BlockPosition(chunkcoordintpair.f(), i2, chunkcoordintpair.g());
        BlockPosition blockposition2 = null;
        double d0 = 0.0;
        for (BlockPosition blockposition3 : BlockPosition.c(blockposition, blockposition1)) {
            IBlockData iblockdata = chunk.a_(blockposition3);
            BlockPosition blockposition4 = blockposition3.d();
            BlockPosition blockposition5 = blockposition3.b(2);
            if (!iblockdata.a(Blocks.fY) || chunk.a_(blockposition4).m(chunk, blockposition4) || chunk.a_(blockposition5).m(chunk, blockposition5)) continue;
            double d1 = blockposition3.c(0.0, 0.0, 0.0);
            if (blockposition2 != null && !(d1 < d0)) continue;
            blockposition2 = blockposition3;
            d0 = d1;
        }
        return blockposition2;
    }

    private static void a(WorldServer worldserver, BlockPosition blockposition, WorldGenEndGatewayConfiguration worldgenendgatewayconfiguration) {
        WorldGenerator.N.a(worldgenendgatewayconfiguration, worldserver, worldserver.m().g(), RandomSource.a(), blockposition);
    }

    @Override
    public boolean a(EnumDirection enumdirection) {
        return Block.a(this.m(), this.n.a_(this.ax_().a(enumdirection)), enumdirection);
    }

    public int f() {
        int i2 = 0;
        for (EnumDirection enumdirection : EnumDirection.values()) {
            i2 += this.a(enumdirection) ? 1 : 0;
        }
        return i2;
    }

    public void a(BlockPosition blockposition, boolean flag) {
        this.l = flag;
        this.k = blockposition;
        this.e();
    }
}

