/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;

public abstract class TileEntityFurnace
extends TileEntityContainer
implements IWorldInventory,
RecipeCraftingHolder,
AutoRecipeOutput {
    protected static final int b = 0;
    protected static final int c = 1;
    protected static final int d = 2;
    public static final int e = 0;
    private static final int[] q = new int[]{0};
    private static final int[] r = new int[]{2, 1};
    private static final int[] s = new int[]{1};
    public static final int f = 1;
    public static final int g = 2;
    public static final int h = 3;
    public static final int i = 4;
    public static final int j = 200;
    public static final int k = 2;
    private static final Codec<Map<ResourceKey<IRecipe<?>>, Integer>> t = Codec.unboundedMap(IRecipe.b, (Codec)Codec.INT);
    private static final short u = 0;
    private static final short v = 0;
    private static final short w = 0;
    private static final short x = 0;
    protected NonNullList<net.minecraft.world.item.ItemStack> l;
    public int y;
    int z;
    public int A;
    public int B;
    protected final IContainerProperties m;
    public final Reference2IntOpenHashMap<ResourceKey<IRecipe<?>>> C;
    private final CraftingManager.a<SingleRecipeInput, ? extends RecipeCooking> D;
    private int maxStack = 99;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    protected TileEntityFurnace(TileEntityTypes<?> tileentitytypes, BlockPosition blockposition, IBlockData iblockdata, Recipes<? extends RecipeCooking> recipes) {
        super(tileentitytypes, blockposition, iblockdata);
        this.l = NonNullList.a(3, net.minecraft.world.item.ItemStack.l);
        this.m = new IContainerProperties(){

            @Override
            public int a(int i2) {
                switch (i2) {
                    case 0: {
                        return TileEntityFurnace.this.y;
                    }
                    case 1: {
                        return TileEntityFurnace.this.z;
                    }
                    case 2: {
                        return TileEntityFurnace.this.A;
                    }
                    case 3: {
                        return TileEntityFurnace.this.B;
                    }
                }
                return 0;
            }

            @Override
            public void a(int i2, int j2) {
                switch (i2) {
                    case 0: {
                        TileEntityFurnace.this.y = j2;
                        break;
                    }
                    case 1: {
                        TileEntityFurnace.this.z = j2;
                        break;
                    }
                    case 2: {
                        TileEntityFurnace.this.A = j2;
                        break;
                    }
                    case 3: {
                        TileEntityFurnace.this.B = j2;
                    }
                }
            }

            @Override
            public int a() {
                return 4;
            }
        };
        this.C = new Reference2IntOpenHashMap();
        this.D = CraftingManager.a(recipes);
    }

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.l;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int ak_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    private boolean k() {
        return this.y > 0;
    }

    @Override
    protected void a(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.a(nbttagcompound, holderlookup_a);
        this.l = NonNullList.a(this.b(), net.minecraft.world.item.ItemStack.l);
        ContainerUtil.b(nbttagcompound, this.l, holderlookup_a);
        this.A = nbttagcompound.b("cooking_time_spent", (short)0);
        this.B = nbttagcompound.b("cooking_total_time", (short)0);
        this.y = nbttagcompound.b("lit_time_remaining", (short)0);
        this.z = nbttagcompound.b("lit_total_time", (short)0);
        this.C.clear();
        this.C.putAll(nbttagcompound.a("RecipesUsed", t).orElse(Map.of()));
    }

    @Override
    protected void b(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.b(nbttagcompound, holderlookup_a);
        nbttagcompound.a("cooking_time_spent", (short)this.A);
        nbttagcompound.a("cooking_total_time", (short)this.B);
        nbttagcompound.a("lit_time_remaining", (short)this.y);
        nbttagcompound.a("lit_total_time", (short)this.z);
        ContainerUtil.a(nbttagcompound, this.l, holderlookup_a);
        nbttagcompound.a("RecipesUsed", t, this.C);
    }

    public static void a(WorldServer worldserver, BlockPosition blockposition, IBlockData iblockdata, TileEntityFurnace tileentityfurnace) {
        boolean flag3;
        boolean flag = tileentityfurnace.k();
        boolean flag1 = false;
        if (tileentityfurnace.k()) {
            --tileentityfurnace.y;
        }
        net.minecraft.world.item.ItemStack itemstack = tileentityfurnace.l.get(1);
        net.minecraft.world.item.ItemStack itemstack1 = tileentityfurnace.l.get(0);
        boolean flag2 = !itemstack1.f();
        boolean bl = flag3 = !itemstack.f();
        if (tileentityfurnace.k() || flag3 && flag2) {
            SingleRecipeInput singlerecipeinput = new SingleRecipeInput(itemstack1);
            RecipeHolder recipeholder = flag2 ? (RecipeHolder)tileentityfurnace.D.a(singlerecipeinput, worldserver).orElse(null) : null;
            int i2 = tileentityfurnace.ak_();
            if (!tileentityfurnace.k() && TileEntityFurnace.a(worldserver.J_(), recipeholder, singlerecipeinput, tileentityfurnace.l, i2)) {
                CraftItemStack fuel = CraftItemStack.asCraftMirror(itemstack);
                FurnaceBurnEvent furnaceBurnEvent = new FurnaceBurnEvent((Block)CraftBlock.at(worldserver, blockposition), (ItemStack)fuel, tileentityfurnace.a(worldserver.M(), itemstack));
                worldserver.getCraftServer().getPluginManager().callEvent((Event)furnaceBurnEvent);
                if (furnaceBurnEvent.isCancelled()) {
                    return;
                }
                tileentityfurnace.z = tileentityfurnace.y = furnaceBurnEvent.getBurnTime();
                if (tileentityfurnace.k() && furnaceBurnEvent.isBurning()) {
                    flag1 = true;
                    if (flag3) {
                        Item item = itemstack.h();
                        itemstack.h(1);
                        if (itemstack.f()) {
                            tileentityfurnace.l.set(1, item.i());
                        }
                    }
                }
            }
            if (tileentityfurnace.k() && TileEntityFurnace.a(worldserver.J_(), recipeholder, singlerecipeinput, tileentityfurnace.l, i2)) {
                if (recipeholder != null && tileentityfurnace.A == 0) {
                    CraftItemStack source = CraftItemStack.asCraftMirror(tileentityfurnace.l.get(0));
                    CookingRecipe recipe = (CookingRecipe)recipeholder.toBukkitRecipe();
                    FurnaceStartSmeltEvent event = new FurnaceStartSmeltEvent((Block)CraftBlock.at(worldserver, blockposition), (ItemStack)source, recipe);
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                    tileentityfurnace.B = event.getTotalCookTime();
                }
                ++tileentityfurnace.A;
                if (tileentityfurnace.A == tileentityfurnace.B) {
                    tileentityfurnace.A = 0;
                    tileentityfurnace.B = TileEntityFurnace.a(worldserver, tileentityfurnace);
                    if (TileEntityFurnace.burn(tileentityfurnace.n, tileentityfurnace.o, worldserver.J_(), recipeholder, singlerecipeinput, tileentityfurnace.l, i2)) {
                        tileentityfurnace.a(recipeholder);
                    }
                    flag1 = true;
                }
            } else {
                tileentityfurnace.A = 0;
            }
        } else if (!tileentityfurnace.k() && tileentityfurnace.A > 0) {
            tileentityfurnace.A = MathHelper.a(tileentityfurnace.A - 2, 0, tileentityfurnace.B);
        }
        if (flag != tileentityfurnace.k()) {
            flag1 = true;
            iblockdata = (IBlockData)iblockdata.b(BlockFurnace.b, tileentityfurnace.k());
            worldserver.a(blockposition, iblockdata, 3);
        }
        if (flag1) {
            TileEntityFurnace.a(worldserver, blockposition, iblockdata);
        }
    }

    private static boolean a(IRegistryCustom iregistrycustom, @Nullable RecipeHolder<? extends RecipeCooking> recipeholder, SingleRecipeInput singlerecipeinput, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist, int i2) {
        if (!nonnulllist.get(0).f() && recipeholder != null) {
            net.minecraft.world.item.ItemStack itemstack = recipeholder.b().a(singlerecipeinput, (HolderLookup.a)iregistrycustom);
            if (itemstack.f()) {
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack1 = nonnulllist.get(2);
            return itemstack1.f() ? true : (!net.minecraft.world.item.ItemStack.c(itemstack1, itemstack) ? false : (itemstack1.M() < i2 && itemstack1.M() < itemstack1.k() ? true : itemstack1.M() < itemstack.k()));
        }
        return false;
    }

    private static boolean burn(World world, BlockPosition blockposition, IRegistryCustom iregistrycustom, @Nullable RecipeHolder<? extends RecipeCooking> recipeholder, SingleRecipeInput singlerecipeinput, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist, int i2) {
        if (recipeholder != null && TileEntityFurnace.a(iregistrycustom, recipeholder, singlerecipeinput, nonnulllist, i2)) {
            net.minecraft.world.item.ItemStack itemstack = nonnulllist.get(0);
            net.minecraft.world.item.ItemStack itemstack1 = recipeholder.b().a(singlerecipeinput, (HolderLookup.a)iregistrycustom);
            net.minecraft.world.item.ItemStack itemstack2 = nonnulllist.get(2);
            CraftItemStack source = CraftItemStack.asCraftMirror(itemstack);
            ItemStack result = CraftItemStack.asBukkitCopy(itemstack1);
            FurnaceSmeltEvent furnaceSmeltEvent = new FurnaceSmeltEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)source, result);
            world.getCraftServer().getPluginManager().callEvent((Event)furnaceSmeltEvent);
            if (furnaceSmeltEvent.isCancelled()) {
                return false;
            }
            result = furnaceSmeltEvent.getResult();
            itemstack1 = CraftItemStack.asNMSCopy(result);
            if (!itemstack1.f()) {
                if (itemstack2.f()) {
                    nonnulllist.set(2, itemstack1.v());
                } else if (CraftItemStack.asCraftMirror(itemstack2).isSimilar(result)) {
                    itemstack2.g(itemstack1.M());
                } else {
                    return false;
                }
            }
            if (itemstack.a(Blocks.aW.h()) && !nonnulllist.get(1).f() && nonnulllist.get(1).a(Items.ro)) {
                nonnulllist.set(1, new net.minecraft.world.item.ItemStack(Items.rp));
            }
            itemstack.h(1);
            return true;
        }
        return false;
    }

    protected int a(FuelValues fuelvalues, net.minecraft.world.item.ItemStack itemstack) {
        return fuelvalues.b(itemstack);
    }

    private static int a(WorldServer worldserver, TileEntityFurnace tileentityfurnace) {
        if (worldserver == null) {
            return 200;
        }
        SingleRecipeInput singlerecipeinput = new SingleRecipeInput(tileentityfurnace.a(0));
        return tileentityfurnace.D.a(singlerecipeinput, worldserver).map(recipeholder -> ((RecipeCooking)recipeholder.b()).d()).orElse(200);
    }

    @Override
    public int[] a(EnumDirection enumdirection) {
        return enumdirection == EnumDirection.a ? r : (enumdirection == EnumDirection.b ? q : s);
    }

    @Override
    public boolean a(int i2, net.minecraft.world.item.ItemStack itemstack, @Nullable EnumDirection enumdirection) {
        return this.b(i2, itemstack);
    }

    @Override
    public boolean b(int i2, net.minecraft.world.item.ItemStack itemstack, EnumDirection enumdirection) {
        return enumdirection == EnumDirection.a && i2 == 1 ? itemstack.a(Items.rp) || itemstack.a(Items.ro) : true;
    }

    @Override
    public int b() {
        return this.l.size();
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> f() {
        return this.l;
    }

    @Override
    protected void a(NonNullList<net.minecraft.world.item.ItemStack> nonnulllist) {
        this.l = nonnulllist;
    }

    @Override
    public void a(int i2, net.minecraft.world.item.ItemStack itemstack) {
        World world;
        net.minecraft.world.item.ItemStack itemstack1 = this.l.get(i2);
        boolean flag = !itemstack.f() && net.minecraft.world.item.ItemStack.c(itemstack1, itemstack);
        this.l.set(i2, itemstack);
        itemstack.f(this.f_(itemstack));
        if (i2 == 0 && !flag && (world = this.n) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.B = TileEntityFurnace.a(worldserver, this);
            this.A = 0;
            this.e();
        }
    }

    @Override
    public boolean b(int i2, net.minecraft.world.item.ItemStack itemstack) {
        if (i2 == 2) {
            return false;
        }
        if (i2 != 1) {
            return true;
        }
        net.minecraft.world.item.ItemStack itemstack1 = this.l.get(1);
        return this.n.M().a(itemstack) || itemstack.a(Items.ro) && !itemstack1.a(Items.ro);
    }

    @Override
    public void a(@Nullable RecipeHolder<?> recipeholder) {
        if (recipeholder != null) {
            ResourceKey<IRecipe<?>> resourcekey = recipeholder.a();
            this.C.addTo(resourcekey, 1);
        }
    }

    @Override
    @Nullable
    public RecipeHolder<?> d() {
        return null;
    }

    @Override
    public void a(EntityHuman entityhuman, List<net.minecraft.world.item.ItemStack> list) {
    }

    public void awardUsedRecipesAndPopExperience(EntityPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(entityplayer.x(), entityplayer.dt(), this.o, entityplayer, itemstack, amount);
        entityplayer.a((Collection<RecipeHolder<?>>)list);
        for (RecipeHolder<?> recipeholder : list) {
            if (recipeholder == null) continue;
            entityplayer.a(recipeholder, this.l);
        }
        this.C.clear();
    }

    public List<RecipeHolder<?>> a(WorldServer worldserver, Vec3D vec3d) {
        return this.getRecipesToAwardAndPopExperience(worldserver, vec3d, this.o, null, null, 0);
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(WorldServer worldserver, Vec3D vec3d, BlockPosition blockposition, EntityPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        ArrayList list = Lists.newArrayList();
        for (Reference2IntMap.Entry reference2intmap_entry : this.C.reference2IntEntrySet()) {
            worldserver.t().b((ResourceKey)reference2intmap_entry.getKey()).ifPresent(recipeholder -> {
                list.add(recipeholder);
                TileEntityFurnace.createExperience(worldserver, vec3d, reference2intmap_entry.getIntValue(), ((RecipeCooking)recipeholder.b()).c(), blockposition, entityplayer, itemstack, amount);
            });
        }
        return list;
    }

    private static void createExperience(WorldServer worldserver, Vec3D vec3d, int i2, float f2, BlockPosition blockposition, EntityHuman entityhuman, net.minecraft.world.item.ItemStack itemstack, int amount) {
        int j2 = MathHelper.d((float)i2 * f2);
        float f1 = MathHelper.i((float)i2 * f2);
        if (f1 != 0.0f && Math.random() < (double)f1) {
            ++j2;
        }
        Object event = amount != 0 ? new FurnaceExtractEvent((Player)entityhuman.getBukkitEntity(), (Block)CraftBlock.at(worldserver, blockposition), CraftItemType.minecraftToBukkit(itemstack.h()), amount, j2) : new BlockExpEvent((Block)CraftBlock.at(worldserver, blockposition), j2);
        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        j2 = event.getExpToDrop();
        EntityExperienceOrb.a(worldserver, vec3d, j2);
    }

    @Override
    public void fillStackedContents(StackedItemContents stackeditemcontents) {
        for (net.minecraft.world.item.ItemStack itemstack : this.l) {
            stackeditemcontents.b(itemstack);
        }
    }

    @Override
    public void a(BlockPosition blockposition, IBlockData iblockdata) {
        super.a(blockposition, iblockdata);
        World world = this.n;
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(worldserver, Vec3D.b(blockposition));
        }
    }
}

