/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.entity.CalibratedSculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.SculkCatalystBlockEntity;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.SculkShriekerBlockEntity;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBanner;
import net.minecraft.world.level.block.entity.TileEntityBarrel;
import net.minecraft.world.level.block.entity.TileEntityBeacon;
import net.minecraft.world.level.block.entity.TileEntityBed;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityBell;
import net.minecraft.world.level.block.entity.TileEntityBlastFurnace;
import net.minecraft.world.level.block.entity.TileEntityBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityCampfire;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityChestTrapped;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityComparator;
import net.minecraft.world.level.block.entity.TileEntityConduit;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityEnchantTable;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.entity.TileEntityFurnaceFurnace;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.entity.TileEntityLightDetector;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.entity.TileEntityShulkerBox;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.entity.TileEntitySmoker;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.piston.TileEntityPiston;
import net.minecraft.world.level.block.state.IBlockData;
import org.slf4j.Logger;

public class TileEntityTypes<T extends TileEntity> {
    private static final Logger V = LogUtils.getLogger();
    public static final TileEntityTypes<TileEntityFurnaceFurnace> a = TileEntityTypes.a("furnace", TileEntityFurnaceFurnace::new, Blocks.cO);
    public static final TileEntityTypes<TileEntityChest> b = TileEntityTypes.a("chest", TileEntityChest::new, Blocks.cG);
    public static final TileEntityTypes<TileEntityChestTrapped> c = TileEntityTypes.a("trapped_chest", TileEntityChestTrapped::new, Blocks.hw);
    public static final TileEntityTypes<TileEntityEnderChest> d = TileEntityTypes.a("ender_chest", TileEntityEnderChest::new, Blocks.gf);
    public static final TileEntityTypes<TileEntityJukeBox> e = TileEntityTypes.a("jukebox", TileEntityJukeBox::new, Blocks.ek);
    public static final TileEntityTypes<TileEntityDispenser> f = TileEntityTypes.a("dispenser", TileEntityDispenser::new, Blocks.bb);
    public static final TileEntityTypes<TileEntityDropper> g = TileEntityTypes.a("dropper", TileEntityDropper::new, Blocks.hJ);
    public static final TileEntityTypes<TileEntitySign> h = TileEntityTypes.a("sign", TileEntitySign::new, Blocks.cP, Blocks.cQ, Blocks.cR, Blocks.cS, Blocks.cT, Blocks.cU, Blocks.cV, Blocks.cW, Blocks.dd, Blocks.de, Blocks.df, Blocks.dg, Blocks.dh, Blocks.di, Blocks.dj, Blocks.dk, Blocks.pC, Blocks.pE, Blocks.pD, Blocks.pF, Blocks.cX, Blocks.dl, Blocks.cY, Blocks.dm);
    public static final TileEntityTypes<HangingSignBlockEntity> i = TileEntityTypes.a("hanging_sign", HangingSignBlockEntity::new, Blocks.dn, Blocks.do, Blocks.dp, Blocks.dq, Blocks.dr, Blocks.ds, Blocks.dt, Blocks.du, Blocks.dv, Blocks.dw, Blocks.dx, Blocks.dy, Blocks.dz, Blocks.dA, Blocks.dB, Blocks.dC, Blocks.dD, Blocks.dE, Blocks.dF, Blocks.dG, Blocks.dI, Blocks.dJ, Blocks.dH, Blocks.dK);
    public static final TileEntityTypes<TileEntityMobSpawner> j = TileEntityTypes.a("mob_spawner", TileEntityMobSpawner::new, Blocks.cD);
    public static final TileEntityTypes<CreakingHeartBlockEntity> k = TileEntityTypes.a("creaking_heart", CreakingHeartBlockEntity::new, Blocks.cE);
    public static final TileEntityTypes<TileEntityPiston> l = TileEntityTypes.a("piston", TileEntityPiston::new, Blocks.ca);
    public static final TileEntityTypes<TileEntityBrewingStand> m = TileEntityTypes.a("brewing_stand", TileEntityBrewingStand::new, Blocks.fR);
    public static final TileEntityTypes<TileEntityEnchantTable> n = TileEntityTypes.a("enchanting_table", TileEntityEnchantTable::new, Blocks.fQ);
    public static final TileEntityTypes<TileEntityEnderPortal> o = TileEntityTypes.a("end_portal", TileEntityEnderPortal::new, Blocks.fW);
    public static final TileEntityTypes<TileEntityBeacon> p = TileEntityTypes.a("beacon", TileEntityBeacon::new, Blocks.gn);
    public static final TileEntityTypes<TileEntitySkull> q = TileEntityTypes.a("skull", TileEntitySkull::new, Blocks.hf, Blocks.hg, Blocks.hn, Blocks.ho, Blocks.hp, Blocks.hq, Blocks.hj, Blocks.hk, Blocks.hh, Blocks.hi, Blocks.hl, Blocks.hm, Blocks.hr, Blocks.hs);
    public static final TileEntityTypes<TileEntityLightDetector> r = TileEntityTypes.a("daylight_detector", TileEntityLightDetector::new, Blocks.hA);
    public static final TileEntityTypes<TileEntityHopper> s = TileEntityTypes.a("hopper", TileEntityHopper::new, Blocks.hD);
    public static final TileEntityTypes<TileEntityComparator> t = TileEntityTypes.a("comparator", TileEntityComparator::new, Blocks.hz);
    public static final TileEntityTypes<TileEntityBanner> u = TileEntityTypes.a("banner", TileEntityBanner::new, Blocks.jl, Blocks.jm, Blocks.jn, Blocks.jo, Blocks.jp, Blocks.jq, Blocks.jr, Blocks.js, Blocks.jt, Blocks.ju, Blocks.jv, Blocks.jw, Blocks.jx, Blocks.jy, Blocks.jz, Blocks.jA, Blocks.jB, Blocks.jC, Blocks.jD, Blocks.jE, Blocks.jF, Blocks.jG, Blocks.jH, Blocks.jI, Blocks.jJ, Blocks.jK, Blocks.jL, Blocks.jM, Blocks.jN, Blocks.jO, Blocks.jP, Blocks.jQ);
    public static final TileEntityTypes<TileEntityStructure> v = TileEntityTypes.a("structure_block", TileEntityStructure::new, Blocks.pG);
    public static final TileEntityTypes<TileEntityEndGateway> w = TileEntityTypes.a("end_gateway", TileEntityEndGateway::new, Blocks.ll);
    public static final TileEntityTypes<TileEntityCommand> x = TileEntityTypes.a("command_block", TileEntityCommand::new, Blocks.gm, Blocks.ln, Blocks.lm);
    public static final TileEntityTypes<TileEntityShulkerBox> y = TileEntityTypes.a("shulker_box", TileEntityShulkerBox::new, Blocks.lv, Blocks.lL, Blocks.lH, Blocks.lI, Blocks.lF, Blocks.lD, Blocks.lJ, Blocks.lz, Blocks.lE, Blocks.lB, Blocks.ly, Blocks.lx, Blocks.lC, Blocks.lG, Blocks.lK, Blocks.lw, Blocks.lA);
    public static final TileEntityTypes<TileEntityBed> z = TileEntityTypes.a("bed", TileEntityBed::new, Blocks.bu, Blocks.bv, Blocks.br, Blocks.bs, Blocks.bp, Blocks.bn, Blocks.bt, Blocks.bj, Blocks.bo, Blocks.bl, Blocks.bi, Blocks.bh, Blocks.bm, Blocks.bq, Blocks.bg, Blocks.bk);
    public static final TileEntityTypes<TileEntityConduit> A = TileEntityTypes.a("conduit", TileEntityConduit::new, Blocks.nD);
    public static final TileEntityTypes<TileEntityBarrel> B = TileEntityTypes.a("barrel", TileEntityBarrel::new, Blocks.oA);
    public static final TileEntityTypes<TileEntitySmoker> C = TileEntityTypes.a("smoker", TileEntitySmoker::new, Blocks.oB);
    public static final TileEntityTypes<TileEntityBlastFurnace> D = TileEntityTypes.a("blast_furnace", TileEntityBlastFurnace::new, Blocks.oC);
    public static final TileEntityTypes<TileEntityLectern> E = TileEntityTypes.a("lectern", TileEntityLectern::new, Blocks.oG);
    public static final TileEntityTypes<TileEntityBell> F = TileEntityTypes.a("bell", TileEntityBell::new, Blocks.oJ);
    public static final TileEntityTypes<TileEntityJigsaw> G = TileEntityTypes.a("jigsaw", TileEntityJigsaw::new, Blocks.pH);
    public static final TileEntityTypes<TileEntityCampfire> H = TileEntityTypes.a("campfire", TileEntityCampfire::new, Blocks.oM, Blocks.oN);
    public static final TileEntityTypes<TileEntityBeehive> I = TileEntityTypes.a("beehive", TileEntityBeehive::new, Blocks.pM, Blocks.pN);
    public static final TileEntityTypes<SculkSensorBlockEntity> J = TileEntityTypes.a("sculk_sensor", SculkSensorBlockEntity::new, Blocks.ry);
    public static final TileEntityTypes<CalibratedSculkSensorBlockEntity> K = TileEntityTypes.a("calibrated_sculk_sensor", CalibratedSculkSensorBlockEntity::new, Blocks.rz);
    public static final TileEntityTypes<SculkCatalystBlockEntity> L = TileEntityTypes.a("sculk_catalyst", SculkCatalystBlockEntity::new, Blocks.rC);
    public static final TileEntityTypes<SculkShriekerBlockEntity> M = TileEntityTypes.a("sculk_shrieker", SculkShriekerBlockEntity::new, Blocks.rD);
    public static final TileEntityTypes<ChiseledBookShelfBlockEntity> N = TileEntityTypes.a("chiseled_bookshelf", ChiseledBookShelfBlockEntity::new, Blocks.cw);
    public static final TileEntityTypes<BrushableBlockEntity> O = TileEntityTypes.a("brushable_block", BrushableBlockEntity::new, Blocks.M, Blocks.P);
    public static final TileEntityTypes<DecoratedPotBlockEntity> P = TileEntityTypes.a("decorated_pot", DecoratedPotBlockEntity::new, Blocks.tZ);
    public static final TileEntityTypes<CrafterBlockEntity> Q = TileEntityTypes.a("crafter", CrafterBlockEntity::new, Blocks.ua);
    public static final TileEntityTypes<TrialSpawnerBlockEntity> R = TileEntityTypes.a("trial_spawner", TrialSpawnerBlockEntity::new, Blocks.ub);
    public static final TileEntityTypes<VaultBlockEntity> S = TileEntityTypes.a("vault", VaultBlockEntity::new, Blocks.uc);
    public static final TileEntityTypes<TestBlockEntity> T = TileEntityTypes.a("test_block", TestBlockEntity::new, Blocks.pI);
    public static final TileEntityTypes<TestInstanceBlockEntity> U = TileEntityTypes.a("test_instance_block", TestInstanceBlockEntity::new, Blocks.pJ);
    private static final Set<TileEntityTypes<?>> W = Set.of(x, E, h, i, j, R, b);
    private final a<? extends T> X;
    private final Set<Block> Y;
    private final Holder.c<TileEntityTypes<?>> Z = BuiltInRegistries.j.f(this);

    @Nullable
    public static MinecraftKey a(TileEntityTypes<?> tileentitytypes) {
        return BuiltInRegistries.j.b(tileentitytypes);
    }

    private static <T extends TileEntity> TileEntityTypes<T> a(String s2, a<? extends T> tileentitytypes_a, Block ... ablock) {
        if (ablock.length == 0) {
            V.warn("Block entity type {} requires at least one valid block to be defined!", (Object)s2);
        }
        SystemUtils.a(DataConverterTypes.s, s2);
        return IRegistry.a(BuiltInRegistries.j, s2, new TileEntityTypes<T>(tileentitytypes_a, Set.of(ablock)));
    }

    private TileEntityTypes(a<? extends T> tileentitytypes_a, Set<Block> set) {
        this.X = tileentitytypes_a;
        this.Y = set;
    }

    public T a(BlockPosition blockposition, IBlockData iblockdata) {
        return this.X.create(blockposition, iblockdata);
    }

    public boolean a(IBlockData iblockdata) {
        return this.Y.contains(iblockdata.b());
    }

    @Deprecated
    public Holder.c<TileEntityTypes<?>> a() {
        return this.Z;
    }

    @Nullable
    public T a(IBlockAccess iblockaccess, BlockPosition blockposition) {
        TileEntity tileentity = iblockaccess.c_(blockposition);
        return (T)(tileentity != null && tileentity.p() == this ? tileentity : null);
    }

    public boolean b() {
        return W.contains(this);
    }

    @FunctionalInterface
    private static interface a<T extends TileEntity> {
        public T create(BlockPosition var1, IBlockData var2);
    }
}

