/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;

public final class TrialSpawner {
    public static final String a = "normal_config";
    public static final String b = "ominous_config";
    public static final int c = 40;
    private static final int d = 36000;
    private static final int e = 14;
    private static final int f = 47;
    private static final int g = MathHelper.h(47);
    private static final float h = 0.02f;
    public Holder<TrialSpawnerConfig> i;
    public Holder<TrialSpawnerConfig> j;
    private final TrialSpawnerData k;
    public int l;
    public int m;
    public final b n;
    private PlayerDetector o;
    private final PlayerDetector.a p;
    private boolean q;
    public boolean r;

    public MapCodec<TrialSpawner> a() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)TrialSpawnerConfig.c.optionalFieldOf(a, Holder.a(TrialSpawnerConfig.a)).forGetter(trialspawner -> trialspawner.i), (App)TrialSpawnerConfig.c.optionalFieldOf(b, Holder.a(TrialSpawnerConfig.a)).forGetter(trialspawner -> trialspawner.j), (App)TrialSpawnerData.b.forGetter(TrialSpawner::f), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("target_cooldown_length", (Object)36000).forGetter(TrialSpawner::g), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)14).forGetter(TrialSpawner::h)).apply((Applicative)instance, (holder, holder1, trialspawnerdata, integer, integer1) -> new TrialSpawner((Holder<TrialSpawnerConfig>)holder, (Holder<TrialSpawnerConfig>)holder1, (TrialSpawnerData)trialspawnerdata, (int)integer, (int)integer1, this.n, this.o, this.p)));
    }

    public TrialSpawner(b trialspawner_b, PlayerDetector playerdetector, PlayerDetector.a playerdetector_a) {
        this(Holder.a(TrialSpawnerConfig.a), Holder.a(TrialSpawnerConfig.a), new TrialSpawnerData(), 36000, 14, trialspawner_b, playerdetector, playerdetector_a);
    }

    public TrialSpawner(Holder<TrialSpawnerConfig> holder, Holder<TrialSpawnerConfig> holder1, TrialSpawnerData trialspawnerdata, int i2, int j2, b trialspawner_b, PlayerDetector playerdetector, PlayerDetector.a playerdetector_a) {
        this.i = holder;
        this.j = holder1;
        this.k = trialspawnerdata;
        this.m = i2;
        this.l = j2;
        this.n = trialspawner_b;
        this.o = playerdetector;
        this.p = playerdetector_a;
    }

    public TrialSpawnerConfig b() {
        return this.r ? this.d() : this.c();
    }

    @VisibleForTesting
    public TrialSpawnerConfig c() {
        return this.i.a();
    }

    @VisibleForTesting
    public TrialSpawnerConfig d() {
        return this.j.a();
    }

    public void a(WorldServer worldserver, BlockPosition blockposition) {
        worldserver.a(blockposition, (IBlockData)worldserver.a_(blockposition).b(TrialSpawnerBlock.c, true), 3);
        worldserver.c(3020, blockposition, 1);
        this.r = true;
        this.k.a(this, worldserver);
    }

    public void b(WorldServer worldserver, BlockPosition blockposition) {
        worldserver.a(blockposition, (IBlockData)worldserver.a_(blockposition).b(TrialSpawnerBlock.c, false), 3);
        this.r = false;
    }

    public boolean e() {
        return this.r;
    }

    public TrialSpawnerData f() {
        return this.k;
    }

    public int g() {
        return this.m;
    }

    public int h() {
        return this.l;
    }

    public TrialSpawnerState i() {
        return this.n.d();
    }

    public void a(World world, TrialSpawnerState trialspawnerstate) {
        this.n.a(world, trialspawnerstate);
    }

    public void j() {
        this.n.f();
    }

    public PlayerDetector k() {
        return this.o;
    }

    public PlayerDetector.a l() {
        return this.p;
    }

    public boolean a(WorldServer worldserver) {
        return this.q ? true : (worldserver.an() == EnumDifficulty.a ? false : worldserver.O().c(GameRules.f));
    }

    public Optional<UUID> c(WorldServer worldserver, BlockPosition blockposition) {
        MobSpawnerData.a mobspawnerdata_a;
        RandomSource randomsource = worldserver.G_();
        MobSpawnerData mobspawnerdata = this.k.b(this, worldserver.G_());
        NBTTagCompound nbttagcompound = mobspawnerdata.d();
        Optional<EntityTypes<?>> optional = EntityTypes.a(nbttagcompound);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        Vec3D vec3d = nbttagcompound.a("Pos", Vec3D.a).orElseGet(() -> new Vec3D((double)blockposition.u() + (randomsource.j() - randomsource.j()) * (double)this.b().c() + 0.5, blockposition.v() + randomsource.a(3) - 1, (double)blockposition.w() + (randomsource.j() - randomsource.j()) * (double)this.b().c() + 0.5));
        if (!worldserver.b(optional.get().a(vec3d.d, vec3d.e, vec3d.f))) {
            return Optional.empty();
        }
        if (!TrialSpawner.a((World)worldserver, blockposition.b(), vec3d)) {
            return Optional.empty();
        }
        BlockPosition blockposition1 = BlockPosition.a(vec3d);
        if (!EntityPositionTypes.a(optional.get(), worldserver, EntitySpawnReason.q, blockposition1, worldserver.G_())) {
            return Optional.empty();
        }
        if (mobspawnerdata.b().isPresent() && !(mobspawnerdata_a = mobspawnerdata.b().get()).a(blockposition1, worldserver)) {
            return Optional.empty();
        }
        Entity entity = EntityTypes.a(nbttagcompound, (World)worldserver, EntitySpawnReason.q, (Entity entity1) -> {
            entity1.b(vec3d.d, vec3d.e, vec3d.f, randomsource.i() * 360.0f, 0.0f);
            return entity1;
        });
        if (entity == null) {
            return Optional.empty();
        }
        if (entity instanceof EntityInsentient) {
            boolean flag;
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            if (!entityinsentient.a((IWorldReader)worldserver)) {
                return Optional.empty();
            }
            boolean bl = flag = mobspawnerdata.a().i() == 1 && mobspawnerdata.a().i("id").isPresent();
            if (flag) {
                entityinsentient.a((WorldAccess)worldserver, worldserver.d_(entityinsentient.dv()), EntitySpawnReason.q, (GroupDataEntity)null);
            }
            entityinsentient.gc();
            Optional<EquipmentTable> optional1 = mobspawnerdata.c();
            Objects.requireNonNull(entityinsentient);
            optional1.ifPresent(entityinsentient::a);
        }
        if (CraftEventFactory.callTrialSpawnerSpawnEvent(entity, blockposition).isCancelled()) {
            return Optional.empty();
        }
        if (!worldserver.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.TRIAL_SPAWNER)) {
            return Optional.empty();
        }
        a trialspawner_a = this.r ? net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.b : net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.a;
        worldserver.c(3011, blockposition, trialspawner_a.a());
        worldserver.c(3012, blockposition1, trialspawner_a.a());
        worldserver.a(entity, GameEvent.t, blockposition1);
        return Optional.of(entity.cG());
    }

    public void a(WorldServer worldserver, BlockPosition blockposition, ResourceKey<LootTable> resourcekey) {
        LootParams lootparams;
        LootTable loottable = worldserver.p().bc().b(resourcekey);
        ObjectArrayList objectarraylist = loottable.a(lootparams = new LootParams.a(worldserver).a(LootContextParameterSets.b));
        if (!objectarraylist.isEmpty()) {
            BlockDispenseLootEvent spawnerDispenseLootEvent = CraftEventFactory.callBlockDispenseLootEvent(worldserver, blockposition, null, objectarraylist);
            if (spawnerDispenseLootEvent.isCancelled()) {
                return;
            }
            objectarraylist = new ObjectArrayList(spawnerDispenseLootEvent.getDispensedLoot().stream().map(CraftItemStack::asNMSCopy).toList());
            for (ItemStack itemstack : objectarraylist) {
                DispenseBehaviorItem.a(worldserver, itemstack, 2, EnumDirection.b, Vec3D.c(blockposition).a(EnumDirection.b, 1.2));
            }
            worldserver.c(3014, blockposition, 0);
        }
    }

    public void a(World world, BlockPosition blockposition, boolean flag) {
        RandomSource randomsource;
        TrialSpawnerState trialspawnerstate = this.i();
        trialspawnerstate.a(world, blockposition, flag);
        if (trialspawnerstate.d()) {
            double d0 = Math.max(0L, this.k.f - world.ae());
            this.k.l = this.k.k;
            this.k.k = (this.k.k + trialspawnerstate.b() / (d0 + 200.0)) % 360.0;
        }
        if (trialspawnerstate.e() && (randomsource = world.G_()).i() <= 0.02f) {
            SoundEffect soundeffect = flag ? SoundEffects.mL : SoundEffects.mK;
            world.a(blockposition, soundeffect, SoundCategory.e, randomsource.i() * 0.25f + 0.75f, randomsource.i() + 0.5f, false);
        }
    }

    public void a(WorldServer worldserver, BlockPosition blockposition, boolean flag) {
        TrialSpawnerState trialspawnerstate1;
        this.r = flag;
        TrialSpawnerState trialspawnerstate = this.i();
        if (this.k.d.removeIf(uuid -> TrialSpawner.a(worldserver, blockposition, uuid))) {
            this.k.f = worldserver.ae() + (long)this.b().h();
        }
        if ((trialspawnerstate1 = trialspawnerstate.a(blockposition, this, worldserver)) != trialspawnerstate) {
            this.a((World)worldserver, trialspawnerstate1);
        }
    }

    private static boolean a(WorldServer worldserver, BlockPosition blockposition, UUID uuid) {
        Entity entity = worldserver.b(uuid);
        return entity == null || !entity.bJ() || !entity.dV().aj().equals(worldserver.aj()) || entity.dv().j(blockposition) > (double)g;
    }

    private static boolean a(World world, Vec3D vec3d, Vec3D vec3d1) {
        MovingObjectPositionBlock movingobjectpositionblock = world.a(new RayTrace(vec3d1, vec3d, RayTrace.BlockCollisionOption.c, RayTrace.FluidCollisionOption.a, VoxelShapeCollision.a()));
        return movingobjectpositionblock.b().equals(BlockPosition.a(vec3d)) || movingobjectpositionblock.d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public static void a(World world, BlockPosition blockposition, RandomSource randomsource, ParticleType particletype) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = (double)blockposition.u() + 0.5 + (randomsource.j() - 0.5) * 2.0;
            double d1 = (double)blockposition.v() + 0.5 + (randomsource.j() - 0.5) * 2.0;
            double d2 = (double)blockposition.w() + 0.5 + (randomsource.j() - 0.5) * 2.0;
            world.a(Particles.ah, d0, d1, d2, 0.0, 0.0, 0.0);
            world.a(particletype, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static void a(World world, BlockPosition blockposition, RandomSource randomsource) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = (double)blockposition.u() + 0.5 + (randomsource.j() - 0.5) * 2.0;
            double d1 = (double)blockposition.v() + 0.5 + (randomsource.j() - 0.5) * 2.0;
            double d2 = (double)blockposition.w() + 0.5 + (randomsource.j() - 0.5) * 2.0;
            double d3 = randomsource.k() * 0.02;
            double d4 = randomsource.k() * 0.02;
            double d5 = randomsource.k() * 0.02;
            world.a(Particles.bh, d0, d1, d2, d3, d4, d5);
            world.a(Particles.N, d0, d1, d2, d3, d4, d5);
        }
    }

    public static void a(World world, BlockPosition blockposition, RandomSource randomsource, int i2, ParticleParam particleparam) {
        for (int j2 = 0; j2 < 30 + Math.min(i2, 10) * 5; ++j2) {
            double d0 = (double)(2.0f * randomsource.i() - 1.0f) * 0.65;
            double d1 = (double)(2.0f * randomsource.i() - 1.0f) * 0.65;
            double d2 = (double)blockposition.u() + 0.5 + d0;
            double d3 = (double)blockposition.v() + 0.1 + (double)randomsource.i() * 0.8;
            double d4 = (double)blockposition.w() + 0.5 + d1;
            world.a(particleparam, d2, d3, d4, 0.0, 0.0, 0.0);
        }
    }

    public static void b(World world, BlockPosition blockposition, RandomSource randomsource) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = (double)blockposition.u() + 0.4 + randomsource.j() * 0.2;
            double d1 = (double)blockposition.v() + 0.4 + randomsource.j() * 0.2;
            double d2 = (double)blockposition.w() + 0.4 + randomsource.j() * 0.2;
            double d3 = randomsource.k() * 0.02;
            double d4 = randomsource.k() * 0.02;
            double d5 = randomsource.k() * 0.02;
            world.a(Particles.aM, d0, d1, d2, d3, d4, d5 * 0.25);
            world.a(Particles.ah, d0, d1, d2, d3, d4, d5);
        }
    }

    public void a(EntityTypes<?> entitytypes, World world) {
        this.k.a();
        this.i = Holder.a(this.i.a().a(entitytypes));
        this.j = Holder.a(this.j.a().a(entitytypes));
        this.a(world, TrialSpawnerState.a);
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void a(PlayerDetector playerdetector) {
        this.o = playerdetector;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void m() {
        this.q = true;
    }

    public static interface b {
        public void a(World var1, TrialSpawnerState var2);

        public TrialSpawnerState d();

        public void f();
    }

    public static enum a {
        a(Particles.F),
        b(Particles.N);

        public final ParticleType c;

        private a(ParticleType particletype) {
            this.c = particletype;
        }

        public static a a(int i2) {
            a[] atrialspawner_a = net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.values();
            return i2 <= atrialspawner_a.length && i2 >= 0 ? atrialspawner_a[i2] : a;
        }

        public int a() {
            return this.ordinal();
        }
    }
}

