/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.EnumDirection8;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.ticks.TickListChunk;
import org.slf4j.Logger;

public class ChunkConverter {
    private static final Logger b = LogUtils.getLogger();
    public static final ChunkConverter a = new ChunkConverter(BlockAccessAir.a);
    private static final String c = "Indices";
    private static final EnumDirection8[] d = EnumDirection8.values();
    private static final Codec<List<TickListChunk<Block>>> e = TickListChunk.a(BuiltInRegistries.e.q().orElse((Object)Blocks.a)).listOf();
    private static final Codec<List<TickListChunk<FluidType>>> f = TickListChunk.a(BuiltInRegistries.c.q().orElse((Object)FluidTypes.a)).listOf();
    private final EnumSet<EnumDirection8> g = EnumSet.noneOf(EnumDirection8.class);
    private final List<TickListChunk<Block>> h = Lists.newArrayList();
    private final List<TickListChunk<FluidType>> i = Lists.newArrayList();
    private final int[][] j;
    static final Map<Block, a> k = new IdentityHashMap<Block, a>();
    static final Set<a> l = Sets.newHashSet();

    private ChunkConverter(LevelHeightAccessor var0) {
        this.j = new int[var0.ap()][];
    }

    public ChunkConverter(NBTTagCompound var02, LevelHeightAccessor var1) {
        this(var1);
        var02.m(c).ifPresent(var0 -> {
            for (int var1 = 0; var1 < this.j.length; ++var1) {
                this.j[var1] = var0.k(String.valueOf(var1)).orElse(null);
            }
        });
        int var2 = var02.b("Sides", 0);
        for (EnumDirection8 var6 : EnumDirection8.values()) {
            if ((var2 & 1 << var6.ordinal()) == 0) continue;
            this.g.add(var6);
        }
        var02.a("neighbor_block_ticks", e).ifPresent(this.h::addAll);
        var02.a("neighbor_fluid_ticks", f).ifPresent(this.i::addAll);
    }

    private ChunkConverter(ChunkConverter var0) {
        this.g.addAll(var0.g);
        this.h.addAll(var0.h);
        this.i.addAll(var0.i);
        this.j = new int[var0.j.length][];
        for (int var1 = 0; var1 < var0.j.length; ++var1) {
            int[] var2 = var0.j[var1];
            this.j[var1] = var2 != null ? IntArrays.copy((int[])var2) : null;
        }
    }

    public void a(Chunk var0) {
        this.b(var0);
        for (EnumDirection8 var4 : d) {
            ChunkConverter.a(var0, var4);
        }
        World var12 = var0.H();
        this.h.forEach(var1 -> {
            Block var2 = var1.a() == Blocks.a ? var12.a_(var1.b()).b() : (Block)var1.a();
            var12.a(var1.b(), var2, var1.c(), var1.d());
        });
        this.i.forEach(var1 -> {
            FluidType var2 = var1.a() == FluidTypes.a ? var12.b_(var1.b()).a() : (FluidType)var1.a();
            var12.a(var1.b(), var2, var1.c(), var1.d());
        });
        l.forEach(var1 -> var1.a(var12));
    }

    private static void a(Chunk var0, EnumDirection8 var1) {
        World var2 = var0.H();
        if (!var0.t().g.remove((Object)var1)) {
            return;
        }
        Set<EnumDirection> var3 = var1.a();
        boolean var4 = false;
        int var5 = 15;
        boolean var6 = var3.contains(EnumDirection.f);
        boolean var7 = var3.contains(EnumDirection.e);
        boolean var8 = var3.contains(EnumDirection.d);
        boolean var9 = var3.contains(EnumDirection.c);
        boolean var10 = var3.size() == 1;
        ChunkCoordIntPair var11 = var0.f();
        int var12 = var11.d() + (var10 && (var9 || var8) ? 1 : (var7 ? 0 : 15));
        int var13 = var11.d() + (var10 && (var9 || var8) ? 14 : (var7 ? 0 : 15));
        int var14 = var11.e() + (var10 && (var6 || var7) ? 1 : (var9 ? 0 : 15));
        int var15 = var11.e() + (var10 && (var6 || var7) ? 14 : (var9 ? 0 : 15));
        EnumDirection[] var16 = EnumDirection.values();
        BlockPosition.MutableBlockPosition var17 = new BlockPosition.MutableBlockPosition();
        for (BlockPosition var19 : BlockPosition.b(var12, var2.K_(), var14, var13, var2.ao(), var15)) {
            IBlockData var20;
            IBlockData var21 = var20 = var2.a_(var19);
            for (EnumDirection var25 : var16) {
                var17.a((BaseBlockPosition)var19, var25);
                var21 = ChunkConverter.a(var21, var25, var2, var19, var17);
            }
            Block.a(var20, var21, var2, var19, 18);
        }
    }

    private static IBlockData a(IBlockData var0, EnumDirection var1, GeneratorAccess var2, BlockPosition var3, BlockPosition var4) {
        return k.getOrDefault(var0.b(), Type.b).a(var0, var1, var2.a_(var4), var2, var3, var4);
    }

    private void b(Chunk var0) {
        int var5;
        BlockPosition.MutableBlockPosition var1 = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition var2 = new BlockPosition.MutableBlockPosition();
        ChunkCoordIntPair var3 = var0.f();
        World var4 = var0.H();
        for (var5 = 0; var5 < this.j.length; ++var5) {
            ChunkSection var6 = var0.b(var5);
            int[] var7 = this.j[var5];
            this.j[var5] = null;
            if (var7 == null || var7.length <= 0) continue;
            EnumDirection[] var8 = EnumDirection.values();
            DataPaletteBlock<IBlockData> var9 = var6.h();
            int var10 = var0.h(var5);
            int var11 = SectionPosition.c(var10);
            for (int var15 : var7) {
                IBlockData var19;
                int var16 = var15 & 0xF;
                int var17 = var15 >> 8 & 0xF;
                int var18 = var15 >> 4 & 0xF;
                var1.d(var3.d() + var16, var11 + var17, var3.e() + var18);
                IBlockData var20 = var19 = var9.a(var15);
                for (EnumDirection var24 : var8) {
                    var2.a((BaseBlockPosition)var1, var24);
                    if (SectionPosition.a(var1.u()) != var3.h || SectionPosition.a(var1.w()) != var3.i) continue;
                    var20 = ChunkConverter.a(var20, var24, var4, var1, var2);
                }
                Block.a(var19, var20, var4, var1, 18);
            }
        }
        for (var5 = 0; var5 < this.j.length; ++var5) {
            if (this.j[var5] != null) {
                b.warn("Discarding update data for section {} for chunk ({} {})", new Object[]{var4.h(var5), var3.h, var3.i});
            }
            this.j[var5] = null;
        }
    }

    public boolean a() {
        for (int[] var3 : this.j) {
            if (var3 == null) continue;
            return false;
        }
        return this.g.isEmpty();
    }

    public NBTTagCompound b() {
        int var2;
        NBTTagCompound var0 = new NBTTagCompound();
        NBTTagCompound var1 = new NBTTagCompound();
        for (var2 = 0; var2 < this.j.length; ++var2) {
            String var3 = String.valueOf(var2);
            if (this.j[var2] == null || this.j[var2].length == 0) continue;
            var1.a(var3, this.j[var2]);
        }
        if (!var1.j()) {
            var0.a(c, var1);
        }
        var2 = 0;
        for (EnumDirection8 var4 : this.g) {
            var2 |= 1 << var4.ordinal();
        }
        var0.a("Sides", (byte)var2);
        if (!this.h.isEmpty()) {
            var0.a("neighbor_block_ticks", e, this.h);
        }
        if (!this.i.isEmpty()) {
            var0.a("neighbor_fluid_ticks", f, this.i);
        }
        return var0;
    }

    public ChunkConverter c() {
        if (this == a) {
            return a;
        }
        return new ChunkConverter(this);
    }

    static abstract sealed class Type
    extends Enum<Type>
    implements a {
        public static final /* enum */ Type a = new Type(new Block[]{Blocks.lu, Blocks.eu, Blocks.ms, Blocks.mt, Blocks.mu, Blocks.mv, Blocks.mw, Blocks.mx, Blocks.my, Blocks.mz, Blocks.mA, Blocks.mB, Blocks.mC, Blocks.mD, Blocks.mE, Blocks.mF, Blocks.mG, Blocks.mH, Blocks.ht, Blocks.hu, Blocks.hv, Blocks.fZ, Blocks.O, Blocks.L, Blocks.N, Blocks.cP, Blocks.cQ, Blocks.cR, Blocks.cS, Blocks.cT, Blocks.cU, Blocks.cV, Blocks.cW, Blocks.dd, Blocks.de, Blocks.df, Blocks.dg, Blocks.di, Blocks.dj, Blocks.dk, Blocks.dn, Blocks.do, Blocks.dp, Blocks.dq, Blocks.ds, Blocks.dt, Blocks.du, Blocks.dz, Blocks.dA, Blocks.dB, Blocks.dC, Blocks.dE, Blocks.dF, Blocks.dG}){

            @Override
            public IBlockData a(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
                return var0;
            }
        };
        public static final /* enum */ Type b = new Type(new Block[0]){

            @Override
            public IBlockData a(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
                return var0.a(var3, var3, var4, var1, var5, var3.a_(var5), var3.G_());
            }
        };
        public static final /* enum */ Type c = new Type(new Block[]{Blocks.cG, Blocks.hw}){

            @Override
            public IBlockData a(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
                if (var2.a(var0.b()) && var1.o().d() && var0.c(BlockChest.d) == BlockPropertyChestType.a && var2.c(BlockChest.d) == BlockPropertyChestType.a) {
                    EnumDirection var6 = var0.c(BlockChest.c);
                    if (var1.o() != var6.o() && var6 == var2.c(BlockChest.c)) {
                        BlockPropertyChestType var7 = var1 == var6.h() ? BlockPropertyChestType.b : BlockPropertyChestType.c;
                        var3.a(var5, (IBlockData)var2.b(BlockChest.d, var7.a()), 18);
                        if (var6 == EnumDirection.c || var6 == EnumDirection.f) {
                            TileEntity var8 = var3.c_(var4);
                            TileEntity var9 = var3.c_(var5);
                            if (var8 instanceof TileEntityChest && var9 instanceof TileEntityChest) {
                                TileEntityChest.a((TileEntityChest)var8, (TileEntityChest)var9);
                            }
                        }
                        return (IBlockData)var0.b(BlockChest.d, var7);
                    }
                }
                return var0;
            }
        };
        public static final /* enum */ Type d = new Type(true, new Block[]{Blocks.aO, Blocks.aP, Blocks.aM, Blocks.aR, Blocks.aQ, Blocks.aN, Blocks.aK, Blocks.aL}){
            private final ThreadLocal<List<ObjectSet<BlockPosition>>> g = ThreadLocal.withInitial(() -> Lists.newArrayListWithCapacity((int)7));

            @Override
            public IBlockData a(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
                IBlockData var6 = var0.a(var3, var3, var4, var1, var5, var3.a_(var5), var3.G_());
                if (var0 != var6) {
                    int var7 = var6.c(BlockProperties.aF);
                    List<ObjectSet<BlockPosition>> var8 = this.g.get();
                    if (var8.isEmpty()) {
                        for (int var9 = 0; var9 < 7; ++var9) {
                            var8.add((ObjectSet<BlockPosition>)new ObjectOpenHashSet());
                        }
                    }
                    var8.get(var7).add((Object)var4.j());
                }
                return var0;
            }

            @Override
            public void a(GeneratorAccess var0) {
                BlockPosition.MutableBlockPosition var1 = new BlockPosition.MutableBlockPosition();
                List<ObjectSet<BlockPosition>> var2 = this.g.get();
                for (int var3 = 2; var3 < var2.size(); ++var3) {
                    int var4 = var3 - 1;
                    ObjectSet<BlockPosition> var5 = var2.get(var4);
                    ObjectSet<BlockPosition> var6 = var2.get(var3);
                    for (BlockPosition var8 : var5) {
                        IBlockData var9 = var0.a_(var8);
                        if (var9.c(BlockProperties.aF) < var4) continue;
                        var0.a(var8, (IBlockData)var9.b(BlockProperties.aF, var4), 18);
                        if (var3 == 7) continue;
                        for (EnumDirection var13 : f) {
                            var1.a((BaseBlockPosition)var8, var13);
                            IBlockData var14 = var0.a_(var1);
                            if (!var14.b(BlockProperties.aF) || var9.c(BlockProperties.aF) <= var3) continue;
                            var6.add((Object)var1.j());
                        }
                    }
                }
                var2.clear();
            }
        };
        public static final /* enum */ Type e = new Type(new Block[]{Blocks.fw, Blocks.fv}){

            @Override
            public IBlockData a(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
                if (var0.c(BlockStem.c) == 7) {
                    Block var6;
                    Block block = var6 = var0.a(Blocks.fv) ? Blocks.fr : Blocks.fs;
                    if (var2.a(var6)) {
                        return (IBlockData)(var0.a(Blocks.fv) ? Blocks.ft : Blocks.fu).m().b(BlockFacingHorizontal.e, var1);
                    }
                }
                return var0;
            }
        };
        public static final EnumDirection[] f;
        private static final /* synthetic */ Type[] g;

        public static Type[] values() {
            return (Type[])g.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        Type(Block ... var2) {
            this(false, var2);
        }

        Type(boolean var2, Block ... var3) {
            for (Block var7 : var3) {
                k.put(var7, this);
            }
            if (var2) {
                l.add(this);
            }
        }

        private static /* synthetic */ Type[] a() {
            return new Type[]{a, b, c, d, e};
        }

        static {
            g = Type.a();
            f = EnumDirection.values();
        }
    }

    public static interface a {
        public IBlockData a(IBlockData var1, EnumDirection var2, IBlockData var3, GeneratorAccess var4, BlockPosition var5, BlockPosition var6);

        default public void a(GeneratorAccess var0) {
        }
    }
}

