/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.MapCodec;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.structure.PersistentStructureLegacy;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.spigotmc.SpigotConfig;

public class IChunkLoader
implements AutoCloseable {
    public static final int d = 1493;
    private final IOWorker a;
    protected final DataFixer e;
    @Nullable
    private volatile PersistentStructureLegacy b;

    public IChunkLoader(RegionStorageInfo regionstorageinfo, Path path, DataFixer datafixer, boolean flag) {
        this.e = datafixer;
        this.a = new IOWorker(regionstorageinfo, path, flag);
    }

    public boolean b(ChunkCoordIntPair chunkcoordintpair, int i2) {
        return this.a.a(chunkcoordintpair, i2);
    }

    private boolean check(ChunkProviderServer cps, int x2, int z2) {
        NBTTagCompound nbt;
        ChunkCoordIntPair pos = new ChunkCoordIntPair(x2, z2);
        if (cps != null && cps.b(x2, z2)) {
            return true;
        }
        try {
            nbt = this.d(pos).get().orElse(null);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new RuntimeException(ex);
        }
        if (nbt != null) {
            NBTTagCompound level = nbt.n("Level");
            if (level.b("TerrainPopulated", false)) {
                return true;
            }
            ChunkStatus status = ChunkStatus.a(level.b("Status", ""));
            if (status != null && status.a(ChunkStatus.j)) {
                return true;
            }
        }
        return false;
    }

    public NBTTagCompound upgradeChunkTag(ResourceKey<WorldDimension> resourcekey, Supplier<WorldPersistentData> supplier, NBTTagCompound nbttagcompound, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> optional, ChunkCoordIntPair pos, @Nullable GeneratorAccess generatoraccess) {
        int i2 = IChunkLoader.a(nbttagcompound);
        if (i2 == SharedConstants.b().d().c()) {
            return nbttagcompound;
        }
        try {
            boolean belowZeroGenerationInExistingChunks;
            NBTTagCompound level;
            if (i2 < 1466 && (level = nbttagcompound.n("Level")).b("TerrainPopulated", false) && !level.b("LightPopulated", false)) {
                ChunkProviderServer cps;
                ChunkProviderServer chunkProviderServer = cps = generatoraccess == null ? null : ((WorldServer)generatoraccess).m();
                if (this.check(cps, pos.h - 1, pos.i) && this.check(cps, pos.h - 1, pos.i - 1) && this.check(cps, pos.h, pos.i - 1)) {
                    level.a("LightPopulated", true);
                }
            }
            if (i2 < 1493 && (nbttagcompound = DataFixTypes.c.a(this.e, nbttagcompound, i2, 1493)).m("Level").flatMap(nbttagcompound1 -> nbttagcompound1.q("hasLegacyStructureData")).orElse(false).booleanValue()) {
                PersistentStructureLegacy persistentstructurelegacy = this.a(resourcekey, supplier);
                nbttagcompound = persistentstructurelegacy.a(nbttagcompound);
            }
            boolean stopBelowZero = false;
            boolean bl = belowZeroGenerationInExistingChunks = generatoraccess != null ? ((WorldServer)generatoraccess).spigotConfig.belowZeroGenerationInExistingChunks : SpigotConfig.belowZeroGenerationInExistingChunks;
            if (i2 <= 2730 && !belowZeroGenerationInExistingChunks) {
                stopBelowZero = "full".equals(nbttagcompound.n("Level").b("Status", ""));
            }
            IChunkLoader.a(nbttagcompound, resourcekey, optional);
            nbttagcompound = DataFixTypes.c.a(this.e, nbttagcompound, Math.max(1493, i2));
            if (stopBelowZero) {
                nbttagcompound.a("Status", BuiltInRegistries.l.b(ChunkStatus.m).toString());
            }
            IChunkLoader.b(nbttagcompound);
            GameProfileSerializer.e(nbttagcompound);
            return nbttagcompound;
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.a(exception, "Updated chunk");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Updated chunk details");
            crashreportsystemdetails.a("Data version", i2);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistentStructureLegacy a(ResourceKey<WorldDimension> resourcekey, Supplier<WorldPersistentData> supplier) {
        PersistentStructureLegacy persistentstructurelegacy = this.b;
        if (persistentstructurelegacy == null) {
            IChunkLoader iChunkLoader = this;
            synchronized (iChunkLoader) {
                persistentstructurelegacy = this.b;
                if (persistentstructurelegacy == null) {
                    this.b = persistentstructurelegacy = PersistentStructureLegacy.a(resourcekey, supplier.get());
                }
            }
        }
        return persistentstructurelegacy;
    }

    public static void a(NBTTagCompound nbttagcompound, ResourceKey<WorldDimension> resourcekey, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> optional) {
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.a("dimension", resourcekey.a().toString());
        optional.ifPresent(resourcekey1 -> nbttagcompound1.a("generator", resourcekey1.a().toString()));
        nbttagcompound.a("__context", nbttagcompound1);
    }

    private static void b(NBTTagCompound nbttagcompound) {
        nbttagcompound.r("__context");
    }

    public static int a(NBTTagCompound nbttagcompound) {
        return GameProfileSerializer.b(nbttagcompound, -1);
    }

    public CompletableFuture<Optional<NBTTagCompound>> d(ChunkCoordIntPair chunkcoordintpair) {
        return this.a.a(chunkcoordintpair);
    }

    public CompletableFuture<Void> a(ChunkCoordIntPair chunkcoordintpair, Supplier<NBTTagCompound> supplier) {
        this.e(chunkcoordintpair);
        return this.a.a(chunkcoordintpair, supplier);
    }

    protected void e(ChunkCoordIntPair chunkcoordintpair) {
        if (this.b != null) {
            this.b.a(chunkcoordintpair.a());
        }
    }

    public void o() {
        this.a.a(true).join();
    }

    @Override
    public void close() throws IOException {
        this.a.close();
    }

    public ChunkScanAccess p() {
        return this.a;
    }

    protected RegionStorageInfo q() {
        return this.a.a();
    }
}

