/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.structure.PersistentIndexed;
import net.minecraft.world.level.storage.WorldPersistentData;

public class PersistentStructureLegacy {
    private static final Map<String, String> a = SystemUtils.a(Maps.newHashMap(), (? super T hashmap) -> {
        hashmap.put("Village", "Village");
        hashmap.put("Mineshaft", "Mineshaft");
        hashmap.put("Mansion", "Mansion");
        hashmap.put("Igloo", "Temple");
        hashmap.put("Desert_Pyramid", "Temple");
        hashmap.put("Jungle_Pyramid", "Temple");
        hashmap.put("Swamp_Hut", "Temple");
        hashmap.put("Stronghold", "Stronghold");
        hashmap.put("Monument", "Monument");
        hashmap.put("Fortress", "Fortress");
        hashmap.put("EndCity", "EndCity");
    });
    private static final Map<String, String> b = SystemUtils.a(Maps.newHashMap(), (? super T hashmap) -> {
        hashmap.put("Iglu", "Igloo");
        hashmap.put("TeDP", "Desert_Pyramid");
        hashmap.put("TeJP", "Jungle_Pyramid");
        hashmap.put("TeSH", "Swamp_Hut");
    });
    private static final Set<String> c = Set.of("pillager_outpost", "mineshaft", "mansion", "jungle_pyramid", "desert_pyramid", "igloo", "ruined_portal", "shipwreck", "swamp_hut", "stronghold", "monument", "ocean_ruin", "fortress", "endcity", "buried_treasure", "village", "nether_fossil", "bastion_remnant");
    private final boolean d;
    private final Map<String, Long2ObjectMap<NBTTagCompound>> e = Maps.newHashMap();
    private final Map<String, PersistentIndexed> f = Maps.newHashMap();
    private final List<String> g;
    private final List<String> h;

    public PersistentStructureLegacy(@Nullable WorldPersistentData worldpersistentdata, List<String> list, List<String> list1) {
        this.g = list;
        this.h = list1;
        this.a(worldpersistentdata);
        boolean flag = false;
        for (String s2 : this.h) {
            flag |= this.e.get(s2) != null;
        }
        this.d = flag;
    }

    public void a(long i2) {
        for (String s2 : this.g) {
            PersistentIndexed persistentindexed = this.f.get(s2);
            if (persistentindexed == null || !persistentindexed.c(i2)) continue;
            persistentindexed.d(i2);
        }
    }

    public NBTTagCompound a(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompound1 = nbttagcompound.n("Level");
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(nbttagcompound1.b("xPos", 0), nbttagcompound1.b("zPos", 0));
        if (this.a(chunkcoordintpair.h, chunkcoordintpair.i)) {
            nbttagcompound = this.a(nbttagcompound, chunkcoordintpair);
        }
        NBTTagCompound nbttagcompound2 = nbttagcompound1.n("Structures");
        NBTTagCompound nbttagcompound3 = nbttagcompound2.n("References");
        for (String s2 : this.h) {
            boolean flag = c.contains(s2.toLowerCase(Locale.ROOT));
            if (nbttagcompound3.l(s2).isPresent() || !flag) continue;
            int i2 = 8;
            LongArrayList longlist = new LongArrayList();
            for (int j2 = chunkcoordintpair.h - 8; j2 <= chunkcoordintpair.h + 8; ++j2) {
                for (int k2 = chunkcoordintpair.i - 8; k2 <= chunkcoordintpair.i + 8; ++k2) {
                    if (!this.a(j2, k2, s2)) continue;
                    longlist.add(ChunkCoordIntPair.c(j2, k2));
                }
            }
            nbttagcompound3.a(s2, longlist.toLongArray());
        }
        nbttagcompound2.a("References", nbttagcompound3);
        nbttagcompound1.a("Structures", nbttagcompound2);
        nbttagcompound.a("Level", nbttagcompound1);
        return nbttagcompound;
    }

    private boolean a(int i2, int j2, String s2) {
        return !this.d ? false : this.e.get(s2) != null && this.f.get(a.get(s2)).b(ChunkCoordIntPair.c(i2, j2));
    }

    private boolean a(int i2, int j2) {
        if (!this.d) {
            return false;
        }
        for (String s2 : this.h) {
            if (this.e.get(s2) == null || !this.f.get(a.get(s2)).c(ChunkCoordIntPair.c(i2, j2))) continue;
            return true;
        }
        return false;
    }

    private NBTTagCompound a(NBTTagCompound nbttagcompound, ChunkCoordIntPair chunkcoordintpair) {
        NBTTagCompound nbttagcompound1 = nbttagcompound.n("Level");
        NBTTagCompound nbttagcompound2 = nbttagcompound1.n("Structures");
        NBTTagCompound nbttagcompound3 = nbttagcompound2.n("Starts");
        for (String s2 : this.h) {
            NBTTagCompound nbttagcompound4;
            Long2ObjectMap<NBTTagCompound> long2objectmap = this.e.get(s2);
            if (long2objectmap == null) continue;
            long i2 = chunkcoordintpair.a();
            if (!this.f.get(a.get(s2)).c(i2) || (nbttagcompound4 = (NBTTagCompound)long2objectmap.get(i2)) == null) continue;
            nbttagcompound3.a(s2, nbttagcompound4);
        }
        nbttagcompound2.a("Starts", nbttagcompound3);
        nbttagcompound1.a("Structures", nbttagcompound2);
        nbttagcompound.a("Level", nbttagcompound1);
        return nbttagcompound;
    }

    private void a(@Nullable WorldPersistentData worldpersistentdata) {
        if (worldpersistentdata != null) {
            for (String s3 : this.g) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                try {
                    nbttagcompound = worldpersistentdata.a(s3, DataFixTypes.o, 1493).n("data").n("Features");
                    if (nbttagcompound.j()) {
                        continue;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                nbttagcompound.a((String s1, NBTBase nbtbase) -> {
                    if (nbtbase instanceof NBTTagCompound) {
                        NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbtbase;
                        long i2 = ChunkCoordIntPair.c(nbttagcompound1.b("ChunkX", 0), nbttagcompound1.b("ChunkZ", 0));
                        NBTTagList nbttaglist = nbttagcompound1.p("Children");
                        if (!nbttaglist.isEmpty()) {
                            Optional<String> optional = nbttaglist.a(0).flatMap(nbttagcompound2 -> nbttagcompound2.i("id"));
                            Map<String, String> map = b;
                            Objects.requireNonNull(map);
                            optional.map(map::get).ifPresent(s2 -> nbttagcompound1.a("id", (String)s2));
                        }
                        nbttagcompound1.i("id").ifPresent(s2 -> this.e.computeIfAbsent((String)s2, s3 -> new Long2ObjectOpenHashMap()).put(i2, (Object)nbttagcompound1));
                    }
                });
                String s12 = s3 + "_index";
                PersistentIndexed persistentindexed = worldpersistentdata.a(PersistentIndexed.a(s12));
                if (persistentindexed.a().isEmpty()) {
                    PersistentIndexed persistentindexed1 = new PersistentIndexed();
                    this.f.put(s3, persistentindexed1);
                    nbttagcompound.a((String s2, NBTBase nbtbase) -> {
                        if (nbtbase instanceof NBTTagCompound) {
                            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbtbase;
                            persistentindexed1.a(ChunkCoordIntPair.c(nbttagcompound1.b("ChunkX", 0), nbttagcompound1.b("ChunkZ", 0)));
                        }
                    });
                    continue;
                }
                this.f.put(s3, persistentindexed);
            }
        }
    }

    public static PersistentStructureLegacy a(ResourceKey<WorldDimension> resourcekey, @Nullable WorldPersistentData worldpersistentdata) {
        if (resourcekey == WorldDimension.b) {
            return new PersistentStructureLegacy(worldpersistentdata, (List<String>)ImmutableList.of((Object)"Monument", (Object)"Stronghold", (Object)"Village", (Object)"Mineshaft", (Object)"Temple", (Object)"Mansion"), (List<String>)ImmutableList.of((Object)"Village", (Object)"Mineshaft", (Object)"Mansion", (Object)"Igloo", (Object)"Desert_Pyramid", (Object)"Jungle_Pyramid", (Object)"Swamp_Hut", (Object)"Stronghold", (Object)"Monument"));
        }
        if (resourcekey == WorldDimension.c) {
            ImmutableList list = ImmutableList.of((Object)"Fortress");
            return new PersistentStructureLegacy(worldpersistentdata, (List<String>)list, (List<String>)list);
        }
        if (resourcekey == WorldDimension.d) {
            ImmutableList list1 = ImmutableList.of((Object)"EndCity");
            return new PersistentStructureLegacy(worldpersistentdata, (List<String>)list1, (List<String>)list1);
        }
        throw new RuntimeException(String.format(Locale.ROOT, "Unknown dimension type : %s", resourcekey));
    }
}

