/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AxisAlignedBB {
    private static final double g = 1.0E-7;
    public final double a;
    public final double b;
    public final double c;
    public final double d;
    public final double e;
    public final double f;

    public AxisAlignedBB(double var0, double var2, double var4, double var6, double var8, double var10) {
        this.a = Math.min(var0, var6);
        this.b = Math.min(var2, var8);
        this.c = Math.min(var4, var10);
        this.d = Math.max(var0, var6);
        this.e = Math.max(var2, var8);
        this.f = Math.max(var4, var10);
    }

    public AxisAlignedBB(BlockPosition var0) {
        this(var0.u(), var0.v(), var0.w(), var0.u() + 1, var0.v() + 1, var0.w() + 1);
    }

    public AxisAlignedBB(Vec3D var0, Vec3D var1) {
        this(var0.d, var0.e, var0.f, var1.d, var1.e, var1.f);
    }

    public static AxisAlignedBB a(StructureBoundingBox var0) {
        return new AxisAlignedBB(var0.h(), var0.i(), var0.j(), var0.k() + 1, var0.l() + 1, var0.m() + 1);
    }

    public static AxisAlignedBB a(Vec3D var0) {
        return new AxisAlignedBB(var0.d, var0.e, var0.f, var0.d + 1.0, var0.e + 1.0, var0.f + 1.0);
    }

    public static AxisAlignedBB a(BlockPosition var0, BlockPosition var1) {
        return new AxisAlignedBB(Math.min(var0.u(), var1.u()), Math.min(var0.v(), var1.v()), Math.min(var0.w(), var1.w()), Math.max(var0.u(), var1.u()) + 1, Math.max(var0.v(), var1.v()) + 1, Math.max(var0.w(), var1.w()) + 1);
    }

    public AxisAlignedBB a(double var0) {
        return new AxisAlignedBB(var0, this.b, this.c, this.d, this.e, this.f);
    }

    public AxisAlignedBB b(double var0) {
        return new AxisAlignedBB(this.a, var0, this.c, this.d, this.e, this.f);
    }

    public AxisAlignedBB c(double var0) {
        return new AxisAlignedBB(this.a, this.b, var0, this.d, this.e, this.f);
    }

    public AxisAlignedBB d(double var0) {
        return new AxisAlignedBB(this.a, this.b, this.c, var0, this.e, this.f);
    }

    public AxisAlignedBB e(double var0) {
        return new AxisAlignedBB(this.a, this.b, this.c, this.d, var0, this.f);
    }

    public AxisAlignedBB f(double var0) {
        return new AxisAlignedBB(this.a, this.b, this.c, this.d, this.e, var0);
    }

    public double a(EnumDirection.EnumAxis var0) {
        return var0.a(this.a, this.b, this.c);
    }

    public double b(EnumDirection.EnumAxis var0) {
        return var0.a(this.d, this.e, this.f);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof AxisAlignedBB)) {
            return false;
        }
        AxisAlignedBB var1 = (AxisAlignedBB)var0;
        if (Double.compare(var1.a, this.a) != 0) {
            return false;
        }
        if (Double.compare(var1.b, this.b) != 0) {
            return false;
        }
        if (Double.compare(var1.c, this.c) != 0) {
            return false;
        }
        if (Double.compare(var1.d, this.d) != 0) {
            return false;
        }
        if (Double.compare(var1.e, this.e) != 0) {
            return false;
        }
        return Double.compare(var1.f, this.f) == 0;
    }

    public int hashCode() {
        long var0 = Double.doubleToLongBits(this.a);
        int var2 = (int)(var0 ^ var0 >>> 32);
        var0 = Double.doubleToLongBits(this.b);
        var2 = 31 * var2 + (int)(var0 ^ var0 >>> 32);
        var0 = Double.doubleToLongBits(this.c);
        var2 = 31 * var2 + (int)(var0 ^ var0 >>> 32);
        var0 = Double.doubleToLongBits(this.d);
        var2 = 31 * var2 + (int)(var0 ^ var0 >>> 32);
        var0 = Double.doubleToLongBits(this.e);
        var2 = 31 * var2 + (int)(var0 ^ var0 >>> 32);
        var0 = Double.doubleToLongBits(this.f);
        var2 = 31 * var2 + (int)(var0 ^ var0 >>> 32);
        return var2;
    }

    public AxisAlignedBB a(double var0, double var2, double var4) {
        double var6 = this.a;
        double var8 = this.b;
        double var10 = this.c;
        double var12 = this.d;
        double var14 = this.e;
        double var16 = this.f;
        if (var0 < 0.0) {
            var6 -= var0;
        } else if (var0 > 0.0) {
            var12 -= var0;
        }
        if (var2 < 0.0) {
            var8 -= var2;
        } else if (var2 > 0.0) {
            var14 -= var2;
        }
        if (var4 < 0.0) {
            var10 -= var4;
        } else if (var4 > 0.0) {
            var16 -= var4;
        }
        return new AxisAlignedBB(var6, var8, var10, var12, var14, var16);
    }

    public AxisAlignedBB b(Vec3D var0) {
        return this.b(var0.d, var0.e, var0.f);
    }

    public AxisAlignedBB b(double var0, double var2, double var4) {
        double var6 = this.a;
        double var8 = this.b;
        double var10 = this.c;
        double var12 = this.d;
        double var14 = this.e;
        double var16 = this.f;
        if (var0 < 0.0) {
            var6 += var0;
        } else if (var0 > 0.0) {
            var12 += var0;
        }
        if (var2 < 0.0) {
            var8 += var2;
        } else if (var2 > 0.0) {
            var14 += var2;
        }
        if (var4 < 0.0) {
            var10 += var4;
        } else if (var4 > 0.0) {
            var16 += var4;
        }
        return new AxisAlignedBB(var6, var8, var10, var12, var14, var16);
    }

    public AxisAlignedBB c(double var0, double var2, double var4) {
        double var6 = this.a - var0;
        double var8 = this.b - var2;
        double var10 = this.c - var4;
        double var12 = this.d + var0;
        double var14 = this.e + var2;
        double var16 = this.f + var4;
        return new AxisAlignedBB(var6, var8, var10, var12, var14, var16);
    }

    public AxisAlignedBB g(double var0) {
        return this.c(var0, var0, var0);
    }

    public AxisAlignedBB a(AxisAlignedBB var0) {
        double var1 = Math.max(this.a, var0.a);
        double var3 = Math.max(this.b, var0.b);
        double var5 = Math.max(this.c, var0.c);
        double var7 = Math.min(this.d, var0.d);
        double var9 = Math.min(this.e, var0.e);
        double var11 = Math.min(this.f, var0.f);
        return new AxisAlignedBB(var1, var3, var5, var7, var9, var11);
    }

    public AxisAlignedBB b(AxisAlignedBB var0) {
        double var1 = Math.min(this.a, var0.a);
        double var3 = Math.min(this.b, var0.b);
        double var5 = Math.min(this.c, var0.c);
        double var7 = Math.max(this.d, var0.d);
        double var9 = Math.max(this.e, var0.e);
        double var11 = Math.max(this.f, var0.f);
        return new AxisAlignedBB(var1, var3, var5, var7, var9, var11);
    }

    public AxisAlignedBB d(double var0, double var2, double var4) {
        return new AxisAlignedBB(this.a + var0, this.b + var2, this.c + var4, this.d + var0, this.e + var2, this.f + var4);
    }

    public AxisAlignedBB a(BlockPosition var0) {
        return new AxisAlignedBB(this.a + (double)var0.u(), this.b + (double)var0.v(), this.c + (double)var0.w(), this.d + (double)var0.u(), this.e + (double)var0.v(), this.f + (double)var0.w());
    }

    public AxisAlignedBB c(Vec3D var0) {
        return this.d(var0.d, var0.e, var0.f);
    }

    public AxisAlignedBB a(Vector3f var0) {
        return this.d(var0.x, var0.y, var0.z);
    }

    public boolean c(AxisAlignedBB var0) {
        return this.a(var0.a, var0.b, var0.c, var0.d, var0.e, var0.f);
    }

    public boolean a(double var0, double var2, double var4, double var6, double var8, double var10) {
        return this.a < var6 && this.d > var0 && this.b < var8 && this.e > var2 && this.c < var10 && this.f > var4;
    }

    public boolean a(Vec3D var0, Vec3D var1) {
        return this.a(Math.min(var0.d, var1.d), Math.min(var0.e, var1.e), Math.min(var0.f, var1.f), Math.max(var0.d, var1.d), Math.max(var0.e, var1.e), Math.max(var0.f, var1.f));
    }

    public boolean d(Vec3D var0) {
        return this.e(var0.d, var0.e, var0.f);
    }

    public boolean e(double var0, double var2, double var4) {
        return var0 >= this.a && var0 < this.d && var2 >= this.b && var2 < this.e && var4 >= this.c && var4 < this.f;
    }

    public double a() {
        double var0 = this.b();
        double var2 = this.c();
        double var4 = this.d();
        return (var0 + var2 + var4) / 3.0;
    }

    public double b() {
        return this.d - this.a;
    }

    public double c() {
        return this.e - this.b;
    }

    public double d() {
        return this.f - this.c;
    }

    public AxisAlignedBB f(double var0, double var2, double var4) {
        return this.c(-var0, -var2, -var4);
    }

    public AxisAlignedBB h(double var0) {
        return this.g(-var0);
    }

    public Optional<Vec3D> b(Vec3D var0, Vec3D var1) {
        return AxisAlignedBB.a(this.a, this.b, this.c, this.d, this.e, this.f, var0, var1);
    }

    public static Optional<Vec3D> a(double var0, double var2, double var4, double var6, double var8, double var10, Vec3D var12, Vec3D var13) {
        double[] var14 = new double[]{1.0};
        double var15 = var13.d - var12.d;
        double var17 = var13.e - var12.e;
        double var19 = var13.f - var12.f;
        EnumDirection var21 = AxisAlignedBB.a(var0, var2, var4, var6, var8, var10, var12, var14, null, var15, var17, var19);
        if (var21 == null) {
            return Optional.empty();
        }
        double var22 = var14[0];
        return Optional.of(var12.b(var22 * var15, var22 * var17, var22 * var19));
    }

    @Nullable
    public static MovingObjectPositionBlock a(Iterable<AxisAlignedBB> var0, Vec3D var1, Vec3D var2, BlockPosition var3) {
        double[] var4 = new double[]{1.0};
        EnumDirection var5 = null;
        double var6 = var2.d - var1.d;
        double var8 = var2.e - var1.e;
        double var10 = var2.f - var1.f;
        for (AxisAlignedBB var13 : var0) {
            var5 = AxisAlignedBB.a(var13.a(var3), var1, var4, var5, var6, var8, var10);
        }
        if (var5 == null) {
            return null;
        }
        double var12 = var4[0];
        return new MovingObjectPositionBlock(var1.b(var12 * var6, var12 * var8, var12 * var10), var5, var3, false);
    }

    @Nullable
    private static EnumDirection a(AxisAlignedBB var0, Vec3D var1, double[] var2, @Nullable EnumDirection var3, double var4, double var6, double var8) {
        return AxisAlignedBB.a(var0.a, var0.b, var0.c, var0.d, var0.e, var0.f, var1, var2, var3, var4, var6, var8);
    }

    @Nullable
    private static EnumDirection a(double var0, double var2, double var4, double var6, double var8, double var10, Vec3D var12, double[] var13, @Nullable EnumDirection var14, double var15, double var17, double var19) {
        if (var15 > 1.0E-7) {
            var14 = AxisAlignedBB.a(var13, var14, var15, var17, var19, var0, var2, var8, var4, var10, EnumDirection.e, var12.d, var12.e, var12.f);
        } else if (var15 < -1.0E-7) {
            var14 = AxisAlignedBB.a(var13, var14, var15, var17, var19, var6, var2, var8, var4, var10, EnumDirection.f, var12.d, var12.e, var12.f);
        }
        if (var17 > 1.0E-7) {
            var14 = AxisAlignedBB.a(var13, var14, var17, var19, var15, var2, var4, var10, var0, var6, EnumDirection.a, var12.e, var12.f, var12.d);
        } else if (var17 < -1.0E-7) {
            var14 = AxisAlignedBB.a(var13, var14, var17, var19, var15, var8, var4, var10, var0, var6, EnumDirection.b, var12.e, var12.f, var12.d);
        }
        if (var19 > 1.0E-7) {
            var14 = AxisAlignedBB.a(var13, var14, var19, var15, var17, var4, var0, var6, var2, var8, EnumDirection.c, var12.f, var12.d, var12.e);
        } else if (var19 < -1.0E-7) {
            var14 = AxisAlignedBB.a(var13, var14, var19, var15, var17, var10, var0, var6, var2, var8, EnumDirection.d, var12.f, var12.d, var12.e);
        }
        return var14;
    }

    @Nullable
    private static EnumDirection a(double[] var0, @Nullable EnumDirection var1, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, EnumDirection var18, double var19, double var21, double var23) {
        double var25 = (var8 - var19) / var2;
        double var27 = var21 + var25 * var4;
        double var29 = var23 + var25 * var6;
        if (0.0 < var25 && var25 < var0[0] && var10 - 1.0E-7 < var27 && var27 < var12 + 1.0E-7 && var14 - 1.0E-7 < var29 && var29 < var16 + 1.0E-7) {
            var0[0] = var25;
            return var18;
        }
        return var1;
    }

    public boolean a(Vec3D var0, List<AxisAlignedBB> var1) {
        Vec3D var2 = this.f();
        Vec3D var3 = var2.e(var0);
        for (AxisAlignedBB var5 : var1) {
            AxisAlignedBB var6 = var5.c(this.b() * 0.5, this.c() * 0.5, this.d() * 0.5);
            if (var6.d(var3) || var6.d(var2)) {
                return true;
            }
            if (!var6.b(var2, var3).isPresent()) continue;
            return true;
        }
        return false;
    }

    public double e(Vec3D var0) {
        double var1 = Math.max(Math.max(this.a - var0.d, var0.d - this.d), 0.0);
        double var3 = Math.max(Math.max(this.b - var0.e, var0.e - this.e), 0.0);
        double var5 = Math.max(Math.max(this.c - var0.f, var0.f - this.f), 0.0);
        return MathHelper.f(var1, var3, var5);
    }

    public String toString() {
        return "AABB[" + this.a + ", " + this.b + ", " + this.c + "] -> [" + this.d + ", " + this.e + ", " + this.f + "]";
    }

    public boolean e() {
        return Double.isNaN(this.a) || Double.isNaN(this.b) || Double.isNaN(this.c) || Double.isNaN(this.d) || Double.isNaN(this.e) || Double.isNaN(this.f);
    }

    public Vec3D f() {
        return new Vec3D(MathHelper.d(0.5, this.a, this.d), MathHelper.d(0.5, this.b, this.e), MathHelper.d(0.5, this.c, this.f));
    }

    public Vec3D g() {
        return new Vec3D(MathHelper.d(0.5, this.a, this.d), this.b, MathHelper.d(0.5, this.c, this.f));
    }

    public Vec3D h() {
        return new Vec3D(this.a, this.b, this.c);
    }

    public Vec3D i() {
        return new Vec3D(this.d, this.e, this.f);
    }

    public static AxisAlignedBB a(Vec3D var0, double var1, double var3, double var5) {
        return new AxisAlignedBB(var0.d - var1 / 2.0, var0.e - var3 / 2.0, var0.f - var5 / 2.0, var0.d + var1 / 2.0, var0.e + var3 / 2.0, var0.f + var5 / 2.0);
    }

    public static class a {
        private float a = Float.POSITIVE_INFINITY;
        private float b = Float.POSITIVE_INFINITY;
        private float c = Float.POSITIVE_INFINITY;
        private float d = Float.NEGATIVE_INFINITY;
        private float e = Float.NEGATIVE_INFINITY;
        private float f = Float.NEGATIVE_INFINITY;

        public void a(Vector3fc var0) {
            this.a = Math.min(this.a, var0.x());
            this.b = Math.min(this.b, var0.y());
            this.c = Math.min(this.c, var0.z());
            this.d = Math.max(this.d, var0.x());
            this.e = Math.max(this.e, var0.y());
            this.f = Math.max(this.f, var0.z());
        }

        public AxisAlignedBB a() {
            return new AxisAlignedBB(this.a, this.b, this.c, this.d, this.e, this.f);
        }
    }
}

