/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import org.bukkit.Art;
import org.bukkit.Fluid;
import org.bukkit.GameEvent;
import org.bukkit.JukeboxSong;
import org.bukkit.Keyed;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockType;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_21_R4.CraftArt;
import org.bukkit.craftbukkit.v1_21_R4.CraftFluid;
import org.bukkit.craftbukkit.v1_21_R4.CraftGameEvent;
import org.bukkit.craftbukkit.v1_21_R4.CraftJukeboxSong;
import org.bukkit.craftbukkit.v1_21_R4.CraftMusicInstrument;
import org.bukkit.craftbukkit.v1_21_R4.CraftSound;
import org.bukkit.craftbukkit.v1_21_R4.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R4.block.banner.CraftPatternType;
import org.bukkit.craftbukkit.v1_21_R4.damage.CraftDamageType;
import org.bukkit.craftbukkit.v1_21_R4.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftCat;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftChicken;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftCow;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftFrog;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPig;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_21_R4.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R4.generator.structure.CraftStructureType;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMenuType;
import org.bukkit.craftbukkit.v1_21_R4.inventory.trim.CraftTrimMaterial;
import org.bukkit.craftbukkit.v1_21_R4.inventory.trim.CraftTrimPattern;
import org.bukkit.craftbukkit.v1_21_R4.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R4.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R4.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R4.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R4.util.Handleable;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.map.MapCursor;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class CraftRegistry<B extends Keyed, M>
implements Registry<B> {
    private static IRegistryCustom registry;
    private final Class<? super B> bukkitClass;
    private final Map<NamespacedKey, B> cache = new HashMap<NamespacedKey, B>();
    private final IRegistry<M> minecraftRegistry;
    private final BiFunction<NamespacedKey, Holder<M>, B> minecraftToBukkit;
    private final BiFunction<NamespacedKey, ApiVersion, NamespacedKey> updater;
    private boolean init;

    public static void setMinecraftRegistry(IRegistryCustom registry) {
        Preconditions.checkState((CraftRegistry.registry == null ? 1 : 0) != 0, (Object)"Registry already set");
        CraftRegistry.registry = registry;
    }

    public static IRegistryCustom getMinecraftRegistry() {
        return registry;
    }

    public static <E> IRegistry<E> getMinecraftRegistry(ResourceKey<IRegistry<E>> key) {
        return CraftRegistry.getMinecraftRegistry().f(key);
    }

    public static <B extends Keyed, M> B minecraftToBukkit(M minecraft, ResourceKey<IRegistry<M>> registryKey, Registry<B> bukkitRegistry) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        IRegistry registry = CraftRegistry.getMinecraftRegistry(registryKey);
        Keyed bukkit = bukkitRegistry.get(CraftNamespacedKey.fromMinecraft(registry.d(minecraft).orElseThrow(() -> new IllegalStateException(String.format("Cannot convert '%s' to bukkit representation, since it is not registered.", minecraft))).a()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (B)bukkit;
    }

    public static <B extends Keyed, M> M bukkitToMinecraft(B bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return ((Handleable)bukkit).getHandle();
    }

    public static <B extends Keyed, M> Holder<M> bukkitToMinecraftHolder(B bukkit, ResourceKey<IRegistry<M>> registryKey) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        IRegistry registry = CraftRegistry.getMinecraftRegistry(registryKey);
        Holder holder = registry.e(CraftRegistry.bukkitToMinecraft(bukkit));
        if (holder instanceof Holder.c) {
            Holder.c holder2 = (Holder.c)holder;
            return holder2;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own registry entry with out properly registering it.");
    }

    private static <M, B> BiFunction<NamespacedKey, Holder<M>, B> wrap(BiFunction<NamespacedKey, M, B> minecraftToBukkit) {
        return (namespacedKey, holder) -> minecraftToBukkit.apply((NamespacedKey)namespacedKey, (Object)holder.a());
    }

    public static <B extends Keyed> Registry<?> createRegistry(Class<? super B> bukkitClass, IRegistryCustom registryHolder) {
        if (bukkitClass == Art.class) {
            return new CraftRegistry<CraftArt, PaintingVariant>(Art.class, registryHolder.f(Registries.aZ), CraftArt::new, FieldRename.NONE);
        }
        if (bukkitClass == Attribute.class) {
            return new CraftRegistry<CraftAttribute, AttributeBase>(Attribute.class, registryHolder.f(Registries.c), CraftAttribute::new, FieldRename.ATTRIBUTE_RENAME);
        }
        if (bukkitClass == Biome.class) {
            return new CraftRegistry<CraftBiome, BiomeBase>(Biome.class, registryHolder.f(Registries.aG), CraftBiome::new, FieldRename.BIOME_RENAME);
        }
        if (bukkitClass == org.bukkit.enchantments.Enchantment.class) {
            return new CraftRegistry<CraftEnchantment, Enchantment>(org.bukkit.enchantments.Enchantment.class, registryHolder.f(Registries.aR), CraftRegistry.wrap(CraftEnchantment::new), FieldRename.ENCHANTMENT_RENAME);
        }
        if (bukkitClass == Fluid.class) {
            return new CraftRegistry<CraftFluid, FluidType>(Fluid.class, registryHolder.f(Registries.F), CraftFluid::new, FieldRename.NONE);
        }
        if (bukkitClass == GameEvent.class) {
            return new CraftRegistry<CraftGameEvent, net.minecraft.world.level.gameevent.GameEvent>(GameEvent.class, registryHolder.f(Registries.H), CraftRegistry.wrap(CraftGameEvent::new), FieldRename.NONE);
        }
        if (bukkitClass == MusicInstrument.class) {
            return new CraftRegistry<CraftMusicInstrument, Instrument>(MusicInstrument.class, registryHolder.f(Registries.aU), CraftMusicInstrument::new, FieldRename.NONE);
        }
        if (bukkitClass == MenuType.class) {
            return new CraftRegistry(MenuType.class, registryHolder.f(Registries.V), CraftMenuType::new, FieldRename.NONE);
        }
        if (bukkitClass == PotionEffectType.class) {
            return new CraftRegistry<CraftPotionEffectType, MobEffectList>(PotionEffectType.class, registryHolder.f(Registries.W), CraftRegistry.wrap(CraftPotionEffectType::new), FieldRename.NONE);
        }
        if (bukkitClass == Sound.class) {
            return new CraftRegistry<CraftSound, SoundEffect>(Sound.class, registryHolder.f(Registries.ap), CraftSound::new, FieldRename.NONE);
        }
        if (bukkitClass == Structure.class) {
            return new CraftRegistry<CraftStructure, net.minecraft.world.level.levelgen.structure.Structure>(Structure.class, registryHolder.f(Registries.be), CraftRegistry.wrap(CraftStructure::new), FieldRename.NONE);
        }
        if (bukkitClass == StructureType.class) {
            return new CraftRegistry<CraftStructureType, net.minecraft.world.level.levelgen.structure.StructureType>(StructureType.class, registryHolder.f(Registries.aw), CraftRegistry.wrap(CraftStructureType::new), FieldRename.NONE);
        }
        if (bukkitClass == Villager.Type.class) {
            return new CraftRegistry<CraftVillager.CraftType, VillagerType>(Villager.Type.class, registryHolder.f(Registries.aE), CraftVillager.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == Villager.Profession.class) {
            return new CraftRegistry<CraftVillager.CraftProfession, VillagerProfession>(Villager.Profession.class, registryHolder.f(Registries.aD), CraftVillager.CraftProfession::new, FieldRename.NONE);
        }
        if (bukkitClass == org.bukkit.inventory.meta.trim.TrimMaterial.class) {
            return new CraftRegistry<CraftTrimMaterial, TrimMaterial>(org.bukkit.inventory.meta.trim.TrimMaterial.class, registryHolder.f(Registries.bk), CraftTrimMaterial::new, FieldRename.NONE);
        }
        if (bukkitClass == TrimPattern.class) {
            return new CraftRegistry<CraftTrimPattern, net.minecraft.world.item.equipment.trim.TrimPattern>(TrimPattern.class, registryHolder.f(Registries.bl), CraftTrimPattern::new, FieldRename.NONE);
        }
        if (bukkitClass == DamageType.class) {
            return new CraftRegistry<CraftDamageType, net.minecraft.world.damagesource.DamageType>(DamageType.class, registryHolder.f(Registries.aN), CraftDamageType::new, FieldRename.NONE);
        }
        if (bukkitClass == JukeboxSong.class) {
            return new CraftRegistry<CraftJukeboxSong, net.minecraft.world.item.JukeboxSong>(JukeboxSong.class, registryHolder.f(Registries.aV), CraftJukeboxSong::new, FieldRename.NONE);
        }
        if (bukkitClass == Wolf.Variant.class) {
            return new CraftRegistry<CraftWolf.CraftVariant, WolfVariant>(Wolf.Variant.class, registryHolder.f(Registries.bm), CraftWolf.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == BlockType.class) {
            return new CraftRegistry<CraftBlockType, Block>(BlockType.class, registryHolder.f(Registries.i), CraftBlockType::new, FieldRename.NONE);
        }
        if (bukkitClass == ItemType.class) {
            return new CraftRegistry<CraftItemType, Item>(ItemType.class, registryHolder.f(Registries.K), CraftItemType::new, FieldRename.NONE);
        }
        if (bukkitClass == Frog.Variant.class) {
            return new CraftRegistry<CraftFrog.CraftVariant, FrogVariant>(Frog.Variant.class, registryHolder.f(Registries.aT), CraftFrog.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == Cat.Type.class) {
            return new CraftRegistry<CraftCat.CraftType, CatVariant>(Cat.Type.class, registryHolder.f(Registries.aH), CraftCat.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == Pig.Variant.class) {
            return new CraftRegistry<CraftPig.CraftVariant, PigVariant>(Pig.Variant.class, registryHolder.f(Registries.ba), CraftPig.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == Cow.Variant.class) {
            return new CraftRegistry<CraftCow.CraftVariant, CowVariant>(Cow.Variant.class, registryHolder.f(Registries.aM), CraftCow.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == Chicken.Variant.class) {
            return new CraftRegistry<CraftChicken.CraftVariant, ChickenVariant>(Chicken.Variant.class, registryHolder.f(Registries.aJ), CraftChicken.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == MapCursor.Type.class) {
            return new CraftRegistry<CraftMapCursor.CraftType, MapDecorationType>(MapCursor.Type.class, registryHolder.f(Registries.R), CraftMapCursor.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == PatternType.class) {
            return new CraftRegistry<CraftPatternType, EnumBannerPatternType>(PatternType.class, registryHolder.f(Registries.aF), CraftPatternType::new, FieldRename.NONE);
        }
        return null;
    }

    public static <B extends Keyed> B get(Registry<B> bukkit, NamespacedKey namespacedKey, ApiVersion apiVersion) {
        if (bukkit instanceof CraftRegistry) {
            CraftRegistry craft = (CraftRegistry)bukkit;
            return craft.get(namespacedKey, apiVersion);
        }
        if (bukkit instanceof Registry.SimpleRegistry) {
            Registry.SimpleRegistry simple = (Registry.SimpleRegistry)bukkit;
            Class bClass = simple.getType();
            if (bClass == EntityType.class) {
                return (B)bukkit.get(FieldRename.ENTITY_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
            if (bClass == Particle.class) {
                return (B)bukkit.get(FieldRename.PARTICLE_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
        }
        return (B)bukkit.get(namespacedKey);
    }

    public CraftRegistry(Class<? super B> bukkitClass, IRegistry<M> minecraftRegistry, BiFunction<NamespacedKey, Holder<M>, B> minecraftToBukkit, BiFunction<NamespacedKey, ApiVersion, NamespacedKey> updater) {
        this.bukkitClass = bukkitClass;
        this.minecraftRegistry = minecraftRegistry;
        this.minecraftToBukkit = minecraftToBukkit;
        this.updater = updater;
    }

    public B get(NamespacedKey namespacedKey, ApiVersion apiVersion) {
        return this.get(this.updater.apply(namespacedKey, apiVersion));
    }

    public B get(NamespacedKey namespacedKey) {
        Keyed cached = (Keyed)this.cache.get(namespacedKey);
        if (cached != null) {
            return (B)cached;
        }
        if (!this.init) {
            this.init = true;
            try {
                Class.forName(this.bukkitClass.getName());
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException("Could not load registry class " + String.valueOf(this.bukkitClass), e2);
            }
            return this.get(namespacedKey);
        }
        B bukkit = this.createBukkit(namespacedKey, this.minecraftRegistry.c(CraftNamespacedKey.toMinecraft(namespacedKey)).orElse(null));
        if (bukkit == null) {
            return null;
        }
        this.cache.put(namespacedKey, bukkit);
        return bukkit;
    }

    @NotNull
    public B getOrThrow(@NotNull NamespacedKey namespacedKey) {
        B object = this.get(namespacedKey);
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (String)"No %s registry entry found for key %s.", this.minecraftRegistry.g(), (Object)namespacedKey);
        return object;
    }

    @NotNull
    public Stream<B> stream() {
        return this.minecraftRegistry.i().stream().map(minecraftKey -> this.get(CraftNamespacedKey.fromMinecraft(minecraftKey)));
    }

    public Iterator<B> iterator() {
        return this.stream().iterator();
    }

    public B createBukkit(NamespacedKey namespacedKey, Holder<M> minecraft) {
        if (minecraft == null) {
            return null;
        }
        return (B)((Keyed)this.minecraftToBukkit.apply(namespacedKey, minecraft));
    }
}

