/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.block.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.level.block.BlockStainedGlassPane;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.GlassPane;
import org.bukkit.craftbukkit.v1_21_R4.block.data.CraftBlockData;

public final class CraftStainedGlassPane
extends CraftBlockData
implements GlassPane,
MultipleFacing,
Waterlogged {
    private static final BlockStateBoolean[] FACES = new BlockStateBoolean[]{CraftStainedGlassPane.getBoolean(BlockStainedGlassPane.class, "north", true), CraftStainedGlassPane.getBoolean(BlockStainedGlassPane.class, "east", true), CraftStainedGlassPane.getBoolean(BlockStainedGlassPane.class, "south", true), CraftStainedGlassPane.getBoolean(BlockStainedGlassPane.class, "west", true), CraftStainedGlassPane.getBoolean(BlockStainedGlassPane.class, "up", true), CraftStainedGlassPane.getBoolean(BlockStainedGlassPane.class, "down", true)};
    private static final BlockStateBoolean WATERLOGGED = CraftStainedGlassPane.getBoolean(BlockStainedGlassPane.class, "waterlogged");

    public CraftStainedGlassPane() {
    }

    public CraftStainedGlassPane(IBlockData state) {
        super(state);
    }

    public boolean hasFace(BlockFace face) {
        BlockStateBoolean state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + String.valueOf(face) + ". Check MultipleFacing.getAllowedFaces.");
        }
        return this.get(state);
    }

    public void setFace(BlockFace face, boolean has) {
        BlockStateBoolean state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + String.valueOf(face) + ". Check MultipleFacing.getAllowedFaces.");
        }
        this.set(state, has);
    }

    public Set<BlockFace> getFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i2 = 0; i2 < FACES.length; ++i2) {
            if (FACES[i2] == null || !this.get(FACES[i2]).booleanValue()) continue;
            faces.add((Object)BlockFace.values()[i2]);
        }
        return faces.build();
    }

    public Set<BlockFace> getAllowedFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i2 = 0; i2 < FACES.length; ++i2) {
            if (FACES[i2] == null) continue;
            faces.add((Object)BlockFace.values()[i2]);
        }
        return faces.build();
    }

    public boolean isWaterlogged() {
        return this.get(WATERLOGGED);
    }

    public void setWaterlogged(boolean waterlogged) {
        this.set(WATERLOGGED, waterlogged);
    }
}

