/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.damage;

import com.google.common.base.Preconditions;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R4.damage.CraftDamageSource;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;

public class CraftDamageSourceBuilder
implements DamageSource.Builder {
    private final DamageType damageType;
    private Entity causingEntity;
    private Entity directEntity;
    private Location damageLocation;

    public CraftDamageSourceBuilder(DamageType damageType) {
        Preconditions.checkArgument((damageType != null ? 1 : 0) != 0, (Object)"DamageType cannot be null");
        this.damageType = damageType;
    }

    public DamageSource.Builder withCausingEntity(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.causingEntity = entity;
        return this;
    }

    public DamageSource.Builder withDirectEntity(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.directEntity = entity;
        return this;
    }

    public DamageSource.Builder withDamageLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        this.damageLocation = location.clone();
        return this;
    }

    public DamageSource build() {
        return CraftDamageSource.buildFromBukkit(this.damageType, this.causingEntity, this.directEntity, this.damageLocation);
    }
}

