/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.animal.EntityCow;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R4.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftAbstractCow;
import org.bukkit.craftbukkit.v1_21_R4.registry.CraftRegistryItem;
import org.bukkit.entity.Cow;

public class CraftCow
extends CraftAbstractCow
implements Cow {
    public CraftCow(CraftServer server, EntityCow entity) {
        super(server, entity);
    }

    @Override
    public EntityCow getHandle() {
        return (EntityCow)this.entity;
    }

    @Override
    public String toString() {
        return "CraftCow";
    }

    public Cow.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().p());
    }

    public void setVariant(Cow.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant");
        this.getHandle().j(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public static class CraftVariant
    extends CraftRegistryItem<CowVariant>
    implements Cow.Variant {
        public static Cow.Variant minecraftToBukkit(CowVariant minecraft) {
            return (Cow.Variant)CraftRegistry.minecraftToBukkit(minecraft, Registries.aM, Registry.COW_VARIANT);
        }

        public static Cow.Variant minecraftHolderToBukkit(Holder<CowVariant> minecraft) {
            return CraftVariant.minecraftToBukkit(minecraft.a());
        }

        public static CowVariant bukkitToMinecraft(Cow.Variant bukkit) {
            return (CowVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<CowVariant> bukkitToMinecraftHolder(Cow.Variant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit, Registries.aM);
        }

        public CraftVariant(NamespacedKey key, Holder<CowVariant> handle) {
            super(key, handle);
        }

        public NamespacedKey getKey() {
            return this.getKeyOrThrow();
        }
    }
}

