/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.item.Items;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.entity.EnderSignal;
import org.bukkit.inventory.ItemStack;

public class CraftEnderSignal
extends CraftEntity
implements EnderSignal {
    public CraftEnderSignal(CraftServer server, EntityEnderSignal entity) {
        super(server, entity);
    }

    @Override
    public EntityEnderSignal getHandle() {
        return (EntityEnderSignal)this.entity;
    }

    @Override
    public String toString() {
        return "CraftEnderSignal";
    }

    public Location getTargetLocation() {
        return new Location(this.getWorld(), this.getHandle().c, this.getHandle().d, this.getHandle().e, this.getHandle().dL(), this.getHandle().dN());
    }

    public void setTargetLocation(Location location) {
        Preconditions.checkArgument((boolean)this.getWorld().equals((Object)location.getWorld()), (Object)"Cannot target EnderSignal across worlds");
        this.getHandle().a(CraftLocation.toBlockPosition(location));
    }

    public boolean getDropItem() {
        return this.getHandle().g;
    }

    public void setDropItem(boolean shouldDropItem) {
        this.getHandle().g = shouldDropItem;
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().e());
    }

    public void setItem(ItemStack item) {
        this.getHandle().a(item != null ? CraftItemStack.asNMSCopy(item) : Items.tA.m());
    }

    public int getDespawnTimer() {
        return this.getHandle().f;
    }

    public void setDespawnTimer(int time) {
        this.getHandle().f = time;
    }
}

